/*
  $Id: infopipe_senddata.c,v 1.1 2002/05/19 10:36:40 wwwwolf Exp $
 */

#include <stdio.h>
#include <glib.h>
#include <xmms/util.h>
#include "infopipe.h"
#include "../config.h"

extern GeneralPlugin infopipe_gp;

/*
  This will get the XMMS information and print them out to the pipe.
 */
void blast_info(FILE *pipe) {
  gchar *play_status;
  gint tunes = xmms_remote_get_playlist_length(SESSIONID);
  gint current = xmms_remote_get_playlist_pos(SESSIONID);

  gint rate, freq, nch;

  /*
  TitleInput *songinfo;
  */

  /* Edited by Shogun, added totalTime for a bit of optimizing.
     Now there is 1 xmms call less ;) */
  gint totalTime,seconds,minutes;

  fprintf(pipe, "XMMS protocol version: %d\n",
	  xmms_remote_get_version(SESSIONID));
  fprintf(pipe, "InfoPipe Plugin version: %s\n",
	  VERSION);

  if(xmms_remote_is_playing(SESSIONID)) {
    if(xmms_remote_is_paused(SESSIONID)) {
      play_status = g_strdup("Paused");
    } else {
      play_status = g_strdup("Playing");
    }
  } else {
    play_status = g_strdup("Stopped");
  }

  fprintf(pipe, "Status: %s\n", play_status);

  fprintf(pipe, "Tunes in playlist: %d\n", tunes);
  fprintf(pipe, "Currently playing: %d\n", (current+1));

  /* Edited by Shogun, First get the count of milliseconds that the
     current song is playing */
  totalTime = (gint)xmms_remote_get_output_time(SESSIONID);
  fprintf(pipe, "uSecPosition: %d\n",totalTime);

  /* Than calculate the seconds and minutes */
  seconds = (gint)((gfloat)totalTime / (gfloat)1000);
  minutes = (gint)((gfloat)seconds / (gfloat)60); 
  seconds -= minutes * 60;
  fprintf(pipe, "Position: %d:%02d\n",minutes,seconds);
  
  /* Edited by Shogun, add info about the total time of the
     current song, would be nice to know ;) */
  totalTime = 
	(gint)xmms_remote_get_playlist_time(SESSIONID,current);
  fprintf(pipe, "uSecTime: %d\n",totalTime);
  
  seconds = (gint)((gfloat)totalTime / (gfloat)1000);
  minutes = (gint)((gfloat)seconds / (gfloat)60);
  seconds -= minutes * 60;
  fprintf(pipe, "Time: %d:%02d\n",minutes,seconds);

  /* Get the bitrate, frequency and number of channels.
     Input Plugin Properties thing could ROCK.
     (Would get CBR/VBR info - it shows only *current* bitrate...)
   */
  xmms_remote_get_info(SESSIONID,
		       &rate, &freq, &nch);
  fprintf(pipe, "Current bitrate: %d\n",rate);
  fprintf(pipe, "Samping Frequency: %d\n",freq);
  fprintf(pipe, "Channels: %d\n",nch);

  /* The basicest of the basic information. Title string and file name. */
  fprintf(pipe, "Title: %s\n",
	  xmms_remote_get_playlist_title(SESSIONID,current));
  fprintf(pipe, "File: %s\n",
	  xmms_remote_get_playlist_file(SESSIONID,current));

  g_free(play_status);
}

