
/***********************************************************
 * XMMS InfoPipe plugin
 * Distributed under GNU GPL. See the COPYING file for details.
 *
 * Written by Weyfour WWWWolf (Urpo Lankinen),
 * 2000-12-09 and onward
 *
 * $Id: infopipe.h,v 1.6 2002/05/19 10:38:03 wwwwolf Exp $
 *
 ***********************************************************/

#ifndef INFOPIPE_PLUGIN_INFOPIPE_H
#define INFOPIPE_PLUGIN_INFOPIPE_H

#include <stdio.h>
#include <xmms/plugin.h>

/* infopipe.c */
GeneralPlugin *get_gplugin_info(void);
void init_plugin(void);
void finalize_plugin(void);
void xmms_quit(void);
void request_handler_thread(void);

/* infopipe_senddata.c */
void blast_info(FILE *pipe);

/* infopipe_config.c */
void load_config(void);

/* infopipe_ui.c */
void show_about(void);
void show_config(void);

/*
  FIFO file prefix. Also, the name of the symlink to create.
  This should be defined in the configuration dialog, but we don't
  have one.. yet...
*/
#define FIFO_FILE_PFX "/tmp/xmms-info"

/*
  FIFO name-outfigurance buffer size. Keep this ample enough.
  Basically, FIFO_FILE_PFX length + space for millions of
  decimals.
*/
#define FIFONAMEBUFSIZE 80

/*
  Some interesting macros to make things a bit more readable.
 */
#define SESSIONID infopipe_gp.xmms_session
/* extern GeneralPlugin infopipe_gp; */

#endif /* INFOPIPE_PLUGIN_INFOPIPE_H */
