/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public class SingletonNode
extends Value {
    protected NodeInfo node = null;
    static /* synthetic */ Class class$java$lang$String;

    public SingletonNode(NodeInfo nodeInfo) {
        this.node = nodeInfo;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public void process(XPathContext xPathContext) throws XPathException {
        if (this.node != null) {
            xPathContext.getReceiver().append(this.node, 0, 2);
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        switch (this.node.getNodeKind()) {
            case 9: {
                NodeInfo nodeInfo;
                AxisIterator axisIterator = this.node.iterateAxis((byte)3);
                ItemType itemType = null;
                while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                    int n = nodeInfo.getNodeKind();
                    if (n == 3) {
                        itemType = null;
                        break;
                    }
                    if (n != 1) continue;
                    if (itemType != null) {
                        itemType = null;
                        break;
                    }
                    itemType = new SingletonNode(nodeInfo).getItemType(typeHierarchy);
                }
                if (itemType == null) {
                    return NodeKindTest.DOCUMENT;
                }
                return new DocumentNodeTest((NodeTest)itemType);
            }
            case 1: {
                int n = this.node.getTypeAnnotation();
                if (n == -1 || n == 641 || n == 572) {
                    return new NameTest(1, this.node.getFingerprint(), this.node.getNamePool());
                }
                return new CombinedNodeTest(new NameTest(1, this.node.getFingerprint(), this.node.getNamePool()), 23, new ContentTypeTest(1, this.node.getConfiguration().getSchemaType(n), this.node.getConfiguration()));
            }
            case 2: {
                int n = this.node.getTypeAnnotation();
                if (n == -1 || n == 642) {
                    return new NameTest(2, this.node.getFingerprint(), this.node.getNamePool());
                }
                return new CombinedNodeTest(new NameTest(2, this.node.getFingerprint(), this.node.getNamePool()), 23, new ContentTypeTest(2, this.node.getConfiguration().getSchemaType(n), this.node.getConfiguration()));
            }
            case 3: {
                return NodeKindTest.TEXT;
            }
            case 8: {
                return NodeKindTest.COMMENT;
            }
            case 7: {
                return NodeKindTest.PROCESSING_INSTRUCTION;
            }
            case 13: {
                return NodeKindTest.NAMESPACE;
            }
        }
        throw new IllegalArgumentException("Unknown node kind " + this.node.getNodeKind());
    }

    public int getCardinality() {
        if (this.node == null) {
            return 8192;
        }
        return 16384;
    }

    public int getLength() throws XPathException {
        return this.node == null ? 0 : 1;
    }

    public Item itemAt(int n) throws XPathException {
        if (n == 0 && this.node != null) {
            return this.node;
        }
        return null;
    }

    public NodeInfo getNode() {
        return this.node;
    }

    public int getSpecialProperties() {
        return 0x420000;
    }

    public SequenceIterator iterate(XPathContext xPathContext) {
        return SingletonIterator.makeIterator(this.node);
    }

    public Item evaluateItem(XPathContext xPathContext) {
        return this.node;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.node != null;
    }

    public String getStringValue() {
        return this.node == null ? "" : this.node.getStringValue();
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        if (this.node == null) {
            return "";
        }
        return this.node.getStringValue();
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        if (this.node == null) {
            printStream.println(ExpressionTool.indent(n) + "Empty node-set");
        } else {
            printStream.println(ExpressionTool.indent(n) + "Node " + Navigator.getPath(this.node));
        }
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (this.node == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.node.getClass())) {
            return this.node;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = SingletonNode.class$("java.lang.String")) : class$java$lang$String)) {
            return this.node.getStringValue();
        }
        return super.convertToJava(clazz, xPathContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

