/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.ValueTailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class TailExpression
extends Expression {
    Expression base;
    int start;

    public TailExpression(Expression base, int start) {
        this.base = base;
        this.start = start;
        this.adoptChildExpression(base);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.base = visitor.typeCheck(this.base, contextItemType);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.base = visitor.optimize(this.base, contextItemType);
        return this;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        if (offer.action != 13) {
            this.base = this.doPromotion(this.base, offer);
        }
        return this;
    }

    public int computeSpecialProperties() {
        return this.base.getSpecialProperties();
    }

    public Expression copy() {
        return new TailExpression(this.base.copy(), this.start);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.base.getItemType(th);
    }

    public int computeCardinality() {
        return this.base.getCardinality() | 0x2000;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.base);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.base == original) {
            this.base = replacement;
            found = true;
        }
        return found;
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public int getStart() {
        return this.start;
    }

    public boolean equals(Object other) {
        return other instanceof TailExpression && this.base.equals(((TailExpression)other).base) && this.start == ((TailExpression)other).start;
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator baseIter = this.base.iterate(context);
        if ((baseIter.getProperties() & 1) != 0) {
            return new ValueTailIterator(((GroundedIterator)baseIter).materialize(), this.start - 1);
        }
        return TailIterator.make(baseIter, this.start);
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("tail");
        destination.emitAttribute("start", this.start + "");
        this.base.explain(destination);
        destination.endElement();
    }
}

