/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-ecat72.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : Read ECAT 7.2 files                                      *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Functions    : MdcCheckECAT7()          - Check for ECAT7 format        *
 *                MdcEcatPrintMainHdr()    - Print content main header     *
 *                MdcEcatPrintImgSubHdr()  - Print content image subheader *
 *                MdcReadECAT7()           - Read ECAT7 file               *
 *                MdcWriteECAT7()          - Write ECAT7 file              *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: m-ecat72.c,v 1.14 2003/04/24 23:25:10 enlf Exp $
 */
/* - debian dummy file v0.2 - by Roland Marcus Rutschmann <Rutschmann@gmx.de>
 */

/*
   Copyright (C) 1997-2003 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "m-depend.h"

#include <stdio.h>
#include <time.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#ifndef _WIN32
#include <strings.h>
#endif
#endif

#include "medcon.h"

/****************************************************************************
                              D E F I N E S
****************************************************************************/


/****************************************************************************
                            F U N C T I O N S
****************************************************************************/
int MdcCheckECAT7(FILEINFO *fi)
{
  return MDC_FRMT_NONE;
}

char *MdcReadECAT7(FILEINFO *fi)
{
  return("ECAT7 Reading in debian unsupported (unclear licensing)");
}

char *MdcWriteECAT7(FILEINFO *fi)
{
  return("ECAT7 Writing not yet supported");
}
