#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from xpdeint.Geometry.NonUniformDimensionRepresentation import NonUniformDimensionRepresentation

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.3'
__CHEETAH_versionTuple__ = (3, 2, 3, 'final', 0)
__CHEETAH_genTime__ = 1558054969.7501655
__CHEETAH_genTimestamp__ = 'Fri May 17 11:02:49 2019'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-3.0.0/xpdeint/Geometry/HermiteGaussDimensionRepresentation.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class HermiteGaussDimensionRepresentation(NonUniformDimensionRepresentation):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(HermiteGaussDimensionRepresentation, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def gridAtIndex(self, index, **KWS):



        ## CHEETAH: generated from @def gridAtIndex($index) at line 29, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''_hermite_zeros_''')
        _v = VFFSL(SL,"parent.name",True) # '${parent.name}' on line 31, col 16
        if _v is not None: write(_filter(_v, rawExpr='${parent.name}')) # from line 31, col 16.
        write('''[''')
        _v = VFFSL(SL,"index",True) # '$index' on line 31, col 31
        if _v is not None: write(_filter(_v, rawExpr='$index')) # from line 31, col 31.
        write('''] * ''')
        _v = VFFSL(SL,"_maximum",True) # '${_maximum}' on line 31, col 41
        if _v is not None: write(_filter(_v, rawExpr='${_maximum}')) # from line 31, col 41.
        write(''' / sqrt(''')
        _v = VFFSL(SL,"fieldCount",True) / 2.0 # '${fieldCount / 2.0}' on line 31, col 60
        if _v is not None: write(_filter(_v, rawExpr='${fieldCount / 2.0}')) # from line 31, col 60.
        write(''')''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def stepWeightAtIndex(self, index, **KWS):



        ## CHEETAH: generated from @def stepWeightAtIndex($index) at line 35, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''_hermite_gauss_weights_''')
        _v = VFFSL(SL,"parent.name",True) # '${parent.name}' on line 37, col 24
        if _v is not None: write(_filter(_v, rawExpr='${parent.name}')) # from line 37, col 24.
        write('''[''')
        _v = VFFSL(SL,"index",True) # '$index' on line 37, col 39
        if _v is not None: write(_filter(_v, rawExpr='$index')) # from line 37, col 39.
        write('''] * ''')
        _v = VFFSL(SL,"_maximum",True) # '${_maximum}' on line 37, col 49
        if _v is not None: write(_filter(_v, rawExpr='${_maximum}')) # from line 37, col 49.
        write(''' / sqrt(''')
        _v = VFFSL(SL,"fieldCount",True) / 2.0 # '${fieldCount / 2.0}' on line 37, col 68
        if _v is not None: write(_filter(_v, rawExpr='${fieldCount / 2.0}')) # from line 37, col 68.
        write(''')''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def indexForSinglePointSample(self, **KWS):



        ## CHEETAH: generated from @def indexForSinglePointSample at line 41, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        #  Take the middle point, which is in the middle of the array
        _v = VFFSL(SL,"globalLattice",True) # '${globalLattice}' on line 44, col 1
        if _v is not None: write(_filter(_v, rawExpr='${globalLattice}')) # from line 44, col 1.
        write('''/2''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def createCoordinateVariableForSinglePointSample(self, **KWS):



        ## CHEETAH: generated from @def createCoordinateVariableForSinglePointSample at line 48, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = VFFSL(SL,"type",True) # '${type}' on line 50, col 1
        if _v is not None: write(_filter(_v, rawExpr='${type}')) # from line 50, col 1.
        write(''' ''')
        _v = VFFSL(SL,"name",True) # '${name}' on line 50, col 9
        if _v is not None: write(_filter(_v, rawExpr='${name}')) # from line 50, col 9.
        write(''' = ''')
        _v = VFFSL(SL,"arrayName",True) # '${arrayName}' on line 50, col 19
        if _v is not None: write(_filter(_v, rawExpr='${arrayName}')) # from line 50, col 19.
        write('''[''')
        _v = VFFSL(SL,"globalLattice",True) # '${globalLattice}' on line 50, col 32
        if _v is not None: write(_filter(_v, rawExpr='${globalLattice}')) # from line 50, col 32.
        write('''/2];
#define d''')
        _v = VFFSL(SL,"name",True) # '${name}' on line 51, col 10
        if _v is not None: write(_filter(_v, rawExpr='${name}')) # from line 51, col 10.
        write(''' (''')
        _v = VFFSL(SL,"stepSizeArrayName",True) # '${stepSizeArrayName}' on line 51, col 19
        if _v is not None: write(_filter(_v, rawExpr='${stepSizeArrayName}')) # from line 51, col 19.
        write('''[''')
        _v = VFFSL(SL,"globalLattice",True) # '${globalLattice}' on line 51, col 40
        if _v is not None: write(_filter(_v, rawExpr='${globalLattice}')) # from line 51, col 40.
        write('''/2]  * (''')
        _v = VFFSL(SL,"volumePrefactor",True) # '${volumePrefactor}' on line 51, col 64
        if _v is not None: write(_filter(_v, rawExpr='${volumePrefactor}')) # from line 51, col 64.
        write('''))
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # HermiteGaussDimensionRepresentation.tmpl
        # 
        # Created by Graham Dennis on 2009-08-12.
        # 
        # Copyright (c) 2009-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''




''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    instanceAttributes = ['_maximum', 'fieldCount']

    instanceDefaults = {'fieldCount': 2.0}

    _mainCheetahMethod_for_HermiteGaussDimensionRepresentation = 'writeBody'

## END CLASS DEFINITION

if not hasattr(HermiteGaussDimensionRepresentation, '_initCheetahAttributes'):
    templateAPIClass = getattr(HermiteGaussDimensionRepresentation,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(HermiteGaussDimensionRepresentation)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=HermiteGaussDimensionRepresentation()).run()


