/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2007 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "callbacks_printdialog.h"
#include "gui_printdialog.h"
#include "support.h"
#include "preferences.h"
#include "log.h"

GtkWidget *printdialog;

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern preferencestype preferences;
extern GList *logwindowlist;


void
on_menu_print_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *printallradiobutton, *printrangeradiobutton, *printlowentry,
		*printhighentry, *printrangelabel, *filedestinationradiobutton,
		*printerdestinationradiobutton;
	GtkWidget *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9, *p10,
		*p11, *p12, *p13, *p14, *p15, *p16, *p17, *p18;
	gchar *temp;
	GtkTreeViewColumn *column;
	logtype *logwindow;
	gint page, response;
	GtkWidget *pvbox, *phbox, *lefttopvbox, *rangeframe, *rangevbox,
		*rangehbox, *destframe, *destvbox, *paperframe, *papervbox,
		*papersizehbox, *papersizelabel, *papersizecombo, *pointsizelabel,
		*pointsizehbox,	*pointsizecombo, *orientationhbox, *orientationlabel,
		*orientationcombo, *columnsframe, *columnshbox, *columnsvbox1,
		*columnsvbox2, *contestframe, *contestcheckbutton;
	GSList *printrangeradiobutton_group = NULL,
		*printerdestinationradiobutton_group = NULL;

	page = gtk_notebook_get_current_page (GTK_NOTEBOOK(mainnotebook));
	if (page >= 0)
	{
		printdialog = gtk_dialog_new_with_buttons (_("xlog - print"),
			GTK_WINDOW(mainwindow), GTK_DIALOG_DESTROY_WITH_PARENT,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);

		pvbox = gtk_vbox_new (FALSE, 0);
		gtk_container_add (GTK_CONTAINER
			(GTK_DIALOG (printdialog)->vbox), pvbox);
		phbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (pvbox), phbox, FALSE, FALSE, 0);
		lefttopvbox = gtk_vbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (phbox), lefttopvbox, FALSE, FALSE, 0);

		rangeframe = gtk_frame_new (_("Range"));
		gtk_box_pack_start (GTK_BOX (lefttopvbox), rangeframe, FALSE, FALSE, 0);
		rangevbox = gtk_vbox_new (FALSE, 0);
		gtk_container_add (GTK_CONTAINER (rangeframe), rangevbox);
		printallradiobutton = gtk_radio_button_new_with_label
			(NULL, _("Print all QSO's"));
		gtk_box_pack_start
			(GTK_BOX (rangevbox), printallradiobutton, FALSE, FALSE, 0);
		printrangeradiobutton_group =
			gtk_radio_button_get_group (GTK_RADIO_BUTTON (printallradiobutton));
		rangehbox = gtk_hbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (rangevbox), rangehbox, FALSE, FALSE, 0);
		printrangeradiobutton = gtk_radio_button_new_with_label
			(printrangeradiobutton_group, _("Print QSO"));
		gtk_box_pack_start
			(GTK_BOX (rangehbox), printrangeradiobutton, FALSE, FALSE, 0);
		printlowentry = gtk_entry_new ();
		gtk_box_pack_start
			(GTK_BOX (rangehbox), printlowentry, FALSE, FALSE, 0);
		gtk_widget_set_size_request (printlowentry, 40, -1);
		gtk_entry_set_max_length (GTK_ENTRY (printlowentry), 8);
		gtk_entry_set_activates_default (GTK_ENTRY (printlowentry), TRUE);
		printrangelabel = gtk_label_new (_("To"));
		gtk_misc_set_padding (GTK_MISC (printrangelabel), 5, 0);
		gtk_box_pack_start
			(GTK_BOX (rangehbox), printrangelabel, FALSE, FALSE, 0);
		printhighentry = gtk_entry_new ();
		gtk_box_pack_start
			(GTK_BOX (rangehbox), printhighentry, FALSE, FALSE, 0);
		gtk_widget_set_size_request (printhighentry, 40, -1);
		gtk_entry_set_max_length (GTK_ENTRY (printhighentry), 8);
		gtk_entry_set_activates_default (GTK_ENTRY (printhighentry), TRUE);

		destframe = gtk_frame_new (_("Destination"));
		gtk_box_pack_start (GTK_BOX (lefttopvbox), destframe, FALSE, FALSE, 0);
		destvbox = gtk_vbox_new (FALSE, 0);
		gtk_container_add (GTK_CONTAINER (destframe), destvbox);
		printerdestinationradiobutton = gtk_radio_button_new_with_label
			(NULL, _("Printer"));
		gtk_box_pack_start
			(GTK_BOX (destvbox), printerdestinationradiobutton, FALSE, FALSE, 0);
		printerdestinationradiobutton_group = gtk_radio_button_get_group
			(GTK_RADIO_BUTTON (printerdestinationradiobutton));
		filedestinationradiobutton = gtk_radio_button_new_with_label
			(printerdestinationradiobutton_group, _("File"));
		gtk_box_pack_start
			(GTK_BOX (destvbox), filedestinationradiobutton, FALSE, FALSE, 0);

		paperframe = gtk_frame_new (_("Paper"));
		gtk_box_pack_start (GTK_BOX (phbox), paperframe, FALSE, FALSE, 0);
		papervbox = gtk_vbox_new (TRUE, 0);
		gtk_container_add (GTK_CONTAINER (paperframe), papervbox);
		papersizehbox = gtk_hbox_new (TRUE, 0);
		gtk_box_pack_start
			(GTK_BOX (papervbox), papersizehbox, FALSE, FALSE, 0);
		papersizelabel = gtk_label_new (_("Papersize"));
		gtk_box_pack_start
			(GTK_BOX (papersizehbox), papersizelabel, FALSE, FALSE, 0);
		papersizecombo = gtk_combo_box_entry_new_text ();
		gtk_box_pack_start
			(GTK_BOX (papersizehbox), papersizecombo, FALSE, FALSE, 0);
		gtk_widget_set_size_request (papersizecombo, 80, -1);
		gtk_combo_box_append_text (GTK_COMBO_BOX (papersizecombo), "a4");
		gtk_combo_box_append_text (GTK_COMBO_BOX (papersizecombo), "letter");
		gtk_editable_set_editable
			(GTK_EDITABLE (GTK_BIN(papersizecombo)->child), FALSE);
		gtk_entry_set_activates_default
		        (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (papersizecombo))), TRUE);
		pointsizehbox = gtk_hbox_new (TRUE, 0);
		gtk_box_pack_start
			(GTK_BOX (papervbox), pointsizehbox, FALSE, FALSE, 0);
		pointsizelabel = gtk_label_new (_("Pointsize"));
		gtk_box_pack_start
			(GTK_BOX (pointsizehbox), pointsizelabel, FALSE, FALSE, 0);
		pointsizecombo = gtk_combo_box_entry_new_text ();
		gtk_box_pack_start
			(GTK_BOX (pointsizehbox), pointsizecombo, FALSE, FALSE, 0);
		gtk_widget_set_size_request (pointsizecombo, 80, -1);
		gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "6");
		gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "7");
		gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "8");
		gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "9");
		gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "10");
		gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "11");
		gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "12");
		gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "13");
		gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "14");
		gtk_editable_set_editable
			(GTK_EDITABLE (GTK_BIN(pointsizecombo)->child),	FALSE);
		gtk_entry_set_activates_default
		        (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (pointsizecombo))), TRUE);
		orientationhbox = gtk_hbox_new (TRUE, 0);
		gtk_box_pack_start
			(GTK_BOX (papervbox), orientationhbox, FALSE, FALSE, 0);
		orientationlabel = gtk_label_new (_("Orientation"));
		gtk_box_pack_start
			(GTK_BOX (orientationhbox), orientationlabel, FALSE, FALSE, 0);
		orientationcombo = gtk_combo_box_entry_new_text ();
		gtk_box_pack_start
			(GTK_BOX (orientationhbox), orientationcombo, FALSE, FALSE, 0);
		gtk_widget_set_size_request (orientationcombo, 80, -1);
		gtk_combo_box_append_text (GTK_COMBO_BOX (orientationcombo),
			_("portrait"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (orientationcombo),
			_("landscape"));
		gtk_editable_set_editable
			(GTK_EDITABLE (GTK_BIN(orientationcombo)->child), FALSE);
		gtk_entry_set_activates_default
		        (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (orientationcombo))), TRUE);
		columnsframe = gtk_frame_new (_("Columns"));
		gtk_box_pack_start (GTK_BOX (pvbox), columnsframe, FALSE, FALSE, 0);
		columnshbox = gtk_hbox_new (TRUE, 0);
		gtk_container_add (GTK_CONTAINER (columnsframe), columnshbox);
		columnsvbox1 = gtk_vbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (columnshbox), columnsvbox1, FALSE, FALSE, 0);
		p1 = gtk_check_button_new_with_label (_("QSO Number"));
		gtk_box_pack_start (GTK_BOX (columnsvbox1), p1, FALSE, FALSE, 0);
		p2 = gtk_check_button_new_with_label (_("Date"));
		gtk_box_pack_start (GTK_BOX (columnsvbox1), p2, FALSE, FALSE, 0);
		p3 = gtk_check_button_new_with_label ("UTC");
		gtk_box_pack_start (GTK_BOX (columnsvbox1), p3, FALSE, FALSE, 0);
		p4 = gtk_check_button_new_with_label (_("UTC - end"));
		gtk_box_pack_start (GTK_BOX (columnsvbox1), p4, FALSE, FALSE, 0);
		p5 = gtk_check_button_new_with_label (_("Call"));
		gtk_box_pack_start (GTK_BOX (columnsvbox1), p5, FALSE, FALSE, 0);
		p6 = gtk_check_button_new_with_label (_("Frequency"));
		gtk_box_pack_start (GTK_BOX (columnsvbox1), p6, FALSE, FALSE, 0);
		p7 = gtk_check_button_new_with_label (_("Mode"));
		gtk_box_pack_start (GTK_BOX (columnsvbox1), p7, FALSE, FALSE, 0);
		p8 = gtk_check_button_new_with_label ("TX(RST)");
		gtk_box_pack_start (GTK_BOX (columnsvbox1), p8, FALSE, FALSE, 0);
		p9 = gtk_check_button_new_with_label ("RX(RST)");
		gtk_box_pack_start (GTK_BOX (columnsvbox1), p9, FALSE, FALSE, 0);
		columnsvbox2 = gtk_vbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (columnshbox), columnsvbox2, FALSE, FALSE, 0);
		p10 = gtk_check_button_new_with_label (_("Qsl Out"));
		gtk_box_pack_start (GTK_BOX (columnsvbox2), p10, FALSE, FALSE, 0);
		p11 = gtk_check_button_new_with_label (_("Qsl In"));
		gtk_box_pack_start (GTK_BOX (columnsvbox2), p11, FALSE, FALSE, 0);
		p12 = gtk_check_button_new_with_label (_("Power"));
		gtk_box_pack_start (GTK_BOX (columnsvbox2), p12, FALSE, FALSE, 0);
		p13 = gtk_check_button_new_with_label (_("Name"));
		gtk_box_pack_start (GTK_BOX (columnsvbox2), p13, FALSE, FALSE, 0);
		p14 = gtk_check_button_new_with_label ("QTH");
		gtk_box_pack_start (GTK_BOX (columnsvbox2), p14, FALSE, FALSE, 0);
		p15 = gtk_check_button_new_with_label (_("Locator"));
		gtk_box_pack_start (GTK_BOX (columnsvbox2), p15, FALSE, FALSE, 0);
		p16 = gtk_check_button_new_with_label (_("Freefield1"));
		gtk_box_pack_start (GTK_BOX (columnsvbox2), p16, FALSE, FALSE, 0);
		p17 = gtk_check_button_new_with_label (_("Freefield2"));
		gtk_box_pack_start (GTK_BOX (columnsvbox2), p17, FALSE, FALSE, 0);
		p18 = gtk_check_button_new_with_label (_("Remarks"));
		gtk_box_pack_start (GTK_BOX (columnsvbox2), p18, FALSE, FALSE, 0);

		contestframe = gtk_frame_new (_("Contests"));
		gtk_box_pack_start (GTK_BOX (pvbox), contestframe, FALSE, FALSE, 0);
		contestcheckbutton = gtk_check_button_new_with_label
			(_("Add empty Multiplier and Points columns"));
		gtk_container_add (GTK_CONTAINER (contestframe), contestcheckbutton);
		gtk_label_set_line_wrap
                (GTK_LABEL (GTK_BIN (contestcheckbutton)->child), TRUE);

		/* Store pointers to all widgets, for use by lookup_widget(). */
		GLADE_HOOKUP_OBJECT_NO_REF (printdialog, printdialog, "printdialog");
		GLADE_HOOKUP_OBJECT (printdialog, printallradiobutton, "printallradiobutton");
		GLADE_HOOKUP_OBJECT (printdialog, printrangeradiobutton, "printrangeradiobutton");
		GLADE_HOOKUP_OBJECT (printdialog, printlowentry, "printlowentry");
		GLADE_HOOKUP_OBJECT (printdialog, printrangelabel, "printrangelabel");
		GLADE_HOOKUP_OBJECT (printdialog, printhighentry, "printhighentry");
		GLADE_HOOKUP_OBJECT (printdialog, printerdestinationradiobutton, "printerdestinationradiobutton");
		GLADE_HOOKUP_OBJECT (printdialog, filedestinationradiobutton, "filedestinationradiobutton");
		GLADE_HOOKUP_OBJECT (printdialog, papersizecombo, "papersizecombo");
		GLADE_HOOKUP_OBJECT (printdialog, pointsizecombo, "pointsizecombo");
		GLADE_HOOKUP_OBJECT (printdialog, orientationcombo, "orientationcombo");
		GLADE_HOOKUP_OBJECT (printdialog, p1, "p1");
		GLADE_HOOKUP_OBJECT (printdialog, p2, "p2");
		GLADE_HOOKUP_OBJECT (printdialog, p3, "p3");
		GLADE_HOOKUP_OBJECT (printdialog, p4, "p4");
		GLADE_HOOKUP_OBJECT (printdialog, p5, "p5");
		GLADE_HOOKUP_OBJECT (printdialog, p6, "p6");
		GLADE_HOOKUP_OBJECT (printdialog, p7, "p7");
		GLADE_HOOKUP_OBJECT (printdialog, p8, "p8");
		GLADE_HOOKUP_OBJECT (printdialog, p9, "p9");
		GLADE_HOOKUP_OBJECT (printdialog, p10, "p10");
		GLADE_HOOKUP_OBJECT (printdialog, p11, "p11");
		GLADE_HOOKUP_OBJECT (printdialog, p12, "p12");
		GLADE_HOOKUP_OBJECT (printdialog, p13, "p13");
		GLADE_HOOKUP_OBJECT (printdialog, p14, "p14");
		GLADE_HOOKUP_OBJECT (printdialog, p15, "p15");
		GLADE_HOOKUP_OBJECT (printdialog, p16, "p16");
		GLADE_HOOKUP_OBJECT (printdialog, p17, "p17");
		GLADE_HOOKUP_OBJECT (printdialog, p18, "p18");
		GLADE_HOOKUP_OBJECT (printdialog, contestcheckbutton, "contestcheckbutton");

		gtk_button_set_label (GTK_BUTTON (p16), preferences.freefield1);
		gtk_button_set_label (GTK_BUTTON (p17), preferences.freefield2);

		if (preferences.printall == 0)
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printallradiobutton),
						TRUE);
			gtk_widget_set_sensitive (printlowentry, 0);
			gtk_widget_set_sensitive (printhighentry, 0);
			gtk_widget_set_sensitive (printrangelabel, 0);
		}
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printrangeradiobutton),
						TRUE);
			gtk_widget_set_sensitive (printlowentry, 1);
			gtk_widget_set_sensitive (printhighentry, 1);
			gtk_widget_set_sensitive (printrangelabel, 1);
		}

		if (preferences.printdestination == 0)
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
						(printerdestinationradiobutton), TRUE);
		else
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
						(filedestinationradiobutton), TRUE);

		logwindow = g_list_nth_data (logwindowlist, page);

		temp = g_strdup_printf ("1");
		gtk_entry_set_text (GTK_ENTRY (printlowentry), temp);
		temp = g_strdup_printf ("%d", logwindow->qsos);
		gtk_entry_set_text (GTK_ENTRY (printhighentry), temp);
		g_free (temp);

		if (preferences.printsize == 0)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(papersizecombo)->child), "a4");
		else
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(papersizecombo)->child), "letter");

		if (preferences.printpoint == 0)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "10");
		else if (preferences.printpoint == 1)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "11");
		else if (preferences.printpoint == 2)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "12");
		else if (preferences.printpoint == 3)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "13");
		else if (preferences.printpoint == 4)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "14");
		else if (preferences.printpoint == 5)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "6");
		else if (preferences.printpoint == 6)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "7");
		else if (preferences.printpoint == 7)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "8");
		else if (preferences.printpoint == 8)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "9");

		if (preferences.printorientation == 0)
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(orientationcombo)->child),
				_("portrait"));
		else
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN(orientationcombo)->child),
				_("landscape"));

		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), NR);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p1), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p1), FALSE);
			gtk_widget_set_sensitive (p1, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), DATE);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p2), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p2), FALSE);
			gtk_widget_set_sensitive (p2, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), GMT);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p3), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p3), FALSE);
			gtk_widget_set_sensitive (p3, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), GMTEND);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p4), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p4), FALSE);
			gtk_widget_set_sensitive (p4, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), CALL);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p5), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p5), FALSE);
			gtk_widget_set_sensitive (p5, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), BAND);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p6), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p6), FALSE);
			gtk_widget_set_sensitive (p6, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), MODE);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p7), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p7), FALSE);
			gtk_widget_set_sensitive (p7, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), RST);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p8), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p8), FALSE);
			gtk_widget_set_sensitive (p8, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), MYRST);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p9), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p9), FALSE);
			gtk_widget_set_sensitive (p9, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), QSLOUT);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p10), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p10), FALSE);
			gtk_widget_set_sensitive (p10, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), QSLIN);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p11), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p11), FALSE);
			gtk_widget_set_sensitive (p11, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), POWER);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p12), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p12), FALSE);
			gtk_widget_set_sensitive (p12, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), NAME);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p13), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p13), FALSE);
			gtk_widget_set_sensitive (p13, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), QTH);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p14), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p14), FALSE);
			gtk_widget_set_sensitive (p14, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), LOCATOR);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p15), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p15), FALSE);
			gtk_widget_set_sensitive (p15, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), U1);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p16), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p16), FALSE);
			gtk_widget_set_sensitive (p16, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), U2);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p17), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p17), FALSE);
			gtk_widget_set_sensitive (p17, 0);
		}
		column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), REMARKS);
		if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p18), TRUE);
		else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p18), FALSE);
			gtk_widget_set_sensitive (p18, 0);
		}

		g_signal_connect (G_OBJECT (printallradiobutton), "toggled",
			G_CALLBACK (on_printradiobutton_toggled), "1");
		g_signal_connect (G_OBJECT (printrangeradiobutton), "toggled",
			G_CALLBACK (on_printradiobutton_toggled), "2");
		gtk_dialog_set_default_response (GTK_DIALOG (printdialog),
						 GTK_RESPONSE_OK);

		gtk_widget_show_all (printdialog);
		response = gtk_dialog_run (GTK_DIALOG(printdialog));
		if (response == GTK_RESPONSE_OK)
		{
			printokbutton_clicked (NULL);
		}
		gtk_widget_destroy (printdialog);
	}
}
