# xlog.spec
#
# Copyright (c) 2002-2005 Joop Stakenborg pg4i@amsat.org
#
%define name xlog
%define version 1.4
%define release 1

Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
Group: Applications/Databases
Prefix: %{_prefix}
Summary: Logging program for Hamradio Operators
Vendor: Joop Stakenborg <pg4i@amsat.org>
URL: http://www.qsl.net/pg4i/linux/xlog.html
Packager: Joop Stakenborg <pg4i@amsat.org>
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/root-%{name}-%{version}

Requires: gtk2 >= 2.4.0

%description
xlog is a logging program for amateur radio operators. The log is stored
into a text file. QSO's are presented in a list. Items in the list can be
added, deleted or updated. For each contact, dxcc information is displayed
and bearings and distance is calculated, both short and long path.
xlog supports trlog, adif, cabrillo, edit, twlog and editest files.

%prep
%setup


%build
export RPM_OPT_FLAGS="-O2 -march=i386"
export CFLAGS="-O2"
%configure --enable-hamlib
make


%install
%{__rm} -rf %{buildroot}
%makeinstall
%find_lang %{name}
desktop-file-install \
	--vendor "" \
	--dir %{buildroot}%{_datadir}/applications \
	%{buildroot}%{_datadir}/applications/%{name}.desktop


%clean
%{__rm} -rf %{buildroot}


%post
if (update-mime-database -v &> /dev/null); then
	update-mime-database "%{_datadir}/mime" > /dev/null
fi
if (update-desktop-database --usage &>/dev/null); then
	update-desktop-database
fi

%postun
if (update-mime-database -v &> /dev/null); then
	update-mime-database "%{_datadir}/mime" > /dev/null
fi
if (update-desktop-database --usage &>/dev/null); then
	update-desktop-database
fi


%files -f %{name}.lang
%defattr(-,root,root)
%doc
%{_bindir}/xlog
%{_datadir}/xlog/*
%{_datadir}/pixmaps/*
%{_datadir}/applications/*.desktop
%{_datadir}/application-registry/*
%{_datadir}/mime-info/*
%{_datadir}/mime/packages/*
%{_datadir}/mimelnk/text/*
%{_datadir}/applnk/Applications/*
%{_datadir}/man/*


%changelog
* Sat Oct 16 2004 Joop Stakenborg
- Freedesktop.org mime support and cleanups.

* Sat Feb 09 2002 Joop Stakenborg
- Initial spec file
