/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* callbacks_preferencesdialog.c
 *
 * callbacks for the preferences dialog, both for the widgets and preferences. 
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <string.h>

#include "callbacks_preferencesdialog.h"
#include "gui_utils.h"
#include "support.h"
#include "types.h"
#include "log.h"
#include "utils.h"

extern GtkWidget *mainwindow;
extern GtkWidget *keyerwindow;
extern preferencestype preferences;
extern keyerstatetype keyerstate;
extern GtkWidget *preferencesdialog;
extern gint clocktimer, savetimer;
extern GList *logwindowlist;

#if WANT_HAMLIB
/* return value for setting widgets */
gint
whichhamlibwidgets (gboolean frequency, gboolean smeter)
{
	if (frequency && smeter)
		return (4);
	else if (frequency && (!smeter))
		return (2);
	else if ((!frequency) && smeter)
		return (3);
	else
		return (1);
}
#endif

/* check save value, if autosave value larger than 0 start timer */
void
set_autosave (gint value, gint saving)
{
	if (saving != 1 && preferences.saving == 1)
	{
		g_source_remove (savetimer);
		savetimer = -1;
	}
	else if (saving == 1 && preferences.saving != 1)
	{
		savetimer =
			g_timeout_add (value * 60 * 1000, (GSourceFunc) autosave, NULL);
	}
	else if (value != preferences.autosave)
	{			/* new value, stop and start timer */
		g_source_remove (savetimer);
		savetimer =
			g_timeout_add (value * 60 * 1000, (GSourceFunc) autosave, NULL);
	}
	preferences.autosave = value;
	preferences.saving = saving;
}

/* set the theme if changed */
void
set_theme (gchar * color, gchar * font, gboolean alsoforlog)
{
	GtkWidget *clocklabel, *qsoframe, *dxccframe, *locatorframe,
		*splabel, *cqlabel;
	gint i;
	logtype *logwindow;
	gint logcolor;
#if WANT_HAMLIB
	GtkWidget *frequencylabel;
#endif

	logcolor = alsoforlog ? 1 : 0;

	if (g_ascii_strcasecmp (color, preferences.themecolor) ||
			g_ascii_strcasecmp (font, preferences.themefont))
	{
		clocklabel = lookup_widget (mainwindow, "clocklabel");
		setlabelstyle (clocklabel, color, font);
#if WANT_HAMLIB
		frequencylabel = lookup_widget (mainwindow, "frequencylabel");
		setlabelstyle (frequencylabel, color, font);
#endif
		qsoframe = lookup_widget (mainwindow, "qsoframe");
		dxccframe = lookup_widget (mainwindow, "dxccframe");
		locatorframe = lookup_widget (mainwindow, "locatorframe");
		setframestyle (qsoframe, color, font);
		setframestyle (dxccframe, color, font);
		setframestyle (locatorframe, color, font);
		for (i = 0; i < g_list_length (logwindowlist); i++)
		{
			logwindow = g_list_nth_data (logwindowlist, i);
			setlabelstyle (logwindow->label, color, font);
		}
		if (keyerwindow)
		{
			cqlabel = lookup_widget (keyerwindow, "cqlabel");
			splabel = lookup_widget (keyerwindow, "splabel");
			if (keyerstate.cqmode)
				setlabelstyle (cqlabel, color, NULL);
			else
				setlabelstyle (splabel, color, NULL);
		}
		preferences.themecolor = color;
		preferences.themefont = g_strdup (font);
	}

	preferences.logcolor = logcolor;
}

/* set savepath if changed */
void
set_path (gchar * pathstr)
{
	if (strlen (pathstr) > 0)
	{
		if (g_ascii_strcasecmp (preferences.savedir, pathstr))
			preferences.savedir = g_strdup (pathstr);
	}
}

/* set backuppath if changed */
void
set_backuppath (gchar * pathstr)
{
	if (strlen (pathstr) > 0)
	{
		if (g_ascii_strcasecmp (preferences.backupdir, pathstr))
			preferences.backupdir = g_strdup (pathstr);
	}
}

/* set logs to load if changed */
void
set_logstoload (gchar * logs)
{
	gchar **logsplit;

	if (g_ascii_strcasecmp (logs, preferences.logstoload) != 0)
	{
		if (strlen (logs) == 0)
			logs = g_strdup ("*");
		logsplit = g_strsplit (logs, ",", -1);	/* delete spaces */
		deletespaces (logsplit);
		preferences.logstoload = g_strjoinv (",", logsplit);
		g_strfreev (logsplit);
	}
}

/* set QTH locator */
void
set_qthlocator (gchar * locator)
{
	if (g_ascii_strcasecmp (locator, preferences.locator) != 0)
	{
		if (strlen (locator) == 0)
			locator = g_strdup ("AA00AA");
		preferences.locator = g_strdup (locator);
	}
}

/* set callsign */
void
set_callsign (gchar * callsign)
{
	if (g_ascii_strcasecmp (callsign, preferences.callsign) != 0)
	{
		if (strlen (callsign) == 0)
			callsign = g_strdup ("N0CALL");
		preferences.callsign = g_strdup (callsign);
	}
}

/* enable/disable clock */
void
set_clock (gboolean on)
{
	GtkWidget *clockhandlebox;

	clockhandlebox = lookup_widget (mainwindow, "clockhandlebox");
	if (on)
	{			/* yes, we want clock */
		if (preferences.clock == 0)
			clocktimer = g_timeout_add (1000, (GSourceFunc) updateclock, NULL);
		gtk_widget_show (clockhandlebox);
		preferences.clock = 1;
	}
	else
	{			/* no clock */
		if (preferences.clock > 0)
			g_source_remove (clocktimer);
		clocktimer = -1;
		gtk_widget_hide (clockhandlebox);
		preferences.clock = 0;
	}
}

#if WANT_HAMLIB
/* check if hamlib has changed */
gboolean hamlib_changed (gint hamlibwidgets, gchar *radio, gchar *device, 
	gint polltime, gchar *rigconf)
{

	if (preferences.hamlib != hamlibwidgets)
		return TRUE;
	else if (g_ascii_strcasecmp (preferences.rigconf, rigconf))
		return TRUE;
	else if (g_ascii_strcasecmp (preferences.radio, radio))
		return TRUE;
	else if (g_ascii_strcasecmp (preferences.device, device))
		return TRUE;
	else if (preferences.polltime != polltime)
		return TRUE;
	else 
	/* FALSE is returned when nothing is changed */
		return FALSE;
}
#endif

/* toggle sensistivity of backup entry and button */
void
on_backupradiobutton_toggled (GtkToggleButton * togglebutton,
	gpointer user_data)
{
	gboolean state;
	GtkWidget *backupentry, *backupbutton;

	backupentry = lookup_widget (preferencesdialog, "backupentry");
	backupbutton = lookup_widget (preferencesdialog, "backupbutton");
	state = gtk_toggle_button_get_active (togglebutton);
	if (state)
	{
		gtk_widget_set_sensitive(backupentry, TRUE);
		gtk_widget_set_sensitive(backupbutton, TRUE);
	}
	else
	{
		gtk_widget_set_sensitive(backupentry, FALSE);
		gtk_widget_set_sensitive(backupbutton, FALSE);
	}
}

/* toggle sensistivity of band widgets in preferences dialog */
void
on_bandsradiobutton_toggled (GtkToggleButton * togglebutton,
	gpointer user_data)
{
	GtkWidget *bandslabel, *bandsentry;

	bandslabel = lookup_widget (preferencesdialog, "bandslabel");
	bandsentry = lookup_widget (preferencesdialog, "bandsentry");
	switch (atoi (user_data))
	{
	case 1:
		gtk_widget_set_sensitive (bandslabel, 0);
		gtk_widget_set_sensitive (bandsentry, 0);
		break;
	case 2:
		gtk_widget_set_sensitive (bandslabel, 1);
		gtk_widget_set_sensitive (bandsentry, 1);
		break;
	}
}

/* toggle sensistivity of modes widgets in preferences dialog */
void
on_modesradiobutton_toggled (GtkToggleButton * togglebutton,
					 gpointer user_data)
{
	GtkWidget *modeslabel, *modesentry;

	modeslabel = lookup_widget (preferencesdialog, "modeslabel");
	modesentry = lookup_widget (preferencesdialog, "modesentry");
	switch (atoi (user_data))
	{
	case 1:
		gtk_widget_set_sensitive (modeslabel, 0);
		gtk_widget_set_sensitive (modesentry, 0);
		break;
	case 2:
		gtk_widget_set_sensitive (modeslabel, 1);
		gtk_widget_set_sensitive (modesentry, 1);
		break;
	}

}


/* check autosave */
void
on_autosaveradiobutton_toggled (GtkToggleButton * togglebutton,
				gpointer user_data)
{
	gboolean state;
	GtkWidget *autosaveframe;

	state = gtk_toggle_button_get_active (togglebutton);
	autosaveframe = lookup_widget (preferencesdialog, "autosaveframe");
	gtk_widget_set_sensitive (autosaveframe, state);
}

/* check polling */
void
on_pollingcheckbutton_toggled (GtkToggleButton * togglebutton,
	gpointer user_data)
{
	gboolean state;
	GtkWidget *pollingframe;

	state = gtk_toggle_button_get_active (togglebutton);
	pollingframe = lookup_widget (preferencesdialog, "pollingframe");
	gtk_widget_set_sensitive (pollingframe, state);
}

/* toggle hamlib widgets in the preferences dialog */
void
on_hamlibcheckbutton_toggled (GtkToggleButton * togglebutton,
	gpointer user_data)
{
	GtkWidget *hamlibframe, *pollingframe, *pollingcheckbutton;
	gboolean state;

	hamlibframe = lookup_widget (preferencesdialog, "hamlibframe");
	state = gtk_toggle_button_get_active (togglebutton);
	gtk_widget_set_sensitive (hamlibframe, state);

	if (state)
	{
		pollingcheckbutton = lookup_widget (preferencesdialog,
			"pollingcheckbutton");
		pollingframe = lookup_widget (preferencesdialog, "pollingframe");
		state = gtk_toggle_button_get_active
			(GTK_TOGGLE_BUTTON (pollingcheckbutton));
		gtk_widget_set_sensitive (pollingframe, state);
	}
}

