/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_pathselectiondialog.c - creation and destruction of the path selection dialog
 *
 * this dialog used by the preferences dialog. You can select a path where your logs
 * are saved. If OK is clicked, the entry in the preferences dialog is updated. The
 * actual path is set when OK is clicked in the preferences dialog.
 */

#include <gtk/gtk.h>

#include "gui_pathselectiondialog.h"
#include "support.h"

extern GtkWidget *preferencesdialog;

void
on_pathbutton_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *pathselection, *pathentry;
	GdkPixbuf *pathselection_icon_pixbuf;
	gint response;
	gchar *selpath;

	pathselection = gtk_file_chooser_dialog_new (_("xlog - select a directory"),
    	GTK_WINDOW(preferencesdialog), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, 
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, 
		GTK_RESPONSE_OK, NULL);

	gtk_window_set_position (GTK_WINDOW (pathselection), GTK_WIN_POS_MOUSE);
	pathselection_icon_pixbuf = create_pixbuf ("xlog.png");
	if (pathselection_icon_pixbuf)
	{
		gtk_window_set_icon (GTK_WINDOW (pathselection), pathselection_icon_pixbuf);
		g_object_unref (pathselection_icon_pixbuf);
	}

	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (pathselection), 
		g_get_home_dir ());
	gtk_widget_set_sensitive (preferencesdialog, 0);
	response = gtk_dialog_run (GTK_DIALOG(pathselection));
	if (response == GTK_RESPONSE_OK)
	{
		selpath = gtk_file_chooser_get_filename 
			(GTK_FILE_CHOOSER (pathselection));
		pathentry = lookup_widget (preferencesdialog, "pathentry");
		gtk_entry_set_text (GTK_ENTRY (pathentry), selpath);
		g_free (selpath);
	}
	gtk_widget_set_sensitive (preferencesdialog, 1);
	gtk_widget_destroy (pathselection);
}
