/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_mainwindow_menu.c - menu's which don't create a dialog
 */

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#ifndef __USE_XOPEN
#define __USE_XOPEN
#endif
#include <time.h>

#include "callbacks_mainwindow_menu.h"
#include "gui_savedialog.h"
#include "support.h"
#include "types.h"
#include "utils.h"
#include "log.h"

#include "strptime.h"
#ifndef HAVE_STRPTIME
#define strptime(s,f,t) mystrptime(s,f,t)
#endif

#if WANT_HAMLIB
# include <hamlib/rig.h>
# include "hamlib-utils.h"
#endif

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern preferencestype preferences;
extern GList *logwindowlist;

/* get the action name and use it to switch logs <alt>1, <alt>2, etc. */
void 
on_menu_log_activate (GtkAction *action, gpointer user_data)
{
	const gchar *name;
	gint lognr;

	name = gtk_action_get_name(action);
	lognr = atoi (name);
	if (lognr <= g_list_length (logwindowlist))
		gtk_notebook_set_current_page (GTK_NOTEBOOK (mainnotebook), lognr - 1);
}


void
on_menu_exit_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *savedialog;
	gint i;
	logtype *logwindow;
	gboolean logchanged = FALSE;

	for (i = 0; i < g_list_length (logwindowlist); i++)
		{
			logwindow = g_list_nth_data (logwindowlist, i);
			if (logwindow->logchanged) logchanged = TRUE;
		}

	if (logchanged)
		{
			savedialog = create_savedialog ();
			gtk_widget_set_sensitive (mainwindow, 0);
			gtk_widget_show (savedialog);
		}
	else
		{
			save_windowsize_and_cleanup ();
			gtk_main_quit ();
		}
}

/* save current page to the log */
void
on_menu_save_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	gchar *temp;
	logtype *logwindow;
	gint page;

	page = gtk_notebook_get_current_page (GTK_NOTEBOOK(mainnotebook));
	if (page >= 0)
	{
		logwindow = g_list_nth_data (logwindowlist, page);
		savelog (logwindow, logwindow->filename, TYPE_FLOG, 1 , logwindow->qsos);
		temp = g_strdup_printf (_("Log saved to %s"), logwindow->filename);
		update_statusbar (temp);
		g_free (temp);
		logwindow->logchanged = FALSE;
		gtk_label_set_text (GTK_LABEL (logwindow->label), logwindow->logname);
	}
}

/* clear all the fields in the qso frame */
void
on_clearframe_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *dateentry, *gmtentry, *callentry, *rstentry, *myrstentry,
		*remarksentry, *modeentry, *bandentry, *incheckbutton, *outcheckbutton,
		*endentry, *powerentry, *nameentry, *qthentry, *locatorentry,
		*unknownentry1, *unknownentry2, *modeoptionmenu, *bandoptionmenu,
		*qsoframe, *locatorframe, *datebutton, *framelabel;
	logtype *logwindow;
	gint i;
	GtkTreeIter selected;
	GtkTreeModel *model;

	dateentry = lookup_widget (mainwindow, "dateentry");
	gmtentry = lookup_widget (mainwindow, "gmtentry");
	endentry = lookup_widget (mainwindow, "endentry");
	callentry = lookup_widget (mainwindow, "callentry");
	bandentry = lookup_widget (mainwindow, "bandentry");
	modeentry = lookup_widget (mainwindow, "modeentry");
	rstentry = lookup_widget (mainwindow, "rstentry");
	myrstentry = lookup_widget (mainwindow, "myrstentry");
	remarksentry = lookup_widget (mainwindow, "remarksentry");
	modeoptionmenu = lookup_widget (mainwindow, "modeoptionmenu");
	bandoptionmenu = lookup_widget (mainwindow, "bandoptionmenu");
	incheckbutton = lookup_widget (mainwindow, "incheckbutton");
	outcheckbutton = lookup_widget (mainwindow, "outcheckbutton");
	powerentry = lookup_widget (mainwindow, "powerentry");
	nameentry = lookup_widget (mainwindow, "nameentry");
	qthentry = lookup_widget (mainwindow, "qthentry");
	locatorentry = lookup_widget (mainwindow, "locatorentry");
	unknownentry1 = lookup_widget (mainwindow, "unknownentry1");
	unknownentry2 = lookup_widget (mainwindow, "unknownentry2");

	for (i = 0; i < g_list_length (logwindowlist); i++)
		{
			logwindow = g_list_nth_data (logwindowlist, i);
			if (gtk_tree_selection_get_selected	(gtk_tree_view_get_selection (GTK_TREE_VIEW(logwindow->treeview)), &model, &selected))
				gtk_tree_selection_unselect_all (gtk_tree_view_get_selection(GTK_TREE_VIEW (logwindow->treeview)));
		}
	datebutton = lookup_widget (mainwindow, "datebutton");
	gtk_widget_grab_focus (datebutton);

	gtk_editable_delete_text (GTK_EDITABLE (dateentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (gmtentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (endentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (callentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (modeentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (bandentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (rstentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (myrstentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (remarksentry), 0, -1);
	gtk_combo_box_set_active (GTK_COMBO_BOX(modeoptionmenu), 0);
	gtk_combo_box_set_active (GTK_COMBO_BOX(bandoptionmenu), 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outcheckbutton), FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (incheckbutton), FALSE);
	gtk_editable_delete_text (GTK_EDITABLE (powerentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (nameentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (qthentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (locatorentry), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (unknownentry1), 0, -1);
	gtk_editable_delete_text (GTK_EDITABLE (unknownentry2), 0, -1);

	qsoframe = lookup_widget (mainwindow, "qsoframe");
	framelabel = gtk_frame_get_label_widget (GTK_FRAME(qsoframe));
	gtk_label_set_text (GTK_LABEL (framelabel), _("New QSO"));

	locatorframe = lookup_widget (mainwindow, "locatorframe");
	if (GTK_WIDGET_VISIBLE (locatorframe))
		{
		locatorframe = lookup_widget (mainwindow, "locatorframe");
			framelabel = gtk_frame_get_label_widget (GTK_FRAME(locatorframe));
			gtk_label_set_text (GTK_LABEL (framelabel), _("Locator"));
		}
}

/* click all buttons when hamlib enabled, fill in defaults */
void
on_clickall_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *datebutton, *gmtbutton, *endbutton, *endhbox,
		*myrstentry, *unknown1hbox, *unknown2hbox, *unknownentry1, *unknownentry2,
		*remarksvbox, *remarksentry, *bandentry, *modeentry, *rstentry, *powerhbox, 
		*powerentry, *endentry, *callentry;
#if WANT_HAMLIB
	GtkWidget *mhzbutton, *modebutton, *rstbutton, *powerbutton;
#endif

	datebutton = lookup_widget (mainwindow, "datebutton");
	gmtbutton = lookup_widget (mainwindow, "gmtbutton");
	g_signal_emit_by_name (G_OBJECT (datebutton), "clicked");
	g_signal_emit_by_name (G_OBJECT (gmtbutton), "clicked");
	endhbox = lookup_widget (mainwindow, "endhbox");
	if (GTK_WIDGET_VISIBLE (endhbox))
		{
			endentry = lookup_widget (mainwindow, "endentry");
			if (strlen(gtk_editable_get_chars (GTK_EDITABLE (endentry), 0, -1)) == 0)
			{
				endbutton = lookup_widget (mainwindow, "endbutton");
				g_signal_emit_by_name (G_OBJECT (endbutton), "clicked");
			}
		}

	bandentry = lookup_widget (mainwindow, "bandentry");
	modeentry = lookup_widget (mainwindow, "modeentry");
	rstentry = lookup_widget (mainwindow, "rstentry");
	powerhbox = lookup_widget (mainwindow, "powerhbox");
	powerentry = lookup_widget (mainwindow, "powerentry");
#if WANT_HAMLIB
	if (preferences.hamlib > 0)
		{ /* when polling use state struct else retrieve info from
			the rig one by one */
			if (preferences.polltime == 0) get_riginfo();
			if (strlen(gtk_editable_get_chars (GTK_EDITABLE (bandentry), 0, -1)) == 0)
			{
				mhzbutton = lookup_widget (mainwindow, "mhzbutton");
				g_signal_emit_by_name (G_OBJECT (mhzbutton), "clicked");
			}
			if (strlen(gtk_editable_get_chars (GTK_EDITABLE (modeentry), 0, -1)) == 0)
			{
				modebutton = lookup_widget (mainwindow, "modebutton");
				g_signal_emit_by_name (G_OBJECT (modebutton), "clicked");
			}
			if (strlen(gtk_editable_get_chars (GTK_EDITABLE (rstentry), 0, -1)) == 0)
			{
				rstbutton = lookup_widget (mainwindow, "rstbutton");
				g_signal_emit_by_name (G_OBJECT (rstbutton), "clicked");
			}
			if (GTK_WIDGET_VISIBLE (powerhbox))
			{
				if (strlen(gtk_editable_get_chars (GTK_EDITABLE (powerentry), 0, -1)) 
					== 0)
				{
					powerbutton = lookup_widget (mainwindow, "powerbutton");
					g_signal_emit_by_name (G_OBJECT (powerbutton), "clicked");
				}
			}
		}
	else
	{
		if (g_ascii_strcasecmp (preferences.defaultmhz, "?"))
			if (strlen(gtk_editable_get_chars (GTK_EDITABLE (bandentry), 0, -1)) == 0)
				gtk_entry_set_text (GTK_ENTRY (bandentry), preferences.defaultmhz);
		if (g_ascii_strcasecmp (preferences.defaultmode, "?"))
			if (strlen(gtk_editable_get_chars (GTK_EDITABLE (modeentry), 0, -1)) == 0)
				gtk_entry_set_text (GTK_ENTRY (modeentry), preferences.defaultmode);
		if (g_ascii_strcasecmp (preferences.defaulttxrst, "?"))
			if (strlen(gtk_editable_get_chars (GTK_EDITABLE (rstentry), 0, -1)) == 0)
				gtk_entry_set_text (GTK_ENTRY (rstentry), preferences.defaulttxrst);
		if (GTK_WIDGET_VISIBLE (powerhbox) && g_ascii_strcasecmp (preferences.defaultpower, "?"))
		{
			if (strlen(gtk_editable_get_chars (GTK_EDITABLE (powerentry), 0, -1)) == 0)
				gtk_entry_set_text (GTK_ENTRY (powerentry), preferences.defaultpower);
		}
	}
#else
	/* set defaults when hamlib disabled */
	if (g_ascii_strcasecmp (preferences.defaultmhz, "?"))
		if (strlen(gtk_editable_get_chars (GTK_EDITABLE (bandentry), 0, -1)) == 0)
			gtk_entry_set_text (GTK_ENTRY (bandentry), preferences.defaultmhz);
	if (g_ascii_strcasecmp (preferences.defaultmode, "?"))
		if (strlen(gtk_editable_get_chars (GTK_EDITABLE (modeentry), 0, -1)) == 0)
			gtk_entry_set_text (GTK_ENTRY (modeentry), preferences.defaultmode);
	if (g_ascii_strcasecmp (preferences.defaulttxrst, "?"))
		if (strlen(gtk_editable_get_chars (GTK_EDITABLE (rstentry), 0, -1)) == 0)
			gtk_entry_set_text (GTK_ENTRY (rstentry), preferences.defaulttxrst);
	if (GTK_WIDGET_VISIBLE (powerhbox) && g_ascii_strcasecmp (preferences.defaultpower, "?"))
	{
		if (strlen(gtk_editable_get_chars (GTK_EDITABLE (powerentry), 0, -1)) == 0)
			gtk_entry_set_text (GTK_ENTRY (powerentry), preferences.defaultpower);
	}
#endif

	/* set non-hamlib defaults */
	if (g_ascii_strcasecmp (preferences.defaultrxrst, "?"))
	{
		myrstentry = lookup_widget (mainwindow, "myrstentry");
		if (strlen(gtk_editable_get_chars (GTK_EDITABLE (myrstentry), 0, -1)) == 0)
			gtk_entry_set_text (GTK_ENTRY (myrstentry), preferences.defaultrxrst);
	}
	unknown1hbox = lookup_widget (mainwindow, "unknown1hbox");
	if (GTK_WIDGET_VISIBLE (unknown1hbox)	&& g_ascii_strcasecmp (preferences.defaultfreefield1, "?"))
	{
		unknownentry1 = lookup_widget (mainwindow, "unknownentry1");
		if (strlen(gtk_editable_get_chars (GTK_EDITABLE (unknownentry1), 0, -1)) == 0)
			gtk_entry_set_text (GTK_ENTRY (unknownentry1), preferences.defaultfreefield1);
	}
	unknown2hbox = lookup_widget (mainwindow, "unknown2hbox");
	if (GTK_WIDGET_VISIBLE (unknown2hbox)	&& g_ascii_strcasecmp (preferences.defaultfreefield2, "?"))
	{
		unknownentry2 = lookup_widget (mainwindow, "unknownentry2");
		if (strlen(gtk_editable_get_chars (GTK_EDITABLE (unknownentry2), 0, -1)) == 0)
			gtk_entry_set_text (GTK_ENTRY (unknownentry2), preferences.defaultfreefield2);
	}
	remarksvbox = lookup_widget (mainwindow, "remarksvbox");
	if (GTK_WIDGET_VISIBLE (remarksvbox) && g_ascii_strcasecmp (preferences.defaultremarks, "?"))
	{
		remarksentry = lookup_widget (mainwindow, "remarksentry");
		if (strlen(gtk_editable_get_chars (GTK_EDITABLE (remarksentry), 0, -1)) == 0)
			gtk_entry_set_text (GTK_ENTRY (remarksentry),	preferences.defaultremarks);
	}
	callentry = lookup_widget (mainwindow, "callentry");
	gtk_widget_grab_focus (callentry);
}

/* show/hide the toolbar */
void
on_view_toolbar_activate (GtkAction *action, gpointer user_data)
{
	GtkWidget *handlebox;
	gboolean status;
	
	handlebox = lookup_widget (mainwindow, "handlebox");
	status = gtk_toggle_action_get_active (GTK_TOGGLE_ACTION (action));
	if (status) gtk_widget_show (handlebox);
		else gtk_widget_hide (handlebox);
}

/* sort function for the date column */
static gint
sort_by_date_time (GtkTreeModel *model, GtkTreeIter *a, GtkTreeIter *b, gpointer user_data)
{
  gchar *date_a, *date_b, *time_a, *time_b, *dt_a, *dt_b, *res = NULL;
  gint result = 0;
	struct tm tm_a, tm_b;
	char buf[255];

  gtk_tree_model_get (model, a, DATE, &date_a, -1);
  gtk_tree_model_get (model, a, GMT, &time_a, -1);
  gtk_tree_model_get (model, b, DATE, &date_b, -1);
  gtk_tree_model_get (model, b, GMT, &time_b, -1);

	/* uses the current locale */
	res = strptime (date_a, "%d %b %Y", &tm_a);
	if (res == NULL)
		g_warning (_("Could not read %s with your current locale"), date_a);
	res = strptime (date_b, "%d %b %Y", &tm_b);
	if (res == NULL)
		g_warning (_("Could not read %s with your current locale"), date_b);

	/* yyyydddhhmm, where ddd is day of the year */
	if (res != NULL)
	{
		strftime (buf, sizeof(buf), "%Y%j", &tm_a);
		dt_a = g_strdup_printf ("%s%s", buf, time_a);
		strftime (buf, sizeof(buf), "%Y%j", &tm_b);
		dt_b = g_strdup_printf ("%s%s", buf, time_b);
	}
	else
	{ /* fallback which does not sort very well */
		dt_a = g_strdup_printf ("%s%s", date_a, time_a);
		dt_b = g_strdup_printf ("%s%s", date_b, time_b);
	}
	result = strcmp (dt_a, dt_b);
	g_free (dt_a);
	g_free (dt_b);

  return -result;
}

void
on_sort_log_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	logtype *logw;
	gint page;
	GtkTreeViewColumn *column;
	GtkTreeModel *model;

	page = gtk_notebook_get_current_page (GTK_NOTEBOOK(mainnotebook));
	if (page >= 0)
	{ /* sort the log and make column unclickable */
		logw = g_list_nth_data (logwindowlist, page);
		column = gtk_tree_view_get_column (GTK_TREE_VIEW(logw->treeview), DATE);
		gtk_tree_view_column_set_sort_column_id (column, DATE);
		model = gtk_tree_view_get_model (GTK_TREE_VIEW(logw->treeview));
		gtk_tree_sortable_set_sort_func (GTK_TREE_SORTABLE (model), DATE, sort_by_date_time, NULL, NULL);
		gtk_tree_view_column_clicked (column);
		logw->logchanged = TRUE;
		gtk_label_set_text (GTK_LABEL (logw->label), g_strconcat (logw->logname, " *", NULL));
		gtk_tree_view_column_set_clickable (column, FALSE);
		update_statusbar (_("Log sorted"));
	}
}
