/*
    $Id: xkeysw.c,v 1.10 2001/08/22 17:22:51 belyi Exp $

    xkeysw - window bound/multi code keyboard switch
    Copyright (C) 2000  Dima Barsky <dima@debian.org>,
                        Igor Belyi  <ibelyi@yahoo.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdio.h>
#include "init.h"

int DebugMask;

void printHelp(char* progname)
{
    printf("Usage: %s [-version] [-help] [-display displayname] "
	   "[-config configfile]\n\n", progname);
}

void printVersion()
{
    printf(
    "%s version %s, Copyright (C) 1999 Dima Barsky, Igor Belyi\n"
    "This is free software, and you are welcome to redistribute it\n"
    "under certain conditions; see COPYING for details.\n"
    "It comes with ABSOLUTELY NO WARRANTY.\n\n",
    PACKAGE, VERSION);
}

int
main(int argc, char **argv)
{
    char *displayname = NULL, *configfile = NULL;
    int i, columns = 2;

    DebugMask = 0;

    for (i = 1; i < argc; i++)
    {
	char *arg = argv[i];

	if (arg[0] == '-') {
	    switch (arg[1]) {
	    case 'd':			/* -display host:dpy */
		displayname = argv[++i];
		continue;
	    case 'c':		/* -config filename */
		configfile = argv[++i];
		continue;
	    case 'r':		/* -restrict number_of_columns */
		if( sscanf( argv[++i], "%d", &columns ) == 1 )
                {
                    if( columns < 1 )
                    {
                        fprintf( stderr,
                            "Number of columns must be greater than 1\n" );
                        exit(1);
                    }
                }
                else
                {
                    fprintf( stderr, "-r requires a numeric argument\n" );
                    exit(1);
                }
		continue;
	    case 'm':		/* Debug mask (octal) */
		if( ++i == argc || sscanf( argv[i], "%o", &DebugMask ) != 1 )
                {
                    fprintf( stderr, "-m requires an octal number\n" );
                    exit(1);
                }
		continue;
	    case 'h':
		printHelp(argv[0]);
		exit(0);
	    case 'v':
		printVersion();
		exit(0);
	    }
	}
    }

    InitializeX(displayname, columns);
    if (Initialize(configfile))
	exit(1);

    XKeySwMainLoop();
    return 0;
}
