/* xkeycaps, Copyright (c) 1991, 1992, 1993 Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the default keymap of the NCD N102 Norwegian keyboard.
 * By Bj|rn Wennberg <bjornw@edb.tih.no>
 */

static const struct default_keycode_map ncd102n_map [] = {

  /* this key has a keycode but no keysym in the default map */
  { 109, 0,		{ 0 }},	/* Setup */


  {   8, 0,		{ XK_Escape }},
  {   9, 0,		{ XK_1,	XK_exclam }},
  {  10, 0,		{ XK_2,	XK_quotedbl }},
  {  11, 0,		{ XK_3,	XK_numbersign }},
  {  12, 0,		{ XK_4 }},
  {  13, 0,		{ XK_5,	XK_percent }},
  {  14, 0,		{ XK_6,	XK_ampersand }},
  {  15, 0,		{ XK_7,	XK_slash }},
  {  16, 0,		{ XK_8,	XK_parenleft }},
  {  17, 0,		{ XK_9,	XK_parenright }},
  {  18, 0,		{ XK_0,	XK_equal }},
  {  19, 0,		{ XK_plus,	XK_question }},
  {  20, 0,		{ XK_backslash,	XK_grave }},
  {  21, 0,		{ XK_BackSpace }},
  {  22, 0,		{ XK_Tab }},
  {  23, 0,		{ XK_Q }},
  {  24, 0,		{ XK_W }},
  {  25, 0,		{ XK_E }},
  {  26, 0,		{ XK_R }},
  {  27, 0,		{ XK_T }},
  {  28, 0,		{ XK_Y }},
  {  29, 0,		{ XK_U }},
  {  30, 0,		{ XK_I }},
  {  31, 0,		{ XK_O }},
  {  32, 0,		{ XK_P }},
  {  33, 0,		{ XK_Adiaeresis }},
  {  34, 0,		{ XK_diaeresis,	XK_asciicircum }},
  {  35, 0,		{ XK_Return }},
  {  36, ControlMask,	{ XK_Control_L }},
  {  37, 0,		{ XK_A }},
  {  38, 0,		{ XK_S }},
  {  39, 0,		{ XK_D }},
  {  40, 0,		{ XK_F }},
  {  41, 0,		{ XK_G }},
  {  42, 0,		{ XK_H }},
  {  43, 0,		{ XK_J }},
  {  44, 0,		{ XK_K }},
  {  45, 0,		{ XK_L }},
  {  46, 0,		{ XK_Odiaeresis }},
  {  47, 0,		{ XK_Adiaeresis }},
  {  48, 0,		{ XK_bar }},
  {  49, ShiftMask,	{ XK_Shift_L }},
  {  50, 0,		{ XK_asterisk,	XK_apostrophe }},
  {  51, 0,		{ XK_Z }},
  {  52, 0,		{ XK_X }},
  {  53, 0,		{ XK_C }},
  {  54, 0,		{ XK_V }},
  {  55, 0,		{ XK_B }},
  {  56, 0,		{ XK_N }},
  {  57, 0,		{ XK_M }},
  {  58, 0,		{ XK_comma,	XK_semicolon }},
  {  59, 0,		{ XK_period,	XK_colon }},
  {  60, 0,		{ XK_underscore,	XK_hyphen }},
  {  61, ShiftMask,	{ XK_Shift_R }},
  {  62, 0,		{ XK_KP_Multiply }},
  {  63, Mod1Mask,	{ XK_Alt_L }},
  {  64, 0,		{ XK_space }},
  {  65, LockMask,	{ XK_Caps_Lock }},
  {  66, 0,		{ XK_F1 }},
  {  67, 0,		{ XK_F2 }},
  {  68, 0,		{ XK_F3 }},
  {  69, 0,		{ XK_F4 }},
  {  70, 0,		{ XK_F5 }},
  {  71, 0,		{ XK_F6 }},
  {  72, 0,		{ XK_F7 }},
  {  73, 0,		{ XK_F8 }},
  {  74, 0,		{ XK_F9 }},
  {  75, 0,		{ XK_F10 }},
  {  76, Mod5Mask,	{ XK_Num_Lock }},
  {  77, 0,		{ XK_Scroll_Lock }},
  {  78, 0,		{ XK_KP_7 }},
  {  79, 0,		{ XK_KP_8 }},
  {  80, 0,		{ XK_KP_9 }},
  {  81, 0,		{ XK_KP_Subtract }},
  {  82, 0,		{ XK_KP_4 }},
  {  83, 0,		{ XK_KP_5 }},
  {  84, 0,		{ XK_KP_6 }},
  {  85, 0,		{ XK_KP_Add }},
  {  86, 0,		{ XK_KP_1 }},
  {  87, 0,		{ XK_KP_2 }},
  {  88, 0,		{ XK_KP_3 }},
  {  89, 0,		{ XK_KP_0 }},
  {  90, 0,		{ XK_KP_Decimal }},
  {  93, 0,		{ XK_less,	XK_greater }},
  {  94, 0,		{ XK_F11 }},
  {  95, 0,		{ XK_F12 }},
  {  96, 0,		{ XK_Home }},
  {  97, 0,		{ XK_Up }},
  {  98, 0,		{ XK_Prior }},
  {  99, 0,		{ XK_Left }},
  { 101, 0,		{ XK_Right }},
  { 102, 0,		{ XK_End }},
  { 103, 0,		{ XK_Down }},
  { 104, 0,		{ XK_Next }},
  { 105, 0,		{ XK_Insert }},
  { 106, 0,		{ XK_Delete }},
  { 107, 0,		{ XK_KP_Enter }},
  { 108, ControlMask,	{ XK_Control_R }},
  { 110, 0,		{ XK_Print }},
  { 111, 0,		{ XK_KP_Divide }},
  { 112, Mod1Mask,	{ XK_Alt_R }}
  };
