#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <xkbselx.h>

#define SIZE 56


static gint delete_callback (GtkWidget * widget, GdkEvent * event,
			     gpointer data);
static gint destroy_callback (GtkWidget * widget, gpointer data);
static gint communicator_callback (GtkWidget * widget, GdkEvent * event);
static gint button_callback (GtkWidget * widget, GdkEvent * event);
static gint menu_callback (gpointer data);


static GtkWidget *menu;
static GtkWidget *label;
static GtkWidget *button;
static GtkWidget *communicator;

static gint first_map;


static gint
delete_callback (GtkWidget * widget, GdkEvent * event, gpointer data)
{

	notify_me (GDK_DISPLAY (),
		   GDK_WINDOW_XWINDOW (communicator->window), 0);
	return (FALSE);
}


static gint
destroy_callback (GtkWidget * widget, gpointer data)
{

	gtk_main_quit ();
	return (FALSE);
}


static gint
communicator_callback (GtkWidget * widget, GdkEvent * event)
{
	sel_info_t selection;
	gint status;
	gint found;

	if (event == NULL || event->type == GDK_BUTTON_PRESS) {
		status =
		    get_current_sel (GDK_DISPLAY (), &selection, &found);

		gtk_label_set_text (GTK_LABEL (label),
				    (!status
				     && found) ? selection.shortcut :
				    "none");
	}

	return (TRUE);
}


static gint
button_callback (GtkWidget * widget, GdkEvent * event)
{
	GdkEventButton *button_event;

	if (event->type == GDK_BUTTON_PRESS) {
		button_event = (GdkEventButton *) event;
		gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
			button_event->button, button_event->time);

		return (TRUE);
	}

	return (FALSE);
}


static gint
menu_callback (gpointer data)
{
	gint status;
	sel_info_t *selection;

	selection = (sel_info_t *) data;

	status = open_db ();
	if (status < 0)
		return (TRUE);

	status = install_map (selection->map_name);
	if (!status)
		publish_current_sel (GDK_DISPLAY (), selection);

	close_db ();

	return (TRUE);
}


int
main (int argc, char *argv[])
{
	GtkStyle *style;
	GtkWidget *main_window;
	GtkWidget *main_container;
	Window x_main_window;
	XWMHints *wm_hints;
	GtkWidget *vbox;
	GtkWidget *menu_item;
	GtkWidget *menu_label1, *menu_label2;
	GtkWidget *menu_box;

	gint M_width;
	db_record_t record;
	gint found;
	gint status;
	gint i;

	gtk_init (&argc, &argv);

	status = read_config ();
	if (status < 0)
		g_error ("failed to read_config ()");

	// main window
	main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize (main_window);
	x_main_window = GDK_WINDOW_XWINDOW (main_window->window);

	main_container = gtk_event_box_new ();
	gtk_widget_set_usize (main_container, SIZE, SIZE);
	gtk_container_add (GTK_CONTAINER (main_window), main_container);
	gtk_widget_realize (main_container);
	gtk_widget_show (main_container);

	wm_hints = XAllocWMHints ();
	wm_hints->window_group = x_main_window;
	wm_hints->icon_window =
	    GDK_WINDOW_XWINDOW (main_container->window);
	wm_hints->icon_x = 0;
	wm_hints->icon_y = 0;
	wm_hints->initial_state = WithdrawnState;
	wm_hints->flags = StateHint |
	    IconPositionHint | WindowGroupHint | IconWindowHint;

	XSetWMHints (GDK_DISPLAY (), x_main_window, wm_hints);
	XSetCommand (GDK_DISPLAY (), x_main_window, argv, argc);

	XFree (wm_hints);

	// delete - destroy
	gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
			    GTK_SIGNAL_FUNC (delete_callback), NULL);
	gtk_signal_connect (GTK_OBJECT (main_window), "destroy",
			    GTK_SIGNAL_FUNC (destroy_callback), NULL);


	// the button
	button = gtk_button_new ();
	gtk_signal_connect_object (GTK_OBJECT (button), "event",
				   GTK_SIGNAL_FUNC (button_callback),
				   NULL);
	gtk_container_add (GTK_CONTAINER (main_container), button);
	gtk_widget_show (button);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (button), vbox);
	gtk_widget_show (vbox);

	// the label
	label = gtk_label_new ("none");
	gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
	gtk_widget_show (label);

	// the communicator
	communicator = gtk_event_box_new ();
	gtk_widget_set_usize (communicator, 1, 1);
	gtk_signal_connect_object (GTK_OBJECT (communicator),
				   "button_press_event",
				   GTK_SIGNAL_FUNC (communicator_callback),
				   NULL);
	gtk_signal_connect_object (GTK_OBJECT (communicator),
				   "button_release_event",
				   GTK_SIGNAL_FUNC (communicator_callback),
				   NULL);
	gtk_box_pack_start (GTK_BOX (vbox), communicator, FALSE, FALSE, 0);
	gtk_widget_show (communicator);

	// the menu
	menu = gtk_menu_new ();

	style = gtk_widget_get_default_style ();
	M_width = gdk_text_width (style->font, "M", 1);

	// menu items
	status = open_db ();
	if (status < 0)
		g_error ("failed to open_db ()");

	first_map = -1;

	for (i = 0; i < n_locale_maps; i++) {
		status =
		    read_db_name (locale_maps[i].map_name, &record,
				  &found);
		if (status < 0)
			g_error ("couldn't read_db_name ()");

		if (!found) {
			g_warning ("Map name %s not found - ignored\n",
				   locale_maps[i].map_name);
			continue;
		}

		menu_item = gtk_menu_item_new ();
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);

		menu_box = gtk_fixed_new ();
		gtk_container_add (GTK_CONTAINER (menu_item), menu_box);
		gtk_widget_show (menu_box);

		menu_label1 = gtk_label_new (locale_maps[i].shortcut);
		gtk_label_set_justify (GTK_LABEL (menu_label1),
				       GTK_JUSTIFY_LEFT);
		gtk_fixed_put (GTK_FIXED (menu_box), menu_label1,
			       8 * M_width, 0);
		gtk_widget_show (menu_label1);

		menu_label2 =
		    gtk_label_new (*record.descr ? record.descr :
				   locale_maps[i].map_name);
		gtk_label_set_justify (GTK_LABEL (menu_label2),
				       GTK_JUSTIFY_LEFT);
		gtk_fixed_put (GTK_FIXED (menu_box), menu_label2, 0, 0);
		gtk_widget_show (menu_label2);

		gtk_signal_connect_object (GTK_OBJECT (menu_item),
					   "activate",
					   GTK_SIGNAL_FUNC (menu_callback),
					   (gpointer) (locale_maps + i));

		if (first_map == -1)
			first_map = i;
	}

	close_db ();

	if (first_map == -1)
		g_error ("No configured maps\n");

	notify_me (GDK_DISPLAY (),
		   GDK_WINDOW_XWINDOW (communicator->window), 1);
	menu_callback ((gpointer) locale_maps + first_map);
	communicator_callback (communicator, NULL);

	gtk_widget_show (main_window);
	gtk_main ();

	return (0);
}
