/* $Id: kbdselmenu-kde.cpp,v 1.2 1999/07/30 16:43:39 stano Exp $ 

   KDE popup menu for keyboard selection

   (C) 1999 Stanislav Meduna <stano@eunet.sk>
*/

#include <kbdselmenu-kde.h>

#include <qfont.h>
#include <kapp.h>

#include <xkbselx.h>

#include <stdio.h>
#include <libintl.h>

#define _(s) gettext(s)

KbdSelPopMenu::KbdSelPopMenu(QWidget *parent, const char *name)
  : KPopupMenu(parent, name),
    infos(0)
{
}

KbdSelPopMenu::~KbdSelPopMenu()
{
	delete [] infos;
}

int KbdSelPopMenu::constructMenu()
{
	int i;
	int r;

	setFont(QFont("Courier", 10, QFont::Normal));

	setTitle(_("Select a keyboard"));

	infos = new (sel_info_t *)[KPM_FirstItem + n_locale_maps];
	if (! infos)
		return -1;

	r = open_db();
	if (r < 0)
		return -1;

	for (i=0; i < n_locale_maps; i++)
        {
		char buf2[MAX_SHORTCUT_LEN+MAX_DESCRIPTION_LEN+16];
		db_record_t rec;
		int found;
		int mi;

		r = read_db_name(locale_maps[i].map_name, &rec, &found);
		if (r < 0)
			return -1;

		if (! found)
                {
			fprintf(stderr, _("Map name %s not found - ignored\n"), 
locale_maps[i].map_name);
			continue;
		}

		sprintf(buf2, "%-8s %s",
                	locale_maps[i].shortcut,
                	*rec.descr ? rec.descr : locale_maps[i].map_name);

		mi = insertItem(buf2);
		infos[mi] = locale_maps + i;
	}

	close_db();

	connect(this, SIGNAL(activated(int)), SLOT(setKbd(int)));

	// Select first keyboard
	setKbd(KPM_FirstItem);
}

void KbdSelPopMenu::setKbd(int idx)
{
	int r;

	// There are people that try to select the menu title :-)
	if (idx < KPM_FirstItem)
		return;

	if (flag_debug)
		fprintf(stderr, "Selected %s\n", infos[idx]->shortcut);

	r = open_db();
	if (r < 0)
		return;

	r = install_map(infos[idx]->map_name);

	if (! r)
		publish_current_sel(KApplication::getKApplication()->getDisplay(), infos[idx]);

	close_db();
	
	return;
}

