/* $Id: dbaccess.h,v 1.2 1999/07/22 09:48:05 stano Exp $

   Database definitions

   This file contains the internal definitions of a database

   (C) 1999 Stanislav Meduna <stano@eunet.sk>

*/

#ifndef _DBACCESS_H_
#define _DBACCESS_H_

#include <config.h>

#ifdef HAVE_NDBM_H
#include <ndbm.h>
#elif HAVE_DB1_NDBM_H
#include <db1/ndbm.h>
#else
#error ndbm.h location not defined
#endif

#include <xkbsel.h>

/* System database or null if not open */
extern DBM *sys_map;

/* User database */
extern DBM *user_map;

/* Create/rebuild the database, system or user one */
int rebuild_db(int user);

/* lex callback, called once for every matched map or redefinition */
void mapinfo_cb(const char *name, const char *descr, const char *pixmap);

/* lex callback, called once for file name specification (for redef files) */
void filename_cb(const char *name);

#endif /* _DBACCESS_H_ */
