#include <config.h>
#include <stdlib.h>
#include <stdio.h>


/*Xlib*/
#include <X11/Xlib.h>

/*atoms*/
#include <X11/Xatom.h>


/*Xt*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

/*Xaw*/
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>

/*pix*/
#include "lib/xitalk.xbm"

/*random jazz*/
#include "xwin.h"
#include "main.h"

/*utmp bits probably have to be re-written for each platform*/
#include "who.h"


/*a standard linked list thingy*/
#include "history.h"


/*catch X close events*/
XtActionsRec xfontsel_actions[] =
    {
        {"Quit", QuitAction    },
    };
Atom wm_delete_window;

/*display*/
extern Display *temp_d;

/*top level windows*/
Widget toplevel, MainCommand, ShellFrame, TtyList, WhoList, EditResponse,Ack;

/*the history list of commands*/
list commands;
int autorunflag;
extern int det_patterns_num;
extern int configs_num;


extern char **determined_tty_list;
extern int determined_length;
extern int determined_current;

extern char **determined_who_list;
extern int determined_who_length;
extern int determined_who_current;

Pixmap xi_bitmap;
#ifdef HAVE_XPM
/*xpm support here we gooooo*/
#include "lib/xitalk.xpm"
Pixmap xi1;
Pixmap xi2;
XpmAttributes xpm_attr;
#endif

XtAppContext app;

static Boolean refuseToGiveUpSingleManagerCB(Widget _w, Atom *_selection, Atom *_target, Atom *_type, XtPointer *_value, unsigned long *_length, int *_format)
{
  *_value = None;
  return FALSE;
}

static void lostSingleManagerCB(Widget _w, Atom *_selection)
{
  XtAppWarning(XtWidgetToApplicationContext(_w),
    "Someone else has taken control of the selection!\n");
}


void open_window (int argc, char **argv, int fd, int dispfd /*,node *patterns*/ )
    {
    Arg args[1];
    static Widget temp;
    static node patterns;
    static det_node det_patterns;
    static config_node configs;
    static init_info init;
	static mail_node mail;
	static fd_and_widgets F_W;
	Atom test;
	Window win;
	static Atom  XA_XITALK;


    XtToolkitInitialize ();
    XtSetErrorHandler ((XtErrorHandler) xterrorthing);
    XSetErrorHandler (xerror);
    XSetIOErrorHandler (xioerror);

    app = XtCreateApplicationContext ();
    temp_d = XtOpenDisplay (app, NULL, NULL, "Xitalk", NULL, 0, &argc, argv);

    if (NULL == temp_d)
    	exit(0);
    write(dispfd, DisplayString(temp_d), strlen(DisplayString(temp_d))+1);
    init_list (&commands, MAX_NUM_COMMANDS, 1, 1);

    toplevel = XtAppCreateShell (NULL, "Xitalk", applicationShellWidgetClass, temp_d, NULL, 0);


    XtAppAddActions (app, xfontsel_actions, XtNumber (xfontsel_actions));
    XtOverrideTranslations (toplevel, XtParseTranslationTable ("<Message>WM_PROTOCOLS: Quit()"));


#ifdef HAVE_XPM
    xpm_attr.valuemask = XpmCloseness;
	xpm_attr.closeness = 65535;
    XpmCreatePixmapFromData (temp_d, RootWindowOfScreen (XtScreen (toplevel)), xitalk_xpm, &xi_bitmap, &xi1, &xpm_attr);
#else
    xi_bitmap = XCreateBitmapFromData (XtDisplay (toplevel), RootWindowOfScreen (XtScreen (toplevel)), xitalk_bits, xitalk_width, xitalk_height);
#endif
	if (xi_bitmap != 0)
		{
		init.use_bitmap =1;
		init.bitmap = xi_bitmap;
    	XtSetArg (args[0], XtNbitmap, (XtArgVal) xi_bitmap);
    	MainCommand = XtCreateManagedWidget ("MainCommand", commandWidgetClass, toplevel, args, 1);
		}
	else
		{
		init.use_bitmap =0;
    	MainCommand = XtCreateManagedWidget ("MainCommand", commandWidgetClass, toplevel, NULL, 0);
		}


    init.autoanswer=0;
    init.autorun=0;
    init.autorefresh=0;
    istrncpy(init.libpath,LIBDIR,MAXFILELEN);
    init.soundhandler[0] = '\0';
    init.defaultpic[0] = '\0';

    create_default_patterns (&patterns, &det_patterns, &configs, &init,&mail);

    temp = create_popup (toplevel, &app, fd, MainCommand, &patterns, &det_patterns, &configs, &init,&mail,&F_W);

    XtAddCallback (MainCommand, XtNcallback, (XtCallbackProc) popup_thing, temp);

    XtRealizeWidget (toplevel);


/*
using X selections to determine if xitalk is already running, must be after
realization
*/
	XA_XITALK = XInternAtom(temp_d, "_XA_XITALK_ATOM", False);

	if (XGetSelectionOwner(temp_d,XA_XITALK) ==None)
		{
		/*XtOwnSelection(toplevel, XA_XITALK, XtLastTimestampProcessed(temp_d),refuseToGiveUpSingleManagerCB, lostSingleManagerCB, NULL);*/
		XtOwnSelection(toplevel, XA_XITALK, XtLastTimestampProcessed(temp_d),NULL, NULL, NULL);
		}
	else
		fprintf(stderr,"xitalk: warning an xitalk is already running on your display.\n");
/*end of determination*/

    wm_delete_window = XInternAtom (XtDisplay (toplevel), "WM_DELETE_WINDOW", False);
    (void) XSetWMProtocols (XtDisplay (toplevel), XtWindow (toplevel), &wm_delete_window, 1);

	organize_filewatch(&F_W);
    XtAppMainLoop (app);
    }

void read_pty_input (fd_and_widgets * F_W)
    {
    int i = 0, length = 0, length_x, begin = 0, x = 0;
    char *temp;
    XawTextBlock xbuf;
    char buf[MAX_PATTERN];
    static char full_buf[MAX_SPAM];
    static int index;
    response_struct *j = NULL;
    Arg args[2];
/*
	char soundcommand[MAX_PICTURE+MAXFILELEN];
*/

    buf[0] = '\0';

    i = read (F_W->fd, buf, MAX_PATTERN);

    if ((i == -1) || (i == 0))
        {
        fprintf (stderr, "we have a small problem heuston\n");
        return;
        }

    /*
place at appropiate position in full buffer, then send section ending in \n
to the pattern matcher
*/
	buf[i]=0;
    if (i > 0)
        {
        if (i > MAX_SPAM - (index + 1))
            {
            /*crap error recover thing*/
            fprintf (stderr, "xitalk: too much input! dumping a chunk of it\n");
            full_buf[index] = '\n';
            }
        else
            {
            /*normal*/
            for (x = 0; x < i; x++)
                {
                full_buf[index + x] = buf[x];
                }
            index += i;
            }

        for (i = 0; i < index; i++)
            {
            if (full_buf[i] == '\n')
                {
                /*we look ahead find a completed line and back fill it in*/
                temp = (char *) malloc (length * sizeof (char));
                for (x = 0; x < length; x++)
                    temp[x] = full_buf[begin + x];
                temp[length - 1] = '\0';
                begin = i + 1;
                j = send_line_for_pattern_match (temp, F_W->head);
                if (j != NULL)
                    {
                    XtSetSensitive (F_W->ack, TRUE);
					/*if a message comes through, while a mail flag
					is up, then disregard the auto mail floag down 
					message*/
					F_W->init->mailactive=FALSE;
                    if (j->use_bitmap == 1)
                        XtSetArg (args[0], XtNbitmap, (XtArgVal) j->bitmap);
                    else
                        XtSetArg (args[0], XtNlabel, (XtArgVal) j->title);
                    XtSetValues (F_W->command, args, 1);

                    XtSetArg (args[0], XtNstring, (XtArgVal) j->command);
                    XtSetValues (F_W->EditResponse, args, 1);
                    /*add command to list*/
                    add_to_end (&commands, j->command);
                    /**/
					do_sound(F_W->init->soundhandler,j->soundclip,F_W->init->libpath);
                    free (j->command);
                    free (j->title);
                    free (j);
                    if (*(F_W->autoanswer))    /*autorespond*/
                        respond (F_W->respond, F_W, NULL);
                    }
                XtSetArg (args[0], XtNinsertPosition, (XtArgVal) & length_x);
                XtGetValues (F_W->log_widget, args, 1);
                xbuf.firstPos = 0;
                xbuf.length = length;
                xbuf.ptr = temp;
                xbuf.format = 0;
                xbuf.ptr[length - 1] = '\n';
                XawTextReplace (F_W->log_widget, length_x, length_x, &xbuf);
                free (temp);
                length = -1;
                }
            length++;
            }

        if (begin + 1 == index)
            index = 0;
        else if (begin > 1)
            {
            memmove (full_buf, full_buf + begin, index - begin);
            index -= begin;
            }

        }
    }


void clear_activity (Widget w,  init_info* init, XtPointer dummy)
    {
    Arg args[1];
    XtSetSensitive (w, FALSE);
	if (init->use_bitmap != 0)
    	{
		XtSetArg (args[0], XtNbitmap, xi_bitmap);
    	XtSetValues (MainCommand, args, 1);
		}
	init->mailactive=FALSE;
    }


void quit (Widget w, app_wid_pid * info, XtPointer dummy)
    {
/* We can't do this, as I'm not root.  However, when we exit, down at the end
 * of the function, my parent will recieve a SIGCHLD and write us out of utmp.
 */
/*    write_user_outof_utmp (); */


    XtUnmapWidget (info->toplevel);

    free_up(info);

	if (info->init->use_bitmap)
		XFreePixmap(temp_d,xi_bitmap);

    XtDestroyWidget (info->toplevel);
    XtAppAddWorkProc (info->app, (XtWorkProc) die_die, (XtPointer) NULL);
    exit (0);
    }

void die_die (XtPointer dummy)
    {
    exit (0);
    }

void respond (Widget w, fd_and_widgets *F_W, XtPointer dummy)
    {
    char *response;
    Arg args[1];

    XtSetSensitive (Ack, FALSE);

    XtSetArg (args[0], XtNstring, (XtArgVal) & response);
    XtGetValues (EditResponse, args, 1);

/*
if this response is not the guessed one by xitalk store it in the
history
*/
    if (NULL == return_current (&commands))
        add_to_end (&commands, response);
    else if (strcmp (response, return_current (&commands)))
        add_to_end (&commands, response);
	
	unpriv_system(response);
/*	free(response);*/


	if (F_W->init->use_bitmap) 
        {
		XtSetArg (args[0], XtNbitmap, xi_bitmap);
    	XtSetValues (MainCommand, args, 1);
		}
	F_W->init->mailactive=FALSE;
    }

void popup_thing (Widget w, Widget temp, XtPointer dummy)
    {
    XtRemoveCallback (w, XtNcallback, (XtCallbackProc) popup_thing, temp);
    XtAddCallback (w, XtNcallback, (XtCallbackProc) popdown_thing, temp);

    if (who ())
        determine_who ();

    XtPopup (temp, XtGrabNone);
    (void) XSetWMProtocols (XtDisplay (temp), XtWindow (temp), &wm_delete_window, 1);
    }

void popdown_thing (Widget w, Widget temp, XtPointer dummy)
    {
    XtRemoveCallback (w, XtNcallback, (XtCallbackProc) popdown_thing, temp);
    XtAddCallback (w, XtNcallback, (XtCallbackProc) popup_thing, temp);
    XtPopdown (temp);
    }

void popdown (Widget w, widget_pair * temp, XtPointer dummy)
    {
    XtPopdown (temp->one);
    XtRemoveCallback (temp->two, XtNcallback, (XtCallbackProc) popdown_thing, temp->one);
    XtAddCallback (temp->two, XtNcallback, (XtCallbackProc) popup_thing, temp->one);
    }

Widget create_dialog (Widget w, app_wid_pid * info, XtPointer dummy)
    {
    Widget ShellFrame2, Label;

    ShellFrame2 = XtCreateManagedWidget ("ShellFrame2", transientShellWidgetClass, info->toplevel, NULL, 0);

    Label = XtCreateManagedWidget ("as", labelWidgetClass, ShellFrame2, NULL, 0);
    return (ShellFrame2);
    }

void popdown_dialog (Widget w, Widget temp, XtPointer dummy)
    {
    XtPopdown (w);
    XtSetSensitive (temp, TRUE);
    }

void popup_temp (Widget w, Widget temp, XtPointer dummy)
    {
    XtPopup (temp, XtGrabNone);
    }

void QuitAction (void)
    {
#ifdef DEBUG
    fprintf (stderr, "xitalk: Recieved DELETE from window Manager\n");
#endif
/* We can't do this, as I'm not root.  However, when we exit, down at the end
 * of the function, my parent will recieve a SIGCHLD and write us out of utmp.
 */
/*  write_user_outof_utmp_and_quit (0); */
    exit(0);
    
    }

void CloseAction (void)
    {
#ifdef DEBUG
    fprintf (stderr, "xitalk: subwindow recieved DELETE from window Manager\n");
#endif
    XtRemoveCallback (MainCommand, XtNcallback, (XtCallbackProc) popdown_thing, ShellFrame);
    XtAddCallback (MainCommand, XtNcallback, (XtCallbackProc) popup_thing, ShellFrame);
    XtPopdown (ShellFrame);
    }

void xterrorthing (void)
    {
    fprintf (stderr, "xitalk: Xt Fatal Error\n");
/* We can't do this, as I'm not root.  However, when we exit, down at the end
 * of the function, my parent will recieve a SIGCHLD and write us out of utmp.
 */
/*  write_user_outof_utmp_and_quit (0); */
    exit(0);
    }

int xioerror (Display * dpy)
    {
#if defined(HAVE_ERRNO_H)
#if defined(HAVE_STRERROR)
    (void) fprintf (stderr,
          "%s: fatal IO error %d (%s) or KillClient on X server \"%s\"\r\n",
                    "xitalk", errno, strerror (errno),
                    DisplayString (dpy));
#else
    (void) fprintf (stderr,
               "%s: fatal IO error %d or KillClient on X server \"%s\"\r\n",
                    "xitalk", errno, DisplayString (dpy));
#endif
#else
    (void) fprintf (stderr,
                  "%s: fatal IO error or KillClient on X server \"%s\"\r\n",
                    "xitalk", DisplayString (dpy));
#endif
/* We can't do this, as I'm not root.  However, when we exit, down at the end
 * of the function, my parent will recieve a SIGCHLD and write us out of utmp.
 */
/*  write_user_outof_utmp_and_quit (0); */
    exit(0);
    return (0);
    }

int xerror (Display * d, register XErrorEvent * ev)
    {
    fprintf (stderr, "%s: warning, error event receieved:\n", "xitalk");
    (void) XmuPrintDefaultErrorMessage (d, ev, stderr);
/* We can't do this, as I'm not root.  However, when we exit, down at the end
 * of the function, my parent will recieve a SIGCHLD and write us out of utmp.
 */
/*    write_user_outof_utmp_and_quit (0); */
    exit(0);
    
    return (0);
    }


void up_arrow (Widget w, fd_and_widgets * W_P, XtPointer dummy)
    {
    Arg args[2];
    const char *temp;

    /*
if the user added some text then hold onto it for him/her on a temporary
basis
*/
    if ((commands.current == commands.last) && (commands.current != NULL))
        {
        if (commands.consider_last_entry_temp)
            {
            XtSetArg (args[0], XtNstring, (XtArgVal) & temp);
            XtGetValues (W_P->EditResponse, args, 1);
            add_to_end (&commands, temp);
            commands.consider_last_entry_temp = 1;
            }
        }
    backward_current (&commands);
    temp = return_current (&commands);
    if (temp != NULL)
        {
        XtSetArg (args[0], XtNstring, (XtArgVal) temp);
        XtSetArg (args[1], XtNinsertPosition, (XtArgVal) strlen (temp));
        XtSetValues (W_P->EditResponse, args, 2);
        }
    }

void down_arrow (Widget w, fd_and_widgets * W_P, XtPointer dummy)
    {
    Arg args[2];
    const char *temp;

    /*if we're at the last entry and its not a temp add a temp*/
    if ((commands.current == commands.last) && (commands.current != NULL))
        {
        if (!(commands.consider_last_entry_temp))
            {
            add_to_end (&commands, " ");
            commands.consider_last_entry_temp = 1;
            }
        }

    forward_current (&commands);
    temp = return_current (&commands);

    if (temp != NULL)
        {
        XtSetArg (args[0], XtNstring, (XtArgVal) temp);
        XtSetArg (args[1], XtNinsertPosition, (XtArgVal) strlen (temp));
        XtSetValues (W_P->EditResponse, args, 2);
        }
    }

/*my favourite bit of Xt Translation magic really*/
void ActionToCallback (Widget w, XEvent * e, String * s, Cardinal * num)
    {
    Widget temp;
    if (*num > 0)
        {
        temp = XtNameToWidget (ShellFrame, s[0]);
        if (temp != NULL)
            if (XtCallbackHasSome == XtHasCallbacks (temp, XtNcallback))
                XtCallCallbacks (temp, XtNcallback, NULL);
        }
    }


void autorun (Widget w, fd_and_widgets * W_P, XtPointer dummy)
    {
    if (autorunflag)
        autorunflag = 0;
    else
        autorunflag = 1;
    }


void autoanswer (Widget w, fd_and_widgets * W_P, XtPointer dummy)
    {
    if (*(W_P->autoanswer))
        *(W_P->autoanswer) = 0;
    else
        *(W_P->autoanswer) = 1;
    }

void refresh (Widget w, XtPointer dum, XtPointer dummy)
    {
    if (who ())
        {
        determine_who ();
        strcpy (determined_tty_list[0], "-      -");
        XawListChange (TtyList, determined_tty_list, 1, 0, TRUE);
        XtSetSensitive (TtyList, FALSE);
        }

    }

void autorefresh (Widget w, XtPointer dum, XtPointer dummy)
    {
    if (!(who_alarm_on))
        {
        signal_handle (SIGALRM, who_signal);
        alarm (3);
        who_alarm_on = 1;
        }
    else
        {
        signal_handle (SIGALRM, SIG_IGN);
        alarm (0);
        who_alarm_on = 0;
        }
    }

void who_signal (int dummy)
    {
    if (who_alarm_on)
        {
#ifdef MUST_REINSTALL_SIGHANDLERS
        signal_handle (SIGALRM, who_signal);
#endif
        alarm (3);
        }

    if (who ())
        {
        determine_who ();
        strcpy (determined_tty_list[0], "-      -");
        XawListChange (TtyList, determined_tty_list, 1, 0, TRUE);
        XtSetSensitive (TtyList, FALSE);
        }
    }

void determine_tty (Widget w, XtPointer dum, XtPointer ca)
    {
    int fd, i;
	char pty[MAX_PTY_NAME_LENGTH];
	struct stat tmp; 
	char *tempstr;
    XawListReturnStruct *info = (XawListReturnStruct *) ca;
	
    tempstr = getenv ("USER");

    determined_current = 0;

    for (fd = 0; fd < who_tty_list_number; fd++)
        {
        if (determined_current == determined_length)
            {
            i = determined_length + WHO_LIST_INC;
            determined_tty_list = Increase (determined_tty_list, char *, i);
            if (determined_tty_list == NULL)
                {
                fprintf (stderr, "xitalk: Memory Allocation Failed\n");
                exit (-1);
                }
            for (; determined_length < i; determined_length++)
                determined_tty_list[determined_length] = (char *) malloc ((USRNAMLEN + 3) * sizeof (char));
            }

        if (!(strcmp (who_list[fd], info->string)))
			{
            strcpy (determined_tty_list[determined_current], tty_list[fd]);
        
    		sprintf(pty,"%s%s","/dev/",tty_list[fd]);
    		if (0 == stat(pty,&tmp))
    		    {
		        if ((S_IWOTH|S_IWGRP) & tmp.st_mode)
		            strcat(determined_tty_list[determined_current]," +");
		        else
		            strcat(determined_tty_list[determined_current]," -");
		        }
		    else
		        strcat(determined_tty_list[determined_current]," -");
			determined_current++;
			}
		}
    XawListChange (TtyList, determined_tty_list, determined_current, 0, TRUE);
    XtSetSensitive (TtyList, TRUE);
    }

void determine_who (void)
    {
    static int last;
    int fd, i, flag;

    if (last == 0)
        {
        determined_who_list = (char **) malloc (WHO_LIST_INC * sizeof (char *));

        if (determined_who_list == NULL)
            {
            fprintf (stderr, "xitalk: Memory Allocation Failed\n");
            exit (-1);
            }

        determined_who_length = WHO_LIST_INC;
        }

    determined_who_current = 0;

    for (fd = 0; fd < who_tty_list_number; fd++)
        {
        flag = 0;
        if (determined_who_current == determined_who_length)
            {
            i = determined_who_length + WHO_LIST_INC;
            determined_who_list = Increase (determined_who_list, char *, i);

            if (determined_who_list == NULL)
                {
                fprintf (stderr, "xitalk: Memory Allocation Failed\n");
                exit (-1);
                }

            for(;determined_who_length<i;determined_who_length++)
				determined_who_list[determined_who_length] = (char*) malloc((USRNAMLEN+1) * sizeof(char));

            }
        for (i = 0; i < determined_who_current; i++)
            if (!(strcmp (determined_who_list[i], who_list[fd])))
                {
                flag = 1;
                break;
                }
        if (flag != 1)
            determined_who_list[determined_who_current++] = who_list[fd];
        XawListChange (WhoList, determined_who_list, determined_who_current, 0, TRUE);
        }
    }

void begin_comm (Widget w, char *command, XtPointer dummy)
    {
    Arg args[2];
    char *temp, string2[USRNAMLEN+3], *string1 = NULL;
    String useless_s = "MainFrame.ResponseControl.Execute";
    int useless_i = 1;
    XawListReturnStruct *info1;
    XawListReturnStruct *info2;
	string2[0] = '\0';

    info1 = XawListShowCurrent (WhoList);
    if (info1->list_index != XAW_LIST_NONE)
        {
        string1 = info1->string;
        info2 = XawListShowCurrent (TtyList);
        if (info2->list_index != XAW_LIST_NONE)
			{
            istrncpy(string2,info2->string,USRNAMLEN+2);
			string2[strlen(string2) -2] = '\0';
			}
        }

    temp = examine_determined (command, string1, string2);

    commands.current = commands.last;
    if (commands.current != NULL)
        {
        add_to_end (&commands, " ");
        commands.consider_last_entry_temp = 1;
        }

    if (temp != NULL)
        {
        XtSetArg (args[0], XtNstring, (XtArgVal) temp);
        XtSetArg (args[1], XtNinsertPosition, (XtArgVal) strlen (temp));
        XtSetValues (EditResponse, args, 2);
        }
    commands.current = commands.last;
    if (temp != NULL)
        free (temp);

    if (autorunflag)
        ActionToCallback (NULL, NULL, &useless_s, &useless_i);
    }


void create_default_patterns (node * head, det_node * det_patterns, config_node * configs, init_info *init,mail_node *mail)
    {
    det_node *temp2;
    node *temp;
    char *tempstr;
    char *filename;
    FILE *file;
    char buffer[LINELEN];
    int i;

    det_patterns_num = 0;
    configs_num = 0;

	mail->picture[0] = '\0';
	mail->mailfile[0] = '\0';
	mail->next = NULL;



/*check for user .xitalkrc file*/
    tempstr = getenv ("HOME");

    filename = (char *) malloc (strlen (tempstr) + strlen (".xitalkrc") + 2);
    sprintf (filename, "%s/.xitalkrc", tempstr);
    i = unpriv_open(filename,R_OK);
    	if (i <= 0)
		{
		free(filename);
		filename = (char *) malloc(strlen (LIBDIR) + strlen("system.xitalkrc") +2);
		sprintf(filename,"%s/system.xitalkrc",LIBDIR);
		i = unpriv_open(filename,R_OK);
		}


    if (i > 0)
        {
        if (NULL != (file = fdopen (i, "r")))
            {
            if (0 != Parse(file,head,det_patterns,configs,init,mail))
                { 
                fclose (file);
				close(i);
                fprintf(stderr,"xitalk: Config file problems with %s, exiting\n",filename);
                exit(-1);
                }
            fclose (file);
			close(i);
            }
        else
            {
            fprintf(stderr,"xitalk: Config file opening problems, exiting\n");
            exit(-1);
            }
        }
    else
        {
        strcpy (head->pattern, "talk: respond with:  talk (.*)@(.*)");
        strcpy (head->title, "Talk Request");
        strcpy (head->command, "xterm -ut -exec ytalk -x %(1)@%(2)");
#ifdef HAVE_XPM
        sprintf (head->picture, "talk.xpm");
#else
        sprintf (head->picture, "talk.xbm");
#endif


        temp = (node *)malloc (sizeof (node));
        if (temp == NULL)
            {
            fprintf (stderr, "5not enough memory!\naborting\n");
            exit (-1);
            }
        strcpy (temp->pattern, "(.*)Message from (.*)@(.*) on (.*) at (.*)");
        strcpy (temp->title, "Write Request");
        strcpy (temp->command, "xterm -exec write %(2) %(4)");
#ifdef HAVE_XPM
        sprintf (temp->picture, "write.xpm");
#else
        sprintf (temp->picture, "write.xbm");
#endif
        temp->next = NULL;
        head->next = temp;

        temp = temp->next;

        temp = malloc (sizeof (node));
        if (temp == NULL)
            {
            fprintf (stderr, "6 not enough memory!\naborting\n");
            exit (-1);
            }
        strcpy (temp->pattern, "Broadcast Message from (.*)@(.*)");
        strcpy (temp->title, "Wall");
        strcpy (temp->command, "xterm -exec write %(1)");
#ifdef HAVE_XPM
        sprintf (temp->picture, "wall.xpm");
#else
        sprintf (temp->picture, "wall.xbm");
#endif

        head->next->next = temp;
        temp->next = NULL;


        strcpy (det_patterns->title, "Talk");
        strcpy (det_patterns->determined_command, "xterm -ut -exec ytalk -x %(u)");

        det_patterns_num++;
        temp2 = malloc (sizeof (det_node));
        if (temp2 == NULL)
            {
            fprintf (stderr, "7 not enough memory!\naborting\n");
            exit (-1);
            }
        strcpy (temp2->title, "Write");
        strcpy (temp2->determined_command, "xterm -exec write %(u) %(t)");

        det_patterns_num++;
        temp2->next = NULL;
        det_patterns->next = temp2;

        temp2 = temp2->next;

        temp2 = malloc (sizeof (det_node));
        if (temp2 == NULL)
            {
            fprintf (stderr, "8 not enough memory!\naborting\n");
            exit (-1);
            }
        strcpy (temp2->title, "Wall");
        strcpy (temp2->determined_command, "xterm -ut -exec wall");
        det_patterns->next->next = temp2;
        temp2->next = NULL;
        det_patterns_num++;

        strcpy (configs->title, "Default");
        istrncpy (configs->filename, filename, MAXFILELEN-1);
        configs_num = 1;
        }


    fix_pics(head,init->libpath);
	

	mainpic(init);
    
    free (filename);
    }

void get_picture(node *temp)
    {
    unsigned int width;
    unsigned int height;
    int x;
    int y;
#ifdef HAVE_XPM
    	xpm_attr.valuemask = XpmCloseness;
		xpm_attr.closeness = 65535;
        if (XpmSuccess == XpmReadFileToPixmap (XtDisplay (toplevel), RootWindowOfScreen (XtScreen (toplevel)), temp->picture, &(temp->bitmap), &xi1, &xpm_attr))
            temp->use_bitmap = 1;
        else
#endif
        if (BitmapSuccess != XReadBitmapFile (XtDisplay (toplevel), RootWindowOfScreen (XtScreen (toplevel)), temp->picture, &width, &height, &(temp->bitmap), &x, &y))
            temp->use_bitmap = 0;
        else
            temp->use_bitmap = 1;
    }


void free_up(app_wid_pid * info)
    {
    node *temp;
    node *random;
    det_node *temp2;
    det_node *random2;
    config_node *temp3;
    config_node *random3;
	mail_node *temp4;
	mail_node *random4;

    random = info->head->next;
    while (random)
        {
        temp = random->next;
		if (random->bitmap)
			XFreePixmap(temp_d, random->bitmap);
		random->use_bitmap=0;
        free (random);
        random = temp;
        }
    random2 = info->det_head->next;
    while (random2)
        {
        temp2 = random2->next;
        free (random2);
        random2 = temp2;
        }
    random3 = info->config_head->next;
    while (random3)
        {
        temp3 = random3->next;
        free (random3);
        random3 = temp3;
        }
    random4 = info->mail->next;
    while (random4)
        {
        temp4 = random4->next;
		XtRemoveTimeOut(random4->timer);
		if (random4->bitmap)
			XFreePixmap(temp_d, random4->bitmap);
        free (random4);
        random4 = temp4;
        }
    info->head->next=NULL;
    info->det_head->next=NULL;
    info->config_head->next=NULL;
    info->mail->next=NULL;
   
 
    }

void fix_pics(node *head,char *libpath)
    {
    char picture[MAX_PICTURE];
    node *temp=head;
    while(temp !=NULL)
        {
        /*try the given filename, if it fails try with the pixmap*/
        get_picture(temp);
        if (temp->use_bitmap == 0)
            {
            istrncpy(picture,temp->picture,MAX_PICTURE-1);
            sprintf (temp->picture, "%s/%s",libpath,picture);
            get_picture(temp);
            if (temp->use_bitmap == 0)
                fprintf (stderr, "xitalk: error in reading %s\n", temp->picture);
            }     
        temp = temp->next; 
        }
    }

void re_init(Widget w,silly_c *info, XtPointer dummy)
    {
    node *temp;
    FILE *file;
    int i;
    /*free menus and lists*/
    /*reinit data*/
    /*run create_patterms */
    /*run selected widget updates*/

    free_up(info->info);

    info->info->init->autoanswer=0;
    info->info->init->autorun=0;
    info->info->init->autorefresh=0;
    istrncpy(info->info->init->libpath,LIBDIR,MAXFILELEN);
    info->info->init->soundhandler[0] = '\0';
    info->info->init->defaultpic[0] = '\0';

	info->info->mail->picture[0] = '\0';
	info->info->mail->mailfile[0] = '\0';


    det_patterns_num = 0;
    configs_num = 0;

    i = unpriv_open(info->filename,R_OK);
    if (i > 0)
        {
        if (NULL != (file = fdopen (i, "r")))
            {
            if (0 != Parse(file,info->info->head,info->info->det_head,info->info->config_head,info->info->init,info->info->mail))
                { 
                fclose (file);
				close(i);
                fprintf(stderr,"xitalk: Config file problems, trying defaults again\n");
                create_default_patterns (info->info->head,info->info->det_head,info->info->config_head,info->info->init,info->info->mail);
                }
            fclose (file);
			close(i);
            }
        else
            {
            fprintf(stderr,"xitalk: couldn't open %s trying defaults again\n",info->filename);
            create_default_patterns (info->info->head,info->info->det_head,info->info->config_head,info->info->init,info->info->mail);
            }
        }
    else
        {
        fprintf(stderr,"xitalk: couldn't open %s trying defaults again\n",info->filename);
        create_default_patterns (info->info->head,info->info->det_head,info->info->config_head,info->info->init,info->info->mail);
        }

    temp = info->info->head;
    while(temp)
        {
        temp = temp->next; 
        }

    fix_pics(info->info->head, info->info->init->libpath);
	PurgeCommands(info->info);
    PurgeConfigs(info->info,info->F_W);
	fix_init(info->info);
/*
create mail here
*/

	organize_filewatch(info->F_W);
    }

void fix_init(app_wid_pid *info)
	{
	Arg args[1];

	if (info->init->autorun)
	    XtSetArg (args[0], XtNstate, True); 
	else
	    XtSetArg (args[0], XtNstate, False); 
	XtSetValues(info->autorun,args,1);
	autorunflag = info->init->autorun;

	if (info->init->autoanswer)
	    XtSetArg (args[0], XtNstate, True); 
	else
	    XtSetArg (args[0], XtNstate, False); 
	XtSetValues(info->autoanswer,args,1);

	if (info->init->autorefresh)
	    XtSetArg (args[0], XtNstate, True); 
	else
	    XtSetArg (args[0], XtNstate, False); 
	XtSetValues(info->autorefresh,args,1);

	mainpic(info->init);

	}



void mainpic(init_info *init)
	{
	unsigned int width;
    unsigned int height;
    int x;
    int y;
	Arg args[1];
    char picture[MAX_PICTURE];
	int pic_status;

	pic_status = init->use_bitmap;

	if (init->defaultpic[0] != '\0')
		{
		get_mainpic(init);
        if (init->use_bitmap == 0)
            {
            istrncpy(picture,init->defaultpic,MAX_PICTURE-1);
            sprintf (init->defaultpic, "%s/%s",init->libpath,picture);
			init->use_bitmap=pic_status;
            get_mainpic(init);
            if (init->use_bitmap == 0)
				{
                fprintf (stderr, "error in reading %s: keeping default picture\n", init->defaultpic);
				init->use_bitmap =pic_status;
				}
			else
				{
    			XtSetArg (args[0], XtNbitmap, (XtArgVal) xi_bitmap);
    			XtSetValues(MainCommand,args,1);
				}
            }     
		}
	else
		init->use_bitmap = 1;

	}


void get_mainpic(init_info *temp)
    {
    unsigned int width;
    unsigned int height;
	static Pixmap temp_p;
    int x;
    int y;
	int pic_status = temp->use_bitmap;


#ifdef HAVE_XPM
		xpm_attr.valuemask = XpmCloseness;
		xpm_attr.closeness = 65535;
        if (XpmSuccess == XpmReadFileToPixmap (XtDisplay (toplevel), RootWindowOfScreen (XtScreen (toplevel)), temp->defaultpic, &temp_p, &xi1, &xpm_attr))
            temp->use_bitmap = 1;
        else
#endif
        if (BitmapSuccess != XReadBitmapFile (XtDisplay (toplevel), RootWindowOfScreen (XtScreen (toplevel)), temp->defaultpic, &width, &height, &temp_p, &x, &y))
            temp->use_bitmap = 0;
        else
            temp->use_bitmap = 1;

    if ((pic_status != 0) && (temp->use_bitmap == 1))
    	{
		XFreePixmap(temp_d,xi_bitmap);
/*
		xi_bitmap = XCreatePixmap(temp_d,RootWindowOfScreen (XtScreen (toplevel)),width,height,DefaultDepthOfScreen(XtScreen (toplevel)));
		XCopyArea(temp_d,temp_p,xi_bitmap,DefaultGCOfScreen(XtScreen(toplevel)),0,0,width,height,0,0);
		XFreePixmap(temp_d,temp_p);
*/
		xi_bitmap = temp_p;
		}

    }


void organize_filewatch(fd_and_widgets *F_W)
	{
	silly_b *silly;
	mail_node *temp;
	struct stat st;
   	int fd;


	temp = F_W->mail;
	if (F_W->mail->mailfile[0] != '\0')
		{
		while (temp != NULL)
			{
            if (temp->touch == 0)
                {
                fd = unpriv_open(temp->mailfile, O_RDONLY);
                if (fd < 0)
                    fprintf(stderr,"\nxitalk: file %s was unopenable!!, file check abandoned\n",temp->mailfile);
                else
                    {
                    get_mailpic(temp,F_W->init->libpath);
                    close(fd);
                    silly = (silly_b*) malloc(sizeof(silly_b));
                    silly->F_W = F_W;
                    silly->mail = temp;	
                    temp->timer = XtAppAddTimeOut(app, 30, (XtTimerCallbackProc)proc, (XtPointer)silly);
                    }
                }
            else
                {
                silly = (silly_b*) malloc(sizeof(silly_b));
                silly->F_W = F_W;
                silly->mail = temp;	
                temp->timer = XtAppAddTimeOut(app, 30, (XtTimerCallbackProc)proc, (XtPointer)silly);
                }
			temp = temp->next;
			}
		}
	}

void proc(silly_b *silly)
	{
    Arg args[1];
	struct stat st;
    char *temp;
    XawTextBlock xbuf;
   	int fd,i;
	char soundcommand[MAX_PICTURE+MAXFILELEN];

    if (silly->mail->touch == 0)
        {
        fd = unpriv_open(silly->mail->mailfile, O_RDONLY);
        if (fd < 0)
            fprintf(stderr,"\nxitalk: file %s was unopenable!!, file check abandoned\n",silly->mail->mailfile);
        else
            {
            fstat(fd, &st);
            close(fd);
            /*if the file has been changed and its bigger that remembered 
            ring the alarm*/
            if ((st.st_mtime >= st.st_atime) && (st.st_size >silly->mail->size))
                {
                XtSetSensitive (silly->F_W->ack, TRUE);
				silly->F_W->init->mailactive=TRUE;

                if (silly->mail->use_bitmap == 1)
                    XtSetArg (args[0], XtNbitmap, (XtArgVal) silly->mail->bitmap);
                        else
                    XtSetArg (args[0], XtNlabel, (XtArgVal) silly->mail->title);
                XtSetValues (silly->F_W->command, args, 1);

                XtSetArg (args[0], XtNstring, (XtArgVal) silly->mail->command);
                XtSetValues (silly->F_W->EditResponse, args, 1);
                /*add command to list*/
                add_to_end (&commands, silly->mail->command);
                do_sound(silly->F_W->init->soundhandler,silly->mail->soundclip,silly->F_W->init->libpath);
                if (*(silly->F_W->autoanswer))    /*autorespond*/
                    respond (silly->F_W->respond, silly->F_W, NULL);
                }
            else if (((st.st_mtime < st.st_atime) && (silly->mail->allowread &&(silly->F_W->init->mailactive))) || ((silly->mail->size > st.st_size) && (silly->mail->allowread)&&(silly->F_W->init->mailactive) ))
                {
				clear_activity(silly->F_W->ack,silly->F_W->init,(XtPointer)0);
                /*if its been read since last modification return to default state*/
                /*that ones for you dave*/
                }


            silly->mail->size = st.st_size;
            if (st.st_atime > st.st_mtime)
                silly->mail->last_change = st.st_atime;
            else
                silly->mail->last_change = st.st_mtime;
            silly->mail->timer = XtAppAddTimeOut(app, DEFAULT_INTERVAL*1000, (XtTimerCallbackProc) proc, (XtPointer)silly);
            }
        }
    else
        {
        /*update the current file*/
        //i = unpriv_open(silly->mail->mailfile,W_OK);
        i = access(silly->mail->mailfile,W_OK);
        if (i == 0)
            {
            if (-1 == utime(silly->mail->mailfile,NULL))
                {
                if (errno = ENOENT)
                    fprintf(stderr,"xitalk: %s doesnt exist\n",silly->mail->mailfile);
                fprintf(stderr,"xitalk: file touch abandoned\n");
                }
            else
                silly->mail->timer = XtAppAddTimeOut(app, DEFAULT_INTERVAL*1000, (XtTimerCallbackProc) proc, (XtPointer)silly);
            close(fd);
            }
        else
            {
            fprintf(stderr,"xitalk: Couldnt file touch %s\n",silly->mail->mailfile);
            fprintf(stderr,"xitalk: file touch abandoned\n");
            }
        }
	}


void get_mailpic(mail_node *mail,char *libpath)
	{
    char picture[MAX_PICTURE];
    mail_node *temp=mail;
        /*try the given filename, if it fails try with the pixmap*/
        get_mail_picture(temp);
        if (temp->use_bitmap == 0)
            {
            istrncpy(picture,temp->picture,MAX_PICTURE-1);
            sprintf (temp->picture, "%s/%s",libpath,picture);
            get_mail_picture(temp);
            if (temp->use_bitmap == 0)
                fprintf (stderr, "error in reading %s\n", temp->picture);
            }
	}

void get_mail_picture(mail_node *temp)
    {
    unsigned int width;
    unsigned int height;
    int x;
    int y;
#ifdef HAVE_XPM
        xpm_attr.valuemask = XpmCloseness;
        xpm_attr.closeness = 65535;
        if (XpmSuccess == XpmReadFileToPixmap (XtDisplay (toplevel), RootWindowOfScreen (XtScreen (toplevel)), temp->picture, &(temp->bitmap), &xi1, &xpm_attr))
            temp->use_bitmap = 1;
        else
#endif
        if (BitmapSuccess != XReadBitmapFile (XtDisplay (toplevel), RootWindowOfScreen (XtScreen (toplevel)), temp->picture, &width, &height, &(temp->bitmap), &x, &y))
            temp->use_bitmap = 0;
        else
            temp->use_bitmap = 1;
    }

int unpriv_open(char *filename,int flags)
    {
    /*
    access checks with the read uid to see if the user should be allowed to
    do what he wants to do
    */
	if (0 == access(filename,flags))
        return (open(filename,flags));
    else
        return(-1);
    }

void unpriv_system(char *response)
	{
    pid_t tpid;

    tpid = fork ();
    if (tpid == (pid_t) 0)
        {
        /* spawn off a unprivilaged child to run the command*/
		setuid (getuid ());
        system (response);
        exit (0);
        }
    else if (tpid < (pid_t) 0)
        {
        /* The fork failed. */
        fprintf (stderr, "Fork failed.\n");
        exit (-1);
        }
	}

void do_sound(char *soundhandler,char *soundclip,char *libdir)
	{
	char temp[MAXFILELEN];
	char soundcommand[MAX_PICTURE+MAXFILELEN];
	struct stat buf;

	strcpy(temp,soundclip);
	if (strcmp(soundhandler,"NONE"))
		{
		if (temp[0] == '\0')
			XBell (temp_d, 0);
		else
			{
			if (-1 == stat(temp, &buf))
					{
					if (errno == ENOENT)
						{
						sprintf(temp,"%s/%s",libdir,soundclip);
						if (-1 == stat(temp, &buf))
							{
							fprintf(stderr,"xitalk: error in playing file %s",temp);
							return;
							}
						}
					else
							fprintf(stderr,"xitalk: error in playing file %s",temp);
					}

			if (soundhandler[0] != '\0')
				sprintf(soundcommand,"%s %s",soundhandler,temp);
			else
				sprintf(soundcommand,"cat %s > /dev/audio",temp);
			unpriv_system(soundcommand);
			}
		}
	}



