/*____________________________________________________________________________
	
	XingMP3 - The Xing MP3 Decoder library

        MP3 Decoder originally Copyright (C) 1995-1997 Xing Technology
        Corp.  http://www.xingtech.com

	Portions Copyright (C) 2001 Robert Kaye

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
	$Id: xingmp3.h,v 1.1 2001/10/12 03:01:39 mayhemchaos Exp $
____________________________________________________________________________*/

#ifndef XINGMP3_H
#define XINGMP3_H

#ifdef __cplusplus
extern "C"
{
#endif

#include "port.h"
#include "mhead.h"

/* head_info3 is a support function to help you find an mp3 frame in
   a bitstream. Given a buffer (buf) and the size of the buffer (n)
   it will fill out MPEG_HEAD (h) and return the the BitRate of the
   first frame in br, and in searchForward will return the number of
   bytes skipped in the buffer to find the first valid header. This
   function returns frame_bytes, the number of bytes in this frame. */
int head_info3(unsigned char *buf, unsigned int n, 
               MPEG_HEAD *h, int *br, 
               unsigned int *searchForward);

/* Use the following function to initialize the decoder. The decoder
   must be reinitailized after every error that occurs. For a normal
   decoding to 16bit signed, use reduction_code = 0, transform_code = 0,
   convert_code = 0, and freq_limit = 24000. framebytes_arg is the value
   returned from a successfuly mhead_info3 call. The MPEG arg is a pointer
   to an uninitialized MPEG struct that will be used to keep the internal 
   state of the decoder. This must be passed to audio_decode_info and
   audio_decode */
int    audio_decode_init(MPEG *, MPEG_HEAD * h, int framebytes_arg,
                         int reduction_code, int transform_code,
                         int convert_code, int freq_limit);
/* Get decode info. Optional */
void   audio_decode_info(MPEG *, DEC_INFO * info);

/* Decode an mp3 frame. Returns an IN_OUT struct. in_bytes indicates
   the number of bytes consumed. out_bytes indicates the number of
   pcm bytes generated. bitstream must contain at least one complete
   mp3 frame. (framebytes number of bytes as returned by head_info3).
   pcm must contain at space for 1152 samples (MPEG-1) or 576 samples (MPEG-2)
   for each frame in bitstream. For normal stereo decoding a sample
   equals 2 16 bit shorts. */ 
IN_OUT audio_decode     (MPEG *, unsigned char *bitstream, short *pcm);

#ifdef __cplusplus
}
#endif

#endif
