#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

/* Field Length offsets
 *  Tag 3 0-2
 *  Songname 30 3-32
 *  Artist 30 33-62
 *  Album 30 63-92
 *  Year 4 93-96
 *  Comment 30 97-126
 *  or{
 *    Comment 28 97-124
 *    zero 1 125
 *    Tracknum 1 126
 *  }
 *  Genre 1 127
 */

struct s_id3 {
    char tag[3];
    char songname[30];
    char artist[30];
    char album[30];
    char year[4];
    char comment[30];
//  char comment[28];
//  unsigned char empty;
//  unsigned char tracknum;
    unsigned char genre;
} id3;


#define NUM_GENRE 148

const char *genre_list[NUM_GENRE+1]={
	"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk",
	"Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies",
	"Other", "Pop", "R&B", "Rap", "Reggae", "Rock",
	"Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks",
	"Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk",
	"Fusion", "Trance", "Classical", "Instrumental", "Acid", "House",
	"Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass",
	"Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock",
	"Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk",
	"Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta",
	"Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret",
	"New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi",
	"Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical",
	"Rock & Roll", "Hard Rock", "Folk", "Folk/Rock", "National Folk", "Swing",
	"Fast-Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde",
	"Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band",
	"Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson",
	"Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus",
	"Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba",
	"Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet",
	"Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall",
	"Goa", "Drum & Bass", "Club House", "Hardcore", "Terror",
	"Indie", "BritPop", "NegerPunk", "Polsk Punk", "Beat",
	"Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary C",
	"Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop",
	"SynthPop",
	NULL
};


/*
@I ID3:<a><b><c>

Status message after loading a song (ID3 song info)

a = title (exactly 30 chars)
b = artist (exactly 30 chars)
c = album (exactly 30 chars)
d = year (exactly 4 chars)
e = comment (exactly 30 chars)
f = genre (string)
*/


void out_id3_info(int fd, char *filename, int remote)
{
    char *p;

    if (remote)
	printf("@I ");

    memset(id3.tag, 0, sizeof(id3.tag));

    lseek(fd, -128, SEEK_END);
    read(fd, &id3, sizeof(id3));
    lseek(fd, 0, SEEK_SET);

    if (! strncmp(id3.tag, "TAG", 3)) {
	/* Ignore id3 v1.1 trackinfo stuff */
	if (id3.comment[28] == '\0') {
	    id3.comment[28] = ' ';
	    id3.comment[29] = ' ';
	}
	if (remote) {
	    printf("ID3:");
	    printf("%-30.30s", id3.songname);
	    printf("%-30.30s", id3.artist);
	    printf("%-30.30s", id3.album);
	    printf("%-4.4s", id3.year);
	    printf("%-30.30s", id3.comment);
	    printf("%s", (id3.genre < NUM_GENRE) ? genre_list[id3.genre] : "unknown");
	    printf("\n");
	} else {
	    printf(" Title:   %.30s\n", id3.songname);
	    printf(" Artist:  %.30s\n", id3.artist);
	    printf(" Album:   %.30s\n", id3.album);
	    printf(" Year:    %.4s\n", id3.year);
	    printf(" Comment: %.30s\n", id3.comment);
	    printf(" Genre:   %s\n", (id3.genre < NUM_GENRE) ? genre_list[id3.genre] : "unknown");
	    printf("\n");
	}
    } else {
	if (remote) {
	    p = strrchr(filename, '/');
	    if (p)
		printf("%s\n", p + 1);
	    else
		printf("%s\n", filename);
	}
    }
}
