// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_multi_editor.h
// *
// * Purpose: Implements functions that involve two XgsmSingleEditors
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 8.3.2000
// *************************************************************************

#ifndef XGSM_MULTI_EDITOR_H
#define XGSM_MULTI_EDITOR_H

#include "xgsm_single_editor.h"

#include <gtk--/widget.h>
#include <gtk--/menu.h>
#include <gtk--/optionmenu.h>
#include <gtk--/button.h>

namespace Xgsm
{
  // forward declarations
  class SingleEditor;
  typedef gsmlib::Ref<SingleEditor> SingleEditorRef;

  // multi-editor operation types
  // these must be aligned with the drop-down selection list
  const int CopySelected = 0, CopyAll = 1, Synchronize = 2, Backup = 3;

  // This class implements functions that involve two
  // Xgsm::SingleEditors: Synchronize, Backup, Copy
  
  class MultiEditor : public Gtk::Widget, public ToplevelHelper
  {
  private:
    string _prefix;             // widget name prefix is "sms" or "pb"
    Gtk::Menu *_opMenu;
    int _operation;             // last operation selected
    Gtk::OptionMenu *_opOptionMenu;
    Gtk::Button *_executeLeftToRight, *_executeRightToLeft, *_close;

    bool _waitingForClose;      // true if waiting for devices to finish
    SigC::Connection _idle;     // connection to idle() function

    // idle function, used to wait for device to finish
    gint idle();

  protected:
    SingleEditorRef _left, _right; // left and right editor frames
    bool _leftSensitivity, _rightSensitivity; // last GUI sensitivity
    bool _leftCloseSensitivity, _rightCloseSensitivity; // last GUI sensitivity
    
    MultiEditor(GtkWidget *w, string prefix);

    // editor window callbacks
    void onClose();
    void onDestroy();
    void onExecuteLeftToRight();
    void onExecuteRightToLeft();
    void onOpMenu();
    virtual gint onConfigureEvent(GdkEventConfigure* event) = 0;

  public:
    // return left and right single editors
    SingleEditorRef leftEditor() {return _left;}
    SingleEditorRef rightEditor() {return _right;}

    // tell multieditor when there is a change in device state
    void sensitive(SingleEditor *singleEditor, bool sensitivity,
                   bool closeSensitivity);

    // only used for SMSSingleEditor
    void setPanedPosition(SingleEditor *caller, int position);

    ~MultiEditor();
  };

  class PbMultiEditor : public MultiEditor
  {
    gint onConfigureEvent(GdkEventConfigure* event);

  public:
    PbMultiEditor();
  };

  class SmsMultiEditor : public MultiEditor
  {
    gint onConfigureEvent(GdkEventConfigure* event);

  public:
    SmsMultiEditor();
  };

};

#endif // XGSM_MULTI_EDITOR_H
