/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFMEDIA__PLAYLIST_QUEUE_H_
#define _XFMEDIA__PLAYLIST_QUEUE_H_

#include <gtk/gtk.h>

#include <xfmedia/xfmedia-playlist.h>

G_BEGIN_DECLS

#define XFMEDIA_TYPE_PLAYLIST_QUEUE         (xfmedia_playlist_queue_get_type())
#define XFMEDIA_PLAYLIST_QUEUE(object)      (G_TYPE_CHECK_INSTANCE_CAST((object), XFMEDIA_TYPE_PLAYLIST_QUEUE, XfmediaPlaylistQueue))
#define XFMEDIA_PLAYLIST_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), XFMEDIA_TYPE_PLAYLIST_QUEUE, XfmediaPlaylistQueueClass))
#define XFMEDIA_IS_PLAYLIST_QUEUE(object)   (G_TYPE_CHECK_INSTANCE_TYPE((object), XFMEDIA_TYPE_PLAYLIST_QUEUE))

typedef struct _XfmediaPlaylistQueue         XfmediaPlaylistQueue;
typedef struct _XfmediaPlaylistQueueClass    XfmediaPlaylistQueueClass;
typedef struct _XfmediaPlaylistQueuePrivate  XfmediaPlaylistQueuePrivate;

struct _XfmediaPlaylistQueue
{
    GtkWindow parent;
    
    /*< private >*/
    XfmediaPlaylistQueuePrivate *priv;
};

struct _XfmediaPlaylistQueueClass
{
    GtkWindowClass parent;
    
    /*< signals >*/
    void (*entry_added)(XfmediaPlaylistQueue *playlist_queue);
    void (*entry_removed)(XfmediaPlaylistQueue *playlist_queue);
    void (*emptied)(XfmediaPlaylistQueue *playlist_queue);
};

GType      xfmedia_playlist_queue_get_type   () G_GNUC_CONST;

GtkWidget *xfmedia_playlist_queue_new        (GtkWindow *parent);

void       xfmedia_playlist_queue_push_entry (XfmediaPlaylistQueue *playlist_q,
                                              const XfmediaPlaylistEntryRef *entry,
                                              const gchar *display_name,
                                              gint entry_length);

XfmediaPlaylistEntryRef *xfmedia_playlist_queue_pop_entry
                                             (XfmediaPlaylistQueue *playlist_q);
XfmediaPlaylistEntryRef *xfmedia_playlist_queue_peek_entry
                                             (XfmediaPlaylistQueue *playlist_q);

void       xfmedia_playlist_queue_clear      (XfmediaPlaylistQueue *playlist_q);
guint      xfmedia_playlist_queue_n_entries  (XfmediaPlaylistQueue *playlist_q);

G_END_DECLS

#endif
