/* $Id: addrbookentry.h,v 1.3 2002/12/19 05:33:57 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2002 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/

#ifndef __ADDRBOOKENTRY_H__
#define __ADDRBOOKENTRY_H__

enum ADDRESSBOOKENTRY_TYPE {
	ADDRESSBOOKENTRY_ALIAS,
	ADDRESSBOOKENTRY_SINGLE
};

class AddressBookEntry {
  public:
	AddressBookEntry(const char *addr = NULL, string desc = string(""));
	AddressBookEntry(struct _mail_addr *addr);
	AddressBookEntry(const AddressBookEntry &entry);
	~AddressBookEntry();

	bool AddAddress(const char *addr);
	bool AddAddress(struct _mail_addr *addr);

	bool DeleteAddress(const char *addr);
	bool DeleteAddress(struct _mail_addr *addr);

	void SetAddress(const char *addr);
	void SetAddress(struct _mail_addr *addr);
	void SetDescription(string desc);
	void SetType(ADDRESSBOOKENTRY_TYPE type);

	struct _mail_addr *GetAddress() const { return addrs; }
	string GetDescription() const { return description; }
	ADDRESSBOOKENTRY_TYPE GetType() const { return type; }

	int Size() const { return size; }

	/* write/read the entry to the file pointer */
	bool Write(FILE *fp);
	int Read(FILE *fp);

	/* comparison operators */
	bool operator<(const AddressBookEntry &entry);
	bool operator>(const AddressBookEntry &entry);
	bool operator==(const AddressBookEntry &entry);

	bool operator<(const AddressBookEntry *entry);
	bool operator>(const AddressBookEntry *entry);
	bool operator==(const AddressBookEntry *entry);

	/* address match routines...determines whether address is contained in entry */
	bool Match(const char *addr) const;
	bool Match(struct _mail_addr *addr) const;

	AddressBookEntry &operator=(const AddressBookEntry &entry);

	static int compare(const AddressBookEntry *e1, const AddressBookEntry *e2);
	static int compare(const AddressBookEntry &e1, const AddressBookEntry &e2);

  private:
	struct _mail_addr *addrs;	/* addresses */
	struct _mail_addr *laddr;
	string description;			/* short description */
	ADDRESSBOOKENTRY_TYPE type;	/* type of entry */
	int size;

	void clear();

	void append_addr(struct _mail_addr *addr);
};

#endif /* __ADDRBOOKENTRY_H__ */
