/*-----------------------------------------------------------------------------
  Fm.h
  
  (c) Simon Marlow 1990-1993
  (c) Albert Graef 1994

  modified 1-29-95 by rodgers@lvs-emh.lvs.loral.com (Kevin M. Rodgers)
  to add filtering of icon/text directory displays by a filename filter.

  modified 7-1997 by strauman@sun6hft.ee.tu-berlin.de to add
  different enhancements (see README-NEW).

  modfied 2005,2006,2007 by Bernhard R. Link (see Changelog)

-----------------------------------------------------------------------------*/

#ifndef FM_H
#define FM_H

#ifdef DEBUG_MALLOC
#include <malloc.h>
#endif

#ifdef _AIX
#pragma alloca
#else
#include <alloca.h>
#endif

#include <stdio.h>
#include <sys/types.h> /* just in case */
#include <sys/stat.h>
#include <dirent.h>
#include <sys/param.h>
#include <unistd.h>
#include <stdbool.h>

#include "magic.h"

/* some systems define SVR4 but not SYSV */
#ifdef SVR4
#ifndef SYSV
#define SYSV
#endif
#endif

/*  RBW - 2001/08/14  */
#ifdef _SVID_SOURCE
#define SYSV
#endif

#ifdef SYSV
#define getwd(s) getcwd(s,MAXPATHLEN)
#endif

/* ULTRIX apparently doesn't define these */
#ifdef ultrix
#define S_ISLNK(mode) (mode & S_IFMT) == S_IFLNK
#define S_ISSOCK(mode) (mode & S_IFMT) == S_IFSOCK
#endif

/* for compatibility with BSDI */
#define fnmatch xfnmatch

#ifndef FILENAME_MAX
#define FILENAME_MAX 1024
#endif

/*--FmDirs-------------------------------------------------------------------*/

#define MAXCFGSTRINGLEN MAXPATHLEN

/* structure representing configured devices */
typedef struct {
  char *name;
  char *mount_action;
  char *umount_action;
  char *type;
  int mounted;
} DevRec, *DevList;

/* structure containing the widget ids of an icon */
typedef struct {
	Widget form, toggle, label, arrow;
} IconRec;

/* structure into which the directory information is read */
typedef struct {
	char *name;
	const char *magic_type;
	IconRec icon;
	Boolean selected;
	struct stat stats;
	struct mime_filetype *mime_type;
	struct magic_modifiers info;
	/* only set after flInitialize is run: */
	int width;
	/* these are only set after a call to FileListReducedFilenames,
	 * i.e. only in the IconFileList */
	char *reducedname;
	size_t reducedlen;
} FileRec, **FileList;

struct filetype_data {
	Pixmap icon_bm;
	unsigned int bm_width,bm_height;
	Boolean builtin;
	// TODO: subtypes...
};

/* enumerated arguments passed to functions */
typedef enum { Files, Directories, All } FilterType;
typedef enum { SortByName, SortBySize, SortByMTime } SortType;
typedef enum { Tree, Icons, Text } DisplayType;

struct ChmodPopupData;

typedef struct _FileWindowRec {
  struct _FileWindowRec *next;
  DisplayType display_type;
  Boolean show_dirs, dirs_first, show_hidden;
  Boolean update;
  SortType sort_type;
  Widget shell, form, button_box, label, viewport, status, icon_box;
  char directory[MAXPATHLEN];
  int dev;
  struct stat stats;
  FileList files;
  int n_files;
  int n_selections;
  long n_bytes, n_bytes_selected;
  int	option_in_use;
  Widget *file_items, *folder_items, *view_items, *option_items;
  Widget unreadable;
  Boolean do_filter;             /* KMR */
  char dirFilter[MAXPATHLEN];    /* KMR */
  Boolean showInode,showType,showLinks,showPermissions,showOwner,showGroup,
	  showLength,showDate;
  Widget file_popup_widget, *file_popup_items;
  Widget dir_popup_widget, *dir_popup_items;
  struct PopupDialog *mkdir, *createFile, *goTo, *rename, *move, *copy, *link,
		     *select, *filter;
  struct ChmodPopupData *chmode;
  struct ConfirmationDialog *confirmationDialog;
  struct InfoData *info;
} FileWindowRec, *FileWindowList;

#define P_READ 0x1
#define P_WRITE 0x2
#define P_EXECUTE 0x4

/* public functions */
Boolean readDirectory(FileWindowRec *fw);
void filterDirectory(FileWindowRec *fw, FilterType type);
void sortDirectory(FileList fl, int n, SortType type, Boolean dirs_first);
int permission(struct stat *stats, int perms);
void makePermissionsString(char *s, unsigned int perms);
void freeFileList(FileWindowRec *fw);

/*--FmFw---------------------------------------------------------------------*/

extern FileWindowList file_windows;

extern unsigned int n_devices;
extern DevList devs;

int findDev(char *path);
Boolean mountDev(int d);
void umountDev(int d);

void initFileWindows(void);
void createFileDisplay(FileWindowRec *fw);
void newFileWindow(String path, DisplayType format, 
			     Boolean by_cursor);
#ifdef ENHANCE_SCROLL
void updateFileDisplay(FileWindowRec *fw, Boolean keep_position);
#else
void updateFileDisplay(FileWindowRec *fw);
#endif
void reSortFileDisplay(FileWindowRec *fw);
void reDisplayFileWindow(FileWindowRec *fw);

void clearUpdateMarks(void);
void markForUpdate(const char *path);
void intUpdate(void);

void updateStatus(FileWindowRec *fw);

void updateTxtOpts(FileWindowRec *fw);

struct PopupDialog;

typedef void CallbackProc(Widget, void *, void *);
typedef void PDCallbackProc(Widget, struct PopupDialog *, void *);
typedef void FmCallbackProc(Widget, FileWindowRec *, void *);

/*--FmFwCb-------------------------------------------------------------------*/

FmCallbackProc
  fileOpenCb, fileSelectAllCb, fileDeselectCb, fileTreeCb, fileIconsCb,
  fileTextCb, fileSortNameCb, fileSortSizeCb, fileSortMTimeCb, fileShowDirsCb,
  fileDirsFirstCb, fileCloseCb, mainArrowCb, fileHomeCb, fileUpCb, 
  floatingMenuCb, fileShowHiddenCb, fileEditCb, fileViewCb, xtermCb,
  fileAboutCb, fileQuitCb;
#ifdef ENHANCE_SELECTION
FmCallbackProc selectionOwnCb;
#endif

FmCallbackProc
  showTxtOptsCb;

#ifdef ENHANCE_MENU
FmCallbackProc fileCloneCb;
#endif

void timeoutCb(XtPointer data, XtIntervalId *id);

/*---FmFwActions-------------------------------------------------------------*/

typedef enum { SingleFile, MultipleFiles, Executable, Directory } FileType;

typedef struct {
  Widget dragged_from;
  FileWindowRec *fw;
  FileType type;
} MoveInfo;

extern MoveInfo move_info;
extern Boolean dragging;
void drag_set_dropable(Display *d, bool dropable);

typedef void FmActionProc(Widget w, XEvent *event, String *params, 
		    Cardinal *num_params);

FmActionProc fileHighlight, fileMaybeHighlight, fileToggle, fileSelect,
  fileRefresh, fileOpenDir, fileBeginDrag, treeOpenDir, fileExecAction,
  resetCursor, trackCursor, filePopup, dirPopup;

void doEdit(const char *directory, const char *fname);
void doView(const char *directory, const char *fname);
void doXterm(const char *directory);

void fileCallWithSelected(const char *action);

/*---FmBitmaps---------------------------------------------------------------*/

enum {
/* Tree view bitmaps */
	NOENTRY_BM=0,
	LLINE_BM,
	TLINE_BM,
	FLINE_BM,
	CLINE_BM,
	LARROW_BM,
	RARROW_BM,
	WAVY_BM,

/* Misc */
	TICK_BM,
	NOTICK_BM,
	EXCL_BM,

#ifdef ENHANCE_PERMS
/* showing the modes */
	sUID_BM,
	SUID_BM,
	StICKY_BM,
	STICKY_BM,
#endif

/* File pixmaps */
	FILES_BM,
	DIR_BM,
	FILE_BM,
	SYMLNK_BM,

/* Hardcoded bitmaps stop here: */
	BM_COUNT
} bitmap_names;

/* Cursors */

enum {	FILE_CUR=0,
	FILES_CUR,
	NOENTRY_CUR,
	DIR_CUR,
	EXEC_CUR,
	WATCH_CUR,
	CURSOR_COUNT
} cursor_names;

/* Builtin default Types */

enum {	DIR_T=0, 
	UPDIR_T,
	FILE_T,
	SPECIAL_T,
	BLACKHOLE_T,	
	TYPE_COUNT
} builtin_type_names;

/* file modifiers */

enum {
	LINK_SYMBOL=0,
	/* not yet implemented... */
	GZIP_SYMBOL,
	BZIP_SYMBOL,
	FILE_MODIFIER_COUNT
} file_modifier_names;

extern Cursor curs[CURSOR_COUNT];
extern struct dimensionedpixmap { 
	Pixmap pm; 
	Dimension width, height;
} file_modifiers[FILE_MODIFIER_COUNT];
extern Pixmap bm[BM_COUNT];
extern Pixmap bm_appmgr,bm_appmgrmsk,bm_icon,bm_iconmsk;

void readBitmaps(void);
Pixmap loadIcon(const char *name, Cardinal *pm_width, Cardinal *pm_height);
Pixmap loadFileIcon(const char *name, Cardinal *pm_width, Cardinal *pm_height);

/*--FmChmod------------------------------------------------------------------*/

FmCallbackProc chmodPopup;

/*--FmConfirm----------------------------------------------------------------*/

int fwConfirm(FileWindowRec *fw, const char *s1, const char *s2, const char *s3, Boolean *aborted);
int amConfirm(const char *s1, const char *s2, const char *s3, Boolean *aborted);

/*--FmDelete-----------------------------------------------------------------*/

FmCallbackProc deleteItems, emptyDir;

/*--FmErrors-----------------------------------------------------------------*/

#include "FmErrors.h"

/*--FmExec-------------------------------------------------------------------*/

typedef struct {
  String pattern, command;
} ExecMapRec;

extern ExecMapRec *exec_map;
extern int n_exec_maps;

/*--FmInfo-------------------------------------------------------------------*/

FmCallbackProc infoPopup;

/*--FmMain-------------------------------------------------------------------*/

/* Structure containing information about the user */
typedef struct {
  uid_t uid;
  gid_t gid;
  char home[MAXPATHLEN];
#ifdef ENHANCE_USERINFO
  char cwd[MAXPATHLEN];
#endif
  mode_t umask;
} UserInfo;

typedef struct {
  Boolean appmgr, filemgr, version;
  String init_geometry;
  XFontStruct *icon_font, *button_font, *menu_font, *label_font, *status_font,
    *bold_font, *cell_font;
  int app_icon_width, app_icon_height, file_icon_width, file_icon_height,
    tree_icon_width, tree_icon_height;
  String main_app_file, app_dir, app_clip, dev_file;
  String mailcap_file, mimetypes_file, magic_file;
#ifdef SYSTEMWIDE_DEFAULTS
  String system_main_app_file, system_app_dir, system_dev_file;
  String system_mailcap_file, system_mimetypes_file, system_magic_file;
#endif
  Boolean confirm_deletes, confirm_delete_folder, confirm_moves,
    confirm_copies, confirm_overwrite, confirm_quit;
  Boolean echo_actions, echo_mime_search;
  SortType default_sort_type;
  DisplayType default_display_type, initial_display_type;
  Boolean show_owner, show_perms, show_date, show_length;
  Boolean show_group, show_type, show_inode, show_links;
  int double_click_time, update_interval;
#ifdef ENHANCE_PERMS
  int hard_update_ticks;
#endif
  String bitmap_path, pixmap_path, icon_path;
#ifdef ENHANCE_HISTORY
  int	 history_max_n;
#endif
#ifdef ENHANCE_TRANSLATIONS
  String app_defs_version;
#endif
#ifdef ENHANCE_CMAP
  int	color_closeness;
#endif
#ifdef ENHANCE_SELECTION
  Pixel  highlight_pixel;
  String selection_paths_separator;
#endif
  String symlinkdir;
  Boolean alwaysSymlink;
  Cardinal maxMagicRead;
  const char **editor, **viewer, **xterminal, **xtermalone, **shell;
} Resources;

extern char *progname;
extern Resources resources;
extern XtAppContext app_context;
extern UserInfo user;

/* The following implements a semaphor for preventing the processing of update
   events in the refresh timer and the client message handler while a complex
   operation is in progress. This is a dreadful kludge, but we have to keep
   these events from modifying global data structures of the file manager
   while an operation is running. Update events which happen to get dispatched
   while the semaphor is set (for instance when an operation like file-copy
   is processing a popup form) will be simply ignored. -ag */

extern int freeze;

void quit(int unused) __attribute__ ((noreturn));

/*---FmPopup-----------------------------------------------------------------*/

FmCallbackProc selectPopup, mkdirPopup, createFilePopup, goToPopup,
  renamePopup, movePopup, copyPopup, linkPopup, filterPopup;

/*--FmUtils------------------------------------------------------------------*/

/* structures containing information required to set up a menu */
typedef struct {
  const char *item_name;
  const char *item_label;
  CallbackProc *callback;
} MenuItemRec;

/* variant for filewindow (must be assignment compatible) */
typedef struct {
  const char *item_name;
  const char *item_label;
  FmCallbackProc *callback;
} FmMenuItemRec;

/* structures containing information required to set up a button */
typedef struct {
  const char *button_name;
  const char *button_label;
  CallbackProc *callback;
} ButtonRec;

/* variant for QuestionPopups (must be assignment compatible!) */
typedef struct {
  const char *button_name;
  const char *button_label;
  PDCallbackProc *callback;
} PDButtonRec;

/* variant for filewindow (must be assignment compatible) */
typedef struct {
  const char *button_name;
  const char *button_label;
  FmCallbackProc *callback;
} FmButtonRec;

/* structure for creating a popup questionaire */
typedef struct {
  const char *label;
  Cardinal length;
} QuestionRec;

struct PopupDialog {
	Widget shell;
	Cardinal count;
	const QuestionRec *questions;
	void *data;
	struct PopupDialog **clear_ptr;
	struct PopupDialogField { char *answer; Widget widget; } fields[];
};

#if 1
#define getPopupAnswer(p,i) ({Cardinal _j=i; assert(_j<(p)->count); (p)->fields[_j].answer;})
#else
#define getPopupAnswer(p,i) (p)->answers[i]
#endif

/* functions */

void initUtils(void);

Widget *createMenu(const char *menu_name, const char *menu_label, const MenuItemRec *items,
		   Cardinal n_items, Dimension left_margin, Widget parent,
		   XtPointer client_data);
static inline Widget *createFmMenu(const char *menu_name, const char *menu_label, const FmMenuItemRec *items, Cardinal n_items, Dimension left_margin, Widget parent, FileWindowRec *fw) {
	return createMenu(menu_name, menu_label, (const MenuItemRec *)items, n_items,
	                  left_margin, parent, fw);
}
Widget *createButtons(const ButtonRec *buttons, Cardinal n_buttons, Widget parent,
		      XtPointer client_data);
void createPopupQuestions(struct PopupDialog **out, Widget parent,
		            const char *name, const char *title, Pixmap bitmap,
			    const QuestionRec *questions, Cardinal n_questions,
			    const PDButtonRec *buttons, Cardinal n_buttons,
			    Cardinal dflt_button);
void popdownPopup(struct PopupDialog *p);
void reloadPopupData(struct PopupDialog *p);
bool setPopupData(struct PopupDialog *p, Cardinal i, const char *value);
void popupPopupByCursor(struct PopupDialog *p, void *data);
void destroyPopup(struct PopupDialog *p);
void fillIn(Widget w);
void grayOut(Widget w);
void tick(Widget w);
void noTick(Widget w);
void popupByCursor(Widget shell, XtGrabKind grab_kind);
void zzz(void), wakeUp(void);
Widget *createFloatingMenu(const char *menu_name,
			   const MenuItemRec *items, Cardinal n_items, 
			   Dimension left_margin, Widget parent, 
			   XtPointer client_data,
			   Widget *menu_widget);
char *varPopup(Widget parent, Pixmap icon_bm, char *action);
void aboutPopup(Widget parent);

void setWMProps(Widget shell);

/*--FmComms------------------------------------------------------------------*/

extern Atom xfm_open_window, xfm_update_window, wm_delete_window,
    wm_protocols, wm_save_yourself, kwm_save_yourself;
void clientMessageHandler(Widget w, XtPointer closure, XEvent *e);
void initComms(void);

/*--FmOps--------------------------------------------------------------------*/

char *xstrdup(const char *str);
char *dirConcat(const char *directory,const char *name);
char *suffixConcat(const char *directory,const char *name);
char *spaceConcat(const char *str1, const char *str2);
char *split(char *s, char c);
char *expand(char *s, char *t, char *c);
void fprintexpand(FILE *f, const char *t, const char *c);
char *strparse(char *s, const char *t, const char *c);
int fnmatch(String pattern, String name);
char *fnexpand(char *fn);
char *dyn_fnexpand(const char *fn);
char *expanddirectory(const char *dir);
char *home_and_env_expand(const char *fn);
int prefix(const char *s, const char *t);
int exists(const char *path);
char *searchPath(char *s1, char *p, const char *s2);
char *searchPathWithSuffix(char *s1, char *p, const char *s2, const char *suffix);
Boolean cmpCanonical(const char *dir1, const char *dir2);

int create(const char *path, mode_t mode), rcopy(const char *oldpath, const char *newpath),
  rmove(const char *oldpath, const char *newpath), rdel(const char *path);

/*---------------------------------------------------------------------------*/

/* Horrible kludge to avoid warnings, as XtFree is designed to take a (char *)*/
#define XTFREE(p) XtFree((void *)(p))
#define XTREALLOC(p,n) XtRealloc((void *)(p),(n))

#endif
