/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#ifdef HAVE_LIBXFCEGUI4
#include <libxfcegui4/libxfcegui4.h>
#endif
#ifdef HAVE_LIBXFCE4MCS_CLIENT
#include <libxfce4mcs/mcs-client.h>
#endif

#include "xffm.h"

#define CHANNEL  "xffm"

 
#ifdef HAVE_LIBXFCE4MCS_CLIENT


static int settings_cb_id = 0;

/* icon theme */
#if GTK_CHECK_VERSION (2,4,0)
static void
icontheme_cb (GtkIconTheme *icontheme)
{
#else /* gtk < 2.4 */
static void
settings_notify_cb (GtkSettings *gsettings, GParamSpec *pspec)
{
    if (strcmp (pspec->name, "gtk-icon-theme-name")) return;
#endif
    g_warning("Theme changed: restart application for changes to take effect");
}




static gboolean active_mcs = TRUE;

static McsClient *client = NULL;


static GdkFilterReturn client_event_filter(GdkXEvent * xevent, GdkEvent * event, gpointer data)
{
    if(mcs_client_process_event(client, (XEvent *) xevent))
	return GDK_FILTER_REMOVE;
    else
	return GDK_FILTER_CONTINUE;
}

static void watch_cb(Window window, Bool is_start, long mask, void *cb_data)
{
    GdkWindow *gdkwin;

    gdkwin = gdk_window_lookup(window);

    if(is_start)
    {
	if(!gdkwin)
	{
	    gdkwin = gdk_window_foreign_new(window);
	}
	else
	{
	    g_object_ref(gdkwin);
	}
	gdk_window_add_filter(gdkwin, client_event_filter, cb_data);
    }
    else
    {
	g_assert(gdkwin);
	gdk_window_remove_filter(gdkwin, client_event_filter, cb_data);
	g_object_unref(gdkwin);
    }
}



static void notify_cb(const char *name, const char *channel_name, McsAction action, McsSetting * setting, void *data)
{

    if(!active_mcs)
	return;
    if(g_ascii_strcasecmp(CHANNEL, channel_name))
    {
	TRACE("This should not happen");
	return;
    }

    switch (action)
    {
	case MCS_ACTION_NEW:
		/*printf("TRACE:MCS_ACTION_NEW with name=%s \n",name);*/
	case MCS_ACTION_CHANGED:
		/*printf("TRACE: MCS_ACTION_CHANGED with name=%s \n",name);*/
	    if(setting->type == MCS_TYPE_STRING)
	    {
		/* environment on the fly */
		if (!setting->data.v_string || 
		    !strlen(setting->data.v_string)){
		   xffm_setenv(name,NULL,TRUE);
		}
		else 
		  xffm_setenv(name,setting->data.v_string,TRUE);
		  
	       	/*printf("TRACE: environment %s\n",env_string[which]);
		   printf("TRACE:getenv=%s\n",getenv(name));*/
	
	    }
	    if(setting->type == MCS_TYPE_INT && xffm_details)
	    {

	    }
	    break;
	case MCS_ACTION_DELETED:
		/*printf("TRACE:  MCS_ACTION_DELETED with name=%s \n",name);*/
	default:
	    break;
    }
}

/* exported functions... */

G_MODULE_EXPORT
void set_active_mcs(gboolean state)
{
    active_mcs = state;
}

G_MODULE_EXPORT
void connect_mcs(void)
{
    /*gchar *theme;*/
    client = mcs_client_new(GDK_DISPLAY(), XDefaultScreen(GDK_DISPLAY()), notify_cb, watch_cb, NULL);
    if(client)
    {
	mcs_client_add_channel(client, CHANNEL);
    }
    else
    {
	g_warning("Cannot create MCS client channel");
    }
#if GTK_CHECK_VERSION (2,4,0)
    settings_cb_id = 
	g_signal_connect (gtk_icon_theme_get_default (), "changed", 
			  G_CALLBACK (icontheme_cb), NULL);
#else
    {
      GtkSettings *gsettings = gtk_settings_get_default ();
      settings_cb_id = g_signal_connect (gsettings, "notify", 
	    			       G_CALLBACK (settings_notify_cb), NULL);
    }
#endif
}

G_MODULE_EXPORT
void
mcs_stop_watch (void)
{
    if (client)
    {
	mcs_client_destroy (client);
	
	client = NULL;
    }

    if (settings_cb_id)
    {
#if GTK_CHECK_VERSION (2,4,0)
	g_signal_handler_disconnect (gtk_icon_theme_get_default (), 
				     settings_cb_id);
#else
	g_signal_handler_disconnect (gtk_settings_get_default (), 
				     settings_cb_id);
#endif
	settings_cb_id = 0;
    }
}

#else /* no HAVE_LIBXFCE4MCS_CLIENT */

void set_active_mcs(gboolean state){}
void connect_mcs(void){}
void mcs_stop_watch (void){}
#endif

