#define GNOME_TRASH 	g_get_home_dir(),".Trash"
/* XXX this is kde2. I dunno about kde3*/
#define KDE_TRASH 	g_get_home_dir(),"Desktop","Trash"

static xftrash_functions *xftrash_fun=NULL;
static widgets_t *widgets_pW=NULL;

static unsigned int trashcount;
static unsigned int smallcount, countbyte;
static xfdir_t trash_xfdir;
static int target_type;
static gboolean just_count;


static DBHashTable *trashbin = NULL;
static DBHashTable *newtrashbin = NULL;

static void set_private_variables(widgets_t *widgets_p){
    widgets_pW=widgets_p;
}

static 
const char *trash_path(void){
    gchar *trashfile=NULL;
    if (!trashfile) {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	trashfile=g_build_filename(xdg_dir,CURRENT_TRASHBIN,NULL);
	g_free(xdg_dir);
    }
    return (const char *)trashfile;
}

static void *local_fork_object=NULL;
static int fork_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics(widgets_pW,"xfce/error", line, NULL);
    return TRUE;
}

static int fork_stdout(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics(widgets_pW,NULL, line, NULL);
    /*print_diagnostics(widgets_pW,"xfce/info", line, NULL);*/
    return TRUE;
}

static void fork_done(pid_t pid){
  local_fork_object = NULL;    
}

static
int fork_wait(gboolean animate){
	
  while (local_fork_object){

    if (xffm_details->arbol) 
	set_progress_generic(&(xffm_details->arbol->widgets),-1,-1,1);
     while (gtk_events_pending()) gtk_main_iteration();
     usleep(5000);
  }
  return TRUE;
}

static
void rm_directory (gchar *fullpath){
	char *argument[4];
	argument[0]="rm";
	argument[1]="-rfv";
	argument[2]=fullpath;
	argument[3]=(char *)0;
		    
	print_diagnostics(widgets_pW,NULL,_("Deleting...")," ",fullpath,"\n",NULL);
	local_fork_object = Tubo (fork_function, 
	    (void *)argument, 
	    fork_done, 
	    NULL, 
	    fork_stdout, fork_stderr,0,FALSE);
	 if (xffm_details->arbol) (*xffm_details->arbol->set_load_wait)();
	 fork_wait(FALSE);
	 print_diagnostics(widgets_pW,NULL,_("Deleted")," ",fullpath,"\n",NULL);
	 if (xffm_details->arbol) (*xffm_details->arbol->unset_load_wait)();
}

static void delete_trash(DBHashTable * dbh)
{
    struct stat st;
    gchar *fullpath = (gchar *)DBH_DATA(dbh);
    if(lstat(fullpath, &st) < 0)
	return;
    if(S_ISDIR(st.st_mode)) rm_directory(fullpath);
    else g_warning("non-directory found in trashbin: %s",fullpath);
    return;
}

static 
DBHashTable *open_trash_dbh(gboolean create){
    DBHashTable *trash_dbh=NULL;

    if (!g_file_test(trash_path(),G_FILE_TEST_EXISTS) && !create){
	print_diagnostics(widgets_pW,NULL,strerror(ENOENT)," :",trash_path(),"\n",NULL);
    }
    else if ((trash_dbh = DBH_open((char *)trash_path())) == NULL ){
	if (create) {
	    trash_dbh = DBH_create((char *)trash_path(), 11);
	} 
	if (!trash_dbh) {
	    print_diagnostics(widgets_pW,"xfce/warning",strerror(EIO),"\n",NULL);
	}	    
    }   
    return  trash_dbh;
}

G_MODULE_EXPORT
int 
delete_all_trash(GtkTreeView *treeview)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter iter;
    record_entry_t *en;

    if ((trashbin=open_trash_dbh(FALSE))==NULL) return -1;
    if(!(*xffm_details->arbol->set_load_wait)()) {
	TRACE("!set_load_wait()");
	print_diagnostics(widgets_pW,"xfce/error",strerror(ECHILD),"\n",NULL);
	return -1;
    }
    cursor_wait(widgets_pW->window);

    DBH_foreach_sweep(trashbin, delete_trash);
    DBH_close(trashbin);

    unlink(trash_path());

    if(!(*xffm_details->arbol->get_module_root)(treeview, &iter, &en,en->module))	
	return 1;

    if(IS_LOADED(en->type))
    {
	GtkTreePath *treepath;
	(*xffm_details->arbol->prune_row)(treemodel, &iter,NULL,en);
	(*xffm_details->arbol->insert_dummy_row)(treemodel, &iter,NULL,en,NULL,NULL);
	if(en->tag){
	    g_free(en->tag);
	    en->tag=NULL;
	}
	treepath = gtk_tree_model_get_path(treemodel, &iter);
	gtk_tree_view_collapse_row(treeview, treepath);
	gtk_tree_path_free(treepath);
	(*xffm_details->arbol->set_icon)(treemodel, &iter);
    }
/* zap gnome and kde trash too */
    {
	gchar *gnome=g_build_filename(GNOME_TRASH,NULL);
	gchar *kde=g_build_filename(KDE_TRASH,NULL);
	if (kde && g_file_test(kde,G_FILE_TEST_IS_DIR)) rm_directory(kde);
	if (gnome && g_file_test(gnome,G_FILE_TEST_IS_DIR)) rm_directory(gnome);
	g_free(kde);
	g_free(gnome);
    }

    
    cursor_reset(widgets_pW->window);
    print_status(widgets_pW,"xfce/info", _("Trash has been deleted"), NULL);
    if (xffm_details->arbol) {
	(*xffm_details->arbol->unset_load_wait)();
	(*xffm_details->arbol->local_monitor)(TRUE);
    }
    return 0;

}


static void count_check(DBHashTable * dbh)
{
    char *p;
    char *fullpath = (char *)DBH_DATA(dbh);

    if (!fullpath) return;
    p = strrchr(fullpath, '/');
    /*printf("TRACE:%s -> %s\n",fullpath,p); */
    if(!p || strlen(p) <= 1)
	return;
    p++;
    if (!g_file_test(fullpath,G_FILE_TEST_EXISTS)){
	return;
    }
    trashcount++;
    return;
}

G_MODULE_EXPORT
int count_trash(void)
{
    trashcount = 0;		/* for count step */
    if ((trashbin=open_trash_dbh(FALSE))==NULL) return -1;
    DBH_foreach_sweep(trashbin, count_check);
    DBH_close(trashbin);
    return (trashcount);
}



static void add_bin(DBHashTable * dbh)
{
    gchar *basename;
    gchar *fullpath = (char *)DBH_DATA(dbh);
    if (!fullpath || !strlen(fullpath)) return;
    basename = g_path_get_basename(fullpath);


    TRACE("add_bin:%s -> %s",fullpath,basename); 


    if(!basename || strlen(basename) <= 1) {
	g_free(basename);
	return;
    }
    if (!g_file_test(fullpath,G_FILE_TEST_EXISTS)) {
	return;
    }
    if(!just_count)
    {
	trash_xfdir.gl[trash_xfdir.pathc].en = stat_entry(fullpath, target_type);
	if(!trash_xfdir.gl[trash_xfdir.pathc].en)
	{
	    printf("xffm: aarrgg! could not stat %s!!\n", fullpath);
	    return;
	}
	if (strstr(fullpath,"..Wastebasket")){
	    gchar *dirname=g_path_get_dirname(fullpath);
	    g_free(basename);
	    basename=g_path_get_basename(dirname);
	    g_free(dirname);
	}
       	
	trash_xfdir.gl[trash_xfdir.pathc].pathv = g_strconcat("[",basename,"]",NULL);
	trash_xfdir.pathc++;
    }
    else {
	trashcount++;
    }
    if (xffm_details->arbol) 
	set_progress_generic(&(xffm_details->arbol->widgets),-1,-1,1);
    g_free(basename);
    return;
}

static
xfdir_t *private_get_xfdir(record_entry_t *en)
{
    gboolean xfce_trash;
    gchar *gnome=NULL,*kde=NULL;

    TRACE("private_get_xfdir trash");
    target_type = en->type;
    UNSET_ERASED_SPACE(en->type);

    smallcount = 0, countbyte = 0x10;	/* for dummy tag */
    trashcount = 0;		/* for count step */
    trash_xfdir.pathc = 0;	/* for read step */
    if ((trashbin=open_trash_dbh(FALSE))==NULL) {
	TRACE("trashbin=open_trash_dbh==NULL");
	print_diagnostics(widgets_pW,"xfce/info",_("No trash has been collected."),NULL);
	xfce_trash=FALSE;
    }
    else xfce_trash=TRUE;

    /* other trash */
    gnome=g_build_filename(GNOME_TRASH,NULL);
    kde=g_build_filename(KDE_TRASH,NULL);
	

    
    if (!trashbin) {
	SET_LOADED(en->type);
	return NULL;
    }
    
    just_count = TRUE;
	TRACE("before sweep, trashcount=%d",trashcount);
    DBH_foreach_sweep(trashbin, add_bin);
	TRACE("after sweep, trashcount=%d",trashcount);

    if (gnome) trashcount++;
    if (kde) trashcount++;
    
    
    if(trashcount)
    {
	trash_xfdir.gl = (dir_t *) malloc(trashcount * sizeof(dir_t));
	if (gnome) {
	    trash_xfdir.gl[trash_xfdir.pathc].pathv=g_strdup("GNOME");
	    trash_xfdir.gl[trash_xfdir.pathc].en=stat_entry(gnome,en->type);
	    trash_xfdir.pathc++;
	}
        if (kde) {
	    trash_xfdir.gl[trash_xfdir.pathc].pathv=g_strdup("KDE");
	    trash_xfdir.gl[trash_xfdir.pathc].en=stat_entry(kde,en->type);
	    trash_xfdir.pathc++;
	}
    

	if(!trash_xfdir.gl)
	{
	    if (trashbin) DBH_close(trashbin);
	    g_warning("malloc(trashcount * sizeof(dir_t)) == NULL");
	    return NULL;
	}
	just_count = FALSE;
	DBH_foreach_sweep(trashbin, add_bin);
        TRACE("TRACE:pathc=%d\n",trash_xfdir.pathc); 
	TRACE("TRACE:count=%d\n",trashcount); 

	if(trashcount != trash_xfdir.pathc + ((gnome)?1:0) + ((kde)?1:0))
	{
	    SET_ERASED_SPACE(en->type);
	    TRACE("TRACE:listed=%d, counted=%d\n", trash_xfdir.pathc, trashcount); 
	}
	trash_xfdir.pathc = trashcount;
    } 
    g_free(gnome); gnome=NULL;
    g_free(kde); kde=NULL;
    if(DBH_ERASED_SPACE(trashbin))
    {
	TRACE("TRACE: erased space=%d\n",DBH_ERASED_SPACE(trashbin)); 
	SET_ERASED_SPACE(en->type);
    }
    DBH_close(trashbin);
    g_free(en->tag);
    en->tag=g_strdup(_("Trash"));
    
    return &trash_xfdir;
}


static int read_trash_locations(char *path)
{
    DIR *directory;
    int count = 0;
    struct dirent *d;
    regex_t shortpreg;
    gchar *newpath=NULL;
    gboolean shortpreg_compiled;

    if(xffm_details->arbol && xffm_details->arbol->widgets.stop) return 0;
    if (xffm_details->arbol) 
        set_progress_generic(&(xffm_details->arbol->widgets), -1, 0,1);

    directory = opendir(path);
    if(!directory)
	return 0;
    
    if (!regcomp(&shortpreg, "^\\.\\.Wastebasket$", REG_EXTENDED | REG_ICASE | REG_NOSUB)) 
	shortpreg_compiled=TRUE;
    else 
	shortpreg_compiled=FALSE;

    
    while((d = readdir(directory)) != NULL)
    {
	if(xffm_details->arbol && xffm_details->arbol->widgets.stop)
	{
	    closedir(directory);
	    return 0;
	}
	if(strcmp(d->d_name, ".") == 0 || strcmp(d->d_name, "..") == 0)
	    continue;
	if (xffm_details->arbol) 
	    set_progress_generic(&(xffm_details->arbol->widgets), -1, 0,1);

	newpath=g_build_filename(path, d->d_name, NULL);
	if(shortpreg_compiled && !regexec(&shortpreg, d->d_name, 0, NULL, 0) )
	{
	    GString *gs;
	    TRACE("TRACE:read(1) trash from %s\n",newpath); 
	    gs = g_string_new(newpath);
	    sprintf((char *)DBH_KEY(trashbin), "%10u", g_string_hash(gs));
	    /* overwrite record if exists might be faster by probability.*/
	    if(!DBH_load(trashbin))
	    {
	      memcpy(DBH_DATA(trashbin), (void *)newpath, strlen(newpath) + 1);
	      DBH_set_recordsize(trashbin, strlen(newpath) + 1);
	      DBH_update(trashbin);
	    }
	    g_string_free(gs, TRUE);
	    count++; 
	    /* message at nonverbose level: */
	    print_diagnostics(widgets_pW,"xfce/waste_basket_full",newpath,"\n",NULL);
	} else {
	    struct stat st;
	    lstat(newpath,&st);
	    if (S_ISDIR(st.st_mode)){
		/* recurse */
		count += read_trash_locations(newpath);
	    }
	}
	g_free(newpath);
    }
    closedir(directory);
    if (shortpreg_compiled)regfree(&shortpreg);
    return (count);
}

static 
void 
purge_trash(DBHashTable * dbh)
{
    char *p;
    char *fullpath = (char *)DBH_DATA(dbh);
    struct stat st;

    if(!newtrashbin)
	assert_not_reached();
    p = strrchr(fullpath, '/');
    if(p)
    {
	p++;
	if(lstat(fullpath, &st) < 0)
	{
	    return;
	}
    }
    /* copy the key from the old record to the new record */
    memcpy(DBH_KEY(newtrashbin), DBH_KEY(trashbin), DBH_KEYLENGTH(trashbin));
    /* copy the data from the old record to the new record */
    memcpy(newtrashbin->data, trashbin->data, DBH_RECORD_SIZE(trashbin));
    /* I always forget this instruction, and it is the most important
     * (since DBH records have a variable size): */
    DBH_set_recordsize(newtrashbin, DBH_RECORD_SIZE(trashbin));
    /* write the record to the new file; */
    if(!DBH_update(newtrashbin))
	assert_not_reached();
    /*printf("TRACE:clean record: %s\n",fullpath); */
    return;
}


G_MODULE_EXPORT
void * 
trash_background_purge(void)
{
    gchar *fname;
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE); 
    gchar *work_directory=g_build_filename(xdg_dir,"xffm","histories",NULL);
    g_free(xdg_dir);

    /* the DBH_regen tmp file is generated here */
    if (chdir(work_directory)<0){
	g_warning("trash purge: %s\n%s",strerror(errno),work_directory);
	g_free(work_directory);
	return GINT_TO_POINTER(0);
    }
    g_free(work_directory);
    
    if ((trashbin=open_trash_dbh(TRUE))==NULL) _exit(1);
 
    /*  make dbh logical and physical structures the same 
     *  eliminating stale entries while you're at it.*/
    fname = g_strdup("trashbin.XXXXXX");
    close(mkstemp(fname));
    newtrashbin = DBH_create(fname, DBH_KEYLENGTH(trashbin));
    DBH_foreach_sweep(trashbin, purge_trash);
    DBH_close(trashbin);
    DBH_close(newtrashbin);
    rename(fname, trash_path());
    g_free(fname);
    return GINT_TO_POINTER(1);
}


/* returns -1 on failure, otherwise count of elements gathered */
G_MODULE_EXPORT
int collect_trash(GtkTreeView * treeview, char *path)
{
    int count=0;
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE); 
    gchar *work_directory=g_build_filename(xdg_dir,"xffm","histories",NULL);

    g_free(xdg_dir);

    /* so the DBH_regen tmp file is generated here */
    if (chdir(work_directory)<0){
	print_diagnostics(widgets_pW,"xfce/error",strerror(errno),"\n",work_directory,"\n",NULL);
	g_free(work_directory);
	return -1;
    }
    g_free(work_directory);
    

    if ((trashbin=open_trash_dbh(TRUE))==NULL) return -1;
 
    {
      gchar *m=g_strdup_printf(_("Collecting trash from %s"),path);
      print_diagnostics(widgets_pW,"xfce/info", m, "...", "\n",NULL);
      g_free(m);
    }
    
    cursor_wait(xffm_details->arbol->widgets.window);
    /* step one: add collected entries: */
    /* not in iconview: */
    show_stop(&(xffm_details->arbol->widgets));
    
#if 0
    if (strrchr(path,'/')&&strcmp(strrchr(path,'/')+1,"..Wastebasket")==0){
	    count = read_trash(treeview, path);
    }
#endif
    
    count += read_trash_locations(path);
    if(xffm_details->arbol->widgets.stop)
    {
	xffm_details->arbol->widgets.stop = FALSE;
	print_status(widgets_pW,"xfce/info",
		strerror(ETIMEDOUT),
		NULL);
	DBH_close(trashbin);
    }
    else
    {
	/* step two:   make dbh logical and physical structures the same 
	 *             eliminating stale entries while you're at it.*/
	gchar *s;
	/* not in iconview: */
	hide_stop(&(xffm_details->arbol->widgets));
	s = g_strdup_printf(_("%d trash items collected."), count);
	print_status(widgets_pW,"xfce/info", s, NULL);
	g_free(s);s=NULL;
	DBH_close(trashbin);
	/*trash_background_purge();*/
    }
    chdir(GETWD);
    cursor_reset(xffm_details->arbol->widgets.window);
    return count;
}

G_MODULE_EXPORT
int add2trash(widgets_t *widgets_p, char *filepath)
{
    GString *gs;
    gchar *path=g_path_get_dirname(filepath);
    if (!path || !strlen(path)) return -1;

    if ((trashbin=open_trash_dbh(TRUE))==NULL) return -1;
    {
      gchar *m=g_strdup_printf(_("Adding to trash: %s"),filepath);	
      print_diagnostics(widgets_p,"xfce/waste_basket_full", m, "\n", NULL);
      g_free(m);
    }

    gs = g_string_new(path);
    sprintf((char *)DBH_KEY(trashbin), "%10u", g_string_hash(gs));
    if(!DBH_load(trashbin))
    {
	memcpy(DBH_DATA(trashbin), (void *)path, strlen(path) + 1);
	DBH_set_recordsize(trashbin, strlen(path) + 1);
	DBH_update(trashbin);
    }
    g_string_free(gs, TRUE);

    DBH_close(trashbin);
    return 1;
}


/****************** callbacks *****************************/
G_MODULE_EXPORT
void collect_trash_callback(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = (*xffm_details->arbol->get_active_tree_id)();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeIter iter;
    record_entry_t *en;
    int caso = 0;
    
    widgets_pW=&(xffm_details->arbol->widgets);
    if(!(*xffm_details->arbol->get_selectpath_iter)(&iter, &en))
	return;
    if(IS_DIR(en->type))
	caso = 1;
    /*else if(IS_BOOKMARK_TYPE(en->type) && IS_ROOT_TYPE(en->type))
	caso = 2;*/
    else
    {
	print_status(widgets_pW,"xfce/error", strerror(EINVAL), NULL);
	return;
    }

    if(caso == 1)
	collect_trash(treeview, en->path);

}

G_MODULE_EXPORT
void uncollect_trash_callback(GtkMenuItem * menuitem, gpointer user_data)
{
    gint tree_id = (*xffm_details->arbol->get_active_tree_id)();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    record_entry_t *en;
    GtkTreeIter iter;
    GtkTreePath *treepath;

    widgets_pW=&(xffm_details->arbol->widgets);

    if(unlink(trash_path()))
    {
	print_diagnostics(widgets_pW,"xfce/error", strerror(errno), ":\n",trash_path(),"\n", NULL);
	return;
    }
    else
    {
	print_status(widgets_pW,"xfce/info", _("Trash has been uncollected"), NULL);
    }


    if(!gtk_tree_model_get_iter_first(treemodel, &iter)) return;
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
    while(en && !IS_TRASH_TYPE(en->type))
    {
	if(!gtk_tree_model_iter_next(treemodel, &iter)) return;
	gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
    }
    if(IS_LOADED(en->type))
    {
	(*xffm_details->arbol->prune_row)(treemodel, &iter,NULL,en);
	(*xffm_details->arbol->insert_dummy_row)(treemodel, &iter,NULL,en,NULL,NULL);
	if(en->tag){
	    g_free(en->tag);
	    en->tag=NULL;
	}
	treepath = gtk_tree_model_get_path(treemodel, &iter);
	gtk_tree_view_collapse_row(treeview, treepath);
	gtk_tree_path_free(treepath);
	(*xffm_details->arbol->set_icon)(treemodel, &iter);
    }
    print_status(widgets_pW,"xfce/info", _("Trash has been uncollected"), NULL);

}

/* only available in treeview mode: */
G_MODULE_EXPORT
void uncollect_from_trash_callback(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeIter iter, parent;
    record_entry_t *en;
    gint tree_id = (*xffm_details->arbol->get_active_tree_id)();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    en = (*xffm_details->arbol->get_selected_entry)(&iter);
    if(!en)	assert_not_reached();
     
    widgets_pW=&(xffm_details->arbol->widgets);
    
    if ((trashbin=open_trash_dbh(FALSE))!=NULL) 
    {
	GString *gs;
	gs = g_string_new(en->path);
	sprintf((char *)DBH_KEY(trashbin), "%10u", g_string_hash(gs));
	g_string_free(gs, TRUE);
	DBH_erase(trashbin);
	DBH_close(trashbin);
    }
    
    (*xffm_details->arbol->remove_row)(treemodel, &iter,NULL,en);
    
    /* if the removed element was the last, insert a dummy.
     * insert_dummy_row will only insert dummy on leaf nodes */
    (*xffm_details->arbol->get_module_root)(treeview, &parent, &en,en->module);
    (*xffm_details->arbol->insert_dummy_row)(treemodel, &parent,NULL,en,"xfce/info",_("No trash has been collected."));
    SET_ERASED_SPACE(en->type);

}


