
/*  Copyright (C) 2001-2005 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "actions_lib.h"

#include "uri.h"
#include <ctype.h>

#define dontUSE_INTERNAL_UTF8


#define TIMERVAL 250

static int download_timer;
static int download_count;
/*static GList *local_remove_list;*/
static GList *download_list=NULL;

static int SMBResult;
static GtkWidget *countW=NULL,*count_label, *count_progress;

static void
printout_listing(gpointer data,gpointer user_data){
  char *pass=(char *)user_data;
  record_entry_t *en=(record_entry_t *)data;
  
  if (!strrchr(en->path,'/')) assert_not_reached();
  smb_xfdir.gl[smb_count].pathv=g_strdup(strrchr(en->path,'/')+1);

  en->tag=g_strdup(pass);
  smb_xfdir.gl[smb_count].en=en;
  smb_count++;
}

static
void init_smb_list(char *path,gboolean show_hidden){
  char *s,*t;
  samba_server=FALSE;

  TRACE("plugin init_smb_list");
  TRACE("plugin path=%s",path);
  s=g_strdup(path);
  strtok(s+2,"/");
  snprintf(smb_server,_POSIX_PATH_MAX-1, "%s",s);
  smb_server[_POSIX_PATH_MAX-1]=0;
  t=s+strlen(s)+1;
  showing_hidden=show_hidden;
  if (strchr(t,'/')){
	t=strtok(NULL,"/");
	snprintf(smb_dir,_POSIX_PATH_MAX-1,"%s",t+strlen(t)+1);
	smb_dir[_POSIX_PATH_MAX-1]=0;
  } else {
	smb_dir[0]=0;
  }
  snprintf(smb_share,_POSIX_PATH_MAX-1, "%s",t);
  smb_share[_POSIX_PATH_MAX-1]=0;
  g_free(s);s=NULL;
  /*input_over=0;*/
  query_result=SUCCESS; 
  if (listing){
      	g_list_free(listing);
	listing=NULL;
  }
}


static
int SMBListStdout (int n, void *data) {
  char *line;
  static char *textos[SHARE_COLUMNS];
  int i, filenamelen;
  char *pw;
  record_entry_t *en;
  struct tm t;
  mode_t unix_mode=0;
  gboolean netdir=FALSE,nethidden=FALSE,netreadonly=FALSE;
    


  if (n) return TRUE;  /* this would mean binary data */
  line = (char *) data;
  TRACE("SMB (line):%s",line);
    print_diagnostics(smb_widgets_p,NULL,line,NULL);
  
    
  for (i=0;challenges[i]!=NULL;i++){
      if (strstr (line, challenges[i]))  {
        query_result = CHALLENGED;
      }	
  }
  for (i=0;smb_errors[i]!=NULL;i++){
      if (strstr (line, smb_errors[i]))  {
	  print_diagnostics(smb_widgets_p,"xfce/error", strerror(EPERM),NULL);
	  TRACE("SMB (line error):%s",smb_errors[i]);
      }	
  }
  if (strstr (line, "Connection") && strstr (line, "failed"))  {
        query_result = FAILED;	  
	  TRACE("SMB (line error): Connection failed");
  	  return TRUE;
  }
  /*if (input_over){
  	TRACE("SMB   input is over\n");
	return TRUE;
  }*/
  if (strlen (line) <= 2){
	/*input_over=1;*/
	TRACE("SMB   no input in line\n");
  	return TRUE;
  }
  if (line[0] != ' ' || line[0] != ' ') {
	TRACE("SMB   no use for line\n");
	return TRUE;
  }
  if (strstr(line,"Server=") && strstr(line,"Samba")) samba_server=TRUE;
  if (strstr (line, "  .   "))	{
	TRACE("SMB  return on .\n");
      return TRUE;
  }
  if (strstr (line, "  ..   "))	{
	TRACE("SMB  return on ..\n");
      return TRUE;
  }
  if (strlen(line) < 1+25+2+8) {
	TRACE("SMB  return on strlen < 1+25+2+8\n");
      return TRUE;
  }
  if (strncmp (line, "  ", 2) != 0){
	TRACE("SMB  return on (strncmp (line, "  ", 2) != 0\n");
      return TRUE;
  }
  
  /* ok. Now we have a line to process
   * This is a line to watch, if smbclient changes the format
   * for output in file client.c, this must be taken into account */
  /* client.c: "  %-30s%7.7s %8.0f  %s",filename,attr,size,asctime */
  /* asctime=24 */
  /* if (strlen(line) > 24+2+8+1+7) */

  TRACE("SMB (line, again):%s",line);
  pw = line + (strlen (line) - 24 - 2 - 8 - 1);
  /* this is where it should be: */
  filenamelen = strlen (line) - 24 - 2 - 8 - 1 - 7;
  /* long count  */
  TRACE("SMB filenamelen=%d pw=%s",filenamelen,pw);
  while (pw != line && isdigit(*pw)){
      /* extra digit field detected */
      pw--;
      filenamelen++;
      TRACE("SMB (extra digit) filenamelen=%d pw=%s",filenamelen,pw);
  }
  /* but pw might also be short (irix)*/
  while (*pw && !isdigit(*pw) && *pw != ' ') {
      pw++;
      filenamelen++;
      TRACE("SMB (short count) filenamelen=%d pw=%s",filenamelen,pw);
  }

  for (i = 0; i < SHARE_COLUMNS; i++) textos[i] = "";
  textos[SHARE_NAME_COLUMN] = line + 2;

  TRACE("SMB textos[SHARE_NAME_COLUMN]=%s",textos[SHARE_NAME_COLUMN]);
  
  for (i = filenamelen; i <= filenamelen + 7; i++)  {
      TRACE("SMB****line[%d]  %c==DHR (%u==DHR)",i,line[i],(unsigned)line[i]);
    if (line[i] == 'D') netdir=TRUE;
    if (line[i] == 'H') nethidden=TRUE;
    if (line[i] == 'R') netreadonly=TRUE;
  }
  line[filenamelen] = 0;
  
  /* mode for windows files: */
  unix_mode = S_IRUSR;
  /* this is the archive bit (set almost everywhere) */
  unix_mode |= S_IXUSR;
  if (netdir) {
      TRACE("SMB: net directory");
      unix_mode |= S_IFDIR;
  }
  else  {
      TRACE("SMB: regular file");
      unix_mode |= S_IFREG;
  }
  if (nethidden) TRACE("SMB: hidden path attribute");
  if (!netreadonly) {     
      unix_mode |= S_IWUSR;
  } else TRACE("SMB: not readonly");

  if(!showing_hidden && nethidden) {
      TRACE("SMB: return on !showing_hidden && nethidden");
      return TRUE;
  }
  if(samba_server && !showing_hidden && textos[SHARE_NAME_COLUMN][0]=='.'){
      TRACE("SMB: return on samba_server && !showing_hidden && textos[SHARE_NAME_COLUMN][0]=='.'");
      
	  return TRUE;
  }
  
  en=mk_entry(0);
  SET_NETWORK_TYPE(en->type);
  if (samba_server){
      TRACE("SMB:  SET_SAMBA_SERVER(en->subtype)");
      SET_SAMBA_SERVER(en->subtype);
  }
  if (netdir) {
      TRACE("SMB: SET_NETDIR, SET_XF_NODE ");
      SET_NETDIR(en->subtype); 
      SET_XF_NODE(en->type);
  }
  if (!IS_NETDIR(en->subtype)) {
      TRACE("SMB: SET_NETFILE ");
      SET_NETFILE(en->subtype);
  }
  if (nethidden) {
      TRACE("SMB: SET_NETHIDDEN ");
      SET_NETHIDDEN(en->subtype);
  }
  if (netreadonly) {
      TRACE("SMB: SET_NETREADONLY ");
      SET_NETREADONLY(en->subtype);
  }

  TRACE("SMB pw (2) = %s",pw);
  while (*pw && *pw==' ') pw++;
  
  if (strstr (pw, " ")) {
    textos[SHARE_SIZE_COLUMN] = strtok (pw, " ");
    textos[SHARE_DATE_COLUMN] = pw + strlen (pw) + 1;
  }
  TRACE("SMB pw (3) = %s",pw);
  {
    gchar *g,*tt=g_strdup(textos[SHARE_DATE_COLUMN]);
    TRACE("SMB (tt):%s\n",tt);
    g=strtok(tt," "); /* day of week */
    g=strtok(NULL," "); /* month */
    if (strcmp(g,"Jan")==0) t.tm_mon=0;
    else if (strcmp(g,"Feb")==0) t.tm_mon=1;
    else if (strcmp(g,"Mar")==0) t.tm_mon=2;
    else if (strcmp(g,"Apr")==0) t.tm_mon=3;
    else if (strcmp(g,"May")==0) t.tm_mon=4;
    else if (strcmp(g,"Jun")==0) t.tm_mon=5;
    else if (strcmp(g,"Jul")==0) t.tm_mon=6;
    else if (strcmp(g,"Aug")==0) t.tm_mon=7;
    else if (strcmp(g,"Sep")==0) t.tm_mon=8;
    else if (strcmp(g,"Oct")==0) t.tm_mon=9;
    else if (strcmp(g,"Nov")==0) t.tm_mon=10;
    else if (strcmp(g,"Dec")==0) t.tm_mon=11;
    g=strtok(NULL," "); /* day of month */
    t.tm_mday=atoi(g);
    g=strtok(NULL,":"); /* hour */
    t.tm_hour=atoi(g);
    g=strtok(NULL,":"); /* minute */
    t.tm_min=atoi(g);
    g=strtok(NULL," "); /* second */
    t.tm_sec=atoi(g);
    g=strtok(NULL,"\n"); /* year */
    t.tm_year=atoi(g)-1900;
    g_free(tt);tt=NULL;
  }
  
  {
     char *t;
     t=textos[SHARE_NAME_COLUMN];
     while (strlen(t) && (t[strlen(t)-1]==' '||t[strlen(t)-1]=='\t'))
	     t[strlen(t)-1]=0;
  }

#ifdef USE_INTERNAL_UTF8
  /* windows server or output put into ascii-readable.
   * applies to both windows and samba servers with
   * local characters set in non-ascii-readable (ancient
   * pc style codesets)
   **/
  {
      gchar *utf8_server, *utf8_share, *utf8_dir, *utf8_name;
      int utf8_length=0;

      TRACE("SMB: ---> USE_INTERNAL_UTF8---------");
      utf8_server = g_strdup(my_utf_string(smb_server));
      utf8_share = g_strdup(my_utf_string(smb_share));
      utf8_dir = g_strdup(my_utf_string(smb_dir));
      utf8_name = g_strdup(my_utf_string(textos[SHARE_NAME_COLUMN]));
      utf8_length = strlen(utf8_server)+1
		    +strlen(utf8_share)+1
		    +strlen(utf8_dir)+1
		    +strlen(utf8_name)+1;
      en->path=(char *)malloc(utf8_length);
      if (!en->path){
	  g_warning("critical: !malloc(%d)",utf8_length);
	return FALSE;
      }
      if (!strlen(utf8_dir))  sprintf(en->path,"%s/%s/%s",
		  utf8_server,utf8_share,utf8_name);
      else sprintf(en->path,"%s/%s/%s/%s",
		  utf8_server,utf8_share,utf8_dir,utf8_name);
      g_free(utf8_server);
      g_free(utf8_share);
      g_free(utf8_dir);
      g_free(utf8_name);
      
  }

#else
  /* old code: save path in ancient pc codeset */  
      TRACE("SMB: ---> old code !USE_INTERNAL_UTF8---------");
  en->path=(char *)malloc(strlen(smb_server)+1+
		  strlen(smb_share)+1+
		  strlen(smb_dir)+1+
		  strlen(textos[SHARE_NAME_COLUMN])+1);
  
  if (!strlen(smb_dir))  sprintf(en->path,"%s/%s/%s",
		  smb_server,smb_share,textos[SHARE_NAME_COLUMN]);
  else sprintf(en->path,"%s/%s/%s/%s",
		  smb_server,smb_share,smb_dir,textos[SHARE_NAME_COLUMN]);
#endif
  
  
  en->st=(struct stat *)malloc(sizeof(struct stat));
  en->st->st_size=atoi(textos[SHARE_SIZE_COLUMN]);

  en->st->st_mtime=mktime(&t);
  en->st->st_gid = (gid_t)-1;
  en->st->st_uid = (uid_t)-1;
  en->st->st_mode=unix_mode;

  
  TRACE("SMB:adding %s \n",en->path);
  listing = g_list_append (listing,(gpointer)en);
  
  return TRUE;
}

/* this does not work well with parallel smbclient
 *      (not enough time alloted to process gtk events)
 *      */

static int smb_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
	print_diagnostics(smb_widgets_p,NULL, line, NULL);
    return TRUE;
}

static 
int smb_wait(gboolean animate){
  while (smb_object){
     if (smb_widgets_p->progress) set_progress_generic(smb_widgets_p,-1,-1,1);
     while (gtk_events_pending()) gtk_main_iteration();
     usleep(5000);
  }
  if (xffm_details->arbol && xffm_details->arbol->widgets.window) 
    gtk_widget_hide(xffm_details->arbol->widgets.progress);  
  /*else if (private_icon_view_p) 
    gtk_widget_hide(private_icon_view_p->widgets.progress);*/
  return TRUE;
}


static void
SMBFork (void *data)
{
  char *the_command,*the_user,*the_netbios;
  FILE *tmpfile;
  struct stat s;
  gchar *SMBtmpfile=(gchar *)data;

  
  if (stat(SMBtmpfile,&s)<0)  _exit(123); /*forgetit("unable to stat temp file");*/
  if ((the_command = (char *)malloc(s.st_size+1))==NULL) _exit(123); 
  tmpfile=fopen(SMBtmpfile,"rb");
  if (tmpfile) {
   if (fread(the_command,1,s.st_size,tmpfile)<s.st_size) _exit(123);
   fclose(tmpfile);
   unlink(SMBtmpfile);
   the_command[s.st_size]=0;
   the_netbios=strtok(the_command,"\n");
   if (!the_netbios) _exit(123); /* error processing */
   the_user=strtok(NULL,"\n");
   if (!the_user) _exit(123); /* error processing */
   the_command=the_user+strlen(the_user)+1;
   TRACE("smbclient %s -U %s\n",the_netbios,the_user);
   TRACE("%s\n",the_command); fflush(NULL);sleep(1);
     /*read data from tmpfile */  
   execlp ("smbclient", "smbclient", the_netbios,"-U",the_user, "-c", the_command, (char *) 0);
  _exit(123); /* error processing */
  }
}


static int
SMBStdout (int n, void *data)
{
  char *line;
  int i;

  if (n) return TRUE;		/* this would mean binary data */
  line = (char *) data;
  /* this should be nonverbose until there is a progress dialog for
   * uploading and deleted similar to the download dialog.
   * This new dialog may be entirely unnecessary... */
  print_diagnostics(smb_widgets_p,NULL,line,NULL);
  
  for (i=0;smb_errors[i]!=NULL;i++){
      if (strstr (line, smb_errors[i]))  {
	  print_diagnostics(smb_widgets_p,"xfce/error", strerror(EPERM),NULL);
      }	
  }
  return TRUE;
}


static void
SMBForkOver (pid_t pid)
{
  if (countW) {
     gtk_widget_destroy(countW);
     countW=NULL;
  }
  
  switch (SMBResult)
  {
  case CHALLENGED:
    /*printf("dbg:%s\n",_("File download failed."));*/
    print_status(smb_widgets_p,"xfce/error",_("File download failed."),NULL);
    break;
  default:
    /* upload was successful: */
    /*printf("dbg:%s\n",_("Download done."));*/
    /*xfce/dlg_error(SMBparent,"smbclient",_("Download done."));*/
    break;

  }
  smb_object = NULL;
  /* OjO, forcing refresh will cause a reload on doubleclicking
  stuff from the smb_list plugin, which is not good... */
  if (smb_widgets_p->type==TREEVIEW_TYPE) {
      (*xffm_details->arbol->local_monitor)(FALSE);
  }
}


static void cb_count_destroy(GtkWidget *widget,gpointer data){
    GList *tmp;
    for (tmp=download_list; tmp; tmp=tmp->next){
	g_free(tmp->data);
    }
    g_list_free(download_list);
    download_list=NULL;
    countW=NULL;
}

static
gint download_watch(GtkTreeView * treeview){
    gchar *s="-\\|/";
    static int s_pos=0;
    struct stat st;
    long size=0;
    int n=download_count-g_list_length(download_list)+1;
    static gchar *str=NULL;
    static gchar *str_n=NULL;
    gfloat fraction;
    TRACE("at timer");
    if (!download_list) return FALSE;

    if (!g_file_test((gchar *) download_list->data,G_FILE_TEST_IS_DIR) 
	    && stat( (gchar *) download_list->data, &st)==0){
	size=st.st_size;
    }
    g_free(str);
    g_free(str_n);

    if (download_count==0) fraction=1.0; else fraction=(float)n/(float)download_count;
    str_n=g_strdup_printf("%d/%d",n,download_count);
    if (size) str=g_strdup_printf("%s (%ld)",(gchar *) download_list->data,(long)size);
    else {
	str=g_strdup_printf("%s (%c)",(gchar *) download_list->data,s[s_pos++]);
	if (s_pos >= strlen(s)) s_pos=0;
    }
	
    gtk_label_set_text ((GtkLabel *)count_label,(const gchar *)str);
    gtk_progress_bar_set_fraction((GtkProgressBar *) count_progress, fraction);
    gtk_progress_bar_set_text((GtkProgressBar *) count_progress, (const gchar *)str_n);

    TRACE("%s (fraction=%f): %s",str_n,fraction,str);
    /* if next file has appeared, this one is done. 
     * )this will give false readings if the next file happens to be a directory
     * which will be overwritten, this is a not fixable buglet).*/
    if (download_list->next && g_file_test( (gchar *) download_list->next->data, G_FILE_TEST_EXISTS)){
	gconstpointer g = download_list->data;
	download_list=g_list_remove(download_list,g);
    }	
    return TRUE;
}


static void download_window(GtkWidget *parent,char *host){
  gchar *g=g_strdup_printf(_("Downloading files from %s"),host);	
  countW=gtk_dialog_new ();
  
  place_dialog(parent, countW);
  gtk_window_set_modal (GTK_WINDOW (countW), TRUE);
  count_label = gtk_label_new (g);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->vbox), count_label, TRUE, TRUE, 3);
  g_free(g);
  count_label = gtk_label_new (".............................................................");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->vbox), count_label, TRUE, TRUE, 3);
//  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->action_area), count_label, TRUE, TRUE, 3);
  count_progress=gtk_progress_bar_new ();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (countW)->action_area), count_progress, TRUE, TRUE, 3);
  

  gtk_widget_realize (countW);
  if (parent) gtk_window_set_transient_for (GTK_WINDOW (countW), GTK_WINDOW (parent)); 
  g_signal_connect (G_OBJECT (countW), "destroy", GTK_SIGNAL_FUNC (cb_count_destroy), NULL);
  gtk_widget_show_all(countW);
  gdk_flush();
  download_timer = g_timeout_add_full(0, TIMERVAL, 
			(GtkFunction) download_watch, NULL, NULL);
  return ;
}


/*****************************  upload section  *******************************/

static void
SMBDropForkOver (pid_t pid)
{

  while (gtk_events_pending()) gtk_main_iteration();
  gdk_flush();
  switch (SMBResult)
  {
  case CHALLENGED:
    print_status(smb_widgets_p,"xfce/error", strerror(EPERM), NULL);
    break;
  default:
    /* upload was successful: */
    print_status(smb_widgets_p,"xfce/info",_("Command done"),NULL);
    break;

  }
  smb_object = NULL;
}

static void forgetit(char *why,char *who){
          fprintf (stderr, "xfsamba: %s %s\n",(why)?why:" ",(who)?who:" ");
	  fflush(NULL);
	  usleep(50000);
          _exit(123);
}

/* function executed after all pipes
*  timeouts and inputs have been set up */
static void
SMBDropFork (void *data)
{
  FILE *file;
  char **argv=(char **)data;
 
  char line[256];
  struct stat s;
  gchar *tmpfile;
  
  tmpfile=g_strdup(argv[5]);
  /*argv[5]=tmpfile;*/

  if (stat(tmpfile,&s)<0)   
	  forgetit("unable to stat temp file",tmpfile);
  if ((argv[5] = (char *)malloc(s.st_size+1))==NULL) 
	  forgetit("unable allocate memory for",tmpfile);
  if ((file=fopen(tmpfile,"r"))==NULL) 
	  forgetit("unable to open",tmpfile);
  strcpy(argv[5],"");
  while (!feof(file) && fgets(line,255,file)){
	  char *w;
	  line[255]=0;
	  if (!strstr(line,"\n")) continue;
	  w=strtok(line,"\n");
          /*fprintf (stderr, "TRACE:child->%s\n", w);fflush(NULL);*/
	  strcat(argv[5],w);	  
  }
 
   TRACE("%s %s %s %s %s %s\n",argv[0],argv[1],argv[2],argv[3],argv[4],argv[5]); fflush(NULL);sleep(1);
  execvp (argv[0],argv);
}



/************  rm stuff **********************/


static int
SMBrmStdout (int n, void *data)
{
  char *line;
  int i;

  if (n)
    return TRUE;		/* this would mean binary data */
  line = (char *) data;
  /* this should be nonverbose until there is a progress dialog for
   * uploading and deleted similar to the download dialog.
   * This new dialog may be entirely unnecessary... */
  print_diagnostics(smb_widgets_p,NULL,line,NULL);
  for (i=0;smb_errors[i]!=NULL;i++){
      if (strstr (line, smb_errors[i]))  {
	    query_result=FAILED;
	    /* tag result as non success to force refresh on fork over */
      }	
  }

  return TRUE;
}





