/*   
  *   *  
 *  Copyright (C) 2001-2005 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
static GList *mastersIP=NULL;
static void *resolve_object=NULL;
static gboolean lookup_done;
static xfdir_t smb_xfdir;


/***************  master resolve segment  *************************/
static int   master_count;
static int   master_status;
static char *master_name=NULL;
static char *master_netbios=NULL;
static char *master_group=NULL;
static char *master_IP;
static widgets_t *widgets_pW=NULL;


#define RESOLVED 	0x01
#define RESOLVING	0x02
#define NOT_RESOLVED	0x04
#define FAILED		0x08
/*static icon_view_t *smb_icon_view_p=NULL;*/

static void set_private_variables(widgets_t *widgets_p){
    widgets_pW=widgets_p;
}

static
int 
smb_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics(widgets_pW,"xfce/error", line, NULL);
    return TRUE;
}


static void 
NMBmastersResolveOver (pid_t pid){
  smb_xfdir.gl[master_count].en=mk_entry(0);
  SET_NETWORK_TYPE(smb_xfdir.gl[master_count].en->type);
  SET_XF_NETWG(smb_xfdir.gl[master_count].en->subtype);
//  smb_xfdir.gl[master_count].en=mk_entry(net_root_type);
  switch (master_status){
	case RESOLVED:
	{
	    gchar *g=g_strdup_printf(_("Resolved %s"),master_name);
    	    print_status(widgets_pW,"xfce/info", g, NULL);
	    g_free(g);
 	     smb_xfdir.gl[master_count].pathv=g_strdup(master_group);
	     smb_xfdir.gl[master_count].en->path=
		     (char *)malloc(strlen(master_netbios)+3);
	     sprintf(smb_xfdir.gl[master_count].en->path,"//%s",master_netbios);
   		break;	
	}
	case NOT_RESOLVED:
	{
	    gchar *g=g_strdup_printf(_("Not resolved %s"),master_IP);
		
 	     smb_xfdir.gl[master_count].pathv=g_strdup(master_IP);
	     smb_xfdir.gl[master_count].en->path=
		     (char *)malloc(strlen(master_IP)+3);
	     sprintf(smb_xfdir.gl[master_count].en->path,"//%s",master_IP);
 
	     print_status(widgets_pW,"xfce/info", g, NULL);
	    g_free(g);
		break;
	}
  }
  smb_xfdir.gl[master_count].en->st=(struct stat *)malloc(sizeof(struct stat));
  smb_xfdir.gl[master_count].en->st->st_size=0;
  smb_xfdir.gl[master_count].en->st->st_mtime=time(NULL);
  smb_xfdir.gl[master_count].en->st->st_ctime=time(NULL);
  smb_xfdir.gl[master_count].en->st->st_gid=(gid_t)-1;
  smb_xfdir.gl[master_count].en->st->st_uid=(uid_t)-1;
  smb_xfdir.gl[master_count].en->st->st_mode=S_IFDIR;
  SET_XF_NETWG(smb_xfdir.gl[master_count].en->subtype);
  SET_XF_NODE(smb_xfdir.gl[master_count].en->type);
  resolve_object=NULL;
}

static int 
NMBparseMastersResolve (int n, void *data){
  char *line;
  if (n)  return TRUE;		/* this would mean binary data */
  line = (char *) data;
  print_diagnostics(widgets_pW,NULL,line,NULL);

  /* apparently <00> is used by more stuff than netbios
   * name, such as a netbios services like databases
   * or whatever. We now switch to <20> to determine
   * netbios name.*/
  if (strstr (line, "<00>")) {
	 if (strstr (line, "<GROUP>")){ /* workgroup name */
 	     strtok (line, " ");
	     g_free(master_group);
	     master_group=g_strdup(line + 1);
	 } 
  }
  if (strstr (line, "<20>")) {
	 /* server name */
 	     strtok (line, " ");
	     g_free(master_netbios);
	     master_netbios=NULL;
	     g_free(master_name);
	     master_name=NULL;
	     if (strncmp(line+1,"IS~",strlen("IS~"))==0) {
	       master_netbios=g_strdup(line + 1+strlen("IS~"));
	       master_name=g_strdup(line + 1+strlen("IS~"));
	     } else {
	       master_netbios=g_strdup(line + 1);
	       master_name=g_strdup(line + 1);
	     }
  	     master_status=RESOLVED;	     
  }
  return TRUE;
}


static gboolean 
NMBmastersResolve (char *IP){
  char *argument[5];
  gchar *g;
  if (!IP) return FALSE;
  master_status=NOT_RESOLVED;
  argument[0]=  "nmblookup";
  argument[1]=  "-A";
  argument[2]= master_IP = IP;
  argument[3]=  0;
  print_diagnostics(widgets_pW,NULL, "XFSAMBA> ","nmblookup -A ", IP,"\n", NULL);
  g=g_strdup_printf(_("Resolving %s"), IP);
  print_status(widgets_pW,"xfce/info", g,NULL);
  
  resolve_object=Tubo (fork_function, 
	(void *)argument, 
	NMBmastersResolveOver, 
	NULL, 
	NMBparseMastersResolve, 
	smb_stderr,0,FALSE);
  
  
  return FALSE;
}


/***************  master lookup segment  *************************/

/* Look up the subnet master browsers, it fails for win95 master
 * browsers, but that's ok. */


static void
printout_masterIP(gpointer data,gpointer user_data){
      print_status(widgets_pW,"xfce/info",_("Master browser found"),NULL);
      if (data) NMBmastersResolve ((char *)data);
      while (resolve_object) {
	      usleep(5000);
	      set_progress_generic(widgets_pW,-1,-1,1);
	      while (gtk_events_pending()) gtk_main_iteration();
      }
      master_count++;
}

static void
NMBmastersForkOver (pid_t pid)
{
  
  if (mastersIP){
       smb_xfdir.pathc = g_list_length(mastersIP);
       smb_xfdir.gl = (dir_t *) malloc(smb_xfdir.pathc * sizeof(dir_t));
	master_count=0;
       g_list_foreach(mastersIP,printout_masterIP,NULL);
       lookup_done=TRUE;
  } else {
    print_status(widgets_pW,"xfce/error", _("No master browser found."),NULL);
    lookup_done=TRUE;
  }
  
  return;
}

static int
NMBmastersParseLookup (int n, void *data)
{
  char *line, *buffer;
  if (n)  return TRUE;		/* this would mean binary data */
  line = (char *) data;
  print_diagnostics(widgets_pW,NULL,line,NULL); /* verbose diagnostics */
  if (!strncmp (line, "querying", strlen ("querying")))
	  return TRUE;
  if (strstr (line, "name_query") 
		  && strstr (line, "failed") 
		  && strstr (line, "__MSBROWSE__")){
          return TRUE;
  }
  if (strstr (line, "__MSBROWSE__") && strstr (line, "<01>")) {
    GList *tmp;
    buffer = strtok (line, " ");
    if (!buffer) return TRUE;
    for (tmp=mastersIP;tmp;tmp=tmp->next){
	gchar *g=tmp->data;
	if (strcmp(g,buffer)==0) return TRUE;
    }
    
    mastersIP = g_list_append (mastersIP,(gpointer)(g_strdup(buffer)));
  }
  return TRUE;
}

static
void 
free_data(gpointer data,gpointer user_data){
	g_free((char *)(data));
	data=NULL;
}


static
xfdir_t *
private_get_xfdir(record_entry_t *en){
  char *argument[5];
  

  argument[0]=  "nmblookup";
  argument[1]=  "-M";
  argument[2]=  "--";
  argument[3]=  "-";
  argument[4]=  0;
  if (mastersIP){
	g_list_foreach(mastersIP,free_data,NULL);
      	g_list_free(mastersIP);
	mastersIP=NULL;
  }
  print_diagnostics(widgets_pW,NULL, _("Looking for master browsers...\n"), NULL);  
  print_diagnostics(widgets_pW,NULL,NULL,"XFSAMBA> ","nmblookup -M -- -\n",NULL);
  lookup_done=FALSE;
  
  
  Tubo (fork_function, 
	(void *)argument,
	NMBmastersForkOver, 
	NULL, 
	NMBmastersParseLookup, 
	smb_stderr,0,FALSE);
  

  while (!lookup_done){
	usleep(5000);
	 set_progress_generic(widgets_pW,-1,-1,1);
	while (gtk_events_pending()) gtk_main_iteration();
  }
    
    return &smb_xfdir;
}


