/*
 * Copyright (C) 2002-2005 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include <dirent.h>
#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <regex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <glob.h>
#include <dbh.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "secondary.h"

#include "bookshelf.i"

/****************   void  functions  ***********************/

/**** logical void functions... */

G_MODULE_EXPORT
void *
module_init(void)
{
    return NULL;
}

G_MODULE_EXPORT
void *
is_root_module(void)
{
    return GINT_TO_POINTER(1);
}

/**** gchar_p void functions... */

G_MODULE_EXPORT
void *
exec_name(void)
{
    return "xfbook";
}
G_MODULE_EXPORT
void *
module_name(void)
{
    return (void *)"xffm_bookshelf";
}

G_MODULE_EXPORT
void *
submodule_name(void)
{
    return (void *)"xffm_book";
}



/*******************  natural functions **********************/

G_MODULE_EXPORT
void *
get_dnd_path(void *p)
{
    static gchar *desktop=NULL;
    if (!desktop) {
	desktop=g_strdup_printf("%s%c%s%c%s",
		PACKAGE_DATA_DIR,G_DIR_SEPARATOR,
		"applications",G_DIR_SEPARATOR,
		"Xfbook.desktop");
    }
    return (void *)desktop;
}

G_MODULE_EXPORT
void *
module_icon_id(void * p){
    return "bookshelf.png";
}

G_MODULE_EXPORT
void *
module_label(void * p){
    return _("Book");
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
valid_drop_site(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (!en) return NULL;
    if(IS_DIR(en->type)) return (void *)((long)1);
    if(IS_BOOKMARK_TYPE(en->type)&& IS_ROOT_TYPE(en->type)) 
     return (void *)((long)1);
    if(IS_NETDIR(en->subtype)) return (void *)((long)1);
    if(IS_XF_NETSHARE(en->subtype)) return (void *)((long)1);
    
    return NULL;
}

G_MODULE_EXPORT
void *
entry_tip(void *p)
{
    const gchar *tip;
    record_entry_t *en=p;
    if (!en || !en->path || !strlen(en->path)) return NULL;
    if (*(en->path)=='/'){
	if (!g_file_test(en->path, G_FILE_TEST_EXISTS))
	    tip=en->path;
	else tip=path_info(en);
	return (void *)tip;
    } else {
	record_entry_t *new_en;
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	gchar *dir = g_build_filename(xdg_dir,BOOKMARK_DIR,NULL);	
	gchar *file = g_build_filename(dir,en->path,NULL);
	gchar *full_file=g_strdup_printf("%s.bm.dbh",file);
	new_en=stat_entry(full_file,0);
	g_free(xdg_dir);
	g_free(file);
	g_free(full_file);
	g_free(dir);
	tip=path_info(new_en);
	destroy_entry(new_en);
	return (void *)tip;
    }
}

G_MODULE_EXPORT
void *
plugin_info(void){
    return _("The BOOKMARKS plugin allows you to bookmark files and create virtual folder without moving anything from the original location on the filesystem. The plugin also organizes bookmark files in a bookshelf.");

}



/*******************  rational functions **********************/

G_MODULE_EXPORT
void *
get_xfdir(void *p ,void *q){
    
    return private_get_xfdir((record_entry_t *)p);
}

G_MODULE_EXPORT
void *
private_popup(void *p, void *q){

    return GINT_TO_POINTER(1);
}

	
