static widgets_t *easy_widgets_p;
static gchar *script_types[]={
    "application/x-csh",
    "application/x-bsh",
    "application/x-ksh",
    "application/x-shellscript",
    "application/x-tsh",
    "application/x-zsh",
    "application/x-perl",
    NULL
};

static 
gboolean 
is_a_script(const gchar *path)
{ 
  const gchar *t=MIME_get_type((const gchar *)path, TRUE);
  if (t) {
      int i;
      for (i=0;script_types[i];i++) if (strncmp(script_types[i],t,strlen(script_types[i]))==0){
	  return TRUE;
      }
  }
  return FALSE;
}
static 
void 
save_to_open_history(		gchar *path2save, 
				gchar *in_cmd, 
				int in_term)
{
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
    gchar *dbh_file=g_build_filename(xdg_dir,OPEN_FILE,NULL);
    GString *gs;
    DBHashTable *d;
    gchar *data;
    int length;
    gchar *basename;

    g_free(xdg_dir);
    if (!path2save) return;
    basename=g_path_get_basename(path2save);
    if ((d=DBH_open(dbh_file))==NULL){
    	if ((d=DBH_create(dbh_file, 11))==NULL) {
		unlink(dbh_file);
		if ((d=DBH_create(dbh_file, 11))==NULL)	return;
	}
    }
    gs = g_string_new(basename);
    g_free(basename);
    sprintf((char *)DBH_KEY(d), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    data = (gchar *)DBH_DATA(d);
    if (in_term) *data = 1;
    else *data=0;
    data++;
    
    length=strlen(in_cmd)+2;
    if (length > DBH_MAXIMUM_RECORD_SIZE(d))length = DBH_MAXIMUM_RECORD_SIZE(d);
    
    strncpy(data,in_cmd, length-2);
    DBH_set_recordsize (d,length);
    
    DBH_update(d);
    DBH_close(d);
    g_free(dbh_file);
}

static
const
gchar *
strip_quotes(const gchar *s){
    static gchar *c=NULL;
    g_free(c);
    if (*s=='\"') c=g_strdup(s+1);
    else c=g_strdup(s);
    if (strchr(c,'\"')) *strchr(c,'\"')=0;
    return (const gchar *) c;
}

static int childFD;

static int 
easy_stderr(int n, void *data)
{
    char *line;
    if(n) return TRUE;		/* this would mean binary data */
    line = (char *)data;
    /*printf("stderr:%s",line);*/
    if (strncmp(line,"Password:",strlen("Password:"))==0){
	const char *p;
    	print_diagnostics(easy_widgets_p, "xfce/warning",_("Sudo password requested"),"\n", NULL);
	p=xffm_get_password(easy_widgets_p,_("Sudo password requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));
	return TRUE;
    }
    if (line[0] != '\n') print_diagnostics(easy_widgets_p, "xfce/error", line, NULL);
    return TRUE;
}

static int 
easy_stdout(int n, void *data)
{
    char *line;
    if(n) return TRUE;		/* this would mean binary data */
    line = (char *)data;
    /*printf("stdout:%s",line);*/
    print_diagnostics(easy_widgets_p,"nonverbose", line, NULL);
    return TRUE;
}

static void 
easy_finished_function(pid_t pid)
{
    TRACE("TRACE:easy over by fork_finished_function\n");
}


