/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include <dirent.h>
#include <errno.h>
#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"


enum
{
    WASTE,
    UNLINK,
};
#define is_digit(x) ((x)>='0' && (x)<='9')

#include "remove.i"

G_MODULE_EXPORT
gboolean xffm_unlink(widgets_t *widgets_p, const gchar *path)
{
    struct stat st;

    WIDGET_P_CHECK;
    process_pending_gtk();
    if(widgets_p->stop)
    {
	widgets_p->stop = FALSE;
	cancel_remove = TRUE;
	hide_stop(widgets_p);
	return FALSE;
    }
    if(cancel_remove) return FALSE;
    if(lstat(path, &st) < 0)
    {
	print_status(widgets_p,"xfce/error", strerror(errno), NULL);
	print_diagnostics(widgets_p,"xfce/error", strerror(errno),":",path, "\n", NULL);
	return FALSE;
    }
    if(!S_ISDIR(st.st_mode))
    {
	if(unlink(path) < 0)
	{
	    print_status(widgets_p,"xfce/error", strerror(errno), NULL);
	    print_diagnostics(widgets_p,"xfce/error", strerror(errno),":",path, "\n", NULL);
	    return FALSE;
	}
#if 0
	/* this sloooows things down */
	if(path && strlen(path) >= 2)
	    print_status(widgets_p,"xfce/warning", _("Deleted"), " ", __VY_FN__(path), NULL);
#endif
	return TRUE;
    }
    else
    {
	gchar *fullpath;
	DIR *directory;
	struct dirent *dir;
	directory = opendir(path);
	if(!directory)
	{
	    return FALSE;
	}
	while((dir = readdir(directory)) != NULL && !cancel_remove)
	{
	    if(strcmp(dir->d_name, ".") == 0 || strcmp(dir->d_name, "..") == 0)
		continue;

	    fullpath=g_strconcat(path,"/",dir->d_name,NULL);

	    if(!xffm_unlink(widgets_p, fullpath))
	    {
		g_free(fullpath);
		return FALSE;
	    }
	    g_free(fullpath);
	}
	closedir(directory);
	if(cancel_remove) return FALSE;
	if(rmdir(path) < 0)
	{
	    print_status(widgets_p,"xfce/error", strerror(errno), NULL);
	    print_diagnostics(widgets_p,"xfce/error", strerror(errno),":",path, "\n", NULL);
	    return FALSE;
	}
    }
    return TRUE;
}

G_MODULE_EXPORT
gboolean xffm_waste(widgets_t *widgets_p, const gchar *path)
{
    gchar *directory;
    gchar *wastepath=NULL;
    gchar *wastename=NULL;

    WIDGET_P_CHECK;

    
    if(!g_file_test(path,G_FILE_TEST_EXISTS)) {
	print_status(widgets_p,"xfce/error",strerror(ENOENT),NULL);	
	print_diagnostics(widgets_p,"xfce/error",strerror(ENOENT)," :\n",path, "\n", NULL);
	return FALSE;
    }
    if(strlen(path) == 1) return FALSE;
    directory = g_path_get_dirname(path);
    wastepath=g_strconcat(directory,"/..Wastebasket",NULL);
    g_free(directory);directory=NULL;
    /*printf("TRACE:wastepath=%s\n",wastepath); */
    if(access(wastepath, F_OK) != 0)
    {
	if(mkdir(wastepath, 0xFFFF) < 0){
	    print_status(widgets_p,"xfce/error",strerror(errno), NULL);
	    print_diagnostics(widgets_p,"xfce/error",strerror(errno)," :\n",wastepath, "\n", NULL);
	    g_free(wastepath);wastepath=NULL;
	    return FALSE;
	}

    }
    wastename=g_strconcat( wastepath,"/",strrchr(path, '/') + 1,NULL);
    /*printf("TRACE:wastename=%s path=%s\n",wastename,path); */
    if(access(wastename, F_OK) == 0)
    {
	/* too harsh: if (!unlinkit(wastename)) return FALSE; */
	gchar *wastebackup=NULL;
	wastebackup=g_strconcat(wastepath,"/",
			xffm_new_name(wastepath, strrchr(wastename, '/') + 1),
			NULL);
	/*printf("TRACE:wastebackup=%s\n",wastebackup); */
	if(rename(wastename, wastebackup) < 0){
	    print_status(widgets_p,"xfce/error", strerror(errno), NULL);
	    print_diagnostics(widgets_p,"xfce/error", strerror(errno)," :\n", wastename, " --> ", wastebackup,"\n", NULL);
	    g_free(wastebackup); 
	    g_free(wastename);
	    g_free(wastepath);
	    return FALSE;
	}
	if(rename(path, wastename) < 0){
	    print_status(widgets_p,"xfce/error", strerror(errno), NULL);
	    print_diagnostics(widgets_p,"xfce/error", strerror(errno)," :\n", path, " --> ", wastename,"\n", NULL);
	    g_free(wastebackup); 
	    g_free(wastename);
	    g_free(wastepath);
	    return FALSE;
	}
	TRASH_add2trash(widgets_p,wastebackup);
    }
    else
    {
	if(rename(path, wastename) < 0){
	    print_status(widgets_p,"xfce/error", strerror(errno), NULL);
	    print_diagnostics(widgets_p,"xfce/error", strerror(errno)," :\n", path, " --> ",wastename,"\n", NULL);
	    g_free(wastename);
	    g_free(wastepath);
	    return FALSE;
	}
	TRASH_add2trash(widgets_p,wastename);
    }
    g_free(wastename);
    g_free(wastepath);
    return TRUE;
}

G_MODULE_EXPORT
int xffm_query_rm(widgets_t *widgets_p, const gchar *nfile, const gchar *ofile,gboolean overwrite){	 
	gboolean err=FALSE;

	WIDGET_P_CHECK;

    	dlg_result = DLG_NO;
try_again:
 	make_single_rm_dialog( widgets_p,nfile, ofile, err);
	if(dlg_result == DLG_YES)
	{
	    if(waste){
		if(!xffm_waste(widgets_p, nfile)) {
		        err=TRUE;
			goto try_again;
		}
	    } else if (!overwrite){
		if (unlink(nfile)<0) {
		        err=TRUE;
			goto try_again;
		}
	    }
	    return TRUE;
	}
	return FALSE;
}

G_MODULE_EXPORT 
void xffm_remove(widgets_t *widgets_p, GList *selection_list)
{

    GList *tmp;
    WIDGET_P_CHECK;

    if (!selection_list){
	    g_warning("NULL selection list for remove");
	    return;
    }
    
    g_free(remote_module); remote_module=NULL;
    
    all = FALSE;
    unlink_mode = FALSE;
    invalid_input = FALSE;
    
    if (remove_list) {
	g_list_free(remove_list);
	remove_list=NULL;
    }
    for (tmp=selection_list; tmp; tmp=tmp->next){
        if (!subcheck_select((record_entry_t *)tmp->data)) continue;
	remove_list=g_list_append(remove_list,tmp->data);
    }
    if(!g_list_length(remove_list) || invalid_input)
    {
	print_status(widgets_p,"xfce/warning,",strerror(EINVAL),NULL);
	return;
    }
    make_dialog(widgets_p, TRUE);
    if (remove_list) {
	g_list_free(remove_list);
	remove_list=NULL;
    }
}



