#ifndef XFFM_PRIMARY_H
#define XFFM_PRIMARY_H
#include <regex.h>
#include "glade_support.h"
#include "primary-modules.h"
#include "primary-icons.h"
#include "primary-misc.h"
#include "ls.h"
#include "uri.h"
gchar ** 
text_type_OK(			const gchar *path);

/* hide/show stuff */
#define showit(x,y) gtk_widget_show_all(lookup_widget(x,y))
#define hideit(x,y) gtk_widget_hide_all(lookup_widget(x,y))

#ifdef XFFM_PRIMARY_C
G_MODULE_EXPORT
xffm_details_t *xffm_details=NULL;
/* the size of env_string must coincide with that of env_vars! */
G_MODULE_EXPORT
gchar *env_string[21]={
	NULL,NULL,NULL,NULL,NULL,
	NULL,NULL,NULL,NULL,NULL,
	NULL,NULL,NULL,NULL,NULL,
	NULL,NULL,NULL,NULL,NULL,
	NULL
};
G_MODULE_EXPORT
char *env_vars[21]={
    /* set by mcs manager buttons*/
	"XFFM_DEFAULT_UNLINK",		/* 1 */
	"XFFM_HOLD_XTERM",		/* 2 */
	"XFFM_USE_SUDO",		/* 3 */
    /* mcs manager listing */
	"TERMCMD",			/* 4 */
	"DESKTOP_COLOR",		/* 5 */
	"DESKTOP_BACKGROUND_IMAGE",	/* 6 */
	"USE_DESKTOP_MENU",		/* 7 */
	"USE_DESKTOP_MENU_ICONS",	/* 8 */
	"DISABLE_DESKTOP",		/* 9 */
	"SMB_USER",			/* 10*/
	"XFFM_SINGLE_CLICK_NAVIGATION",	/* 11*/
	"XFFM_DRAG_DOES_COPY",		/* 12*/
	"XFFM_FORCE_DIAGNOSTICS",	/* 13*/
	"XFFM_DISABLE_DIAGNOSTICS",	/* 14*/
	"XFFM_DISABLE_MONITOR",		/* 15*/
	"XFFM_DISABLE_TEXTCOLORS",	/* 16*/
	"XFFM_DISABLE_CELL_EDIT",	/* 17*/
	"XFFM_DISABLE_TIPS",		/* 18*/
	"XFFM_MAX_PREVIEW_SIZE",	/* 19*/
    /* internally used envar */
	"PWD",				/* 20*/
	NULL				/* 21*/
};

#else
extern xffm_details_t *xffm_details;
extern gchar *env_string[];
extern char *env_vars[];
#endif
void set_ascending(int asc);
void set_sort_column(int column);

void 	
init_xffm_env(		void);

void 
xffm_setenv(		const char *name,
			char *value,
			gboolean verbose);

/* entries */
gint 
entry_compare(		int caso,
			record_entry_t *en_a,
			record_entry_t *en_b);

record_entry_t *
copy_entry(record_entry_t *src_en);

void 
destroy_entry(		record_entry_t * en);

record_entry_t *
mk_entry(		int type);

record_entry_t *
mk_entry_path(		const gchar *path, 
			int type);

record_entry_t *
stat_entry(		const gchar *path, 
			int type);

record_entry_t *
mk_net_entry(		const gchar *path,
			unsigned type);

void 
set_entry_tag(			record_entry_t * en, 
				off_t tama);

/* gui */

void 
set_processing_pending(		void);

void 
unset_processing_pending(	void);

gboolean 
processing_pending(		void);

void 
process_pending_gtk();

void 
cursor_wait(	GtkWidget *w);

void 
cursor_reset(	GtkWidget *w);

/* local files */
gint 
count_files(			gchar *path);

gboolean 
get_xfdir_local(	xfdir_t *xfdir_p,
			record_entry_t *en,
			const gchar *filter);

void rm_cache_local(	const gchar *directory);

void 
xfdirfree(		xfdir_t * xfdir);

int
xfdir_compare(		const void *a, 
			const void *b);

regex_t *
get_regex_filter(record_entry_t * en);

const regex_t *
compile_regex_filter(		const gchar *filter,
				gboolean shows_hidden);

gint 
all_files_count(		void);

const gchar *
get_local_cache_path(gchar *directory);

#ifdef DEBUG
const gchar *
profile(void);
#endif

#endif
