/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * Olivier Fourdan (fourdan@xfce.org)
*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <pwd.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include <gmodule.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"
#include "actions_lib.h"

enum
{
    DND_NONE,
    DND_MOVE,
    DND_COPY,
    DND_LINK
};

#define MAXURILEN 4096		/* Longest URI to allow */

#define DRAG_TYPE_UNDEFINED	0
#define DRAG_TYPE_LOCAL		0x01
#define DRAG_TYPE_NET		0x02
#define DRAG_TYPE_INCONSISTENT	0x04



G_MODULE_EXPORT
gboolean dragging = FALSE;


/*static GList *selection_list = NULL;*/
static char *dnd_data = NULL;
static int the_mode;


/*************   core *****************/
#if 0
void on_drag_data_delete(GtkWidget * widget, GdkDragContext * context, gpointer data)
{
    printf("TRACE: on_drag_data_delete!\n\n");


    return;
}
#endif

G_MODULE_EXPORT
void core_drag_end (GtkWidget * widget, GdkDragContext * context, gpointer data)
{
    TRACE("TRACE drag end\n");
    dragging = FALSE;
    /* check if this is in treeviewlib, then delete:
     * if (scrolltimer)g_source_remove(scrolltimer);
    scrolltimer=0,scrollx=-1, scrolly=-1;*/
    if(!widget)	return;

    if(dnd_data)
    {
	g_free(dnd_data);
	dnd_data = NULL;
    }
    TRACE("TRACE drag end done\n");
    return;
}

/*
 * DND sender: prepare data for the remote
 * event: drag_data_get
 */
G_MODULE_EXPORT
void core_drag_data_get (widgets_t *widgets_p, GList *drag_entry_list, GdkDragContext * context, GtkSelectionData * selection_data, guint info, guint time)
{
    char *files;
    GList *tmp;
    record_entry_t *en;
    int selection_len;
    int drag_type;
    gchar *format=NULL;
    const gchar *me,*she;
    
    if(!drag_entry_list || !g_list_length(drag_entry_list) || !drag_entry_list->data)	{
	TRACE("!SELECTION_LIST");
	return;
    }
    en=(record_entry_t *)drag_entry_list->data;
    
    me = OUR_HOST_NAME(widgets_p);
    she = host_name(GDK_WINDOW_XID(context->dest_window));
    TRACE("on_drag_data_get, me=%s --> she=%s",me,she);
    
    if (en->module){
	const gchar *fmt=function_natural("plugins",en->module,en,"get_dnd_format");
	if (fmt) format=g_strdup(fmt);
	TRACE("module format=%s",(format?format:"null"));
    } else TRACE("not module format");
    if (!format) {
	drag_type=DRAG_TYPE_LOCAL;
 	if (strcmp(me,she)){
	    struct passwd *pw=getpwuid(getuid());
	    if (pw) {
		format = g_strdup_printf("file://%s@%s",pw->pw_name,me);
	    } else {
		format = g_strdup_printf("file://%s",me);
	    }
	} else format = g_strdup("file:");
    }
    
    TRACE("on_drag_data_get, format=%s",(format?format:"null"));

    /* prepare data for the receiver */
    switch (info)
    {
	case	TARGET_RAW:
	    g_warning("TARGET_RAW");
	case	TARGET_UTF8:
	    g_warning("TARGET_UTF8");
	case	TARGET_URI_LIST:
	    TRACE("TARGET_URI_LIST");	 
	default:
	 selection_len = 0;
	 if(dnd_data){
		 g_free(dnd_data);
		 dnd_data=NULL;
	 }
	 /* count length of bytes to be allocated */
	 for (tmp = drag_entry_list;tmp;tmp = tmp->next) {
	    const gchar *dndpath;
	    en=(record_entry_t *)tmp->data;
	    if (!en || !en->path || !strlen(en->path)) continue;
	    if (en->module) {
		dndpath=function_natural("plugins",en->module,en,"get_dnd_path");
		if (!dndpath) continue;
	    } else {
		dndpath = en->path;
	    }
	    /* 2 is added for the \r\n */
	    selection_len += (strlen(dndpath) + strlen(format) + 2);
	 }
	 /* 1 is added for terminating null character */
	 dnd_data = files = g_malloc(selection_len + 1);
	 memset(files,0,selection_len + 1);
	 for (tmp = drag_entry_list;tmp;tmp = tmp->next) {
	    const gchar *dndpath;
	    en=(record_entry_t *)tmp->data;
	    if (!en || !en->path || !strlen(en->path)) continue;
	    if (en->module) {
		dndpath=function_natural("plugins",en->module,en,"get_dnd_path");
		if (!dndpath) continue;
	    } else {
		dndpath = en->path;
	    }
	    sprintf(files, "%s%s\r\n", format, dndpath);
	    files += (strlen(format) + strlen(dndpath) + 2);
	 }	    
	 break;
    }
    TRACE ("drag data is:%s",dnd_data);

    gtk_selection_data_set(selection_data, selection_data->target, 
		    8, (const guchar *)dnd_data, selection_len); 
    dragging=FALSE;
    xffm_details->comm |= COMM_IGNORE_RELEASE;
    TRACE("TRACE drag get done, format=%s\n",format);    
    TRACE("dnd ignore second releas=%d... \n",xffm_details->comm & COMM_IGNORE_RELEASE); 
    g_free(format);
}


G_MODULE_EXPORT
gboolean core_drag_data (widgets_t *widgets_p, record_entry_t *target_en,  GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time)
{
    int nitems, action;
    gchar *url;
    int mode = 0;
    GList *tmp, *list = NULL;
    gchar *tmpfile = NULL;
    gboolean result=FALSE;
    const gchar *he,*me;



    if(!target_en || data->length < 0 || data->format != 8)
    {
	TRACE("!target_en || data->length < 0 || data->format != 8"); 
	goto drag_over;		/* of course */
    }

    me = OUR_HOST_NAME(widgets_p);
    he = host_name(GDK_WINDOW_XID(context->source_window)); 

    TRACE("on drag data; he = %s --> me = %s ",me,he);

    /* remote instance may have full format specification,
     * or borked specification. Here we must consider
     * both cases */
    
    if (context->action <= GDK_ACTION_DEFAULT)
    {
	if (getenv("XFFM_DRAG_DOES_COPY") && strlen(getenv("XFFM_DRAG_DOES_COPY")))
	{
	    action = GDK_ACTION_COPY;
	} else {
	    action = GDK_ACTION_MOVE;
	}
    } else action = context->action;

      
    TRACE("info=%d (%d,%d)",info,TARGET_STRING, TARGET_URI_LIST);
    if(!(info == TARGET_STRING) && !(info == TARGET_URI_LIST))
    {
	goto drag_over;		/* of course */
    }


    if(action == GDK_ACTION_MOVE)
	the_mode = mode = TR_MOVE;
    else if(action == GDK_ACTION_COPY)
	the_mode = mode = TR_COPY;
    else if(action == GDK_ACTION_LINK)
	the_mode = mode = TR_LINK;
    else
    {
	print_status(widgets_p,"xfce/error",strerror(EINVAL), NULL);
	goto drag_over;		/* of course */
    }


    nitems = uri_parse_list((const char *)data->data, &list);
    TRACE("nitems=%d, drag data=%s",nitems,(const char *) data->data); 
    if(!nitems){
	goto drag_over;		/* of course */
    }

    /***/

    /* if the first entry is SMB type, treat all as SMB types */   
    url = list->data;
    
    if(strncmp(url,"smb://",strlen("smb://"))==0
	    || strncmp(url,"SMB://",strlen("SMB://"))==0)
    {	
	if (!function_void("plugins","xffm_smb_list","clear_drop_entry")){
	    g_warning("xffm_smb_list plugin is not available");
	    list = uri_free_list(list);
	    goto drag_over;		    
	}
	if (!g_file_test(target_en->path,G_FILE_TEST_EXISTS)) { 
	    g_warning("drop from smb server to non-path not supported.");
	    list = uri_free_list(list);
	    goto drag_over;	
	}
	TRACE("SMBGetFile now...");
	if (!function_natural("plugins","xffm_smb_list",target_en,"set_drop_entry")) {
	    g_warning("set_drop_entry symbole not found");
	}
	if (!function_rational("plugins","xffm_smb_list",list,widgets_p,"SMBGetFile")){
	    g_warning("SMBGetFile symbole not found");
	}
	if (!function_void("plugins","xffm_smb_list","clear_drop_entry")){
	    g_warning("clear_drop_entry symbole not found");
	}
	list = uri_free_list(list);
	result=TRUE; /* whatever */
	goto drag_over;	
    }
    

    /* if target is a plugin, let the plugin take care of business. */
    if (target_en->module) {
	uri_remove_file_prefix_from_list(list,he,me);
	TRACE("en->module=%s",target_en->module);
	if (function_natural("plugins",target_en->module,target_en,"valid_drop_site")){
	    TRACE("module: valid_drop_site for %s",target_en->module);
	    function_natural("plugins",target_en->module,target_en,"set_drop_entry");
	    if (function_rational("plugins",target_en->module,list,widgets_p,"process_drop")){
		TRACE("module: process_drop ok");
		result=TRUE;
	    }
	    function_void("plugins",target_en->module,"clear_drop_entry");
	    list = uri_free_list(list);
	    goto drag_over;
	}
    }
    
    /* now determine whether cp or scp should be used 
     * (we ignore the format for this determination, 
     * because other applications may bork this)*/
    uri_remove_file_prefix_from_list(list, he, me);
    
    if(strcmp(me,he) != 0) {
	int l;
	char **srcs;
	
	TRACE("dnd: doing scp");

	l=g_list_length(list);
	srcs = (char **)malloc((l+1) * sizeof(char *));
	if(!srcs) {
	    list = uri_free_list(list);
	    TRACE("dnd: no srcs");
	    goto drag_over;
	}
	srcs[l] = NULL;
	for(l = 0, tmp = list; tmp; tmp = tmp->next,l++) {
	    srcs[l] = tmp->data;
	}
	xffm_scp(widgets_p, (const gchar **)srcs, target_en->path);
	g_free(srcs);
	list = uri_free_list(list);
	result=TRUE;
	goto drag_over;
    }

    /* local file cp/ln/mv */
    url = list->data; 
    {
	/* nonsense check */
	struct stat st;
	lstat(url, &st);
	if(target_en->st && st.st_ino == target_en->st->st_ino)
	{
	    list = uri_free_list(list);
	    print_status(widgets_p,"xfce/error", strerror(EEXIST), NULL);
	    /*fprintf(stderr,"dbg:nonsense 1\n"); */
	    goto drag_over;
	}
	if(!S_ISDIR(st.st_mode) && strchr(url, '/'))
	{
	    char *p;
	    p = g_strdup(url);
	    *(strrchr(p, '/')) = 0;
	    if(target_en->path && strcmp(p, target_en->path) == 0)
	    {
		list = uri_free_list(list);
		g_free(p);
		p=NULL;
		print_status(widgets_p,"xfce/error", strerror(EEXIST), NULL);
		/*fprintf(stderr,"dbg:nonsense 2\n"); */
		goto drag_over;
	    }
	    g_free(p);
	    p=NULL;
	}
    }

    TRACE("dnd: local");

    tmpfile = xffm_CreateTmpList(widgets_p, list, target_en);

    if(!tmpfile)
    {
	char *what;
	if(mode == TR_MOVE) what = _("Nothing moved");
	else if(mode == TR_COPY) what = _("Nothing copied");
	else what = _("Nothing linked");
	TRACE("TRACE:null tmpfile\n"); 
	print_status(widgets_p,"xfce/info", what, NULL);
	list = uri_free_list(list);
	goto drag_over;
    }
     else TRACE("dbg:dnd, tmpfile=%s\n",tmpfile); 
    /* acording to tmpfile name, do a direct move, here, and break.- */

    xffm_IndirectTransfer(mode, tmpfile,widgets_p);

    if(tmpfile) unlink(tmpfile);
    g_free(tmpfile);
    
    list = uri_free_list(list);
    result=TRUE;
  drag_over:
    gtk_drag_finish(context, TRUE, (the_mode & TR_MOVE) ? TRUE : FALSE, time);
    TRACE("TRACE: on drag data: drag_over\n"); 
   return result;
}


