/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"
#include "treeview.h"

#include "treeview_widgets.i"



G_MODULE_EXPORT
GtkTreeRowReference *pasteref=NULL;
static gboolean anything_selected=FALSE;

static void sensitive(gchar *name,gboolean state){
    GtkWidget *w;
    if (!name){
	g_warning("sensitive(name), name==NULL");
	return;
    }
    w=lookup_widget(xffm_details->arbol->widgets.window,name);
    if (w) {
	gtk_widget_set_sensitive(w, state);
    } 
    /*else g_warning("name=%s not found",name);*/
    	
    return;
}

G_MODULE_EXPORT
void hide_bars(void)
{
    GtkWidget *v;
    GtkWidget *w;
    unsigned global_pref=xffm_details->preferences;
    int i;

	TRACE("TRACE: hide_bars... \n");
    if (global_pref & SHOW_TB1) {
	TRACE("TRACE:SHOW_TB1\n");
	toolbar_buttons();
	
    }
    
#ifdef USE_TOOLBAR_PANEL
    if (global_pref & SHOW_TB2) {
	TRACE("TRACE:SHOW_TB2\n");
	parse_panel_config();
    }
#endif

    for(i = 0; bars[i]; i++) {
	v = lookup_widget(xffm_details->arbol->widgets.window,bars[i]);
	w = lookup_widget(xffm_details->arbol->widgets.window,bar_buttons[i]);
	if(global_pref & bar_prefs[i]) {
	    if(GTK_WIDGET_VISIBLE(w)) gtk_widget_hide(w);
	    if(!GTK_WIDGET_VISIBLE(v)) gtk_widget_show(v);
	} else {
	    if(GTK_WIDGET_VISIBLE(v)) gtk_widget_hide(v);
	    if(!GTK_WIDGET_VISIBLE(w)) gtk_widget_show(w);
	}
    }

#ifdef USE_FILTER_BAR
    /* is the filter widget was unhidden, load filter history: */
    if(global_pref & SHOW_F) set_filter_combo(&(xffm_details->arbol->widgets));
#endif

    for (i=0;i<TREECOUNT; i++){
	if (strstr(xffm_details->argv[0],"xfglob")) 
	    gtk_tree_view_set_headers_visible(xffm_details->arbol->treestuff[i].treeview, TRUE);
	else
	    gtk_tree_view_set_headers_visible(xffm_details->arbol->treestuff[i].treeview, global_pref & SHOW_TITLES);
    }
    
    w = lookup_widget(xffm_details->arbol->widgets.window,"show_titles");
    if(global_pref & SHOW_TITLES) {
	if(GTK_WIDGET_VISIBLE(w)) gtk_widget_hide(w);
    } else {
	if(!GTK_WIDGET_VISIBLE(w)) gtk_widget_show(w);
    }
    write_xffm_config (); 
}

G_MODULE_EXPORT
gboolean set_load_wait(void)
{
    int i;
    if(!xffm_details->arbol->widgets.window){
	TRACE("TRACE(widgets.c): !xffm_details->arbol->widgets.window\n"); 
	return FALSE;
    }
    if(xffm_details->arbol->loading){
	TRACE("TRACE(widgets.c): xffm_details->arbol->loading\n"); 
	return FALSE;
    }
    for(i = 0; focus_names[i]; i++)
    {
	if(gtk_widget_is_focus(lookup_widget(xffm_details->arbol->widgets.window,focus_names[i])))  return FALSE;
    }
    if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) for(i = 0; toolbar_focus_names[i]; i++)
    if (lookup_widget(xffm_details->arbol->widgets.window,toolbar_focus_names[i])){
	if(gtk_widget_is_focus(lookup_widget(xffm_details->arbol->widgets.window,toolbar_focus_names[i])))  return FALSE;
    }
   
    for(i = 0; main_widget_names[i] != NULL; i++) sensitive(main_widget_names[i], FALSE);
    if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) for(i = 0; toolbar_widget_names[i] != NULL; i++) sensitive(toolbar_widget_names[i], FALSE);
    
    xffm_details->arbol->loading = TRUE;
    return TRUE;
}

G_MODULE_EXPORT
gboolean unset_load_wait(void)
{
    int i;
    if(!xffm_details->arbol->widgets.window)
	return FALSE;
    for(i = 0; main_widget_names[i] != NULL; i++) sensitive(main_widget_names[i], TRUE);
    if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) for(i = 0; toolbar_widget_names[i] != NULL; i++) sensitive(toolbar_widget_names[i], TRUE);
  
    xffm_details->arbol->loading = FALSE;
    TRACE("menu widgets on\n");
    for (i=0; i<TREECOUNT;i++) {
	TRACE("goto widgets on\n");
	turn_on();
	TRACE("other widgets on\n");
    }
    return TRUE;
}


G_MODULE_EXPORT
void set_widget_initial_state(void)
{
    int i, j;
    char **names[] = {
	need_select_names,
	NULL
    };
    char **toolbar_names[] = {
	single_selected_path_names,
	toolbar_selected_names,
	toolbar_need_select_names,
	NULL
    };

    for(j = 0; names[j] != NULL; j++)
    {
	for(i = 0; names[j][i] != NULL; i++)sensitive(names[j][i], FALSE);
    }
    if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) {
	for(j = 0; toolbar_names[j] != NULL; j++)
	{
	    for(i = 0; toolbar_names[j][i] != NULL; i++)sensitive(toolbar_names[j][i], FALSE);
	}
    }
 
}



static void turn_it_on(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    int i;
    record_entry_t *en;

    /* condition for only one item selected: */
    if(pasteref)
    {
	gtk_tree_row_reference_free(pasteref);
	pasteref = NULL;
    }
    xffm_details->pastepath = NULL;
    anything_selected=TRUE;
    
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en || !en->path || IS_DUMMY_TYPE(en->type))
	return;


    if ((IS_ROOT_TYPE(en->type) && (!IS_LOCAL_TYPE(en->type)&&!IS_BOOKMARK_TYPE(en->type))) ||
       (IS_NETWORK_TYPE(en->type) && 
	!IS_XF_NETWS(en->subtype) && 
	!IS_XF_NETSHARE(en->subtype) && 
	!IS_NETDIR(en->subtype) && 
	!IS_NETFILE(en->subtype)
       )||
       IS_XF_FND(en->type) 
       ){
	    return;
    }

    xffm_details->arbol->selectionOK++;


    if(xffm_details->arbol->selectionOK == 1)
    {
	GtkWidget *sidebar=gtk_bin_get_child(GTK_BIN(lookup_widget(xffm_details->arbol->widgets.window,"eventbox_sidebar")));
	if(IS_DIR(en->type) ||
	   IS_NETDIR(en->subtype) ||
	   IS_XF_NETSHARE(en->subtype))
	{
	    xffm_details->pastepath = en->path;
	    pasteref = gtk_tree_row_reference_new(treemodel, path);
	}
	else if(IS_BOOKMARK_TYPE(en->type) && IS_ROOT_TYPE(en->type))
	{
	    pasteref = gtk_tree_row_reference_new(treemodel, path);
	    xffm_details->pastepath = "ROOT_BOOKMARKS";
	}
	else if (IS_FILE(en->type)) {
	    GtkTreeIter parent;
	    if ( gtk_tree_model_iter_parent (treemodel,&parent,iter)) {
		GtkTreePath * p_path=gtk_tree_model_get_path(treemodel,&parent);
		record_entry_t *p_en;
		gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
		xffm_details->pastepath = p_en->path;
		pasteref = gtk_tree_row_reference_new(treemodel, p_path);
		gtk_tree_path_free(p_path);	
	    }
	}
	if(IS_FILE(en->type)||IS_DIR(en->type))
	{
	    
	    if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) for(i = 0; single_selected_path_names[i]; i++)
	    {
				
		if(!IS_BROKEN_LNK(en->type)) {
		    sensitive(single_selected_path_names[i], TRUE);
		}
		if (sidebar && GTK_WIDGET_VISIBLE(sidebar)){
#if USE_XFALL || USE_SCRAMBLEDIR
		    if (!IS_PATH(en->type))
#else
		    if (IS_DIR(en->type) || !IS_FILE(en->type))
#endif
		    {
			    if (lookup_widget(xffm_details->arbol->widgets.window,"sb_scramble"))
			gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"sb_scramble"),FALSE);
			    if (lookup_widget(xffm_details->arbol->widgets.window,"sb_unscramble"))
			gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"sb_unscramble"),FALSE);
		    } 
		    else 
#if USE_XFALL || USE_SCRAMBLEDIR
			if (IS_DIR(en->type)) {
			    if (lookup_widget(xffm_details->arbol->widgets.window,"sb_unscramble"))
			  gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"sb_unscramble"),TRUE);
			}
			else
			
#endif
		    {
			gchar *p=strrchr(en->path,'.');
			if (!p || strcmp(p,".cyt")!=0) {
			    if (lookup_widget(xffm_details->arbol->widgets.window,"sb_scramble"))
			    gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"sb_scramble"),TRUE);
			    if (lookup_widget(xffm_details->arbol->widgets.window,"sb_unscramble"))
			    gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"sb_unscramble"),FALSE);
			}
			else {
			    if (lookup_widget(xffm_details->arbol->widgets.window,"sb_unscramble"))
			    gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"sb_unscramble"),TRUE);
			    if (lookup_widget(xffm_details->arbol->widgets.window,"sb_scramble"))
			    gtk_widget_set_sensitive(lookup_widget(xffm_details->arbol->widgets.window,"sb_scramble"),FALSE);
			}
		    }
		}
	    }
	}
	if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) for(i = 0; toolbar_need_select_names[i]; i++){
	    if (strcmp(toolbar_need_select_names[i],"go_button")==0){
	        sensitive(toolbar_need_select_names[i], local_branch_is_visible(treemodel));
	    }
	    else 
		sensitive(toolbar_need_select_names[i], TRUE);	
	}
	 
	 for (i = 0; go_stuff[i]; i++) sensitive(go_stuff[i], TRUE);
 	 if (sidebar) {
	     gboolean state=local_branch_is_visible(treemodel);
	     if (GTK_WIDGET_VISIBLE(sidebar)){
		 sensitive("sb_goto_jump", state);
		 sensitive("sb_go_home", state);
		 sensitive("sb_go_backward", state);
		 sensitive("sb_go_forward", state);
		 sensitive("sb_go_up", state);
	     } 
	 }
   
	
	for(i = 0; need_select_names[i]; i++){
	    sensitive(need_select_names[i], TRUE);	
	}
    }
    else
    {
	for(i = 0; need_select_names[i]; i++) sensitive(need_select_names[i], FALSE);
	if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) {
	    for(i = 0; toolbar_need_select_names[i]; i++) sensitive(toolbar_need_select_names[i], FALSE);
	    for(i = 0; single_selected_path_names[i]; i++) sensitive(single_selected_path_names[i], FALSE);
	}
    }


    if(!IS_PATH(en->type) &&
       !IS_XF_NETWS(en->subtype) &&
       !IS_XF_NETSHARE(en->subtype) &&
       !IS_NETDIR(en->subtype) &&
       !IS_NETFILE(en->subtype)
      )	return;
    if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) for(i = 0; toolbar_selected_names[i]; i++) sensitive(toolbar_selected_names[i], TRUE);
}

G_MODULE_EXPORT
void turn_on_pasteboard(void)
{
    int i;
    if(xffm_details->pastepath && valid_pasteboard())
    {
	if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1")))for(i = 0; toolbar_valid_pasteboard_names[i]; i++)sensitive(toolbar_valid_pasteboard_names[i], TRUE);
    }
    else
    {
	if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1")))for(i = 0; toolbar_valid_pasteboard_names[i]; i++)sensitive(toolbar_valid_pasteboard_names[i], FALSE);
    }
    return;
}

G_MODULE_EXPORT
void turn_on(void)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    record_entry_t *en;

    /* turn widgets on/off */
    set_widget_initial_state();
    
    
    xffm_details->arbol->selectionOK = 0;
    
    xffm_details->pastepath = NULL;

    anything_selected=FALSE;
    gtk_tree_selection_selected_foreach(selection, 
		    turn_it_on, (gpointer) treeview);


    if(xffm_details->arbol->selectionOK == 0)
    {
	GtkTreeIter iter;
    	int i;

	if(get_selectpath_iter(&iter, &en))
	{
	    TRACE("get_selectpath_iter done \n");
	    if(IS_DIR(en->type))
	    {
		TRACE("IS_DIR  done \n");
	       	for(i = 0; need_select_names[i]; i++)sensitive(need_select_names[i], TRUE);
	    }
	}
    } 
    
    if (get_only_visible_treestuff() || anything_selected){
    	int i;
	GtkWidget *sidebar=gtk_bin_get_child(GTK_BIN(lookup_widget(xffm_details->arbol->widgets.window,"eventbox_sidebar")));
	 sensitive("input_ok", TRUE);
         if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) {
	     sensitive("go_button", TRUE);
	     sensitive("nb_refresh", TRUE);
	 }
	 for (i = 0; go_stuff[i]; i++) sensitive(go_stuff[i], TRUE);
	 
	 if (sidebar && GTK_WIDGET_VISIBLE(sidebar)){
		 sensitive("sb_goto_jump", TRUE);
		 sensitive("sb_go_home", TRUE);
		 sensitive("sb_go_backward", TRUE);
		 sensitive("sb_go_forward", TRUE);
		 sensitive("sb_go_up", TRUE);
	 }
    } else {
	GtkWidget *sidebar=gtk_bin_get_child(GTK_BIN(lookup_widget(xffm_details->arbol->widgets.window,"eventbox_sidebar")));
    	int i;
	for (i = 0; go_stuff[i]; i++) sensitive(go_stuff[i], FALSE);
	if (GTK_WIDGET_VISIBLE(lookup_widget(xffm_details->arbol->widgets.window,"box_tb1"))) sensitive("go_button", FALSE);
 	if (sidebar && GTK_WIDGET_VISIBLE(sidebar)){
		 sensitive("sb_goto_jump", FALSE);
		 sensitive("sb_go_home", FALSE);
		 sensitive("sb_go_backward", FALSE);
		 sensitive("sb_go_forward", FALSE);
		 sensitive("sb_go_up", FALSE); 
	}
   }
    
    TRACE("turnon  done \n");
    turn_on_pasteboard();
}
