/* basic_row_c */
/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <grp.h>
#include <pwd.h>
#include <errno.h>
#include <gtk/gtk.h>


#include "constants.h"
#include "types.h"

#include "treeview.h" 
#include "primary.h" 
#include "secondary.h" 

/* static functions: */
#include "treeview_local.i"



/*******************************************************************/
/*        adding a local folder 
 *
 *        basic_local.c
 *
 *        ****************************/
/*******************************************************************/


G_MODULE_EXPORT
int 
open_folder_local(	GtkTreeView *treeview,
			GtkTreeIter *iter,
		       	GtkTreePath *treepath,
			record_entry_t *en)
{
    const gchar *filter;
    struct stat st;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    if (!en || !iter || !treeview){
	errno=EINVAL;
	return -1;
    }
    
    if(access(en->path, X_OK)!=0) return -1;
    if(stat(en->path, &st) >= 0)
    {
	if (!en->st) {
	    en->st = (struct stat *)malloc(sizeof(struct stat));
	    memset(en->st,0,sizeof(struct stat));
	}
	if(st.st_mtime != en->st->st_mtime || st.st_ctime != en->st->st_ctime)
	{
	    TRACE("UNSET_LOADED st.st_mtime != en->st->st_mtime\n");
	    memcpy(en->st, &st, sizeof(struct stat));
	    UNSET_LOADED(en->type);
	}	
    } else return -1;

    TRACE("opening %s",en->path); 
    
    if (IS_LOADED(en->type) && ! IS_INCOMPLETE(en->type)) {
	TRACE("Hmm... %s is already loaded",en->path); 
	return en->count;
    }
    
    /* if filterchanged reload as well */
    if (!en->filter || (filter=get_filter(&(xffm_details->arbol->widgets)))==NULL) {
	g_warning("!en->filter || !get_filter(&(xffm_details->arbol->widgets))");
	errno=EINVAL;
	return -1;
    }
    
    if (IS_LOADED(en->type) && strcmp(en->filter, filter) == 0) {
	return en->count;
    }
	    
    /*printf("TRACE: loaded=%d, filter=%s,en->filter=%s\n",
			    IS_LOADED(en->type),
			    (filter)?filter:"NULL",
			    (en->filter)?en->filter:"NULL");*/
    prune_row(treemodel, iter, NULL, en);

	    
    UNSET_INCOMPLETE(en->type);

    en->count =add_folder_local(treeview, iter, en);
    /* just count visible files */
    /*en->count = all_files_count();*/

    update_text_cell_for_row(SIZE_COLUMN,treemodel, iter,sizetag((off_t)-1, en->count)); 

    return en->count;

}


