/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#ifdef HAVE_STDARG_H
#include <stdarg.h>
#elif HAVE_VARARGS_H
#include <varargs.h>
#else
#error "no <stdarg.h> or <varargs.h>!"
#endif

#include <string.h>

#ifdef HAVE_LIBSM
/*#include <X11/SM/SMlib.h>*/
#endif
#ifdef HAVE_LIBXFCEGUI4
#include <libxfcegui4/libxfcegui4.h>
#endif

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "treeview.h"


extern root_t root[];

 
static GtkTreePath *first_path;
static 
void 
first_selection(		GtkTreeModel * model, 
				GtkTreePath * path, 
				GtkTreeIter * iter, 
				gpointer data)
{
	if (first_path) return;
	first_path=gtk_tree_path_copy(path);
}

G_MODULE_EXPORT
const gchar *
treeview_get_selected_chdir (void)
{
    static gchar *Cdir=NULL;
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    record_entry_t *en;
    
    if (Cdir) {
	g_free(Cdir);
	Cdir=NULL;
    }
    TRACE("treeview_get_selected_chdir now 1");
    
	first_path=NULL;
	gtk_tree_selection_selected_foreach(selection, first_selection, (gpointer) treeview);
	if (first_path)
	{
	  GtkTreeIter iter;
	  if (gtk_tree_model_get_iter (treemodel,&iter,first_path)){
	    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1); 
	    if (en && en->path) { 
		gchar *g;
		if (IS_DIR(en->type)) g=g_strdup(en->path);
		else g=g_path_get_dirname(en->path);
		if (strcmp(g,".")==0) {
		   g_free(g);
		   g=NULL;
		}
		else Cdir=g;
	    } 
	  }
	  gtk_tree_path_free(first_path);
	}
    
    if (!Cdir) Cdir = g_strdup(GETWD); 
    return (const gchar *)Cdir;
}


G_MODULE_EXPORT
gboolean get_selectpath_iter(GtkTreeIter * iter, record_entry_t ** en)
{
   gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = xffm_details->arbol->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = xffm_details->arbol->treestuff[tree_id].selection;
    GtkTreeIter parent;
    record_entry_t *c_en= NULL, *p_en = NULL;
    int caso = 0;

    if(!xffm_details) return FALSE;
    if(!xffm_details->arbol->widgets.window) return FALSE;


    gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
    if(!gtk_tree_selection_get_selected(selection, &treemodel, iter))
    {
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	return FALSE;
    }
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &c_en, -1);
    if(gtk_tree_model_iter_parent(treemodel, &parent, iter))
    {
	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
    }

    if(IS_PATH(c_en->type) && IS_DIR(c_en->type))
	caso = 1;

    else if(IS_FIND_TYPE(c_en->type))
    {
	if(IS_DIR(c_en->type))
	    caso = 1;
	else if(p_en && IS_FILE(c_en->type) && IS_XF_FND(p_en->type))
	    caso = 0;
	else if(p_en && IS_FILE(c_en->type) && IS_DIR(p_en->type))
	    caso = 2;
	else
	    caso = 0;
    }
    else if(IS_LOCAL_TYPE(c_en->type))
    {
	if(IS_DIR(c_en->type))
	    caso = 1;
	else if(p_en && (IS_FILE(c_en->type) || IS_DUMMY_TYPE(c_en->type)))
	    caso = 2;
	else
	    caso = 0;
    }
    else if(IS_BOOKMARK_TYPE(c_en->type))
    {
	if(IS_DIR(c_en->type) || IS_ROOT_TYPE(c_en->type) ||
	   IS_NETDIR(c_en->subtype) || IS_XF_NETSHARE(c_en->subtype) ||
	   IS_XF_NETWS(c_en->subtype)  )
	    caso = 1;
	else if (p_en && 
		 (IS_FILE(c_en->type) || IS_DUMMY_TYPE(c_en->type)
		  || IS_NETFILE(c_en->subtype))
		) caso = 2;
	else
	    caso = 0;
    }
    else if(IS_NETWORK_TYPE(c_en->type))
    {
	if(IS_ROOT_TYPE(c_en->type) || 
	   IS_XF_NETWG(c_en->subtype) ||
	   IS_XF_NETWS(c_en->subtype) ||
	   IS_NETDIR(c_en->subtype) ||
	   IS_XF_NETSHARE(c_en->subtype))
	    caso = 1;
	else if (p_en )
	    caso = 2;
	else
	    caso = 0;
    }
    else if (IS_FSTAB_TYPE(c_en->type))
    {
	if(IS_ROOT_TYPE(c_en->type)||IS_DIR(c_en->type))
	    caso = 1;
	else if(p_en && (IS_FILE(c_en->type) || IS_DUMMY_TYPE(c_en->type)))
	    		caso = 2;
	else caso = 0;
    }
    else if (c_en->module) { /*frequent, recent, trash */
	if(IS_ROOT_TYPE(c_en->type))
	    caso = 1;
	else if(p_en && (IS_FILE(c_en->type) || IS_DUMMY_TYPE(c_en->type)))
	    caso = 2;
	else
	    caso = 0;
    }
    
	    
    /*printf("TRACE: caso is %d\n",caso);*/
    if(caso)
    {
	if(caso == 2)
	{
	    *en = p_en;
	    *iter = parent;
	}
	else
	    *en = c_en;
    }
    else
	return FALSE;

    return TRUE;
}


G_MODULE_EXPORT
void count_selection (GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    xffm_details->arbol->selectionOK++;
    return ;
}


G_MODULE_EXPORT
treestuff_t *get_treestuff (GtkTreeView *treeview){
    int i;
    for (i=0;i<TREECOUNT;i++){
	if (treeview == xffm_details->arbol->treestuff[i].treeview) 
	    return (xffm_details->arbol->treestuff)+i;
    }
    g_warning("treestuff != NULL");
    return NULL;
}

G_MODULE_EXPORT
gint get_tree_id (GtkTreeView *treeview){
    int i;
    for (i=0;i<TREECOUNT;i++){
      /*printf("TRACE: treeviewcmp  0x%x==0x%x\n",xffm_details->arbol->treestuff[i].treeview,treeview);*/
	if (treeview == xffm_details->arbol->treestuff[i].treeview) 
	    return i;
    }
    /*g_error("treestuff[tree_id] != NULL");*/
    return -1;
}


static gboolean correct_selection;
static void query_selection(GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    /*GtkTreeView *treeview = (GtkTreeView *) data;*/
    if(correct_selection) return;
    correct_selection=TRUE;
    return;
}

G_MODULE_EXPORT
GtkTreeView *get_bigger_treeview(void){
    GtkWidget *vpaned = lookup_widget(xffm_details->arbol->widgets.window,"hpaned1");
    if (gtk_paned_get_position((GtkPaned *)vpaned) <= vpaned->allocation.width * 0.50) {
	return xffm_details->arbol->treestuff[0].treeview;
    } else return xffm_details->arbol->treestuff[1].treeview;
}

G_MODULE_EXPORT
treestuff_t *get_only_visible_treestuff (void){
    GtkWidget *vpaned = lookup_widget(xffm_details->arbol->widgets.window,"hpaned1");
    if (gtk_paned_get_position((GtkPaned *)vpaned) <= vpaned->allocation.width * 0.10) {
	set_relative_tree_id(0);
	return xffm_details->arbol->treestuff;
    } 
    if (gtk_paned_get_position((GtkPaned *)vpaned) >= vpaned->allocation.width *0.90) {
	set_relative_tree_id(1);
	return xffm_details->arbol->treestuff+1;
    }
    return NULL;
}

G_MODULE_EXPORT
gboolean local_branch_is_visible (GtkTreeModel *treemodel){
    GtkTreeIter iter;
    record_entry_t *en;
    if(gtk_tree_model_get_iter_first(treemodel, &iter)){
	do {  
	  gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	  if (!en) continue;
	  if (IS_LOCAL_TYPE(en->type)) return TRUE;
	} while (gtk_tree_model_iter_next(treemodel, &iter));
    }
    return FALSE;	
}

static GtkTreeView *get_active_treeview(void){
    int i;
    treestuff_t *treestuff=get_only_visible_treestuff();
    GtkTreeView *treeview;
    GtkTreeSelection *selection;
    correct_selection=FALSE;
    
    
    if (treestuff) return (treestuff->treeview);
    for (i=0;i<TREECOUNT;i++) {
      treeview=xffm_details->arbol->treestuff[i].treeview;
      selection = gtk_tree_view_get_selection(treeview);
      gtk_tree_selection_selected_foreach(selection, query_selection, (gpointer) treeview);
      if (correct_selection) return treeview;
    }
    return get_bigger_treeview();
}


G_MODULE_EXPORT
gint get_active_tree_id (void){
    gint i;
    GtkTreeView *treeview = get_active_treeview();
    i=get_tree_id(treeview);
    if (i < 0 || i >= TREECOUNT) 
	g_error("treeview != any(xffm_details->arbol->treestuff[i].treeview)");
    return i;
}


G_MODULE_EXPORT
int find_module_root(GtkTreeView * treeview, GtkTreeIter * iter, record_entry_t ** en, const gchar *which)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    if(!gtk_tree_model_get_iter_first(treemodel, iter)){
	return FALSE;
    }
	    
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, en, -1);
    if (!en) {
	return FALSE;
    }

    while(!(*en)->module || (which && strcmp((*en)->module,which)) != 0)
    {
	gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, en, -1);
	if (!en) return FALSE;
	/* hack, becuase find module is not a plugin...*/
	if (which && IS_FIND_TYPE((*en)->type) && strcmp(which,"xffm_find")==0) {
	    return TRUE;
	}
	if (!which && !(*en)->module) return TRUE;
	if (which && (*en)->module && strcmp((*en)->module,which) == 0) return TRUE;
	if(!gtk_tree_model_iter_next(treemodel, iter)){
	   return FALSE;
	}
    } 
    TRACE("module root for %s not found",(which?which:"null"));
    return FALSE;
}

G_MODULE_EXPORT
int get_module_root(GtkTreeView * treeview, GtkTreeIter * iter, record_entry_t ** en, const gchar *which)
{
    GtkTreeModel *treemodel;
    treemodel = gtk_tree_view_get_model(treeview);
    if(!find_module_root(treeview, iter, en, which)){
	TRACE("TRACE(misc.c):create_root_element(treeview,iter,which,g)\n");
	create_root_element(treeview,iter,which,NULL);
   	gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, en, -1);
    }
    return TRUE;
}


G_MODULE_EXPORT
void on_treeview_column_click (GtkTreeViewColumn * column, gpointer data){
    set_relative_tree_id((gint)((long)data));
}

G_MODULE_EXPORT
gint set_relative_tree_id_from_model (GtkTreeModel *treemodel){
    int i;
    for (i=0;i<TREECOUNT;i++){
      /*printf("TRACE: treeviewcmp  0x%x==0x%x\n",xffm_details->arbol->treestuff[i].treeview,treeview);*/
	if (treemodel == xffm_details->arbol->treestuff[i].treemodel) {
	    set_relative_tree_id(i);
	    return 1;
	}
    }
    g_warning("tree_id == NULL");
    return 1;
}

G_MODULE_EXPORT
void set_font(GtkTreeModel *treemodel, GtkTreeIter * iterator)
{
#if 0
    PangoFontDescription *desc;
    int size,ssize;
    record_entry_t *en;
   
    if (!(xffm_details->preferences & ENABLE_RESIZE_FONTS)) return;
       gtk_tree_model_get(treemodel, iterator, ENTRY_COLUMN, &en, -1);
    if (!en) return;   
    switch (xffm_details->icon_size) {
	case 3: 
	    size = 16 * 1000;break;
	case 2:
	    size = 14 * 1000;break;
	case 1:
	    size = 12 * 1000;break;
	case 0:
	default:
	    size = 10 * 1000;break;
    }
    ssize = 10 * 1000;
    desc = pango_font_description_new();

#if 0
    if(IS_ROOT_TYPE(en->type))
	pango_font_description_set_family(desc, "times");
#endif

    pango_font_description_set_size(desc, size);

    /*printf("font size is=%d\n",pango_font_description_get_size(desc)); */
/*FIXME: all gtk_tree_store_set should reside in "basic" files*/
    gtk_tree_store_set((GtkTreeStore *) treemodel, iterator, FONT_COLUMN, desc, -1);
    pango_font_description_set_size(desc, ssize);
    gtk_tree_store_set((GtkTreeStore *) treemodel, iterator, SFONT_COLUMN, desc, -1);
    
    pango_font_description_free(desc);
#endif
}

G_MODULE_EXPORT
GtkTreeIter *
get_iter_from_reference(	GtkTreeModel * treemodel, 
				GtkTreeRowReference *reference)
{
    static GtkTreeIter iter;
    GtkTreePath *treepath;
    if (!gtk_tree_row_reference_valid(reference)){
        g_warning("Invalid row reference");
	return NULL;
    } else if ((treepath = gtk_tree_row_reference_get_path(reference))==NULL){
	g_warning("gtk_tree_row_reference_get_path() == NULL");
	return NULL;
    }
    gtk_tree_model_get_iter(treemodel, &iter, treepath);
    gtk_tree_path_free(treepath);
    return &iter;
}


