/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <grp.h>
#include <pwd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "secondary.h"
#include "treeview.h"
#include "actions_lib.h"

#include "tubo.h"

/* bug workaround (double click signals click first)*/
static gboolean skip_second_release = FALSE;
static gboolean mousedown=FALSE;
static gdouble mouseX,mouseY;
static GtkTreePath *clickpath=NULL;
G_MODULE_EXPORT
gboolean easy_mode=FALSE;

static
const gchar *get_selected_module_name(){
    if (xffm_details->arbol->widgets.window) {
	GtkTreeIter iter;
        record_entry_t *en, *p_en;
        GtkTreeIter parent;
	GtkTreeModel *treemodel=xffm_details->arbol->treestuff[get_active_tree_id()].treemodel;
	en=treeview_get_selected_entry(&iter);
        if (!gtk_tree_model_iter_parent(treemodel,&parent,&iter)) 
	    return NULL;
    	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
    	if (!p_en) return NULL;
	return p_en->module;
    } 
    return NULL;
}


static gboolean unsel(GtkTreeModel * treemodel, GtkTreePath * treepath, GtkTreeIter * iter, gpointer data);

static gboolean valid_iter(GtkTreeView * treeview,GtkTreeIter * iter){
    record_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    gtk_tree_model_get(GTK_TREE_MODEL(treemodel), iter, ENTRY_COLUMN, &en, -1);
    if (!en) return FALSE;
    if (IS_PATH(en->type) && access(en->path,F_OK)!=0) return FALSE;
    return TRUE;
}

int
open_module_folder (GtkTreeView *treeview, GtkTreeIter *iter, GtkTreePath *treepath, gpointer user_data)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    record_entry_t *en;
    xfdir_t *xfdir_p=NULL;
    const gchar *submodule_name;
    
    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if (!en || !en->module) return -1;

    TRACE("obtaining xfdir_p from module %s",en->module);
    xfdir_p=module_xfdir(&(xffm_details->arbol->widgets),en->module,en);
    submodule_name=function_void("plugins",en->module,"submodule_name");
	    
    if (!xfdir_p) {
	print_status(&(xffm_details->arbol->widgets),"xfce/warning",_("Nothing found"),NULL);
	return -1;
    }
    
    prune_row(treemodel, iter, NULL, en);
    /* set submodule_name to all children_en->module here*/
    {
	int i;
	for (i=0; i<xfdir_p->pathc; i++){
	    xfdir_p->gl[i].en->module = g_strdup(submodule_name);
	}
    }
    add_contents_row(treemodel, iter, xfdir_p);
    xfdirfree(xfdir_p);
    return(xfdir_p->pathc);
}




extern gboolean no_sorting;/* see explanation in treeview.c */

G_MODULE_EXPORT
void open_dir(GtkTreeView * treeview, GtkTreeIter * iter, GtkTreePath * treepath, gpointer user_data)
{
    int load_count=0;
    record_entry_t *en;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter child;
    static gboolean red_light=FALSE;
    GtkTreeSortable *sortable=GTK_TREE_SORTABLE(treemodel);
    
    TRACE("open_dir ...");
    
    /* first gtk bug workaround:
     * click on expander passes button_press but not button_release
     * */
    mousedown=FALSE; 
    

    /*clear_path_from_selection_list(treeview,clickpath);*/
    if (!valid_iter(treeview,iter)){
	TRACE("!valid_iter");
	local_monitor(TRUE);
	return;
    }
    gtk_tree_model_get(GTK_TREE_MODEL(treemodel), iter, ENTRY_COLUMN, &en, -1);
    if(!en || !en->path) {
	g_warning("should not happen: no entry nor path to expand");
	return;
    }

    if (red_light){
	TRACE("red_light return");
	return;
    }
    if(!set_load_wait())
    {
	TRACE("!set_load_wait()...");
	gtk_tree_view_collapse_row(treeview, treepath);
	return;
    }
    red_light=TRUE;
    /* unselect all */
    treeview_clear_dnd_selection_list();
    gtk_tree_selection_unselect_all(gtk_tree_view_get_selection(treeview));

    /* select this one */
    gtk_tree_selection_select_path(gtk_tree_view_get_selection(treeview),treepath);    
    
    gtk_widget_show(xffm_details->arbol->widgets.progress); 
	TRACE("red light set...");
    /* second gtk-bug workaround:
     * disable internal sorting while loading, otherwise gtk
     * will sort on each added row (slower), instead of sorting when
     * all rows have been added (faster).**/
    no_sorting=TRUE;
	
    if (!en->module) {
	print_status(&(xffm_details->arbol->widgets),NULL,_("Loading..."),NULL);
    }
    cursor_wait(xffm_details->arbol->widgets.window);
    process_pending_gtk();

    /* here we should obtain the xfdir */

    /* first, check if a filter is set and if it is different from
     * the filter for the entry (which may be already loaded) */
    if(en->filter && strcmp(en->filter, get_filter(&(xffm_details->arbol->widgets)))){
	UNSET_LOADED(en->type);
    }
    
    /* if the node being expanded belongs to a local filesystem
     * directory, use the local code */
    if(!IS_LOADED(en->type)) {
      if(g_file_test(en->path,G_FILE_TEST_IS_DIR)) {
	load_count=open_folder_local(treeview,iter,treepath,en);
	TRACE("open_folder_local");	
      } else {	
	if (!en->module && !IS_FIND_TYPE(en->type)) {
	    g_warning("CRITICAL: module name cannot be null");
	} else {
	    /* find type is a plugin that is not a plugin, but a module,
	     * in the future, the find module may become a plugin... */
	    load_count=open_module_folder(treeview,iter,treepath,en);
	}
      }
    
      if (load_count < 0) {	
	TRACE("reset_dummy_row now...");	
	   if (en->module && function_void("plugins",en->module,"dummy_text")){
	       reset_dummy_row(treemodel, iter,NULL,en,"xfce/error",function_void("plugins",en->module,"dummy_text"));
	   } else {
	       reset_dummy_row(treemodel, iter,NULL,en,"xfce/error",strerror(errno));
	   }
    	   hide_stop(&(xffm_details->arbol->widgets));
	   unset_load_wait();
	   cursor_reset(xffm_details->arbol->widgets.window);
	   red_light=FALSE;
	   return;
      } else {
	GtkTreeIter parent;
	/*if(IS_ROOT_TYPE(en->type) && strcmp(en->path,"/")!=0 && load_count) {*/
	if (load_count && strcmp(en->path,"/")!=0 && g_file_test(en->path,G_FILE_TEST_IS_DIR) && !gtk_tree_model_iter_parent(treemodel, &parent, iter) ) {
	    TRACE("insert_dummy_row xfce/stock_go-up");
	    insert_dummy_row(treemodel, iter,NULL,en,"xfce/stock_go-up","..");
	} 
	else if (!load_count) {
	    TRACE("!load_count) insert_dummy_row NULL");
	    if (IS_ROOT_TYPE(en->type))
		insert_dummy_row(treemodel, iter,NULL,en,"xfce/stock_go-up","..");
	    else 
		insert_dummy_row(treemodel, iter,NULL,en,NULL,NULL);
	}
      }
    }
    

    SET_EXPANDED(en->type);

    TRACE("icon setting for %s",en->path); 
    set_icon(treemodel, iter);
	
    
    if(gtk_tree_model_iter_children(treemodel, &child, iter)) {
      do {
	record_entry_t *c_en;    
        gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	if (c_en && IS_DIR(c_en->type)) {
	    TRACE("icon setting for %s",c_en->path); 
	    set_icon(treemodel, &child);
	}
      } while(gtk_tree_model_iter_next(treemodel, &child));
    }
    
    hide_stop(&(xffm_details->arbol->widgets));

    /* mechanism to workaround gtk slowness...
     * when the node is expanded, we collapse it, thus
     * on adding new rows speed is enhanced. Only after all
     * new rows are added should the actual expansion occur,
     * which is right here:*/
    TRACE("now expanding previously loaded treemodel...");
    if (!gtk_tree_view_row_expanded(treeview,treepath)) {
	 gtk_tree_view_expand_row(treeview, treepath, FALSE);
    }

    
	

    set_icon_name(xffm_details->arbol->widgets.window,en->path);
    set_application_icon(&(xffm_details->arbol->widgets),en);
    if (en->tag && !en->module) {
	print_status(&(xffm_details->arbol->widgets),NULL,en->tag,NULL);
    }
     
    /*if(xffm_details->preferences & AUTOSCROLL)*/
    {
	gdk_flush();
	/*another gtk treeview bug, scrolling does not always occur...
	 * bugzilla  120269 */
	gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
    }

    cursor_reset(xffm_details->arbol->widgets.window);
    gtk_widget_hide(xffm_details->arbol->widgets.progress); 
    red_light=FALSE;
	TRACE("red light unset...");
    unset_load_wait();
     /* reenable internal sorting now... */
    no_sorting=FALSE;
    gtk_tree_sortable_sort_column_changed (sortable);
	TRACE("gtk_tree_sortable_sort_column_changed...");
  
}


G_MODULE_EXPORT
void close_dir(GtkTreeView * treeview, GtkTreeIter * iter, GtkTreePath * path, gpointer user_data)
{
    record_entry_t *en;
    GtkTreeIter parent,child;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);


    mousedown=FALSE; 
    
#if 0
    /* gtk bug workaround:click on expander passes button_press but not button_release */
    if (clickpath){
        clear_path_from_selection_list(treeview,clickpath);
    }
#else    
    /* unselect all */
    treeview_clear_dnd_selection_list();
    gtk_tree_selection_unselect_all(gtk_tree_view_get_selection(treeview));

    /* select this one */
    gtk_tree_selection_select_path(gtk_tree_view_get_selection(treeview),path);    

#endif

    if (!valid_iter(treeview,iter)){
	    local_monitor(TRUE);
	    return;
    }
    if(xffm_details->arbol->loading)
    {
	/* this creates an endless loop: 
	 * gtk_tree_view_expand_row (treeview,treepath,FALSE);*/
	return;			/* Hey, push the stop button man! */
    }

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en) goto time2return;


    UNSET_EXPANDED(en->type);
    if(gtk_tree_model_iter_children(treemodel, &child, iter)){
      do {
	record_entry_t *c_en;    
        gtk_tree_model_get(treemodel, &child, ENTRY_COLUMN, &c_en, -1);
	if (en && IS_DIR(en->type)) UNSET_EXPANDED(c_en->type);
      } while(gtk_tree_model_iter_next(treemodel, &child));
    }

    set_icon(treemodel, iter);
    
    
    if (gtk_tree_model_iter_parent(treemodel, &parent, iter)) {
	record_entry_t *p_en;
	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, &p_en, -1);
        set_icon_name(xffm_details->arbol->widgets.window,p_en->path);
        set_application_icon(&(xffm_details->arbol->widgets),p_en);
    } else {
        set_icon_name(xffm_details->arbol->widgets.window,NULL);
        set_application_icon(&(xffm_details->arbol->widgets),NULL);
    }
   time2return:
    turn_on();
    xffm_details->arbol->loading = FALSE;
}


/********************* callbacks **************************/

static int reselecttimer=0;
#if 0
static gint do_reselect(gpointer data){
	GtkTreeView * treeview=(GtkTreeView * )data;
 	reselect_dnd_list(treeview);
	/*printf("TRACE:at reselecttimer = %d\n",reselecttimer );*/
	reselecttimer=0;
	return FALSE;
}
#endif
static gint delayed_selection(gpointer data){
	GtkTreeView * treeview=(GtkTreeView * )data;
        GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
	 TRACE("delayed selection...\n");
     	gtk_tree_selection_selected_foreach(selection, treeview_get_dnd_selection, (gpointer) treeview);
	if (xffm_details->selection_list && g_list_length(xffm_details->selection_list) > 1){
	    gchar *g=g_strdup_printf(_("%d item(s) selected"),g_list_length(xffm_details->selection_list));
	    print_status(&(xffm_details->arbol->widgets),"xfce/info",g,NULL);
	    g_free(g);
	}
	    cursor_reset(xffm_details->arbol->widgets.window);

	return FALSE;
}


G_MODULE_EXPORT
gboolean button_releaseF(GtkWidget * widget, GdkEventButton * event, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreePath *treepath;
    record_entry_t *en;
    GtkTreeIter iter;

   mousedown=FALSE; 
    TRACE("release event... ignore second releas=%d... \n",xffm_details->comm & COMM_IGNORE_RELEASE); 
    if(xffm_details->arbol->loading)	return FALSE;
    mouseX=event->x;
    mouseY=event->y;
    { 
        int i;
        for (i=0;i<TREECOUNT;i++) {
	   gtk_tree_view_set_drag_dest_row (xffm_details->arbol->treestuff[i].treeview,NULL,GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);
	}
    }

   if(event->button == 1 && skip_second_release) 
    {
	skip_second_release = FALSE;
	/*printf("skip_second_release = 1\n");*/
	return FALSE;
    }
    /* this corrupts the double click because the treeview gets moved:
     *  hide_text(widget);
     *  */
    switch (event->button)
    {
	default:
	    break;
	case 4:
	case 5: /* these don't work ... */
	    break;
	case 1: case 3:
	if (event->button == 3)
	    break;		/* not working for button 3 */
	/* BUTTON_1: */
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, 
				    &treepath, NULL, NULL, NULL))
	    {

	        gtk_tree_path_free(treepath);
	        turn_on();
	    }
	    if (xffm_details->comm & COMM_IGNORE_RELEASE){
		/* nautilus sends the release event back to
		 * originating window after drop. We don't
		 * want it... */
		TRACE("ignoring release signal");
	    }
	    else treeview_clear_dnd_selection_list();
	    break; /* case 1 */
	case 2:
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, &treepath, NULL, NULL, NULL))
	    {
		show_text(xffm_details->arbol->widgets.diagnostics);
		gtk_tree_model_get_iter(treemodel, &iter, treepath);
		gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		print_path_info(&(xffm_details->arbol->widgets),en);
		gtk_tree_path_free(treepath);
	    }
	    treeview_clear_dnd_selection_list();
	    break; /* case 2 */
    } /* end switch */
    return FALSE;
}


static gboolean unsel(GtkTreeModel *,GtkTreePath *, GtkTreeIter *, gpointer);

G_MODULE_EXPORT
gboolean treeclick(GtkWidget * widget, GdkEventButton * event, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) data;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    treestuff_t *treestuff=get_treestuff(treeview);
    record_entry_t *en;
    GtkTreePath *treepath;
    GtkTreeIter iter,child;
    gchar *newpath=NULL;
    int type;
    gint tree_id;
    gboolean double_click=FALSE;
    widgets_t *widgets_p=&(xffm_details->arbol->widgets);

    xffm_details->eventtime = event->time;

    mousedown=TRUE;
    easy_mode=FALSE;

    xffm_details->comm &= (COMM_IGNORE_RELEASE^0xffffffff);
    TRACE("callbacks ignore second releas=%d... \n",xffm_details->comm & COMM_IGNORE_RELEASE); 

    /*dnd_mouse_moved=FALSE;*/
    if(xffm_details->arbol->loading)
	return TRUE;

    if(widgets_p->input)
    {
	treeview_cancel_input(NULL,NULL);
    }
    skip_second_release = FALSE;

    for (tree_id=0; tree_id<TREECOUNT; tree_id++) {      
      /*printf("TRACE: treeview is  0x%x==0x%x\n",xffm_details->arbol->treestuff[tree_id].treeview,treeview);*/
      if (treeview != xffm_details->arbol->treestuff[tree_id].treeview){
        /* unselect all in auxiliary treeview */
        GtkTreeSelection *selection = gtk_tree_view_get_selection(xffm_details->arbol->treestuff[tree_id].treeview);
	gtk_tree_model_foreach(xffm_details->arbol->treestuff[tree_id].treemodel,unsel,selection);
      }
    }
    
    if((event->type == GDK_2BUTTON_PRESS) && (event->button == 1) && !(event->state & GDK_CONTROL_MASK)){ 
	gdouble h=(event->x - mouseX)*(event->x - mouseX)+(event->y - mouseY)*(event->y - mouseY);
	/*printf("h is %lf (%lf,%lf)--(%lf,%lf)\n",h,event->x ,event->y,mouseX,mouseY);*/
	if (h < 25) double_click=TRUE;
    }
		
	
    if(double_click)
    {	/* this works because item is selected at first click of double click */
	skip_second_release=TRUE; /* skip the second button release event */
	if (reselecttimer)g_source_remove(reselecttimer);
		    /*printf("TRACE:canceled reselecttimer = %d\n",reselecttimer );*/
	reselecttimer=0;
	

	gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
	if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
	{
	    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	    if (!en || !en->path) goto done;
	    if (en && en->exec) {
		GError *error=NULL;
		if (!g_spawn_command_line_async (en->exec,&error)){
		    print_diagnostics(&(xffm_details->arbol->widgets),
			    "xfce/error",error->message,NULL);
		    g_error_free(error); 
		}
		goto done;
	    }

	    newpath = g_strdup(en->path);
	    type = en->type;
	    if ((IS_DIR(en->type) && FSTAB_is_in_fstab(en->path))
		    || IS_XF_NETSHARE(en->subtype)){
		gpointer result;
		result=function_rational("plugins","xffm_fstab",en,&(xffm_details->arbol->widgets),"fstab_mount");
		if (result && IS_XF_NETSHARE(en->subtype)){
		    go_to(xffm_details->arbol->treestuff+get_tree_id(treeview),result);
		}
		goto done;
	    }
	    if(IS_DUMMY_TYPE(en->type) && en->path && strcmp(en->path, "..") == 0)
	    {
		tb_go_up((GtkButton *) xffm_details->arbol->widgets.window, NULL);
		goto done;
	    }
	    if (IS_DUMMY_TYPE(en->type)) goto done;
	    if (!g_file_test(en->path,G_FILE_TEST_EXISTS)){
		const gchar *module_name=get_selected_module_name();
		if (module_name) {
		    TRACE("module business here...");
		    function_rational("plugins",module_name,en,&(xffm_details->arbol->widgets),"double_click");
		}
		goto done;
	    }
	    

	    if(IS_PATH(en->type))
	    {
		if (IS_DIR(en->type))
		{
		    /*pushgo(treestuff, newpath);*/
		    if (!IS_LOCAL_TYPE(en->type)){
    			GtkTreePath *treepath;
			treepath = gtk_tree_model_get_path(treemodel, &iter);
		    	gtk_tree_selection_unselect_path (selection,treepath);
		    	gtk_tree_path_free(treepath);
		    }
		    /* this is always an absolute path */
		    go_to(treestuff, newpath);
		}

		else if(IS_EXE(en->type) )
		{	/* run it (if not registered)*/
			const gchar *prg = MIME_command (en->path);
			if (prg) treeview_double_click_open_with(en);
			else {
    				/*  assume in_term to be safe */
    				SET_IN_TERM(en->subtype);
				xffm_double_click_run(&(xffm_details->arbol->widgets),en);
			}
			if (en->path) RECENT_add2history(&(xffm_details->arbol->widgets),en->path);
		} else 
		{      /* open with */
			treeview_double_click_open_with(en);
			if (en->path) RECENT_add2history(&(xffm_details->arbol->widgets),en->path);
		}
	    }
       	    else if(gtk_tree_model_iter_children(treemodel, &child, &iter)){
       		GtkTreePath *treepath;
       		treepath = gtk_tree_model_get_path(treemodel, &iter);
		gtk_tree_view_expand_row(treeview, treepath, FALSE);
       		gtk_tree_path_free(treepath);
	    }
done:
	    g_free(newpath);
	    newpath=NULL;
	}
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	return TRUE;
    }

    switch (event->button)
    {
	default:
	    break;
	case 2:	
	    /* needs to be exported for this, but then also
	     * needs to be treeview namespaced...
	     * if ((event->state & GDK_CONTROL_MASK)){
    		on_iconview_activate(NULL,NULL);
	    }*/

	    return TRUE;	
	    /* this disables dnd (wrong), but also selection (right)*/
#if 0
	       return FALSE; 
	    /* this enables dnd(right), but also selection(wrong)*/
#endif
	case 3:
	    treeview_clear_dnd_selection_list(); /* only currently selected items */
	    /* if control not pressed, unselect other rows...*/
	    /*if (event->state != GDK_CONTROL_MASK){*/
	    if (!(event->state & GDK_CONTROL_MASK)){
    		gtk_tree_model_foreach(treemodel,unsel,selection);
	    }
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, 
				    event->y, &treepath, 
				    NULL, NULL, NULL))
	    {
		gtk_tree_selection_select_path(selection,treepath);    
		gtk_tree_model_get_iter (treemodel,&iter,treepath); 
	        gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		if (!IS_PATH(en->type) && ! IS_NETTHING(en->subtype) ) {
		    /*this unselects other stuff: */
		    gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
		} else {
    	           gtk_tree_selection_selected_foreach(selection, treeview_get_dnd_selection, (gpointer) treeview);
		}
	       	gtk_tree_path_free(treepath);
	    }
	    do_popup(treeview, event);
	    return TRUE;
	case 1: 
	/* case BUTTON_1: */

	    treeview_clear_dnd_selection_list();
	    print_status(&(xffm_details->arbol->widgets),NULL,_("Reading..."),NULL);
	    cursor_wait(xffm_details->arbol->widgets.window);
	    process_pending_gtk();
	    if(gtk_tree_view_get_path_at_pos(treeview, event->x, event->y, 
				    &treepath, NULL, NULL, NULL))
	    {
		gtk_tree_model_get_iter(treemodel, &iter, treepath);
		gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
		treeview_update_status_line(en);	
		set_path_reference(treeview,treepath);
	        gtk_tree_path_free(treepath);
	    }
		 
	    
		 
	    g_timeout_add_full(0, 250, (GtkFunction) delayed_selection, (gpointer) treeview, NULL);

	    if(gtk_tree_view_get_path_at_pos(treeview, event->x,  event->y, &treepath, NULL, NULL, NULL))
	    {	
		easy_mode = gtk_tree_selection_path_is_selected (selection,treepath);
		if (clickpath) gtk_tree_path_free(clickpath);
		clickpath=gtk_tree_path_copy(treepath);
	    }
	    return FALSE;
    }
    return FALSE;
}

G_MODULE_EXPORT
void treeview_double_click_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GdkEventButton event;
    event.button = 1;
    event.type = GDK_2BUTTON_PRESS;
    event.x = mouseX;
    event.y = mouseY;
    treeclick((GtkWidget *) menuitem, &event, user_data);
}

/**** callbacks ********/

static gboolean unsel(GtkTreeModel * treemodel, 
		GtkTreePath * treepath, 
		GtkTreeIter * iter, 
		gpointer data)
{
    GtkTreeSelection *selection = (GtkTreeSelection *)data;
    gtk_tree_selection_unselect_path (selection,treepath);
    return FALSE;
}



