G_MODULE_EXPORT
void gridview_run_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    if (icon_view_p) gridview_show_input(RUN_INPUT,icon_view_p);
}
G_MODULE_EXPORT
void 
gridview_double_click_open_with(		record_entry_t *en,icon_view_t *icon_view_p)
{
    widgets_t *widgets_p=&(icon_view_p->widgets);
    /* open with */
    gchar *name;
    int argc;
    gchar **argv;
    const gchar *command;
    const gchar *command_fmt;
    GError *error=NULL;
    
    if (!en || !en->path) return;
    name=g_path_get_basename(en->path);
    
    
    command_fmt = MIME_command(name);
    
    if(!command_fmt)
    {
	gridview_show_input(RUN_DOUBLE_CLICK,icon_view_p);
	print_status(widgets_p,"xfce/question",name,NULL);
    } else {
        gchar *wd=g_path_get_dirname((const gchar *)en->path);	    
	command =  MIME_mk_command_line(command_fmt,name,FALSE,FALSE);


	g_shell_parse_argv (command, &argc,&argv,&error);
	if (error){
	    gchar *msg = g_strcompress (error->message);
	    print_diagnostics(widgets_p,"xfce/error",msg,":\n",command,"\n",NULL);
	    g_error_free(error);
	    g_free (msg);
	    g_free(wd);
	    return;
	}
	xffm_runvwd(widgets_p,wd,argv);
	g_free(wd);
	g_strfreev (argv); 
    }
    g_free(name);
    return;
}

G_MODULE_EXPORT
void gridview_print_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gboolean valid_path=FALSE;
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    widgets_t *widgets_p=&(icon_view_p->widgets);
   
    TRACE("gridview_print_activate");
    if (icon_view_p->selection_list) {
	GList *tmp;
	for (tmp=icon_view_p->selection_list; tmp; tmp=tmp->next){
	    record_entry_t *en=(record_entry_t *)tmp->data;
	    if (en && IS_FILE(en->type)) {
		valid_path=TRUE;
		break;
	    }
	}
    }
    if(!valid_path)
    {
	show_text(widgets_p->diagnostics);
	print_diagnostics(widgets_p,"xfce/error", strerror(EINVAL),"\n", NULL);
	return;
    }
    gridview_show_input(PRINT_INPUT,icon_view_p);
}


static
void
on_autotype_R                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    record_entry_t *en;
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    en=icon_view_p->en;
    gridview_double_click_open_with(en,icon_view_p);
    return;
}

static
void on_iconview_activate(GtkMenuItem *w,gpointer data){
    icon_view_t *icon_view_p=(icon_view_t *)data;

	record_entry_t *en=copy_entry(icon_view_p->en);
	icon_view_t *icon_view_target=create_iconview(en);	    
	cursor_wait(icon_view_target->widgets.window);
	icon_view_target->preferences = icon_view_p->preferences;
	icon_view_target->sortcolumn = icon_view_p->sortcolumn;
	icon_view_target->module_name=icon_view_p->module_name;
 	reload_iconview(icon_view_target, en, TRUE); 
	return;
}

static 
void gridview_open_in_terminal_activate(GtkMenuItem * menuitem, gpointer data)
{
    gchar *path=NULL;
    icon_view_t *icon_view_p=(icon_view_t *)data;
#if 0
/* is a directory selected? */
    if (icon_view_p->selection_list && icon_view_p->selection_list->data){
	record_entry_t *en=icon_view_p->selection_list->data;
	if (g_file_test(en->path,G_FILE_TEST_IS_DIR)){
	    path=g_strdup(en->path);
	}
    }
#endif
    if (!path && icon_view_p->en && icon_view_p->en->path) path=g_strdup(icon_view_p->en->path);
    xffm_new_terminal_path(&(icon_view_p->widgets),path);
    g_free(path);
    return;
}
   
static
void gridview_differences_activate(GtkMenuItem * menuitem, gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    gchar *file1 = NULL, *file2 = NULL;
    
    if (icon_view_p->selection_list) {
	    file1 = ((record_entry_t *)(icon_view_p->selection_list->data))->path;
	    if (g_list_length(icon_view_p->selection_list)>1)
		file2 = ((record_entry_t *)(icon_view_p->selection_list->next->data))->path;
	
    }
    TRACE("xfdiff %s %s",(file1?file1:"null"),(file2?file2:"null"));
    xffm_diff(&(icon_view_p->widgets),file1, file2);
}

static
void on_xfce_setting_show(GtkMenuItem *w,gpointer data){
    icon_view_t *icon_view_p=(icon_view_t *)data;
    gchar *argv[]={"xfce-setting-show",NULL};
    xffm_runvwd(&(icon_view_p->widgets),NULL,argv);
    return;
 
}
static
void on_newdir_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en=NULL;
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    if (icon_view_p) en=icon_view_p->en;
    if(!en) return;
    gridview_show_input(NEW_DIR_INPUT,icon_view_p);
}

static
void on_newfile_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en=NULL;
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    if (icon_view_p) en=icon_view_p->en;
    if(!en) return;
    gridview_show_input(NEW_FILE_INPUT,icon_view_p);
}
 
static
void on_open_with_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en;
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    en=icon_view_p->en;
    if(!en){
	gridview_show_input(RUN_INPUT,icon_view_p);
    }
    else
    {
	gridview_show_input(RUN_DOUBLE_CLICK,icon_view_p);
	print_status(&(icon_view_p->widgets),"xfce/question", _("Input requested"), NULL);
    }
}
   
static int
autofunction_workdir  (	icon_view_t *icon_view_p,
			record_entry_t *en,
			const gchar *querypath) 
{
    widgets_t *widgets_p;
    
    widgets_p=&(icon_view_p->widgets);

         
  g_free(workdir);
  workdir=NULL;
  if (querypath){
      workdir=g_strdup(querypath); 
	/* remove any previous gtk loop: */ 
	gridview_cancel_input(NULL,icon_view_p);    
	/* this starts a new gtk loop */
	gridview_show_input(WORKDIR_INPUT,icon_view_p);
      /* on returning from the loop, xffm_details->input == OTHER_INPUT
       * means it was cancelled by button press, or menu selection */
      if (widgets_p->input == OTHER_INPUT) return FALSE;
      widgets_p->input = OTHER_INPUT;
      if (!workdir){
	 print_status(widgets_p,"xfce/warning",strerror(ENOTDIR),NULL);
	 return FALSE;
      }	 
  } else {
  	workdir=g_path_get_dirname (en->path);
  }
  if(!workdir || chdir(workdir)<0){
	 print_status(widgets_p,"xfce/error",strerror(errno), NULL);
	 g_free(workdir);
	 workdir=NULL;
	 chdir(GETWD);
	 return FALSE;
  }
  chdir(GETWD);
  return TRUE;
}


G_MODULE_EXPORT
void
gridview_autotype_C                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    const gchar *command;
    const gchar *dirname;
    static gchar *new_command=NULL;
    gboolean *queued;
    const gchar *querypath,*output_arg,*output_ext;
    record_entry_t *en;
    gint argc;
    gchar **argv;
    GError *error=NULL;
    record_entry_t *tmp_en=NULL;
    icon_view_t *icon_view_p=g_object_get_data(G_OBJECT(menuitem),"gui_data");
    widgets_t *widgets_p=&(icon_view_p->widgets);
  

    en=icon_view_p->en;
    if (IS_NETFILE(en->subtype)){
	const gchar *file=XF_SMBget_cache_file(en,widgets_p);
	tmp_en = stat_entry ((gchar *)file, __LOCAL_TYPE);
	en=tmp_en;
    }
    output_arg=g_object_get_data(G_OBJECT(menuitem),"output_arg");
    command=g_object_get_data(G_OBJECT(menuitem),"command");
    dirname=g_object_get_data(G_OBJECT(menuitem),"workdir");
    querypath=g_object_get_data(G_OBJECT(menuitem),"querypath");
    queued=g_object_get_data(G_OBJECT(menuitem),"queued");
    output_ext=g_object_get_data(G_OBJECT(menuitem),"output_ext");
    if (output_arg && !output_ext) g_warning("output_arg && !output_ext not met"); 
    if (querypath && !autofunction_workdir (icon_view_p, en,querypath)) {
	if (tmp_en) destroy_entry(tmp_en);
	return;
    }
    
    if (output_arg) {
	gchar *outputdir=workdir;
	/*workdir=g_path_get_dirname(en->path);*/
	workdir=g_strdup(dirname);
	TRACE("output dir is %s",outputdir);
	if (new_command) g_free(new_command);
	new_command = g_strconcat(command," \"",outputdir,G_DIR_SEPARATOR_S,output_arg,output_ext,"\" \"",output_arg,"\"",NULL);
	command = (const gchar *)new_command;
	g_free(outputdir);
    } else if (!querypath)
    {
	g_free(workdir);
	/*workdir=g_path_get_dirname(en->path);*/
	workdir=g_strdup(dirname);
	TRACE("*****workdir is %s",workdir);
    } else if (!workdir)
    {
	g_warning("workdir==NULL");
	return;
    }
    
    TRACE("output_arg=%s, command=%s, querypath=%s, output_ext=%s, workdir=%s",
	    output_arg, command, querypath, output_ext, dirname);
    
    g_shell_parse_argv (command, &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics(widgets_p,"xfce/error",msg,": ",command,"\n",NULL);
	g_error_free(error);
	g_free (msg);
    }
    
    TRACE("queued=0x%x (%d)",(unsigned)queued,((queued)? *queued : 0));
    if (queued==NULL || *queued == FALSE){
       if (xffm_runvwd(widgets_p,workdir,argv)){
	    if (en && en->path) RECENT_add2history(widgets_p,en->path);
       }
	g_strfreev (argv);
	if (tmp_en) destroy_entry(tmp_en);
       return;
    } 

    
    gui_autofunction(&(icon_view_p->widgets),en,argv,(queued && *queued));
    
    chdir(GETWD);
    if (workdir && strcmp(workdir,GETWD)!=0) print_diagnostics(widgets_p,NULL,"$chdir ",GETWD,"\n",NULL);
    g_strfreev (argv);
    if (tmp_en) destroy_entry(tmp_en);

	
}


static
void gridview_up_activate (GtkMenuItem * menuitem, gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!icon_view_p) {
	g_warning("!icon_view_p");
    }
    else {
	if (icon_view_p->population_pp && icon_view_p->population_pp[0]){
	    record_entry_t *en;
	    if (icon_view_p->population_pp[0]->en &&
		    !IS_DUMMY_TYPE(icon_view_p->population_pp[0]->en->type)) 
		return;
	    en=copy_entry(icon_view_p->population_pp[0]->en);
	    push_iconview_go_history(icon_view_p);
	    if (icon_view_p->population_pp[0]->en) icon_view_p->module_name=icon_view_p->population_pp[0]->en->module;
	    else icon_view_p->module_name=NULL;
	    reload_iconview(icon_view_p,en,TRUE);
	}
    }
}
static
void gridview_home_activate (GtkMenuItem * menuitem, gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!icon_view_p) {
	g_warning("!icon_view_p");
    } else {
	record_entry_t *en=stat_entry((gchar *) g_get_home_dir(),__ROOT_TYPE | __LOCAL_TYPE );
	push_iconview_go_history(icon_view_p);
	icon_view_p->module_name=NULL;
	reload_iconview(icon_view_p,en,FALSE);
    }
}

static
void gridview_jump_to_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    gridview_show_input(GOTO_INPUT,icon_view_p);
}

static
void gridview_back_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    GList *last;
    record_entry_t *en;
    TRACE("iconview goback");
    if (!icon_view_p) {
	g_warning("!icon_view_p");
	return;
    }
    last=g_list_last(icon_view_p->go_list);
    if (!last) return;
    en=last->data;	    
    if (en) icon_view_p->module_name=en->module;
    else icon_view_p->module_name=NULL;
    reload_iconview(icon_view_p,en,FALSE);
    pop_iconview_go_history(icon_view_p);
}


extern
void
mk_text_entry(icon_view_t *icon_view_p, population_t *population_p, int caso);
/*********************** private callbacks ************************************/
#define RENAME_CASO 	0
#define DUPLICATE_CASO 	1
#define SYMLINK_CASO 	2

static 
gboolean
easy_data_test(icon_view_t *icon_view_p){
    if(!icon_view_p->en || !IS_PATH(icon_view_p->en->type) || !icon_view_p->selected_p || !icon_view_p->selected_p->en)
    {
	print_status(&(icon_view_p->widgets),"xfce/error", strerror(EINVAL), NULL);
	return FALSE;
    }
   return TRUE;
}

static
void gridview_rename_activate(GtkMenuItem * menuitem, gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!easy_data_test(icon_view_p)) return;
    mk_text_entry(icon_view_p, icon_view_p->selected_p, RENAME_CASO);
}
 
static
void gridview_duplicate_activate(GtkMenuItem * menuitem, gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!easy_data_test(icon_view_p)) return;
    mk_text_entry(icon_view_p, icon_view_p->selected_p, DUPLICATE_CASO);
}

static
void gridview_symlink_activate(GtkMenuItem * menuitem, gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!easy_data_test(icon_view_p)) return;
    mk_text_entry(icon_view_p, icon_view_p->selected_p, SYMLINK_CASO);
}
   
static
void gridview_unselect_all_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    icon_view_t *icon_view_p =(icon_view_t *)user_data;
    if (!icon_view_p) return;
    unselect_all_iconview(icon_view_p);
}

static
void gridview_select_all_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    icon_view_t *icon_view_p =(icon_view_t *)user_data;
    int items=0;
    if (!icon_view_p) return;
	
    print_status(&(icon_view_p->widgets),"xfce/info",_("Select all"),"...",NULL);
    cursor_wait(icon_view_p->widgets.window);
    while (gtk_events_pending()) gtk_main_iteration();
    items=select_all_iconview(icon_view_p);
    {
	gchar *g=g_strdup_printf(_("%d item(s) selected"),items);
	print_status(&(icon_view_p->widgets),"xfce/info",g,NULL);
	g_free(g);
    }
    cursor_reset(icon_view_p->widgets.window);
}

void gridview_touch_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    record_entry_t *en=NULL;
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
   
    if (icon_view_p && icon_view_p->selection_list && icon_view_p->selection_list->data) {
	 en=(record_entry_t *)icon_view_p->selection_list->data;
    }
 
    if(!en || !IS_PATH(en->type))
    {
	print_status(&(icon_view_p->widgets),"xfce/error", strerror(EINVAL), NULL);
	return;
    }
    xffm_touch(&(icon_view_p->widgets),en->path);
    return;
}

/***   properties_callbacks  ***/


static
void 
gridview_on_prop_activate(GtkMenuItem * menuitem, gpointer user_data) {
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    TRACE("on_prop_activate icon_view_p=0x%x",(unsigned)icon_view_p);
    if (!icon_view_p) return;
    PROP_do_prop(&(icon_view_p->widgets), icon_view_p->selection_list);
#ifndef LINKED_MODULES
    unload_prop_module();
#endif
}


/*********   find callbacks   *********/

static
void 
gridview_glob_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    TRACE("on_find_activate icon_view_p=0x%x",(unsigned)icon_view_p);
    if (!icon_view_p || !icon_view_p->en || !icon_view_p->en->path) {
	TRACE("on_find_activate no path");
	FIND_do_find((GtkWidget *) menuitem);
    } else  {
	TRACE("on_find_activate path=%s",icon_view_p->en->path);
	FIND_do_find_path((GtkWidget *) menuitem,icon_view_p->en->path);
    }
}

static
void 
gridview_host_activate(GtkMenuItem * menuitem, gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    record_entry_t *en=NULL;
    if (!icon_view_p) return;
    push_iconview_go_history(icon_view_p);
    reload_iconview(icon_view_p,en,FALSE);
}


static
void 
gridview_select_by_filter(GtkMenuItem * menuitem, gpointer data)
{
    const gchar *filter_s;
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!icon_view_p) return;
    filter_s = gui_get_response(&(icon_view_p->widgets),_("Select by filter"),_("File filter : "));

    if (filter_s && strlen(filter_s)) {
	select_byfilter_iconview(icon_view_p, filter_s);
    }
    return;
}
 
static 
void       
gridview_hidden_toggled (GtkToggleButton *togglebutton, gpointer data){
    record_entry_t *en;
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!data) return;
    if (icon_view_p->redlight) return;
    if (icon_view_p->en && icon_view_p->en->path) unlink(get_local_cache_path(icon_view_p->en->path));

    icon_view_p->preferences ^= __SHOW_HIDDEN;
    en=copy_entry(icon_view_p->en);

    save_iconview_preferences(icon_view_p);
    reload_iconview(icon_view_p,en,FALSE);
}

static 
void       
gridview_preview_toggled (GtkToggleButton *togglebutton, gpointer data){
    record_entry_t *en;
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!data) return;
    if (icon_view_p->redlight) return;
    icon_view_p->preferences ^= __SHOW_IMAGES;
    en=copy_entry(icon_view_p->en);
    save_iconview_preferences(icon_view_p);
    reload_iconview(icon_view_p,en,FALSE);
}

/* sort type radio: */
static 
void       
gridview_on_radio (GtkCheckMenuItem *checkmenuitem, gpointer user_data){
    record_entry_t *en;
    icon_view_t *icon_view_p=(icon_view_t *)g_object_get_data(G_OBJECT(checkmenuitem),"gui_data");
    if (!icon_view_p) return;
    if (icon_view_p->redlight) return;
    en = copy_entry(icon_view_p->en);
    icon_view_p->sortcolumn = GPOINTER_TO_INT(user_data);
    save_iconview_preferences(icon_view_p);
    reload_iconview(icon_view_p,en,FALSE);
}

static
void 
on_ascending (GtkMenuItem * menuitem, gpointer data){
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!icon_view_p || icon_view_p->redlight) return;
    if (icon_view_p){
	record_entry_t *en=copy_entry(icon_view_p->en);
	icon_view_p->preferences |= SORT_ASCENDING;
	save_iconview_preferences(icon_view_p);
	reload_iconview(icon_view_p,en,FALSE);
	return;
    } 
}

static
void 
on_descending (GtkMenuItem * menuitem, gpointer data){
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (!icon_view_p || icon_view_p->redlight) return;
    if (icon_view_p){
	record_entry_t *en=copy_entry(icon_view_p->en);
	icon_view_p->preferences &= (SORT_ASCENDING^0xffffffff);
	save_iconview_preferences(icon_view_p);
	reload_iconview(icon_view_p,en,FALSE);
	return;
    } 
}

static
void on_treeview_activate(GtkMenuItem * menuitem, gpointer user_data) {
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    const gchar *program="xffm-treeview";
    const gchar *argument=NULL;
    if (icon_view_p && icon_view_p->en && icon_view_p->en->path){
	if (icon_view_p->en && icon_view_p->en->path && g_file_test(icon_view_p->en->path,G_FILE_TEST_IS_DIR)){
	    program="xftree4";
	    argument=icon_view_p->en->path;
	} else if (icon_view_p->module_name){
	    if (function_void("plugins",icon_view_p->module_name,"exec_name"))
		program=function_void("plugins",icon_view_p->module_name,"exec_name");
	}
    }
    if (fork()==0){
	execlp(program,program,argument,NULL);
	_exit(123);
    }
}

G_MODULE_EXPORT
void gridview_remove_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    widgets_t *widgets_p;
    record_entry_t *new_en;
    icon_view_p->redlight=TRUE;
    widgets_p = &(icon_view_p->widgets);
    xffm_remove(widgets_p,icon_view_p->selection_list);
    if (icon_view_p->en && icon_view_p->en->path) unlink(get_local_cache_path(icon_view_p->en->path));
    new_en = copy_entry(icon_view_p->en);
    icon_view_p->redlight=FALSE;
    reload_iconview(icon_view_p,new_en,FALSE);
}


static
void
private_mount   (icon_view_t *icon_view_p, int mounted){
    record_entry_t *en=NULL;

    if (icon_view_p->selected_p && icon_view_p->selected_p->en) {
	en=icon_view_p->selected_p->en;
    }
    TRACE("<<<<<<<<<<< on mount %d (0x%x)",mounted,(unsigned)icon_view_p);
    if(!en || !en->path) {
	g_warning("no entry to mount");
	return;
    }
    if (mounted) SET_MOUNTED(en->type); else UNSET_MOUNTED(en->type);
    FSTAB_fstab_mount(en,&(icon_view_p->widgets));
    TRACE("<<<<<<<<<<< on mount done");
}


G_MODULE_EXPORT
void
gridview_mount   (GtkMenuItem     *menuitem, gpointer         user_data){
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    private_mount(icon_view_p, FALSE);
}
G_MODULE_EXPORT
void
gridview_unmount   (GtkMenuItem     *menuitem, gpointer         user_data){
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    private_mount(icon_view_p, TRUE);
}



/*   pasteboard callbacks   */

static void private_paste(widgets_t *widgets_p, icon_view_t *icon_view_p, gboolean symlink)
{
    gboolean cut;
    GList *list=NULL;
    record_entry_t *t_en = NULL;
    int i;

    if(!xffm_details->pastepath) return;
    if ((t_en=icon_view_p->en)==NULL) return;
    
    TRACE("TRACE:pastepath=%s\n",xffm_details->pastepath);
    
    if ((i=pasteboard_list(&list))==0) return;
    if (i==1) cut=TRUE; else cut=FALSE;
    i=pasteboard_transfer(widgets_p, t_en,list, icon_view_p,  cut,  symlink);
     
    list = uri_free_list(list);
		
    if (i) {
	record_entry_t *new_en=copy_entry(icon_view_p->en);
        if (icon_view_p->en && icon_view_p->en->path) unlink(get_local_cache_path(icon_view_p->en->path));
	reload_iconview(icon_view_p,new_en,FALSE);
	if(cut) XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);
    }
    return;
}


static 
void update_pasteboard_icons(icon_view_t *icon_view_p){
    int i;
    for (i=0; i<icon_view_p->max_elements; i++){
        population_t *population_p=icon_view_p->population_pp[i];
        if (population_p && population_p->en && IS_CUT(population_p->en->type) )
        {
	    gridview_set_icon(icon_view_p, (icon_view_p->population_pp[i])->en);
	}
    }
}

static 
void copy_cut_callback(gboolean cut, gpointer data){
    GList *tmp;
    GList *list=NULL;
    icon_view_t *icon_view_p=(icon_view_t *)data;
    widgets_t *widgets_p = &(icon_view_p->widgets);
    for (tmp=icon_view_p->selection_list;tmp;tmp=tmp->next){
        list=g_list_append(list,tmp->data);
    }
    if (!list) return;
    pasteboard_copy_cut(widgets_p,cut,&list);
    update_pasteboard_icons(icon_view_p);
    if (cut) for(tmp = list; tmp; tmp = tmp->next){
        record_entry_t *en=(record_entry_t *)tmp->data;
        gridview_set_icon(icon_view_p, en);
    }
    g_list_free(list);
}

G_MODULE_EXPORT
void gridview_cut_activate(GtkMenuItem * menuitem, gpointer data)
{
    copy_cut_callback(TRUE, data);
    return;
}



G_MODULE_EXPORT
void gridview_copy_activate(GtkMenuItem * menuitem, gpointer data)
{
    copy_cut_callback(FALSE, data);
    return;
}

static
void paste_callback(gboolean symlink, gpointer data){
    icon_view_t *icon_view_p=(icon_view_t *)data;
    widgets_t *widgets_p = &(icon_view_p->widgets);
    if (!icon_view_p->en) return;
    xffm_details->pastepath = icon_view_p->en->path;
    private_paste(widgets_p, icon_view_p, symlink);
}

G_MODULE_EXPORT
void gridview_paste_activate(GtkMenuItem * menuitem, gpointer data)
{
    paste_callback(FALSE, data);
    return;
}

G_MODULE_EXPORT
void gridview_pastelink_activate(GtkMenuItem * menuitem, gpointer data)
{
    paste_callback(TRUE, data);
    return;
}


G_MODULE_EXPORT
void gridview_list_pasteboard_activate(GtkMenuItem * menuitem, gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    if (icon_view_p) pasteboard_show(&(icon_view_p->widgets));
}


G_MODULE_EXPORT
void gridview_clear_pasteboard_activate(GtkMenuItem * menuitem, gpointer user_data)
{

    XStoreBuffer(GDK_DISPLAY(), "", 1, CUT_BUFFER);	/* store a null string */
}

G_MODULE_EXPORT
gint gridview_refresh(widgets_t *widgets_p)
{
    icon_view_t *icon_view_p=(icon_view_t *)widgets_p->parent;
    record_entry_t *en=copy_entry(icon_view_p->en);
    if (icon_view_p->en && icon_view_p->en->path) 
	unlink(get_local_cache_path(icon_view_p->en->path));
    return reload_iconview(icon_view_p,en,FALSE);
}

static
void gridview_refresh_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    icon_view_t *icon_view_p=(icon_view_t *)user_data;
    gridview_refresh(&(icon_view_p->widgets));
    return;
}


