/*
 * Copyright (C) 2002-5 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <ctype.h>

#include <errno.h>
#include <limits.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"
#include "primary.h"
#include "secondary.h"

#include "gridview_lib.h"
#include "gridview_input.h"

#include "actions_lib.h"



#define PRINT_STATUS_INPUT print_status(widgets_p,"xfce/question", _("Input requested"), NULL)
#define PRINT_STATUS_DONE print_status(widgets_p,"xfce/info", _("Command done"), NULL)
	
static icon_view_t *combo_icon_view_p=NULL;


extern gchar *workdir;



static
void set_new_combo(icon_view_t *icon_view_p)
{
    GtkWidget *w = lookup_widget(icon_view_p->widgets.window,"input_combo");
    GList *new_list = NULL;
    record_entry_t *en;
    char *path;

    TRACE("set_new_combo");

    if (!icon_view_p){
	g_warning("!icon_view_p");
	return;
    }
    en=icon_view_p->en;
    if (!icon_view_p->en || ! icon_view_p->en->path){
	g_warning("!icon_view_p->en || ! icon_view_p->en->path");
	return;
    }
    
    path = g_strdup(en->path);
    if(!IS_DIR(en->type)) *(strrchr(path, '/')) = 0;
    if (IS_NETTHING(en->subtype)) new_list = g_list_append(new_list,  _("New"));
    else new_list = g_list_append(new_list, (gchar *)xffm_new_name(path, _("New")));
    gtk_combo_set_popdown_strings(GTK_COMBO(w), new_list);
    g_list_free(new_list);
    g_free(path);
    path=NULL;
}

static gchar *fix_relative_path(icon_view_t *icon_view_p,gchar *choice){
    gchar *g=NULL;
    /* invalid stuff */
    if (!choice || !icon_view_p) return NULL; 
    if (!strlen(choice)) return g_strdup(choice); 
    /* network stuff */
    if (strncmp(choice,"//",2)==0) return g_strdup(choice); 
    /* absolute path */
    if (*choice == G_DIR_SEPARATOR && g_file_test((const gchar *)choice,G_FILE_TEST_IS_DIR)) return g_strdup(choice); 
    if (icon_view_p->en && icon_view_p->en->path){
        g=g_strconcat(icon_view_p->en->path,G_DIR_SEPARATOR_S,choice,NULL);    
    }
    if (g && g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)) {
        return g;
    }
    /* relative to homedir, maybe */
    g_free(g);
    g=g_strconcat(GETWD,G_DIR_SEPARATOR_S,choice,NULL);
    if (g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)) {
        return g;
    }
    g_free(g);
    return g_strdup(choice);
}



/* **********************private*********************** */
static void check1_toggle (GtkToggleButton *togglebutton, gpointer data){
    widgets_t *widgets_p=(widgets_t *)data;
    GtkWidget *check = lookup_widget(widgets_p->window,"checkbutton3");
    if (widgets_p->input != RUN_INPUT && widgets_p->input !=  RUN_DOUBLE_CLICK) return;
    gtk_button_set_label((GtkButton *) check, _("Hold"));
    if (!gtk_toggle_button_get_active (togglebutton)) gtk_widget_hide(check); 
    else gtk_widget_show(check);
}




static
const gchar *
get_selection_list_path(icon_view_t *icon_view_p){
    GList *tmp,*selection_list;
    int list_path_length=0;
    static gchar *list_path=NULL;
    g_free(list_path);
    list_path=NULL;

    selection_list=icon_view_p->selection_list;
    
    for (tmp = selection_list; tmp; tmp=tmp->next)
    {
	record_entry_t *en;
	en=(record_entry_t *) tmp->data;
	list_path_length += (strlen(en->path)+3);
    }
    list_path =(gchar *)malloc(list_path_length+1);
    memset(list_path,0,list_path_length+1);

    if (!list_path) return NULL;
    strcpy(list_path,"");
    for (tmp = selection_list; tmp; tmp=tmp->next)
    {
	record_entry_t *en;
	en=(record_entry_t *) tmp->data;
	strcat(list_path,"\"");
	strcat(list_path,en->path);
	strcat(list_path,"\"");
	if (tmp->next) strcat(list_path," ");
    }
    return (const gchar *) list_path;
}

static
void private_ok_input (icon_view_t *icon_view_p)
{
    /*gboolean result;*/
    gchar *choice;
    GtkEntry *entry;
    record_entry_t *en;
    gchar *nfile=NULL;
    xfc_combo_info_t **combo_info;
    widgets_t *widgets_p=&(icon_view_p->widgets);


    combo_info=(xfc_combo_info_t **)(&(widgets_p->combo_info));

    TRACE("-*************at input ok,widgets_p->input=%d (%d,%d,%d)",widgets_p->input,NEW_FILE_INPUT, NEW_DIR_INPUT,NEW_INPUT);

    print_status(widgets_p,NULL," ",NULL);
    entry = (GtkEntry *) lookup_widget(widgets_p->window,"input_entry");
    choice = g_strdup(XFC_get_entry(*combo_info));

    gtk_widget_hide(lookup_widget(widgets_p->window,"input_box"));
   

    if (!choice && widgets_p->input==NEW_WIN_INPUT){
	choice=g_strdup(g_get_home_dir());
    }
    if (!choice) {
	TRACE("!choice\n");
	return;
    }
    g_strstrip(choice);
    if (!strlen(choice)) {
	g_free(choice); 
	TRACE("!strlen(choice)\n");
	return;
    }


    TRACE("*************at input ok,xffm_details->input=%d (%d,%d,%d)",widgets_p->input,NEW_FILE_INPUT, NEW_DIR_INPUT,NEW_INPUT);
    switch (widgets_p->input)
    {
	default:
	    break;
	case WORKDIR_INPUT:
	    g_free(workdir);
	    workdir=g_strdup(choice);
	    if (g_file_test((const gchar *)workdir,G_FILE_TEST_IS_DIR)){
		save_workdir_history(workdir);
	    }
    	    g_free(choice);
	    choice=NULL;
	    /* OTHER_INPUT should cancel whatever is waiting on gtk loop */
    	    /*xffm_details->input = OTHER_INPUT;*/
	    gtk_main_quit();
	    gtk_paned_set_position(GTK_PANED(widgets_p->vpane), 10000);
	    return;
	case PRINT_INPUT:
	{    
	    if (!icon_view_p->selection_list || g_list_length(icon_view_p->selection_list) < 1) return;
	    en=(record_entry_t *)icon_view_p->selection_list->data;
	    if (!en->path || !IS_FILE(en->type)) return;
	    xffm_print(widgets_p, choice, en->path);
 	    break;
	}
	case RUN_DOUBLE_CLICK:
	case RUN_INPUT:
	    {
		gboolean in_terminal, remember, hold;
		GtkWidget *check;
		gchar *in_cmd;
		GList *selection_list;

		selection_list = icon_view_p->selection_list;
		TRACE("at RUN_INPUT");
		check = lookup_widget(widgets_p->window,"checkbutton1");
		in_terminal = gtk_toggle_button_get_active((GtkToggleButton *) check);
		check = lookup_widget(widgets_p->window,"checkbutton3");
		hold = gtk_toggle_button_get_active((GtkToggleButton *) check);

		if (g_file_test(choice,G_FILE_TEST_IS_DIR)){
		    if (in_terminal) {
			xffm_new_terminal_path(widgets_p,choice);
			{
			    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
			    gchar *f=g_strconcat(xdg_dir,RUN_DBH_FILE,NULL);

			    g_free(xdg_dir);
			    XFC_save_to_history(f,choice);
			    xffm_save_flags(choice,in_terminal,hold);
			    g_free(f);
			}
			break;
		    }
		    else in_cmd = g_strdup_printf("xffm %s",choice);
		} else {
		    in_cmd = g_strdup(choice);
		}
		
#ifdef TRACE
		TRACE("selection_list=0x%x, length=%d, icon_view_p->selected_p=0x%x",(unsigned)selection_list,g_list_length(selection_list),(unsigned)icon_view_p->selected_p);
		
#endif
	   
		if(widgets_p->input == RUN_INPUT)
		{
		    remember = FALSE;
		    en = NULL;
		    if (icon_view_p->en && icon_view_p->en->path && g_file_test(icon_view_p->en->path,G_FILE_TEST_IS_DIR)) chdir(icon_view_p->en->path);
		}
		else /*RUN_DOUBLE_CLICK */
		{		/*RUN_DOUBLE_CLICK */
		    check = lookup_widget(icon_view_p->widgets.window,"checkbutton2");
		    remember = gtk_toggle_button_get_active((GtkToggleButton *) check);
		    if (icon_view_p->selected_p) en=icon_view_p->selected_p->en;
		    else en=NULL;
		}
		TRACE("at input ok xffm_on_run %s en=0x%x",in_cmd,(unsigned)en);
		if (widgets_p->input == RUN_DOUBLE_CLICK && g_list_length(selection_list)==1){
		    TRACE("selection=%s",get_selection_list_path(icon_view_p));
		    if(xffm_on_run_path(widgets_p,in_cmd, get_selection_list_path(icon_view_p), in_terminal, remember, TRUE, hold)) {
			gchar *g=g_strdup_printf(_("Executing %s"),in_cmd);
			print_status(widgets_p,"xfce/info", g, NULL);
			g_free(g);
		    }

		}
		else { 
		    if(xffm_on_run(widgets_p,in_cmd, en, in_terminal, remember, TRUE, hold));
		}
		chdir(GETWD);
		
		{
			gchar *g;
			if (g_file_test(in_cmd,G_FILE_TEST_EXISTS)) {
			    gchar *f;
			    f=g_path_get_basename(in_cmd);
			    g=g_strdup_printf(_("Executing %s"),f);
			    g_free(f);
			} else {
			    g=g_strdup_printf(_("Executing %s"),in_cmd);
			}
			print_status(widgets_p,"xfce/info", g, NULL);
			g_free(g);
		}
		g_free(in_cmd);
		in_cmd=NULL;
		/*if (icon_view_p) gtk_paned_set_position(GTK_PANED(icon_view_p->widgets.vpane), 10000);*/
	    }
	    break;
	case GOTO_INPUT:
	    {
		record_entry_t *new_en;
		gchar *g=fix_relative_path(icon_view_p,choice);
		if (strncmp(g,"//",2) != 0 && !g_file_test(g,G_FILE_TEST_IS_DIR)){
		  /* try utf8...*/
		  /*gchar *gg=g;
		  g=g_strdup(my_valid_utf_pathstring(g));
		  g_free(gg);*/
		  if (!g_file_test(g,G_FILE_TEST_IS_DIR)){
		    print_diagnostics(widgets_p, "xfce/error","g is ", " : ", g, "\n", NULL);
		    print_diagnostics(widgets_p, "xfce/error", strerror(ENOENT), " : ", choice, "\n", NULL);
		    print_status(widgets_p, "xfce/error", strerror(ENOENT), NULL);
		    goto over;
		  }
		} 
	    
		push_iconview_go_history(icon_view_p); 
		if (strncmp(g,"//",2)==0) {
		    gchar *p;
		    for (p=g; *p; p++) *p=toupper(*p);
		    new_en=mk_entry(__NETWORK_TYPE);
		    new_en->st=(struct stat *)malloc(sizeof(struct stat));
		    new_en->st->st_size=0;
		    new_en->st->st_mtime=0;
		    new_en->st->st_ctime=0;
		    new_en->st->st_gid=-1;
		    new_en->st->st_uid=-1;
		    new_en->st->st_mode=0;
		    new_en->path=g_strdup(g);
		    
		    icon_view_p->module_name="xffm_smb_ws";
		    reload_iconview(icon_view_p,new_en,FALSE);
		} else {
		    new_en=stat_entry(g,__LOCAL_TYPE);
		    icon_view_p->module_name=NULL;
		    reload_iconview(icon_view_p,new_en,FALSE);
		}
		    
		
	      /* save relative path for autocompletion */
	      if (g && g_file_test((const gchar *)g,G_FILE_TEST_IS_DIR)){
	        save_to_go_history(g);
	        TRACE("TRACE: RECENT_add2history(%s)\n",(char *)g);
	        RECENT_add2history( widgets_p, (char *)g);
	      }
	      g_free(g);
	    }
	    break;
	case NEW_FILE_INPUT:
	case NEW_DIR_INPUT:
	case NEW_INPUT:
	    {
		GtkWidget *w = lookup_widget(widgets_p->window,"checkbutton1");

		en=icon_view_p->en;

		TRACE("newinput, en=0x%x\n",(unsigned)en);
    		if(!en) break;
		TRACE("newinput en->module0x%x",(unsigned)en->module);
		if (en->module) {
		    const gchar *function_name="on_new";
		    switch (widgets_p->input) {
			case NEW_FILE_INPUT: function_name="on_new_file"; break;
			case NEW_DIR_INPUT:  function_name="on_new_dir"; break;
			case NEW_INPUT:
			    if (gtk_toggle_button_get_active((GtkToggleButton *) w)) {
				function_name="on_new_dir"; break;
			    } else {
				function_name="on_new_file"; break;
			    }
		    }
		    function_rational("plugins",en->module,en,widgets_p,function_name);
		    break;
		}
		else if(!IS_PATH(en->type))break;
		

		if (!en->module) {
		    char *path = g_strdup(en->path);
		    char *name = g_strdup(choice);
		    if(!IS_DIR(en->type)) *(strrchr(path, '/')) = 0;
		    xffm_new(&(icon_view_p->widgets), path, name, gtk_toggle_button_get_active((GtkToggleButton *) w));
		    g_free(path);
		    path=NULL;
		    g_free(name);
		    name=NULL;
		}

		{
		    record_entry_t *en=copy_entry(icon_view_p->en);
		    if (icon_view_p->en && icon_view_p->en->path) unlink(get_local_cache_path(icon_view_p->en->path));
		    reload_iconview(icon_view_p,en,FALSE);
		}
	    }
	    break;
    }
over:
    g_free(nfile);
    nfile=NULL;
    g_free(choice);
    choice=NULL;
    widgets_p->input = OTHER_INPUT;
    gtk_paned_set_position(GTK_PANED(icon_view_p->widgets.vpane), 10000);
}


/*******************************************************************************/

G_MODULE_EXPORT
void gridview_show_input (int which,icon_view_t *icon_view_p)
{
    GtkCheckButton *check_button1, *check_button2;
    GtkLabel *label;
    GtkEntry *entry;
    GtkCombo *combo;
    /*GtkToggleButton *w; */
    char *path, *name=NULL;
    record_entry_t *en;
    xfc_combo_info_t **combo_info;
    widgets_t *widgets_p = &(icon_view_p->widgets);
    combo_icon_view_p=icon_view_p;

    combo_info=(xfc_combo_info_t **)(&(icon_view_p->widgets.combo_info));




    TRACE("at gridview_show_input");

    if(icon_view_p->widgets.tubo_object){
	print_status(widgets_p,"xfce/error",strerror(EBUSY),NULL);
	return;
    }
	
    gridview_cancel_input(NULL,icon_view_p);
    

    label = (GtkLabel *) lookup_widget(icon_view_p->widgets.window,"input_label");
    entry = (GtkEntry *) lookup_widget(icon_view_p->widgets.window,"input_entry");

    /* combo setting up: */
    combo=(GtkCombo *)lookup_widget(icon_view_p->widgets.window,"input_combo");
    check_button1 = (GtkCheckButton *) lookup_widget(icon_view_p->widgets.window,"checkbutton1");
    if (*combo_info==NULL){
	TRACE("signal icon_view_p is 0x%x",(unsigned)icon_view_p);
	g_signal_connect((gpointer)check_button1,"toggled",G_CALLBACK (check1_toggle),&(icon_view_p->widgets));
	*combo_info = XFC_init_combo(combo);
    } else {
	XFC_clear_history(*combo_info);
    }

    (*combo_info)->activate_func = gridview_input_activate;
    (*combo_info)->activate_user_data=icon_view_p;
    /*(*combo_info)->activate_user_data=*combo_info;*/
    (*combo_info)->cancel_func = gridview_cancel_input;
    (*combo_info)->cancel_user_data=icon_view_p;
    
#ifndef LINKED_MODULES 
    /* not available in debug mode... */
    {
      xfc_combo_functions *xfc;
      xfc=load_xfc();
      if (xfc) switch (which) {
	case RUN_INPUT:
	case RUN_DOUBLE_CLICK:
	xfc->extra_key_completion = extra_key_completion;
	xfc->extra_key_data = &(icon_view_p->widgets);
	/*xfc->extra_key_data = icon_view_p;*/
	TRACE("iconview_p=0x%x",(unsigned)icon_view_p);
	break;
	default:
	xfc->extra_key_completion = NULL;
	xfc->extra_key_data = NULL;
	break;
      } 
      else g_warning("xfc==NULL");
    }
#endif
    
    gtk_widget_show_all(lookup_widget(icon_view_p->widgets.window,"input_box"));
    gtk_widget_show_all(lookup_widget(icon_view_p->widgets.window,"input_combo"));
    XFC_set_combo(*combo_info,NULL);
    
    /* check button initializations: */
    
    gtk_widget_hide(lookup_widget(icon_view_p->widgets.window,"checkbutton1"));
    gtk_widget_hide(lookup_widget(icon_view_p->widgets.window,"checkbutton2"));
    gtk_widget_hide(lookup_widget(icon_view_p->widgets.window,"checkbutton3"));

    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button1))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, FALSE);
    if (which==NEW_INPUT || which==NEW_DIR_INPUT)
	gtk_toggle_button_set_active((GtkToggleButton *) check_button1, TRUE);

    check_button2 = (GtkCheckButton *) lookup_widget(icon_view_p->widgets.window,"checkbutton2");
    if(gtk_toggle_button_get_active((GtkToggleButton *) check_button2))
	gtk_toggle_button_set_active((GtkToggleButton *) check_button2, FALSE);

    icon_view_p->widgets.input = which;

    if (icon_view_p->selected_p) en=icon_view_p->selected_p->en;
    else en=NULL;

    if (en) TRACE("input.c, en->module is %s",((en->module)?en->module:"null"));
    else TRACE("input.c, entry is null");
        
    if(!en || !en->path)	    
    {
	path = g_strdup(GETWD);
	name = g_strdup(_("New"));
    }
    else
    {
	path = g_strdup(en->path);
	if(IS_PATH(en->type))
	{
	    if (!strrchr(path, '/')) {
		g_warning("show_input(): en->path is not absolute!\n");
		name=g_strdup(my_utf_string(path));
	    } else {
		name=g_path_get_basename(my_utf_string(path));
	    }
	}
	else
	{
	    name = g_strdup(_("New"));
	}
    }

    switch (which)
    {
	case PRINT_INPUT:
	{
	    gchar *pc=g_find_program_in_path("xfprint4");
	    gtk_label_set_text(label, _("Print command"));
	    if (pc) {
		gtk_entry_set_text(entry, "xfprint4");
		print_status(widgets_p,"xfce/question","xfprint4 ",FILENAME(en), NULL);
	    }
	    else {
		gtk_entry_set_text(entry, "lpr");
		print_status(widgets_p,"xfce/question","lpr ",FILENAME(en), NULL);
	    }
	    g_free(pc);
	    break;
	}
	case NEW_INPUT:
	case NEW_FILE_INPUT:
	case NEW_DIR_INPUT:
	    set_new_combo(icon_view_p);
	    gtk_label_set_text(label, _("Name"));
	    print_status(widgets_p,"xfce/question", _("Name"), NULL);
	    if (which == NEW_INPUT){
	      gtk_button_set_label((GtkButton *) check_button1, _("Directory"));
	      showit(NULL,"checkbutton1");
	    }
	    break; 
	case WORKDIR_INPUT: 
	    {
	      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	      gchar *f=g_build_filename(xdg_dir,WORKDIR_DBH_FILE,NULL);
	      gchar *dir=NULL;

	      if (en && en->path) dir = g_path_get_dirname(en->path);

	      g_free(xdg_dir);
	      XFC_read_history(*combo_info,f);
    	      XFC_set_combo(*combo_info,NULL);
	      
	      /* only suggest a valid utf8 path initially */
	      if (dir && g_utf8_validate (dir,-1,NULL)) {
		  XFC_set_entry(*combo_info,dir);
	      }
   	      g_free (f);
   	      g_free (dir);
	    }
	    gtk_label_set_text(label,workdir?_(workdir):_("Output dir"));
	    PRINT_STATUS_INPUT;
	    break;
	case GOTO_INPUT:
	    {
	      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	      gchar *f=g_build_filename(xdg_dir,GOTO_DBH_FILE,NULL);
	      
	      g_free(xdg_dir);
	      XFC_read_history(*combo_info,f);
	      XFC_set_blank(*combo_info);
   	      g_free (f);
	    }
	    gtk_label_set_text(label, _("Go to"));
	    PRINT_STATUS_INPUT;
	    break;
	case RUN_INPUT:
	case RUN_DOUBLE_CLICK:
	    switch (which)
	    {
		case RUN_INPUT:
	    	    xffm_set_run_combo(&(icon_view_p->widgets),en,*combo_info);
		    gtk_label_set_text(label, _("Run"));
		    PRINT_STATUS_INPUT;
		    break;
		case RUN_DOUBLE_CLICK:
	    	    xffm_set_run_combo(&(icon_view_p->widgets),en,*combo_info);
		    gtk_label_set_text(label, _("Open with"));
		    gtk_button_set_label((GtkButton *) check_button2, 
				    _("Remember"));
		    gtk_widget_show_all(lookup_widget(icon_view_p->widgets.window,"checkbutton2"));
		    if(en && en->path)
		    {
		      int in_term;
		      gchar **text_editors;
		      const gchar *p=xffm_get_from_open_history(en->path, &in_term);
		      if (p) {
			  /* XXX: this value is not in association hash...
			   * So if it is not a valid utf8, forget about it...*/
			  if ( g_utf8_validate (p,-1,NULL)) {
			    XFC_set_entry(*combo_info,(gchar *)(p));
			    gtk_toggle_button_set_active((GtkToggleButton *) check_button2, (gboolean)in_term);	
			  }
		      }
		      else if ((text_editors=text_type_OK(en->path))!=NULL){  
			  /* OK to apply an editor */
			int k;
			for (k=0;text_editors[k];k++){
			    gchar *c=g_find_program_in_path(text_editors[k]);
			    if (c){
				g_free(c);
				XFC_set_entry(*combo_info,(gchar *)text_editors[k]);
				break;
			    }
			}	
		      }
		      else {
			const gchar *p=MIME_command(en->path);
			/*printf("TRACE:no history to set for %s\n",en->path);*/
			if (p) XFC_set_entry(*combo_info,(gchar *)my_valid_utf_pathstring(p));
			else XFC_set_blank(*combo_info);
		      }
		    }
		    if (icon_view_p &&  g_list_length(icon_view_p->selection_list) > 1) {
			gchar *g=g_strdup_printf(_("%d item(s) selected"),icon_view_p->selection_count);
			print_status(widgets_p,"xfce/question", _("Input requested")," [",g,"]", NULL);
			g_free(g);
		    } else {
			PRINT_STATUS_INPUT;
		    }
		    break;

	    }

	    gtk_button_set_label((GtkButton *) check_button1, _("In terminal"));
	    gtk_widget_show_all(lookup_widget(icon_view_p->widgets.window,"checkbutton1"));
	    break;

	default:
	    break;
    }
    g_free(path);
    path=NULL;
    gtk_widget_grab_focus((GtkWidget *) entry);
    /* these will preselect */
    
    if (which == NEW_INPUT ||
	which == NEW_FILE_INPUT || which == NEW_DIR_INPUT ||
	which ==  RUN_INPUT || which == RUN_DOUBLE_CLICK){
      gtk_editable_set_position(GTK_EDITABLE (entry),0);
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);
    } else {
      gtk_editable_select_region (GTK_EDITABLE (entry), 0, 0);
      gtk_editable_set_position(GTK_EDITABLE (entry),-1);
    }
    if (which==WORKDIR_INPUT) gtk_main();
    g_free(name);
}


G_MODULE_EXPORT
void gridview_cancel_input (GtkEntry *entry,gpointer data)
{
    icon_view_t *icon_view_p=(icon_view_t *)data;
    widgets_t *widgets_p;
    if (!icon_view_p) return;
    
    widgets_p=&(icon_view_p->widgets);
    if (widgets_p->input == OTHER_INPUT) return;
    
    gtk_widget_hide(lookup_widget(widgets_p->window,"input_box"));
    print_status(widgets_p,NULL,_("Omitting"),NULL);
    gtk_paned_set_position(GTK_PANED(widgets_p->vpane), 10000);
    
    if (widgets_p->input==WORKDIR_INPUT){
	    g_free(workdir);
	    workdir=NULL;
	    widgets_p->input = OTHER_INPUT;
	    gtk_main_quit(); /* this lets on_autotype_C continue */
    } else {
	    widgets_p->input = OTHER_INPUT;
    }
}

/* callbacks */


/*
G_MODULE_EXPORT
void gridview_input_cancel (GtkButton * button, gpointer user_data)
{
    cancel_input(NULL,user_data);
}*/


G_MODULE_EXPORT
void gridview_input_ok (GtkButton * button, gpointer data)
{ 
    TRACE("--on inputok, iconview_p is 0x%x\n",(unsigned)data);
    private_ok_input((icon_view_t *)data);	
}


G_MODULE_EXPORT
void gridview_input_activate (GtkEntry * entry, gpointer data)
{
    private_ok_input ((icon_view_t *)data);
}
