
static
void
deskview_autotype_C         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    const gchar *command;
    const gchar *dirname;
    static gchar *new_command=NULL;
    gboolean *queued;
    const gchar *querypath,*output_arg,*output_ext;
    record_entry_t *en;
    gint argc;
    gchar **argv=NULL;
    GError *error=NULL;
    record_entry_t *tmp_en=NULL;
    desk_view_t *desk_view_p=g_object_get_data(G_OBJECT(menuitem),"gui_data");
    widgets_t *widgets_p=&(desk_view_p->widgets);
    gchar *workdir=NULL;
    

    
    en=desk_view_p->selection_list->data;
    output_arg=g_object_get_data(G_OBJECT(menuitem),"output_arg");
    command=g_object_get_data(G_OBJECT(menuitem),"command");
    dirname=g_object_get_data(G_OBJECT(menuitem),"workdir");
    querypath=g_object_get_data(G_OBJECT(menuitem),"querypath");
    queued=g_object_get_data(G_OBJECT(menuitem),"queued");
    output_ext=g_object_get_data(G_OBJECT(menuitem),"output_ext");
    if (output_arg && !output_ext) g_warning("output_arg && !output_ext not met"); 
    
    if (querypath) workdir = g_strdup(desk_view_p->en->path); 
    
    if (output_arg) {
	gchar *outputdir=workdir;
	workdir=g_strdup(dirname);
	TRACE("output dir is %s",outputdir);
	if (new_command) g_free(new_command);
	new_command = g_strconcat(command," \"",outputdir,G_DIR_SEPARATOR_S,output_arg,output_ext,"\" \"",output_arg,"\"",NULL);
	command = (const gchar *)new_command;
	g_free(outputdir);
    } else if (!querypath)
    {
	g_free(workdir);
	workdir=g_strdup(dirname);
	TRACE("*****workdir is %s",workdir);
    } else if (!workdir)
    {
	g_warning("workdir==NULL");
	return;
    }
    
    TRACE("output_arg=%s, command=%s, querypath=%s, output_ext=%s, workdir=%s",
	    output_arg, command, querypath, output_ext, dirname);
    
    g_shell_parse_argv (command, &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics(widgets_p,"xfce/error",msg,": ",command,"\n",NULL);
	g_error_free(error);
	g_free (msg);
    }
    if (!queued || *queued == FALSE){
       if (xffm_runvwd(widgets_p,workdir,argv)){
	    if (en && en->path) RECENT_add2history(widgets_p,en->path);
       }
	g_strfreev (argv);
	if (tmp_en) destroy_entry(tmp_en);
       return;
    } 

    
    gui_autofunction(&(desk_view_p->widgets),en,argv,(queued && *queued));
    
    chdir(GETWD);
    if (workdir && strcmp(workdir,GETWD)!=0) print_diagnostics(widgets_p,NULL,"$chdir ",GETWD,"\n",NULL);
    g_strfreev (argv);
    if (tmp_en) destroy_entry(tmp_en);

	
}



#if 0
static
void deskview_refresh_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    deskview_reload(&(desk_view_p->widgets));
    return;
}
#endif

static
void on_open_with_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    int argc;
    GError *error=NULL;
    gchar **argv;
    const gchar *g;
    gchar *q;
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    record_entry_t *en=desk_view_p->selection_list->data;
    widgets_t *widgets_p=&(desk_view_p->widgets);
    
    /*g=gui_get_response(NULL,_("Open with..."),_("Open with"));*/
    {
      gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
      gchar *f=g_build_filename(xdg_dir,RUN_DBH_FILE,NULL); 
      g=gui_get_response_history(NULL,_("Open with..."),_("Open with"),f,en->path);
      g_free(xdg_dir);
      g_free(f);
    }

    if (!g) return;
    q=g_strdup_printf("%s \"%s\"",g,en->path);
    g_shell_parse_argv (q, &argc,&argv,&error);
    if (error){
        g_warning(error->message);
	g_error_free(error);
	return;
    }
    g_free(q);
    q=g_path_get_basename(en->path);
    xffm_runvwd(widgets_p,g,argv);
    g_free(q);
}

 
static
void 
deskview_double_click_open_with(desk_view_t *desk_view_p)
{
    widgets_t *widgets_p=&(desk_view_p->widgets);
    /* open with */
    gchar *name;
    int argc;
    gchar **argv;
    const gchar *command;
    const gchar *command_fmt;
    GError *error=NULL;
    record_entry_t *en;

    if (!desk_view_p->selection_list || !desk_view_p->selection_list->data)
	return;
    en=(record_entry_t *)desk_view_p->selection_list->data;
    if (!en->path || !strlen(en->path)) return;
    name=g_path_get_basename(en->path);
    
    command_fmt = MIME_command(name);
    
    if(!command_fmt)
    {
	g_warning("FIXME: add get response with combo history");
    } else {
        gchar *wd=g_path_get_dirname((const gchar *)en->path);	    
	command =  MIME_mk_command_line(command_fmt,name,FALSE,FALSE);


	g_shell_parse_argv (command, &argc,&argv,&error);
	if (error){
	    gchar *msg = g_strcompress (error->message);
	    print_diagnostics(widgets_p,"xfce/error",msg,":\n",command,"\n",NULL);
	    g_error_free(error);
	    g_free (msg);
	    g_free(wd);
	    return;
	}
	xffm_runvwd(widgets_p,wd,argv);
	g_free(wd);
	g_strfreev (argv); 
    }
    g_free(name);
    return;
}

static
void
on_autotype_R                          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    deskview_double_click_open_with(desk_view_p);
    return;
}

static
void deskview_remove_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    widgets_t *widgets_p;
    desk_view_p->redlight=TRUE;
    widgets_p = &(desk_view_p->widgets);
    xffm_remove(widgets_p,desk_view_p->selection_list);
    if (desk_view_p->en && desk_view_p->en->path) 
	unlink(get_local_cache_path(desk_view_p->en->path));
    desk_view_p->redlight=FALSE;
    reload_deskview(desk_view_p);
}


static
void 
deskview_on_prop_activate(GtkMenuItem * menuitem, gpointer user_data) {
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    if (!desk_view_p) return;
    PROP_do_prop(NULL,desk_view_p->selection_list);
#ifndef LINKED_MODULES
    unload_prop_module();
#endif
}

static
void 
deskview_on_autoplace(GtkMenuItem * menuitem, gpointer user_data) {
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    if (!desk_view_p) return;
    {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	gchar *f=g_build_filename(xdg_dir,DESKVIEW_GEOMETRY_DBH_FILE,NULL);
	unlink(f);
	g_free(f);
	g_free(xdg_dir);
	reload_deskview(desk_view_p);
    }
    return;
}




/***********************************************************************/




static
void
private_mount   (desk_view_t *desk_view_p, int mounted){
    record_entry_t *en=NULL;
    if (!desk_view_p->selection_list || desk_view_p->selection_list->data) return;
    en=desk_view_p->selection_list->data;
    
    TRACE("<<<<<<<<<<< on mount %d (0x%x)",mounted,(unsigned)desk_view_p);
    if(!en->path || !strlen(en->path)) {
	g_warning("no entry to mount");
	return;
    }
    if (mounted) SET_MOUNTED(en->type); else UNSET_MOUNTED(en->type);
    FSTAB_fstab_mount(en,&(desk_view_p->widgets));
    TRACE("<<<<<<<<<<< on mount done");
}


static
void
deskview_mount   (GtkMenuItem     *menuitem, gpointer         user_data){
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    private_mount(desk_view_p, FALSE);
}
static
void
deskview_unmount   (GtkMenuItem     *menuitem, gpointer         user_data){
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    private_mount(desk_view_p, TRUE);
}

static 
void deskview_open_in_terminal_activate(GtkMenuItem * menuitem, gpointer data)
{
    gchar *path=NULL;
    desk_view_t *desk_view_p=(desk_view_t *)data;
    xffm_new_terminal_path(&(desk_view_p->widgets),desk_view_p->en->path);
    /*xffm_new_terminal_path(&(desk_view_p->widgets),g_get_home_dir());*/
    g_free(path);
    return;
}

static
void deskview_print_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    /*widgets_t *widgets_p=&(desk_view_p->widgets);*/
    record_entry_t *en=desk_view_p->selection_list->data;
	    
    if (!IS_FILE(en->type)) return;

    g_warning("FIXME: open a printwith response dialog");
   
}


