/*  xfce4
 *  
 *       Copyright (C) 2005 Edscott Wilson Garcia <edscott@xfce.org>
 *                     2004 Brian Tarricone <bjt23@cornell.edu>
 *                     2004 Danny Milosavljevic <danny.milo@gmx.net>
 *                     2003 Biju Chacko (botsie@users.sourceforge.net)
 *  	          2002-2003 Jasper Huijsmans (huysmans@users.sourceforge.net)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <glib.h>
#include <gmodule.h>
#include <gtk/gtk.h>

#include <libxfce4util/i18n.h>

/******************   module loading code  **************************/
typedef struct _XfceDesktopMenu XfceDesktopMenu;

typedef struct xfdesktop_menu_t {
    XfceDesktopMenu *desktop_menu;
    XfceDesktopMenu *(*xfce_desktop_menu_new)(const gchar *menu_file, gboolean deferred);
    GtkWidget *(*xfce_desktop_menu_get_widget)(XfceDesktopMenu *desktop_menu);
    const gchar *(*xfce_desktop_menu_get_menu_file)(XfceDesktopMenu *desktop_menu);
    gboolean (*xfce_desktop_menu_need_update)(XfceDesktopMenu *desktop_menu);
    void (*xfce_desktop_menu_start_autoregen)(XfceDesktopMenu *desktop_menu, guint delay);
    void (*xfce_desktop_menu_stop_autoregen)(XfceDesktopMenu *desktop_menu);
    void (*xfce_desktop_menu_force_regen)(XfceDesktopMenu *desktop_menu);
    void (*xfce_desktop_menu_set_show_icons)(XfceDesktopMenu *desktop_menu, gboolean show_icons);
    void (*xfce_desktop_menu_destroy)(XfceDesktopMenu *desktop_menu);
} xfdesktop_menu_t;

#define XDM_new			(*(xfdesktop_menu_p->xfce_desktop_menu_new))
#define XDM_get_widget		(*(xfdesktop_menu_p->xfce_desktop_menu_get_widget))
#define XDM_get_menu_file	(*(xfdesktop_menu_p->xfce_desktop_menu_get_menu_file))
#define XDM_need_update		(*(xfdesktop_menu_p->xfce_desktop_menu_need_update))
#define XDM_start_autoregen	(*(xfdesktop_menu_p->xfce_desktop_menu_start_autoregen))
#define XDM_stop_autoregen	(*(xfdesktop_menu_p->xfce_desktop_menu_stop_autoregen))
#define XDM_force_regen		(*(xfdesktop_menu_p->xfce_desktop_menu_force_regen))
#define XDM_set_show_icons	(*(xfdesktop_menu_p->xfce_desktop_menu_set_show_icons))
#define XDM_destroy		(*(xfdesktop_menu_p->xfce_desktop_menu_destroy))


static xfdesktop_menu_t *
get_xfdesktop_menu_p (GModule *module)
{
    static xfdesktop_menu_t *xfdesktop_menu_p=NULL;
    if (xfdesktop_menu_p) return xfdesktop_menu_p;
    xfdesktop_menu_p=(xfdesktop_menu_t *)malloc(sizeof(xfdesktop_menu_t));
    if (!xfdesktop_menu_p) return NULL;
    memset(xfdesktop_menu_p, 0, sizeof(xfdesktop_menu_t));
    if(
	!g_module_symbol(module, "xfce_desktop_menu_new_impl",
            (gpointer)&(xfdesktop_menu_p->xfce_desktop_menu_new)) ||
	!g_module_symbol(module, "xfce_desktop_menu_get_widget_impl",
            (gpointer)&(xfdesktop_menu_p->xfce_desktop_menu_get_widget)) ||
	!g_module_symbol(module, "xfce_desktop_menu_get_menu_file_impl",
            (gpointer)&(xfdesktop_menu_p->xfce_desktop_menu_get_menu_file)) ||
	!g_module_symbol(module, "xfce_desktop_menu_need_update_impl",
            (gpointer)&(xfdesktop_menu_p->xfce_desktop_menu_need_update)) ||
	!g_module_symbol(module, "xfce_desktop_menu_start_autoregen_impl",
            (gpointer)&(xfdesktop_menu_p->xfce_desktop_menu_start_autoregen)) ||
	!g_module_symbol(module, "xfce_desktop_menu_stop_autoregen_impl",
            (gpointer)&(xfdesktop_menu_p->xfce_desktop_menu_stop_autoregen)) ||
	!g_module_symbol(module, "xfce_desktop_menu_force_regen_impl",
            (gpointer)&(xfdesktop_menu_p->xfce_desktop_menu_force_regen)) ||
	!g_module_symbol(module, "xfce_desktop_menu_set_show_icons_impl",
            (gpointer)&(xfdesktop_menu_p->xfce_desktop_menu_set_show_icons)) ||
	!g_module_symbol(module, "xfce_desktop_menu_destroy_impl",
            (gpointer)&(xfdesktop_menu_p->xfce_desktop_menu_destroy))	)
    {
	g_free(xfdesktop_menu_p);
	return NULL;
    }
    return xfdesktop_menu_p;
}

#define XFCEMODDIR LIBDIR,"xfce4","modules"


static xfdesktop_menu_t *
load_xfdesktop_menu_module(void)
{
    GModule *module;
    gchar *filename;
    xfdesktop_menu_t *xfdesktop_menu_p;
    
    filename = g_build_filename(XFCEMODDIR, "xfce4_desktop_menu." G_MODULE_SUFFIX, NULL);
    module = g_module_open(filename, 0);
    
    if(!module) {
	g_warning("g_module_open(%s) == NULL\n",filename);
	g_warning("Module cannot be opened! Check if correctly installed...\n");
        return NULL;
    }
    g_free(filename);
    xfdesktop_menu_p=get_xfdesktop_menu_p(module);
    if(!xfdesktop_menu_p) {
	g_warning("XfceDesktopMenu: !xfdesktop_menu_p");
        g_module_close(module);
        return NULL;
    }
    
    return xfdesktop_menu_p;
}

/******************   actual menu stuff  ************************/

static void
stop_menu_module(xfdesktop_menu_t *xfdesktop_menu_p) {
    if(xfdesktop_menu_p->desktop_menu) {
        XDM_stop_autoregen(xfdesktop_menu_p->desktop_menu);
        XDM_destroy(xfdesktop_menu_p->desktop_menu);
        xfdesktop_menu_p->desktop_menu = NULL;
    }
}

static 
xfdesktop_menu_t *
start_menu_module()
{
    xfdesktop_menu_t *xfdesktop_menu_p=load_xfdesktop_menu_module();
    if (!xfdesktop_menu_p) return NULL;
    xfdesktop_menu_p->desktop_menu = XDM_new(NULL, TRUE);
    if(xfdesktop_menu_p->desktop_menu) {
	if (getenv("USE_DESKTOP_MENU_ICONS") && strlen(getenv("USE_DESKTOP_MENU_ICONS"))) 
	    XDM_set_show_icons(xfdesktop_menu_p->desktop_menu, TRUE);
	else 
	    XDM_set_show_icons(xfdesktop_menu_p->desktop_menu, FALSE);
        XDM_start_autoregen(xfdesktop_menu_p->desktop_menu, 10);
        return xfdesktop_menu_p;
    } else {
        g_warning("Unable to initialise menu module.");
        return xfdesktop_menu_p;
    }
}

static
void
popup_desktop_menu(	xfdesktop_menu_t *xfdesktop_menu_p,
			GdkScreen *gscreen, 
			gint button, 
			guint32 time)
{
    GtkWidget *menu_widget;
    
    if(!xfdesktop_menu_p->desktop_menu)
        return;
    
    if(XDM_need_update(xfdesktop_menu_p->desktop_menu))
        XDM_force_regen(xfdesktop_menu_p->desktop_menu);
    
    menu_widget = XDM_get_widget(xfdesktop_menu_p->desktop_menu);
    /*gtk_menu_set_screen(GTK_MENU(menu_widget), gscreen);*/
    gtk_menu_popup(GTK_MENU(menu_widget), NULL, NULL, NULL, NULL,
            button, time);
}


