/**********************************************************************/
/* Copywrite Edscott Wilson Garcia 2005 
 * See attached GPL licence for further information.
 * 
 * ********************************************************************/

static GdkDragAction drag_action=GDK_ACTION_MOVE;
static GtkTargetList* target_list=NULL;

static GtkTargetEntry target_table[] = {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"text/x-moz-url", 0, TARGET_MOZ_URL},
    {"text/plain", 0, TARGET_PLAIN},
    {"UTF8_STRING", 0, TARGET_UTF8},
    {"STRING", 0, TARGET_STRING}
};
#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))

/*
 * this could be useful, maybe...
G_MODULE_EXPORT
void set_drag_copy(desk_view_t *desk_view_p, gboolean will_copy){
    if (will_copy) drag_action = GDK_ACTION_COPY;
    else drag_action = GDK_ACTION_MOVE;
}
*/
/***************** GTK callbacks **************************/


static
void
enter_drag_state(desk_view_t *desk_view_p)
{
	    GdkPixmap *pixmap;
            GdkBitmap *mask;

	    if (desk_view_p->dragstate) {
		TRACE("dragstate true");
		return;
	    }
	    erase_text(desk_view_p,desk_view_p->doing_drag_p);
	    redraw_background(desk_view_p,desk_view_p->doing_drag_p);

	    select_desk_population_p(desk_view_p,desk_view_p->doing_drag_p);
	    if (!desk_view_p->doing_drag_p->selected_pixbuf)
		g_warning("!desk_view_p->doing_drag_p->selected_pixbuf");
	    else
		gdk_pixbuf_render_pixmap_and_mask(desk_view_p->doing_drag_p->selected_pixbuf,&pixmap,&mask,1);
	    desk_view_p->drag_event.context = 
		gtk_drag_begin   (desk_view_p->paper,   
			   target_list,
			   GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK, 
			    desk_view_p->drag_button,
			    (GdkEvent *)(&(desk_view_p->drag_event)));
	    gdk_drag_status(desk_view_p->drag_event.context, drag_action, desk_view_p->drag_event.time);

	    gtk_drag_set_icon_pixmap (desk_view_p->drag_event.context,
		    desk_view_p->cmap, 
		    pixmap, mask,
		    desk_view_p->hot_x,desk_view_p->hot_y);
	    desk_view_p->dragstate=TRUE;
	    
}
static
void
setup_drag_state(desk_view_t *desk_view_p,GdkEventButton *event)
{
	    desk_view_p->drag_button=event->button;
	    desk_view_p->hot_x=event->x - desk_view_p->doing_drag_p->x;
	    desk_view_p->hot_y=event->y - desk_view_p->doing_drag_p->y;
	    desk_view_p->drag_event.type=GDK_DRAG_ENTER;
	    desk_view_p->drag_event.x_root=event->x;
	    desk_view_p->drag_event.y_root=event->y;
	    desk_view_p->drag_event.time=event->time+2;
	    desk_view_p->drag_event.window=event->window;
	    desk_view_p->drag_event.send_event=event->send_event;
	    TRACE("event time=0x%x",event->time);
}

static
gboolean 
destroy_event(		GtkWidget * widget, 
			GdkEvent * event, 
			gpointer data)
{
    desk_view_t *desk_view_p = (desk_view_t *)data; 
    destroy_deskview(desk_view_p);
    return FALSE;
}

static 
void 
on_expose (		GtkWidget * widget, 
			GdkEventExpose *event,
			gpointer data)
{
    TRACE("on_expose");
    desk_view_t *desk_view_p = (desk_view_t *)data; 
    if (!desk_view_p || !desk_view_p->pixmap || !desk_view_p->paper) return;
    XCopyArea(	GDK_DISPLAY(), 
		GDK_PIXMAP_XID(desk_view_p->pixmap), 
		GDK_DRAWABLE_XID(desk_view_p->paper->window), 
		GDK_GC_XGC(desk_view_p->penGC), 
		event->area.x,event->area.y,
		event->area.width,event->area.height,
		event->area.x,event->area.y);
}
static 
gboolean 
on_enter (		GtkWidget *widget, 
			GdkEventCrossing *event, 
			gpointer data)
{
  // desk_view_t *desk_view_p = (desk_view_t *)data;   
  TRACE("on enter");
    return TRUE;
}
static 
gboolean 
on_leave (		GtkWidget *widget, 
			GdkEventCrossing *event, 
			gpointer data)
{
    desk_view_t *desk_view_p = (desk_view_t *)data;   
    TRACE("on leave");
    if (!desk_view_p->doing_drag_p) unsaturate(desk_view_p);
    return TRUE;
}
static 
gboolean  
on_button_release (	GtkWidget *widget, 
			GdkEventButton *event, 
			gpointer data)
{
    desk_view_t *desk_view_p = (desk_view_t *)data;   
    gint current_x, current_y;
    desk_population_t *desk_population_p;
    GdkModifierType mask;

    if (!gdk_window_get_pointer (widget->window,&current_x, &current_y,&mask)){
	TRACE("gdk_window_get_pointer returns NULL");
    }
    TRACE("on_button_release at %d %d, offset is %lf %lf",
	    current_x, current_y,desk_view_p->offset_x,desk_view_p->offset_y);
    desk_population_p=find_in_population(desk_view_p,(gdouble)current_x, (gdouble)current_y);

    //if (desk_view_p->doing_drag_p) desk_view_p->doing_drag_p->selected=FALSE;
    unselect_all_population(desk_view_p);
    if (desk_population_p && desk_population_p==desk_view_p->doing_drag_p) {
	TRACE("clicked %s",desk_population_p->en->path);
	select_desk_population_p(desk_view_p,desk_population_p);
    } 
    


    TRACE(" %lf  > %d, %lf > %d",
	    event->x - desk_view_p->offset_x, 
	    desk_view_p->paper->allocation.width, 
	    event->y - desk_view_p->offset_y, 
	    desk_view_p->paper->allocation.height);
 
    if (desk_view_p->restore_pixbuf){
	TRACE("doing restore pixbuf to %lf %lf",desk_view_p->initial_x, desk_view_p->initial_y);
	desk_view_p->offset_x=desk_view_p->offset_y=0;
	/* redraw_pixbuf at drag end, so that the flying pixmap will not come
	 * after the final position placing: */
    }
    else {
	if (desk_view_p->doing_drag_p && desk_view_p->doing_drag_p->selected){
	    GList *tmp;
	    select_pixbuf(desk_view_p,desk_view_p->doing_drag_p, (gdouble)current_x, (gdouble)current_y);
	    /*XXX this single save is probably not necessary with loop below */
	    save_deskview_geometry(desk_view_p->doing_drag_p->en->path, desk_view_p->doing_drag_p->x, desk_view_p->doing_drag_p->y);
	    /* once something is moved, save everything else. 
	     * Positioning control passed to user...*/
	    for (tmp=desk_view_p->population_list; tmp; tmp=tmp->next){
		desk_population_t *pop=tmp->data;
		if (!pop) continue;
		save_deskview_geometry(pop->en->path,pop->x,pop->y);
	    }
	    redraw_text(desk_view_p,desk_view_p->doing_drag_p,SELECT_TEXT_COLOR);
	}
	else if (desk_view_p->doing_drag_p) {
	    saturate_pixbuf(desk_view_p,desk_view_p->doing_drag_p, (gdouble)current_x, (gdouble)current_y);
	    redraw_text(desk_view_p,desk_view_p->doing_drag_p,SATURATE_TEXT_COLOR);
	}
	desk_view_p->doing_drag_p=NULL;
    }
        /* forward unused events to the root window, i.e. the window manager */
    if (!desk_view_p->doing_drag_p && !desk_population_p) {
	TRACE("!desk_view_p->doing_drag_p");
        event_forward_to_rootwin(gtk_widget_get_screen(widget), (GdkEvent*)event);
	return TRUE;
    }
    return TRUE;
}
static 
gboolean  
on_button_press (	GtkWidget *widget, 
			GdkEventButton *event, 
			gpointer data)
{
    int single_click_button;
    int double_click_button;
    desk_view_t *desk_view_p = (desk_view_t *)data;   
    desk_population_t *desk_population_p;
    TRACE("on_button_press");
    desk_population_p=find_in_population(desk_view_p,event->x,event->y);
    if (desk_population_p) {
	if (desk_view_p->selection_list) {
	    g_list_free(desk_view_p->selection_list);
	    desk_view_p->selection_list=NULL;
	}
	desk_view_p->selection_list = g_list_append(desk_view_p->selection_list,desk_population_p->en); 
	
	if (event->button == 3){
	  TRACE("uh-huh. a popup now.");
	  do_deskview_popup(desk_view_p, desk_population_p, event);
	  return TRUE;
	} 
	
	if (getenv("XFFM_SINGLE_CLICK_NAVIGATION") && strlen(getenv("XFFM_SINGLE_CLICK_NAVIGATION"))) {
	    TRACE("XFFM_SINGLE_CLICK_NAVIGATION");
	    single_click_button=1;
	    double_click_button=2;
	} else {
	    single_click_button=2;
	    double_click_button=1;
	}

	if ((event->type == GDK_2BUTTON_PRESS && event->button == double_click_button) || event->button == single_click_button)
	{
	    GError *error=NULL;
	    gchar *g=NULL;
	    if (desk_population_p->URL && strcmp(desk_population_p->URL,"start-here:")==0) {
		g=g_strdup("xffm");
	    } else if (desk_population_p->exec) {
		g=g_strdup(desk_population_p->exec);
	    } else {
		g=g_strdup_printf("xffm \"%s\"",desk_population_p->en->path);
	    }
	    if (!g_spawn_command_line_async (g,&error)){
	        g_warning("error->message (%s)",error->message);
	        /*print_diagnostics(widgets_p,"xfce/error",
		 * error->message,NULL);*/
	        g_error_free(error);
	    }
	    g_free(g);
	    return TRUE;
	}
	TRACE("found %s",desk_population_p->en->path);
	set_population_offset(desk_view_p,desk_population_p,event->x,event->y);
	desk_view_p->doing_drag_p=desk_population_p;
	desk_view_p->restore_pixbuf=FALSE;
	update_population_list(desk_view_p,desk_view_p->doing_drag_p);
	desk_view_p->initial_x = desk_view_p->doing_drag_p->x;
	desk_view_p->initial_y = desk_view_p->doing_drag_p->y;
	    
	desk_view_p->dragstate=FALSE;
	
	setup_drag_state(desk_view_p,event);
    }
    else
    {
	TRACE("nothing found at %f %f",event->x,event->y);
	unselect_all_population(desk_view_p);
#ifdef HAVE_LIBXFCEGUI4
	if (event->button == 3 && getenv("USE_DESKTOP_MENU") && strlen(getenv("USE_DESKTOP_MENU")) && desk_view_p->xfdesktop_menu_p)
	{/* screen not used yet */
	    popup_desktop_menu((xfdesktop_menu_t *)desk_view_p->xfdesktop_menu_p,NULL,event->button,event->time);
	    
	} else
#endif
     /* forward unused events to the root window, i.e. the window manager */
        event_forward_to_rootwin(gtk_widget_get_screen(widget), (GdkEvent*)event);
    }
    return TRUE;
}
static 
gboolean 
on_motion (		GtkWidget *widget, 
			GdkEventMotion *event, 
			gpointer data)
{
    desk_view_t *desk_view_p = (desk_view_t *)data;   
    TRACE("on motion");
    if (!desk_view_p->doing_drag_p){
	desk_population_t *desk_population_p = find_in_population(desk_view_p,event->x,event->y);
	if (desk_view_p->saturated != desk_population_p){
	  unsaturate(desk_view_p);
	  unselect_all_population(desk_view_p);
	  if (desk_population_p && !(desk_population_p->selected)) {
	    gdouble x=desk_population_p->x;
	    gdouble y=desk_population_p->y;
	    desk_view_p->offset_x=desk_view_p->offset_y=0;
	    TRACE("saturating");
	    desk_view_p->saturated=desk_population_p;
	    saturate_pixbuf(desk_view_p,desk_population_p, x, y);
	    redraw_text(desk_view_p,desk_view_p->saturated,SATURATE_TEXT_COLOR);
	    update_population_list(desk_view_p,desk_population_p);
	  } 
	}
    }
    else {
	GdkEventExpose expose_event;
	enter_drag_state(desk_view_p);
	expose_event.area.x=((event->x-ICON_SIZE-1 < 0)? 0: event->x-ICON_SIZE-1);
	expose_event.area.y=((event->y-ICON_SIZE < 0)? 0: event->y-ICON_SIZE);
	expose_event.area.width=2*ICON_SIZE;
	expose_event.area.height=2*ICON_SIZE;
	on_expose(desk_view_p->paper,&expose_event,desk_view_p);
	
	expose_event.area.x=((desk_view_p->doing_drag_p->x-1 < 0)? 0: desk_view_p->doing_drag_p->x-1);
	expose_event.area.y=((desk_view_p->doing_drag_p->y-1 < 0)? 0: desk_view_p->doing_drag_p->y-1)+ desk_view_p->doing_drag_p->h;
	expose_event.area.width=desk_view_p->doing_drag_p->logical_rect.width+2;
	expose_event.area.height=desk_view_p->doing_drag_p->logical_rect.height+2;

	on_expose(desk_view_p->paper,&expose_event,desk_view_p);

    }
    return TRUE;
}
static 
void 
drag_data (		GtkWidget * widget, 
			GdkDragContext * context, 
			gint x, gint y, 
			GtkSelectionData * selection_data, 
			guint info, 
			guint time, 
			gpointer data)
{
    GList *list=NULL;
    TRACE("drag_data...");
    desk_view_t *desk_view_p = (desk_view_t *)data;   
    record_entry_t *target_en;
    TRACE("deskview_drag_data: drag_data...");
    desk_view_p->redlight=TRUE;
    if (!desk_view_p) {
	TRACE("!desk_view_p");
	gtk_drag_finish(context, FALSE, FALSE, time);
	desk_view_p->redlight=FALSE;
	return;
    }
    cursor_wait(desk_view_p->widgets.window);
    target_en=desk_view_p->en;
    
    TRACE("drag_data...core_drag_data");
    if (core_drag_data (&(desk_view_p->widgets),target_en, context, x, y, selection_data, info, time)){
	TRACE("drag_data...reload 0x%x->0x%x",
		(unsigned)desk_view_p, (unsigned)desk_view_p->en);
    }

    TRACE("drag_data...all done");
    /* place first icon wherever user dropped it, and the rest
     * should be "smartly" placed by application*/
    uri_parse_list((const char *)selection_data->data, &list);
    if (list && list->data) {
	gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CACHE,"/",TRUE);
	gchar *f=g_build_filename(xdg_dir,DESKVIEW_GEOMETRY_DBH_FILE,NULL);
	gchar *url = (gchar *)list->data;

	g_free(xdg_dir);
	if (g_file_test(f,G_FILE_TEST_EXISTS)) {
	    save_deskview_geometry(url, x, y);
	    TRACE("saving %s -> %d,%d",url, x, y);
	}
	g_free(f);
    } 
    else TRACE("list is null");
    uri_free_list(list);
    list=NULL;
    reload_deskview(desk_view_p);
    cursor_reset(desk_view_p->widgets.window);
    desk_view_p->redlight=FALSE;

}
static 
void  
drag_leave (		GtkWidget *widget, 
			GdkDragContext *drag_context, 
			guint time, 
			gpointer data)
{
    desk_view_t *desk_view_p = (desk_view_t *)data;   
    TRACE("drag_leave...");
    desk_view_p->restore_pixbuf=TRUE;
}

static 
void 
drag_delete (		GtkWidget * widget, 
			GdkDragContext * context, 
			gpointer data)
{
    desk_view_t *desk_view_p = (desk_view_t *)data; 
    TRACE(">>>>>drag delete here...0x%x",(unsigned)desk_view_p);
    desk_view_p->restore_pixbuf=FALSE;
   // reload_deskview(desk_view_p);
}

static 
void 
drag_drop (		GtkWidget * widget, 
			GdkDragContext * context, 
			gpointer data)
{
    /*desk_view_t *desk_view_p = (desk_view_t *)data; 
    TRACE(">>>>drag drop here...0x%x",(unsigned)desk_view_p);*/
    /*if (context->source_window != context->dest_window){
	desk_view_p->restore_pixbuf=FALSE;
    }*/
}


static 
void 
drag_end (		GtkWidget * widget, 
			GdkDragContext * context, 
			gpointer data)
{
    desk_view_t *desk_view_p = (desk_view_t *)data;   
    TRACE("drag_end...");
	    

    if (!desk_view_p->doing_drag_p) return;
    if (desk_view_p->restore_pixbuf) {
        TRACE("restoring pixbuf...");
	desk_view_p->offset_x=desk_view_p->offset_y=0; 
	if (desk_view_p->doing_drag_p->selected) {
	    select_pixbuf(desk_view_p,
		    desk_view_p->doing_drag_p, 
		    desk_view_p->initial_x, 
		    desk_view_p->initial_y);
	    redraw_text(desk_view_p,desk_view_p->doing_drag_p,SELECT_TEXT_COLOR);
	} else {
	    redraw_pixbuf(desk_view_p,
		    desk_view_p->doing_drag_p, 
		    desk_view_p->initial_x, 
		    desk_view_p->initial_y);
	    redraw_text(desk_view_p,desk_view_p->doing_drag_p,TEXT_COLOR);
	}
	desk_view_p->doing_drag_p=NULL;
    }
    else {
	TRACE("NOT restoring pixbuf...");
	reload_deskview(desk_view_p);
    }

}
static 
gboolean 
drag_motion (		GtkWidget * widget, 
			GdkDragContext * dc, 
			gint x, 
			gint y, 
			guint t, 
			gpointer data)
{

    desk_view_t *desk_view_p = (desk_view_t *)data;   
    if (dc->actions == GDK_ACTION_MOVE) gdk_drag_status(dc, GDK_ACTION_MOVE, t);
    else if(dc->actions == GDK_ACTION_COPY) gdk_drag_status(dc, GDK_ACTION_COPY, t);
    else if(dc->actions == GDK_ACTION_LINK) gdk_drag_status(dc, GDK_ACTION_LINK, t);
    else gdk_drag_status(dc, GDK_ACTION_LINK, t);
    TRACE("on_drag_motion...");
     if (desk_view_p->doing_drag_p){
	TRACE("widget ok");
	desk_view_p->restore_pixbuf=FALSE;
    }
   
    return (TRUE);
}
static 
void 
drag_data_get (		GtkWidget * widget, 
			GdkDragContext * context, 
			GtkSelectionData * selection_data, 
			guint info, 
			guint time, 
			gpointer data)
{
    GList *selection_list=NULL;
    desk_view_t *desk_view_p = (desk_view_t *)data;   
    TRACE("drag_data_get...");
    if (!desk_view_p->doing_drag_p) return;
    selection_list=g_list_append(selection_list,desk_view_p->doing_drag_p->en);
    core_drag_data_get(&(desk_view_p->widgets),selection_list,context,selection_data,info,time);
    g_list_free(selection_list);
    return;
}
static 
void   
drag_begin (		GtkWidget *widget,
			GdkDragContext *drag_context,
			gpointer data)
{
    //desk_view_t *desk_view_p = (desk_view_t *)data;   
    TRACE("on_drag_begin...");
}
static
gboolean    on_configure (GtkWidget *widget, GdkEventConfigure *event, gpointer user_data){
	TRACE("configure event");
	return TRUE;
}



static
gboolean    on_size (GtkWidget *widget, GtkAllocation *allocation, gpointer user_data){
    return TRUE;
#if 0
    gboolean redraw=FALSE;
    desk_view_t *desk_view_p=(desk_view_t *)user_data;
    if (desk_view_p->widgets.window->allocation.width > desk_view_p->paper->allocation.width){
	TRACE("width too big=%d",desk_view_p->widgets.window->allocation.width);
	// XXX 3 is the scrollbar spacing, and 2 is the spacing at each
	// side of drawing area (default gtk values used here)
	gtk_widget_set_size_request ((GtkWidget *)desk_view_p->paper,
		desk_view_p->widgets.window->allocation.width - desk_view_p->scrolled_window->vscrollbar->allocation.width-3-2,
		desk_view_p->paper->allocation.height);
	redraw=TRUE; 
    }
    if (desk_view_p->widgets.window->allocation.height > desk_view_p->paper->allocation.height){
	TRACE("height too big=%d",desk_view_p->widgets.window->allocation.height);
	// we don't worry about getting rid of this scrollbar for 
	// the time being.
	gtk_widget_set_size_request ((GtkWidget *)desk_view_p->paper,
		desk_view_p->paper->allocation.width - desk_view_p->scrolled_window->hscrollbar->allocation.height,
		desk_view_p->widgets.window->allocation.height);
	redraw=TRUE;
    }
    if (redraw){
	GList *tmp=desk_view_p->population_list;
	TRACE("redrawing pixbuf...");
	clean_paper(desk_view_p);
	for (;tmp; tmp=tmp->next){
	    desk_population_t *desk_population_p=(desk_population_t *)tmp->data;
	    redraw_pixbuf(desk_view_p, desk_population_p, desk_population_p->x, desk_population_p->y);
	    redraw_text(desk_view_p, desk_population_p,TEXT_COLOR);
	}
    }
    
    TRACE("size allocation event for main window...\n");
 
    return TRUE;
#endif
}


