/*
 * Copyright (C) 2006 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifdef HAVE_SYS_UCRED_H
#include <sys/ucred.h>
#endif
#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif

#include <stdio.h>
#include <errno.h>
#ifdef HAVE_FSTAB_H
#include <fstab.h>
#endif
#include <limits.h>
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <regex.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "constants.h"
#include "types.h"

#include "primary.h"
#include "gui.h"
#include "actions_lib.h"

/* this should be first 2 lines after headers: */
G_MODULE_EXPORT
LIBXFFM_MODULE


#define MODULE_NAME "xffm_proc"
#define CHILD_MODULE "xffm_proc"

#define ALL_PROCS 	0x100000
#define PROC_LEADERS 	0x200000
#define PROC_PARENTS 	0x400000
#define PROC_ORPHANS 	0x800000

#include "proc.i"

G_MODULE_EXPORT
const gchar * 
g_module_check_init(GModule *module){
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE,PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
#endif
    TRACE("domain=%s", GETTEXT_PACKAGE);
#endif
    return NULL;
}


/****************   void  functions  ***********************/
/******************************/

G_MODULE_EXPORT
void *
allow_filter (void)
{
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
name_column_title(void)
{
    return private_name_column_title();
}
G_MODULE_EXPORT
void *
size_column_title(void)
{
    return private_size_column_title();
}
G_MODULE_EXPORT
void *
date_column_title(void)
{
    return private_date_column_title();
}
G_MODULE_EXPORT
void *
owner_column_title(void)
{
    return private_owner_column_title();
}
G_MODULE_EXPORT
void *
group_column_title(void)
{
    return private_group_column_title();
}
G_MODULE_EXPORT
void *
mode_column_title(void)
{
    return private_mode_column_title();
}
/******************************/


G_MODULE_EXPORT
const gchar *
module_name(void){
    return MODULE_NAME;
}
G_MODULE_EXPORT
void *
submodule_name(void){
    return CHILD_MODULE;
}

G_MODULE_EXPORT
const gchar *
submodule_dir(void){
    return "plugins";
}

G_MODULE_EXPORT
void *
is_root_module(void){
    return GINT_TO_POINTER(1);
}

G_MODULE_EXPORT
void *
module_init(void){
    return NULL;
}

G_MODULE_EXPORT
void *
exec_name(void){
    return "xffm-proc";
}

G_MODULE_EXPORT
void *
plugin_info(void){
    return _("The PROCESSES plugin allows you to locate and control processed running on your system.");
}

/*******************  natural functions **********************/

G_MODULE_EXPORT
void *
get_dnd_path(void *p)
{
    static gchar *desktop=NULL;
    if (!desktop) {
	desktop=g_strdup_printf("%s%c%s%c%s",
		PACKAGE_DATA_DIR,G_DIR_SEPARATOR,
		"applications",G_DIR_SEPARATOR,
		"Xffm-proc.desktop");
    }
    return (void *)desktop;
}

G_MODULE_EXPORT
void *
date_column_string(void * p){
    return private_date_column_string(p);
}
G_MODULE_EXPORT
void *
size_column_string(void * p){
    return private_size_column_string(p);
}
G_MODULE_EXPORT
void *
group_column_string(void * p){
    return private_group_column_string(p);
}

G_MODULE_EXPORT
void *
owner_column_string(void * p){
    return private_owner_column_string(p);
}

G_MODULE_EXPORT
void *
mode_column_string(void * p){
    return private_mode_column_string(p);
}

G_MODULE_EXPORT
void *
entry_tip(void *p)
{
    static gchar *tip=NULL;
    record_entry_t *en=p;
    if (!en || !en->path || !strlen(en->path)) return NULL;
    g_free(tip);
    tip=g_strdup_printf("%s\n%s=%s %s=%s %s=%s %s=%s %s=%s",
        en->path,
        (char *)private_size_column_title(),
	(char *)private_size_column_string(p),
	(char *)private_date_column_title(),
	(char *)private_date_column_string(p),
	(char *)private_owner_column_title(),
	(char *)private_owner_column_string(p),
	(char *)private_group_column_title(),
	(char *)private_group_column_string(p),
	(char *)private_mode_column_title(),
	(char *)private_mode_column_string(p)
	    );
    
    return (void *)tip;
}



G_MODULE_EXPORT
void *
module_icon_id(void * p){
    int f=0;
    record_entry_t *en=(record_entry_t *)p;
    static char pfx[64];

    if (!p) return "xffm-proc.png";
    if (en->path && strcmp(en->path,_("Processes"))==0) return  "xffm-proc.png";
    if (!en->st) return "proc.png";

    if (en->st->st_gid ==1)f |= 0x01;
    if (en->st->st_blocks > 1 )f |= 0x02;
    if (en->st->st_nlink) f |= 0x04;
    memset(pfx,0,64);
    if (f & 0x01) strcat(pfx,"i");
    if (f & 0x02) strcat(pfx,"g");
    if (f & 0x04) strcat(pfx,"c");
    strcat(pfx,"proc.png");
    return pfx;
}

G_MODULE_EXPORT
void *
module_label(void * p){
    return _("Processes");
}

G_MODULE_EXPORT
void *
is_selectable(void *p){
    record_entry_t *en=(record_entry_t *)p;
    if (g_file_test(en->path, G_FILE_TEST_EXISTS))
	return (void *)"Yes";
    
    return NULL;
}


G_MODULE_EXPORT
void *
valid_drop_site(void *p){
    return NULL;
}

static
int parse_int(gchar *string,gchar *token){
    gchar *f=strtok(string," "); 
    float v;
    int r;
    if (!f) {
        g_warning("incorrect parsing...");
	return 0;
    }
    v=atof(f)+0.5;
    r=v;
    return r;
}
static
long parse_long(gchar *string,gchar *token){
    gchar *f=strtok(string," "); 
    if (!f) {
        g_warning("incorrect parsing...");
	return 0;
    }
    return atol(f);
}

G_MODULE_EXPORT
void *
module_monitor(void *p){
    return GINT_TO_POINTER(1);
}

    

/*******************  rational functions **********************/
void *
get_xfdir(void *p, void *q){
    const regex_t *preg=NULL;
    FILE *pipe;
    GSList *tmp;
    int i;
    record_entry_t *en, *p_en=(record_entry_t *)p;
    static xfdir_t xfdir;
    widgets_t *widgets_p=(widgets_t *)q;
    gchar *ps;
#ifdef HAVE_UNIX_O_RSS
    const gchar *fmt="pid,ppid,pgid,pcpu,nice,rss,time,args";
#else 
    const gchar *fmt="pid,ppid,pgid,pcpu,nice,vsz,time,args";
#endif


    
#ifdef HAVE_UNIX_O
#ifdef HAVE_UNIX_W
    if (p_en->subtype & ALL_PROCS) 
	ps=g_strdup_printf("ps -wwe -o %s",fmt);
    else
	ps=g_strdup_printf("ps -wwU %u -o %s",(unsigned)getuid(),fmt);
#else
    if (p_en->subtype & ALL_PROCS) 
	ps=g_strdup_printf("ps -e -o %s",fmt);
    else
	ps=g_strdup_printf("ps -U %u -o %s",(unsigned)getuid(),fmt);
#endif
    
#else

#ifdef HAVE_BSD_O
#ifdef HAVE_BSD_W
    if (p_en->subtype & ALL_PROCS) 
	ps=g_strdup_printf("ps awwo %s",fmt);
    else
	ps=g_strdup_printf("ps wwo %s",fmt);
#else
    if (p_en->subtype & ALL_PROCS) 
        ps=g_strdup_printf("ps ao %s",fmt);
    else
        ps=g_strdup_printf("ps o %s",fmt);
#endif
#endif
    
#endif
    
    /*p_en->subtype |= PROC_LEADERS;*/
    
    
    TRACE("ps=%s",ps);

    xfdir.pathc=0;
    if (ps_list) g_slist_free(ps_list);  ps_list=NULL;
    pipe = popen(ps, "r");
    g_free(ps);
    if(pipe) {
	char *f;
	gchar line[4096];
	memset(line,0,4096);
	while (fgets(line, 4095, pipe)){
	    if (!strchr(line,'\n')){
		g_warning("memory overrun averted");
		break;
	    }
	    if (!strstr(line,"PPID")) {
		en=mk_entry(0);
		en->type=0; /* remove local-type attributes */
		en->st = (struct stat *)malloc(sizeof(struct stat));
		memset(en->st,0,sizeof(struct stat));
		TRACE("line=%s",line);
		/* PID */
		en->st->st_uid=(uid_t)parse_int(line," ");
		/* PPID */
		en->st->st_gid=(gid_t)parse_int(NULL," ");
		/* PGID */
		en->st->st_ino=(ino_t)parse_int(NULL," ");
		/* PCPU */
		en->st->st_mode=(mode_t)parse_int(NULL," ");

		/* NICE */
		en->st->st_ctime=(time_t)parse_int(NULL," ");
		TRACE("time=%d\n",(int)en->st->st_ctime);
		/* RSS/VSZ */
		en->st->st_size=(off_t)parse_long(NULL," ");
		/* TIME */
		{
		    int h=0,m=0,s=0;
		    char *p,*c=strtok(NULL," ");
		    p=strchr(c,':');
		    if (!p) goto ko;
		    *p=0;
		    h=atoi(c);
		    c=p+1;
		    p=strchr(c,':');
		    if (!p) {
			m=h;
			h=0;
			s=atoi(c);
			goto ko;
		    } else {
			*p=0;
			m=atoi(c);
			c=p+1;
			s=atoi(c);
		    }
ko:
		    en->st->st_mtime=(time_t)(h*3600+m*60+s);
		}
		/* ARGS */
		f=strtok(NULL,"\n"); en->path=g_strdup(f);
		TRACE("path=%s\n",f);
		if (strchr(f,' ')) strtok(f," ");
		en->module=MODULE_NAME;
		ps_list=g_slist_append(ps_list,en);
	    }
	}		
	pclose(pipe);
    }
	
    /* tag parent and group-leader processes...*/
    for (tmp=ps_list; tmp; tmp=tmp->next){
	ppid_list=g_slist_append(ppid_list,tmp->data);
    }

    for (tmp=ps_list; tmp; tmp=tmp->next){
	GSList *tm;
	en=(record_entry_t *)tmp->data;
	for (tm=ppid_list;tm;tm=tm->next){
	    record_entry_t *c_en=(record_entry_t *)tm->data;
	    if ((int)(en->st->st_uid) == (int)(c_en->st->st_gid)) 
		en->st->st_nlink++;
	    TRACE("%d == %d",(int)(en->st->st_uid),(int)(c_en->st->st_ino));
	    if ((int)(en->st->st_uid) == (int)(c_en->st->st_ino))
		en->st->st_blocks++;
	}
    }
    if (ppid_list) g_slist_free(ppid_list);  ppid_list=NULL;
    
    if (p_en->subtype & PROC_ORPHANS){
	for (tmp=ps_list; tmp; tmp=tmp->next){
	    en=(record_entry_t *)tmp->data;
	    if ((int)en->st->st_gid != 1) ppid_list=g_slist_append(ppid_list,en);
	    else destroy_entry(en);
	}
	g_slist_free(ps_list);
	ps_list = ppid_list;
	ppid_list=NULL;
    }
    if (p_en->subtype & PROC_PARENTS){
	for (tmp=ps_list; tmp; tmp=tmp->next){
	    en=(record_entry_t *)tmp->data;
	    if (en->st->st_nlink) ppid_list=g_slist_append(ppid_list,en);
	    else destroy_entry(en);
	}
	g_slist_free(ps_list);
	ps_list = ppid_list;
	ppid_list=NULL;
    }
    if (p_en->subtype & PROC_LEADERS){
	for (tmp=ps_list; tmp; tmp=tmp->next){
	    en=(record_entry_t *)tmp->data;
	    TRACE("%d -->%d",(int)en->st->st_uid,(int)en->st->st_blocks);
	    if ((int)en->st->st_blocks > 1) ppid_list=g_slist_append(ppid_list,en);
	    else destroy_entry(en);
	}
	g_slist_free(ps_list);
	ps_list = ppid_list;
	ppid_list=NULL;
    }
    
    g_free(p_en->filter);
    p_en->filter=g_strdup(gui_get_filter(widgets_p));
    TRACE("gui_get_filter=%s",p_en->filter);
    if (p_en->filter && strcmp(p_en->filter,"*") != 0) {
	preg=compile_regex_filter(p_en->filter,TRUE);
	/*regcomp(preg, p_en->filter, REG_ICASE);*/
    } else preg=NULL;
    if (preg){
	GSList *new_list=NULL;
	for (tmp=ps_list; tmp; tmp=tmp->next){
	    en=(record_entry_t *)tmp->data;
	    if (regexec(preg, en->path, 0, NULL, 0)==0) 
		new_list=g_slist_append(new_list,en);
	    else destroy_entry(en);
	}
	g_slist_free(ps_list);
	ps_list = new_list;
    }
    if (preg) regfree((regex_t *)preg);

	
    xfdir.pathc=g_slist_length(ps_list);	
    xfdir.gl = (dir_t *)malloc(xfdir.pathc*sizeof(dir_t));
    memset(xfdir.gl,0,xfdir.pathc*sizeof(dir_t));
    for (i=0,tmp=ps_list; tmp && tmp->data; tmp=tmp->next,i++){
	gchar *g;
	en=(record_entry_t *)tmp->data;
	g=strchr(en->path,' ');
	if (g) *g=0;
	xfdir.gl[i].pathv = g_path_get_basename(en->path);
	if (g) *g=' ';
	xfdir.gl[i].en=en;
	TRACE("pathv = %s\n",(const char *)xfdir.gl[i].pathv);
    }
    g_slist_free(ps_list);
    ps_list=NULL;
    return &xfdir;
}

G_MODULE_EXPORT
void *
private_popup(void *p, void *q){
    GtkWidget *w;
    widgets_t *widgets_p=(widgets_t *)q;
    gchar *label=_("Processes"),*altlabel=NULL;
    record_entry_t *en=(record_entry_t *)p;
    
    if (!en) return NULL;    
    if (private_popup_widget) gtk_widget_destroy(private_popup_widget);

    TRACE("en->st=0x%x",(unsigned)en->st);
    
    if (en && en->st && en->path) {
	label=en->path;
	if (strlen(label)>30) {
	    altlabel=g_strdup(en->path);
	    altlabel[30]=0;
	    label=altlabel;
	}
    }
    
    private_popup_widget=gui_mk_menu(
	  widgets_p,		  /* window */
	  label, /* label */
	  NULL,   /* name */
	  NULL, 	  /* parent */
	  NULL,NULL); /* callback (or NULL)*/
    g_free(altlabel);
	
	    
	w = gtk_image_menu_item_new_with_mnemonic (_("Reload"));
	g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
	gui_mk_pixmap_menu(widgets_p, "xffm/stock_refresh",w,MENU_PIXMAP);
	gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	g_signal_connect ((gpointer) w, "activate", G_CALLBACK (proc_reload), en);
	gtk_widget_show (w);
	
    if (en->st==NULL){
	/* root guy */
	
	w = gtk_image_menu_item_new_with_mnemonic (_("Show process tree"));
	g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
	/*gui_mk_pixmap_menu(widgets_p, "xffm/stock_",w,MENU_PIXMAP);*/
	gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	g_signal_connect ((gpointer) w, "activate", G_CALLBACK (proc_tree), en);
#ifdef HAVE_BSD_XF
	gtk_widget_show (w);
#endif
#ifdef HAVE_UNIX_JH
	gtk_widget_show (w);
#endif
	
	w = gtk_image_menu_item_new_with_mnemonic (_("Treeview"));
	g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
	gui_mk_pixmap_menu(widgets_p, "xffm/stock_index",w,MENU_PIXMAP);
	gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	g_signal_connect ((gpointer) w, "activate",G_CALLBACK (open_proc), GINT_TO_POINTER(1));
	gtk_widget_show (w);

	w = gtk_image_menu_item_new_with_mnemonic (_("Iconview"));
	g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
	gui_mk_pixmap_menu(widgets_p, "icon_view.png",w,MENU_PIXMAP);
	gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	g_signal_connect ((gpointer) w, "activate", G_CALLBACK (open_proc), GINT_TO_POINTER(0));
	gtk_widget_show (w);
	{
	    int flags[]={ALL_PROCS,PROC_LEADERS,PROC_PARENTS,PROC_ORPHANS};
	    int invert[]={1,0,0,0};
	    char *hideS[]={N_("Show system processes"),N_("Hide followers"),N_("Hide children"),N_("Hide orphans"),NULL};
	    char *showS[]={_("Hide system processes"),_("Show followers"),_("Show children"),_("Show orphans"),NULL};
	    int i;
	    for (i=0; hideS[i]; i++){
		if (en->subtype & flags[i]){
		    w = gtk_image_menu_item_new_with_mnemonic (_(showS[i]));
		     gui_mk_pixmap_menu(widgets_p, 
			     ((invert[i])?"xffm/stock_no":"xffm/stock_yes"),
			       w,MENU_PIXMAP);
		} else {
		    w = gtk_image_menu_item_new_with_mnemonic (_(hideS[i]));
		    gui_mk_pixmap_menu(widgets_p, 
			     ((invert[i])?"xffm/stock_yes":"xffm/stock_no"),
			    w,MENU_PIXMAP);
		}
		g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
		g_object_set_data(G_OBJECT(w),"flag",GINT_TO_POINTER(flags[i]));
		gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
		g_signal_connect ((gpointer) w, "activate", 
			G_CALLBACK (proc_set), en);
		gtk_widget_show (w);
	    }
	}
	goto popup_done;
    }

    /* should test for ps capabilities and go the full
     * yard with gnu ps (like find-moduel_gui.c): */
    w = gtk_image_menu_item_new_with_mnemonic (_("Show process information"));
    g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
#ifdef HAVE_BSD_L
	gtk_widget_show (w);
#endif
#ifdef HAVE_UNIX_LY
	gtk_widget_show (w);
#endif


    
    gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
    gui_mk_pixmap_menu(widgets_p, "xffm/info",w,MENU_PIXMAP);
    g_signal_connect ((gpointer) w, "activate", G_CALLBACK (proc_info), en);
    w = gtk_image_menu_item_new_with_mnemonic (_("Renice"));
    g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
    gui_mk_pixmap_menu(widgets_p, "nice.png",w,MENU_PIXMAP);
    g_signal_connect ((gpointer) w, "activate", G_CALLBACK (proc_nice), en);
    
    {
	gchar **p;
	int *ip;
	gchar *t[]={
	    N_("Hangup"),
	    N_("SIGUSR1"),
	    N_("SIGUSR2"),
	    N_("Terminate"),
	    N_("Kill"),
	    N_("Crash"),
	    NULL
	};
	int sig[]={
	    SIGHUP,
	    SIGUSR1,
	    SIGUSR2,
	    SIGTERM,
	    SIGKILL,
	    SIGSEGV,
	    0
	};
	for (ip=sig,p=t; *p; p++,ip++){
	    w = gtk_image_menu_item_new_with_mnemonic (_(*p));
	    g_object_set_data(G_OBJECT(w),"widgets_p",widgets_p);
	    if (*ip) 
		g_object_set_data(G_OBJECT(w),"signal",GINT_TO_POINTER(*ip));
	    gtk_widget_show (w);
	    gtk_container_add (GTK_CONTAINER (private_popup_widget), w);
	    gui_mk_pixmap_menu(widgets_p, "xffm-proc-kill.png",w,MENU_PIXMAP);
	    g_signal_connect ((gpointer) w, "activate", G_CALLBACK (proc_signal), en);
	}
    }
    
    
popup_done:
    
    gtk_menu_popup(GTK_MENU(private_popup_widget), NULL, NULL, NULL, NULL, 3, xffm_details->eventtime);	

    return GINT_TO_POINTER(1);
}


