// Directory box for the "extract to" command

#include "config.h"
#include "i18n.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>

#include <fox/fx.h>

#include "DirList.h"
#include "DirListBox.h"


// Map
FXDEFMAP(DirListBox) DirListBoxMap[]={};

// Object implementation
FXIMPLEMENT(DirListBox,FXDialogBox,DirListBoxMap,ARRAYNUMBER(DirListBoxMap))

// Make some windows
DirListBox::DirListBox(FXWindow *win): FXDialogBox(win,_("Directory List"), DECOR_TITLE|DECOR_BORDER,0,0,0,400)
{
    void *dum;

    FXVerticalFrame *contents=new FXVerticalFrame(this,
                              LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y|
                              PACK_UNIFORM_WIDTH);

    // Make contents
    FXHorizontalFrame *treeframe=new FXHorizontalFrame(contents,
                                 PACK_UNIFORM_WIDTH|LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|LAYOUT_FILL_Y|
                                 /*FRAME_GROOVE*/FRAME_SUNKEN);
    dirtree=new DirList(treeframe,NULL,0,
                          HSCROLLING_OFF|TREELIST_ROOT_BOXES|TREELIST_SHOWS_LINES|\
                          TREELIST_SHOWS_BOXES|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0);

    // Done
    FXHorizontalFrame *frame=new FXHorizontalFrame(contents,
                             /*PACK_UNIFORM_WIDTH|*/LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X);


    dum = (void*)new FXButton(frame,_("&Cancel"),
                              NULL,this,ID_CANCEL,FRAME_RAISED|
                              FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    dum = (void*)new FXButton(frame,_("  &OK   "),NULL,this,
                              ID_ACCEPT,FRAME_RAISED|FRAME_THICK|
                              LAYOUT_RIGHT|LAYOUT_CENTER_Y,0,0,0,0,20,20);
    dum = (void*)new FXCheckButton(frame,_("Show hidden folders"),dirtree,DirList::ID_TOGGLE_HIDDEN,LAYOUT_LEFT|ICON_BEFORE_TEXT);

}
void DirListBox::setPath(const FXString &path)
{
    dirtree->setDirectory(path);
}
FXString DirListBox::getPath()
{
    TreeItem *item;
    item = (TreeItem*)dirtree->getCurrentItem();
    if (item == NULL)
    {
        return "";
    }
    FXString thepath;
    thepath = dirtree->getItemPathname(item);
    if(access(thepath.text(),R_OK|X_OK))
        return "";
    return thepath;
}

FXuint DirListBox::execute()
{
    FXint rx,ry;

    rx = ry = 0;
    show(PLACEMENT_OWNER);
    dirtree->expandTree(dirtree->getFirstItem());
    return getApp()->runModalFor(this);
}

