/* $Id: xdg-desktop-support.h,v 1.3 2004/08/08 14:08:52 bmeurer Exp $ */
/*-
 * Copyright (c) 2004 os-cillation
 * All rights reserved.
 *
 * Written by Benedikt Meurer <bm@os-cillation.de>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __XDG_DESKTOP_SUPPORT_H__
#define __XDG_DESKTOP_SUPPORT_H__

#include <glib-object.h>

G_BEGIN_DECLS;

#define XDG_TYPE_DESKTOP_CACHE            (xdg_desktop_cache_get_type ())
#define XDG_DESKTOP_CACHE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), XDG_TYPE_DESKTOP_CACHE, XdgDesktopCache))
#define XDG_DESKTOP_CACHE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), XDG_TYPE_DESKTOP_CACHE, XdgDesktopCacheClass))
#define XDG_IS_DESKTOP_CACHE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XDG_TYPE_DESKTOP_CACHE))
#define XDG_IS_DESKTOP_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XDG_TYPE_DESKTOP_CACHE))
#define XDG_DESKTOP_CACHE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), XDG_TYPE_DESKTOP_CACHE, XdgDesktopCacheClass))

#define XDG_TYPE_DESKTOP_DIR              (xdg_desktop_dir_get_type ())
#define XDG_DESKTOP_DIR(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), XDG_TYPE_DESKTOP_DIR, XdgDesktopDir))
#define XDG_DESKTOP_DIR_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), XDG_TYPE_DESKTOP_DIR, XdgDesktopDirClass))
#define XDG_IS_DESKTOP_DIR(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XDG_TYPE_DESKTOP_DIR))
#define XDG_IS_DESKTOP_DIR_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), XDG_TYPE_DESKTOP_DIR))
#define XDG_DESKTOP_DIR_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), XDG_TYPE_DESKTOP_DIR, XdgDesktopDirClass))

#define XDG_TYPE_DESKTOP_ENTRY            (xdg_desktop_entry_get_type ())
#define XDG_DESKTOP_ENTRY(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), XDG_TYPE_DESKTOP_ENTRY, XdgDesktopEntry))
#define XDG_DESKTOP_ENTRY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), XDG_TYPE_DESKTOP_ENTRY, XdgDesktopEntryClass))
#define XDG_IS_DESKTOP_ENTRY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XDG_TYPE_DESKTOP_ENTRY))
#define XDG_IS_DESKTOP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XDG_TYPE_DESKTOP_ENTRY))
#define XDG_DESKTOP_ENTRY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), XDG_TYPE_DESKTOP_ENTRY, XdgDesktopEntryClass))


typedef struct _XdgDesktopCacheClass XdgDesktopCacheClass;
typedef struct _XdgDesktopCache      XdgDesktopCache;
typedef struct _XdgDesktopDirClass   XdgDesktopDirClass;
typedef struct _XdgDesktopDir        XdgDesktopDir;
typedef struct _XdgDesktopEntryClass XdgDesktopEntryClass;
typedef struct _XdgDesktopEntry      XdgDesktopEntry;

struct _XdgDesktopCacheClass
{
  GObjectClass  __parent__;
};

struct _XdgDesktopCache
{
  GObject      __parent__;
  gchar       *dir;         /* the directory where cache files are stored */
  GList       *dirs;        /* the list of XdgDesktopDirs */
  GHashTable  *id_to_entry;
};

GType xdg_desktop_cache_get_type (void) G_GNUC_CONST;

XdgDesktopCache *xdg_desktop_cache_new           (void);

XdgDesktopDir   *xdg_desktop_cache_append_dir    (XdgDesktopCache *cache,
                                                  const gchar     *path,
                                                  const gchar     *prefix);


struct _XdgDesktopDirClass
{
  GObjectClass __parent__;

  void (*added) (XdgDesktopDir *dir, XdgDesktopEntry *entry);
  void (*removed) (XdgDesktopDir *dir, XdgDesktopEntry *entry);
};

struct _XdgDesktopDir
{
  GObject          __parent__;
  gchar           *path;
  gchar           *prefix;
  gboolean         legacy;
  gchar           *cache_file;
  GList           *entries;
  guint            timer_id;
  guint            sync_id;
  XdgDesktopCache *cache;
};

GType   xdg_desktop_dir_get_type (void) G_GNUC_CONST;


struct _XdgDesktopEntryClass
{
  GObjectClass  __parent__;

  void (*changed) (XdgDesktopEntry *entry);
};

struct _XdgDesktopEntry
{
  GObject      __parent__;

  gchar         *id;   /* the desktop id */

  gchar         *name;
  gchar         *comment;
  gchar        **categories;
  gchar         *icon;
  gchar         *command;
  gboolean       use_sn;
  gboolean       use_term;

  gchar         *fullpath;
  const gchar   *filename;  /* points to the filename portion of fullpath */
  gint           mtime;

  XdgDesktopDir *appdir;
};

GType            xdg_desktop_entry_get_type (void) G_GNUC_CONST;


G_END_DECLS;

#endif /* !__XDG_DESKTOP_SUPPORT_H__ */
