/* vim: set expandtab ts=8 sw=4: */

/*  $Id: wavelan.h 20330 2006-03-11 11:03:56Z jasper $
 *
 *  Copyright © 2005 Jasper Huijsmans <jasper@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFCE_PANEL_WAVELAN_H
#define _XFCE_PANEL_WAVELAN_H

#define PANEL_ICON_SIZE            48
#define MIN_ICON_SIZE              12 

/* A bit of a hack: Don't use icons without xfce- default */
#define NUM_CATEGORIES             (XFCE_N_BUILTIN_ICON_CATEGORIES - 4)

typedef struct  _WavelanPlugin    WavelanPlugin;

enum
{
  STATE_ERROR = 0,
  STATE_LINK0 = 1,
  STATE_LINK1 = 2,
  STATE_LINK2 = 3,
  STATE_LINK3 = 4,
  STATE_LINK4 = 5,
  STATE_LINK5 = 6
};


struct _WavelanPlugin
{
    GtkWidget *plugin;
    GtkTooltips *tips;

    GtkWidget *image;
    
    int screen_id;
    gchar *interface;
    struct wi_device *device;
    guint timer_id;

    guint state;

    GdkPixbuf *pb[7];

};


/* wavelan */
void wavelan_update_panel_entry (WavelanPlugin *wavelan);

void wavelan_save (XfcePanelPlugin *plugin, WavelanPlugin *wavelan);

void wavelan_entry_free (WavelanEntry *entry);

/* icon */
GdkPixbuf * wavelan_icon_load_pixbuf (GtkWidget *w, 
                                       WavelanIcon *icon, 
                                       int size);

#endif /* _XFCE_PANEL_WAVELAN_H */
