/* $Id: xfce-setting-show.c,v 1.7 2004/06/14 18:44:28 benny Exp $ */
/*-
 * Copyright (c) 2002 Olivier Fourdan <fourdan@xfce.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include <libxfce4mcs/mcs-client.h>

int
main(int argc, char **argv)
{
    gchar *module;
    
    gtk_init (&argc, &argv);

    if (!mcs_client_check_manager (gdk_display, DefaultScreen (gdk_display),
                                   "xfce-mcs-manager"))
    {
	    g_warning ("MCS manager not running");
	    return EXIT_FAILURE;
    }

    switch (argc)
    {
    case 1:
        module = "all";
	      break;

    case 2:
        module = argv[1];
  	    break;

    default:
	      fprintf (stderr, "Usage: %s [<mcs-module-name>]\n", g_get_prgname ());
  	    return EXIT_FAILURE;
    }

    mcs_client_show (gdk_display, DefaultScreen (gdk_display), module);
 
    return EXIT_SUCCESS;
}
