#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#include <string.h>
#include <inttypes.h>
#include <errno.h>

#include "xenner.h"
#include "mm.h"

/* ------------------------------------------------------------------ */

void hypercall_stats(struct xenvm *xen)
{
    struct xenner_info *vminfo;

    if (!xen->e.config[EMUDEV_CONF_VMINFO_PFN])
	return;
    vminfo = mfn_to_ptr(xen, xen->e.config[EMUDEV_CONF_VMINFO_PFN]);
    print_hcall_stats(xen, vminfo->hcalls, NULL);
    print_fault_stats(xen, vminfo->faults, NULL);
    print_event_stats(xen, vminfo->events, NULL, vminfo->enames);
}
