typedef struct {
	int counter;
} atomic_t;

#define atomic_read(v)		((v)->counter)
#define atomic_set(v, i)	(((v)->counter) = (i))

static inline void atomic_add(int i, atomic_t *v)
{
	asm volatile("lock; addl %1,%0"
		     : "+m" (v->counter)
		     : "ir" (i));
}

static inline void atomic_sub(int i, atomic_t *v)
{
	asm volatile("lock; subl %1,%0"
		     : "+m" (v->counter)
		     : "ir" (i));
}

static inline void atomic_inc(atomic_t *v)
{
	asm volatile("lock; incl %0"
		     : "+m" (v->counter));
}

static inline void atomic_dec(atomic_t *v)
{
	asm volatile("lock; decl %0"
		     : "+m" (v->counter));
}
