#!/bin/sh

initrd_tty="test/ttylinux-i486-6.1/rootfs"
append_tty="xencons=xvc console=xvc0 root=/dev/ram0 ro ramdisk_size=16384 ramdisk_blocksize=1024"

initrd_os32="test/opensuse-10.3-rescue-32.gz.gz"
initrd_os64="test/opensuse-10.3-rescue-64.gz.gz"
append_os="xencons=xvc console=xvc0 root=/dev/ram0 rw ramdisk_size=65536"

# defaults
kernel32="$(echo test/vmlinux-xen31-32.bin)"
#kernel32="$(echo $HOME/BUILD/kernel-2.6.18*/linux-*/build-i386-xen32/vmlinux)"
initrd32="$initrd_tty"
append32="$append_tty"

kernel64="$(echo test/vmlinux-xen31-64.bin)"
#kernel64="$(echo $HOME/BUILD/kernel-2.6.18*/linux-*/build-x86_64-xen/vmlinux)"
initrd64="$initrd_tty"
append64="$append_tty"
#kernel64="/export/install/rhel5-server-20070208.0-x86_64-dvd/images/xen/vmlinuz"
#initrd64="/export/install/rhel5-server-20070208.0-x86_64-dvd/images/xen/initrd.img"
#append64=""

# parse args
done=0
while test "$done" = "0"; do
	case "$1" in
	-32)	kernel="$kernel32"
		initrd="$initrd32"
		append="$append32"
		shift;
		;;
	-64)	kernel="$kernel64"
		initrd="$initrd64"
		append="$append64"
		shift;
		;;
	-tty)	initrd="$initrd_tty"
		append="$append_tty"
		shift
		;;
	-os32)	initrd="$initrd_os32"
		append="$append_os"
		shift
		;;
	-os64)	initrd="$initrd_os64"
		append="$append_os"
		shift
		;;
	-a)	append="$append $2"
		shift; shift
		;;
	*)	done=1
		;;
	esac
done

# boot
set -ex
exec ./xenner -m 128 -kernel "$kernel" -initrd "$initrd" \
	-append "$append" -logfile xenner.log \
	-network 00:00:11:22:33:44,br0 \
	"$@"
