;; Copyright 2004 Stephen J. Turnbull

;; This file is licensed under the GNU General Public License, version 2.

;; unused stuff

(defun synfl-make-parse-tree (children &optional symbol nonstrict)
  "Return a synfl parse tree constructed from CHILDREN and SYMBOL.
CHILDREN is a token or a list of parse trees.  If CHILDREN is a token, then
SYMBOL may be nil or the corresponding terminal.  Otherwise SYMBOL must be
a nonterminal.

If NONSTRICT is nil, check that children is valid."
  ;; Actually, we could and maybe should check that nonterminals are valid.
  (unless nonstrict
    (cond ((symbolp children)
	   (synfl-check-terminal children)
	   (unless (or (null symbol) (eq (get children :terminal) symbol))
	     (error 'invalid-argument "token and symbol must match"
		    children symbol)))
	  ((listp children)
	   (mapc #'synfl-check-parse-tree children)
	   (synfl-check-nonterminal symbol))
	  (t (error 'wrong-type-argument "must be token or list" children))))
  (let ((tree (gensym)))
    (put tree :children children)
    (put tree :symbol (or symbol (get children :terminal)))
    tree))


(defun synfl-parse-tree-p (object)
  "Return non-nil iff OBJECT is a synfl parse tree.

This function is recursive and can infloop if OBJECT contains cycles."
  (and (symbolp object)
       (let ((symbol (get object :symbol))
	     (children (get object :children)))
	 (or (and (synfl-terminal-p children)
		  (eq symbol (get children :terminal)))
	     (apply #'and (synfl-nonterminal-p symbol)
		          (mapcar #'synfl-parse-tree-p children))))))


(defun synfl-check-parse-tree (object)
  "Signal an error if OBJECT is not a valid synfl parse tree."
  (unless (synfl-parse-tree-p object)
    (error 'wrong-type-argument 'synfl-parse-tree object)))


;; deprecated
(defun synfl-parse-tree-make-node (tree symbol state token stack)
  (let ((node (gensym "Node")))
    (put node :type symbol)
    node))


